set firstTime {
You're seeing this message because this is the first time that you've run this version of exmh.  You won't see this message again until the local version of exmh changes.

Would you like me to add you to the local OSF exmh-users mailing list?
(If you just got my message announcing the local install of 1.6.9,
you are already on it).
}

proc First_Time {} {
    global exmh firstTime
    set w .first
    if [winfo exists $w] {
	destroy $w
    }
    frame $w -bd 4 -relief raised
    set l [frame $w.left -bd 20]
    Widget_Label $l label {top} \
	-text "Welcome to EXMH" \
	-font -Adobe-Times-Medium-R-Normal--*-180-*-*-*-*-*-*
    Widget_Label $l vers {top} \
	-text $exmh(version) \
	-fg black
    pack $l -side left -fill none
    set f [frame $w.pad -bd 20]
    Widget_Message $f msg -text $firstTime -width 220

    pack [frame $f.default -relief sunken -bd 1] -side left
    Widget_AddBut $f.default yes Yes {set exmh(addme) 1} {top padx 2 pady 2}
    Widget_AddBut $f no No {set exmh(addme) 0} {right padx 2 pady 2}
    pack $f
    Widget_PlaceDialog . $w
    tkwait visibility $f
    focus $f
    catch {grab $f}
    vwait exmh(addme)
    catch {grab -release $f}

    if $exmh(addme) {
	global mhProfile env

	MhExec comp -nowhatnowproc
	set draftID [Mh_Cur $mhProfile(draft-folder)]
        set path $mhProfile(path)/$mhProfile(draft-folder)/$draftID
	set fid [open $path w]
	puts $fid "To: exmh-users-request"
	puts $fid "Subject: request to be added"
	puts $fid "X-Hostname: [exec hostname]"
	catch {puts $fid "X-Hostinfo: [exec uname -a]"}
	puts $fid "\nsubscribe"
	close $fid
	Mh_Send $draftID
    }

    unset exmh(addme)
    set exmh(lastVersion) $exmh(version)
    PreferencesSave nodismiss

    destroy $w
}
