#!/usr/local/bin/perl
#  file.pl - routines to help with file management
#
#  Written by Curtis Olson.  Started April 22, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: file.pl,v 2.5 1997/01/18 03:28:43 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;   # don't take no guff


# given a directory and an extension mask (: separated list) return a
# list of files that match (including all directories)
sub get_files {
    my($dir, $mask) = split(/ +/, $_[0]);
    my($file, $ext, $count, @files, @sorted);

    print DEBUG "Directory = $dir\n";
    print DEBUG "Mask = $mask\n";

    $count = 0;

    opendir(DIR, $dir);
    $file = readdir(DIR);	# skip "."
    $file = readdir(DIR);	# skip ".."
    $file = readdir(DIR);
    while ( defined($file) ) {
	$ext = &file_extension($file);
	# print "$file --- $ext\n";
	if ( (($mask =~ m/:$ext:/) && ($file ne $ext)) || (-d "$dir/$file") ) {
	    # print "$file\n";
	    $files[$count] = $file;
	    $count++;
	}
	$file = readdir(DIR);
    }
    closedir(DIR);

    @sorted = sort @files;
    foreach $file (@sorted) {
	print "$file\n";
    }
    return "//none//";
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: file.pl,v $
# Revision 2.5  1997/01/18 03:28:43  curt
# Added "use strict" pragma to enforce good scoping habits.
#
# Revision 2.4  1996/12/17 14:53:56  curt
# Updated copyright date.
#
# Revision 2.3  1996/12/11 18:33:35  curt
# Ran a spell checker.
#
# Revision 2.2  1996/07/13 02:57:43  curt
# Version 0.65
# Packing Changes
# Documentation changes
# Changes to handle a value in both debit and credit fields.
#
# Revision 2.1  1996/02/27  05:35:42  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:42:56  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
