/*  
 *  This file is part of abc2ps, Copyright (C) 1996,1997 Michael Methfessel
 *  See file abc2ps.c for details.
 */

/*  subroutines for postscript output  */


/* ----- init_ps ------- */
void init_ps (fp,str,is_epsf,bx1,by1,bx2,by2)
FILE *fp;
char str[];
int  is_epsf;
float bx1,bx2,by1,by2;
{
  time_t  ltime;
  char    tstr[41];
  int i;

  if (is_epsf) {
    if (vb>=8) printf("Open EPS file with title \"%s\"\n", str);
    fprintf (fp, "%%!PS-Adobe-3.0 EPSF-3.0\n");
    fprintf (fp, "%%%%BoundingBox: %.0f %.0f %.0f %.0f\n",
             bx1,by1,bx2,by2);
  }
  else {
    if (vb>=8) printf("Open PS file with title \"%s\"\n", str);
    fprintf (fp, "%%!PS-Adobe-3.0\n");
  }

  /* Title */
  fprintf (fp, "%%%%Title: %s\n", str);
  
  /* CreationDate */
  time(&ltime);              
  strcpy (tstr,  ctime(&ltime));
  tstr[24]='\0';
  tstr[16]='\0';
  fprintf (fp, "%%%%Creator: abc2ps %s.%s\n", VERSION, REVISION);
  fprintf (fp, "%%%%CreationDate: %s %s\n", tstr+4,tstr+20);

  if (PS_LEVEL == 2) fprintf (fp, "%%%%LanguageLevel: 2\n");
  fprintf (fp, "%%%%EndComments\n\n");

  if (is_epsf) 
    fprintf (fp, "gsave /origstate save def mark\n100 dict begin\n\n");

  fprintf (fp, "%%%%BeginSetup\n");
  if (PS_LEVEL < 2) {
    fprintf (fp, 
             "/selectfont { exch findfont exch dup   %% emulate level 2 op\n"
             "  type /arraytype eq {makefont}{scalefont} ifelse setfont\n"
             "} bind def\n"
             );
  }
  if (vb>=7) printf ("\nDefining ISO fonts in file header:\n");
  for (i=0;i<nfontnames;i++) {
    define_font (fp,fontnames[i],i);
    if (vb>=7) printf ("   F%d   %s\n", i,fontnames[i]); 
  }
  define_symbols (fp);
  fprintf (fp, "\n0 setlinecap 0 setlinejoin 0.8 setlinewidth\n");
  fprintf (fp, "\n/T {translate} bind def\n/M {moveto} bind def\n");
  fprintf (fp, "%%%%EndSetup\n");
  file_initialized=1;
}

/* ----- close_ps ------- */
void close_ps (fp)
FILE *fp;
{
  if(vb>=8) printf ("closing PS file\n");
  fprintf (fp, 
           "%%EOF\n\n"
           );
}

/* ----- init_page: initialize postscript page ----- */
void init_page (fp)
FILE *fp;
{

  if (vb>=10) printf ("init_page called; in_page=%d\n", in_page);
  if (in_page) return;

  if (!file_initialized) {
    if (vb>=10) printf ("file not yet initialized; do it now\n");
    init_ps (fp,infostr, 0,0.0,0.0,0.0,0.0);
  }
  in_page=1;
  pagenum++;

  if (verbose==0) ;
  else if (verbose==1) printf ("[%d] ", pagenum);
  else if (verbose==2) printf ("[%d] ", pagenum);
  else                 printf ("[%d]\n", pagenum);
  fflush (stdout);
  fprintf (fp, 
           "\n%% --- page %d\n"
           "%%%%Page: %d %d\n"
           "%%%%BeginPageSetup\n",
           pagenum, pagenum, pagenum);

  if (cfmt.landscape) fprintf(fp,"%%%%PageOrientation: Landscape\n");
  fprintf(fp,"gsave ");
  if (cfmt.landscape) fprintf(fp,"90 rotate 0 %.1f translate ", 
                              -cfmt.pageheight);
  fprintf (fp,"%.2f %.2f translate\n", 
           cfmt.leftmargin, cfmt.pageheight-cfmt.topmargin);
  fprintf (fp, "%%%%EndPageSetup\n");


  /* write page number */
  if (pagenumbers) {
    fprintf (fp, "/Times-Roman 12 selectfont ");
    
    /* page numbers always at right */
    fprintf(fp, "%.1f %.1f moveto (%d) lshow\n", 
            cfmt.staffwidth, cfmt.topmargin-30.0, pagenum); 

    /* page number right/left for odd/even pages */
/*|      if (pagenum%2==0)   |*/
/*|        fprintf(fp, "%.1f %.1f moveto (%d) show\n",  |*/
/*|                0.0, cfmt.topmargin-30.0, pagenum);  |*/
/*|      else  |*/
/*|        fprintf(fp, "%.1f %.1f moveto (%d) lshow\n",  |*/
/*|                cfmt.staffwidth, cfmt.topmargin-30.0, pagenum);  |*/

  }
  
}

/* ----- close_page-------- */
void close_page (fp)
FILE *fp;
{
  if (vb>=10) printf ("close_page called; in_page=%d\n", in_page);

  if (! in_page) return;
  in_page=0;

  fprintf (fp, 
           "\n%%%%PageTrailer\n"
           "grestore\n"
           "showpage\n");
}


/* ----- init_epsf: initialize epsf file ----- */
void init_epsf (fp)
FILE *fp;
{
  float px,py;
  px=cfmt.leftmargin;
  py=cfmt.pageheight-cfmt.topmargin;
  fprintf (fp, "%.2f %.2f translate\n", px, py);
}

/* ----- close_epsf: close epsf file ----- */
void close_epsf (fp)
FILE *fp;
{
  fprintf (fp, 
           "\nshowpage\nend\n"
           "cleartomark origstate restore grestore\n\n");
}


/* ----- write_pagebreak ----- */
void write_pagebreak (fp)
FILE *fp;
{

  close_page (fp);
  init_page  (fp);
  if (strlen(page_init)>0) fprintf(fp,"%s\n", page_init);
  posy=cfmt.pageheight-cfmt.topmargin;
  
}
