#!/bin/sh

# Based on a shell script by Brendan Macmillan <bren@cs.monash.edu.au>
# Modifed based on a comment by Eric Petersen [Aero] <epeterse@msi.umn.edu>
# Julian Gilbey <J.D.Gilbey@qmw.ac.uk>  3 December 1997

# in case the noclobber environment variable is set
unset noclobber

if [ "$1" != "" ]
then
  FILE=$1
  if [ ! -f $FILE ]
  then
    FILE=$1".tex"
  fi
  if [ -f $FILE ]
  then
    BASE=`basename $FILE .tex`
    EX=$BASE".ex"
    sed '
    /^\\immediate/ d
    /^\\let\\:/d 
    /^\\nopagenumbers/ d
    /^\\input/ d
    /^\\readmod/ d
    /^\\vfill\\eject/ d
    /^\\bye/ d
    /^\\startmuflex/  s/\\startmuflex//' $FILE > $EX
  else
    echo "Can't find either $1 or $FILE"
  fi
else
  echo "tex2ex: Strip .tex input file to give a .ex output file"
  echo "Usage: $0 filename"
fi

