/*	bin2src.c -
 *		convert to C source file from binary data file
 *
 *			Date:	1999 Jan 30
 *			Auther: KIMURA Takamichi<takamiti@tsden.org>
 *
 *	options:
 *		-o = output file name(if ommited, out to "stdout")
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/types.h>
#include "extipl.h"

#define DOT_INC			".inc"

static int bin2src(FILE *, char *, off_t);
static int parse_line(char *, char **, char **);


main(argc, argv)
int argc;
char **argv;
{
    FILE *templet, *output;
    char line[LBUF_SIZE], *outfile, *av[64], *work;
    char **s, *p;
    int n, i, ac;
    long skip;

    outfile =  NULL;
    while (--argc > 0 && *(*(++argv)) == '-') {
	p = *argv + 1;
	while (*p) {
	    s = NULL;
	    switch(*p) {
	    case 'o': s = &outfile;	break;
	    default:  exit(1);
	    }
	    if (s != NULL) {
		++p;
		if (*p) *s = p;
		else if (++argv, --argc != 0)
		    *s = *argv;
		else
		    exit(1);
		break;
	    }
	}
    }

    if (*argv == NULL || (templet = fopen(*argv, "r")) == NULL) {
	fprintf(stderr, "can not open templet file\n");
	exit(1);
    }

    if (outfile == NULL) {
	output = stdout;
    } else {
	if ((output = fopen(outfile, "w")) == NULL) {
	    fprintf(stderr, "can not open output file\n");
	    exit(1);
	}
    }
    n = 1;
    while(n > 0 && fgets(line, LBUF_SIZE, templet) != NULL) {
	if (*line == '.' && (ac = parse_line(line, av, &work)) > 0) {
	    if (ac >= 2 && strcmp(av[0], DOT_INC) == 0) {
		skip = 0L;
		for(i = 2; i < ac; i++) {
		    if (strncmp(av[i], "skip=", 5) == 0) {
			skip = atol(av[i] + 5);
		    }
		}
		n = bin2src(output, av[1], (off_t)skip);
	    } else
		fputs(line, output);
	    free(work);
	} else
	    fputs(line, output);
    }
    fclose(output);
    fclose(templet);
    if (n <= 0) {
	unlink(outfile);
	exit(1);
    }
    exit(0);
}

static int bin2src(fp, name, skip)
FILE *fp;
char *name;
off_t skip;
{
    int fd, n, i;
    char buf[SECTOR_SIZE], *p;

    if ((fd = open(name, O_RDONLY)) < 0) {
	perror(name);
	return(-1);
    }
    if (lseek(fd, skip, SEEK_SET) < 0)
	n = 0;
    else
	n = read(fd, buf, SECTOR_SIZE);
    close(fd);
    if (n == 0) {
	fprintf(stderr, "%s: read error\n", name);
	return(0);
    }
    if (n >= IPL_MAGIC_POS) {
	fprintf(stderr, "%s: program too long\n", name);
	return(-1);
    }
    for(p = buf, i = 0; i < n; i++, p++) {
	if (i % 8 == 0)
	    fprintf(fp, "%s", i == 0 ? "\t" : "\n\t");
	fprintf(fp, "0x%02X, ", *p & 0xff);
    }
    fprintf(fp, "\n\t/* %d bytes */\n", i);
    return(n);
}

static int parse_line(buf, av, dst)
char *buf, **av, **dst;
{
    int quote, ac;
    char *s;

    if ((s = *dst = strdup(buf)) == NULL)
	return(-1);

    quote = ac = 0;
    while(*buf) {
	while(*buf && (isspace(*buf) || *buf == '\n')) buf++;
	*av = s;
	while(*buf) {
	    if (quote == 0 && (isspace(*buf) || *buf == '\n')) break;
	    switch(*buf) {
	    case '"':
		    quote = 1 - quote;
	    case '\\':
		    buf++;
		    if (*buf == 0) break;
	    default:
		    *s++ = *buf++;
		    break;
	    }
	}
	*s++ = 0;
	ac++;
	av++;
    }
    av = NULL;
    if (quote || ac == 0) {
	free(*dst);
	*dst = NULL;
	if (quote) return(-1);
    }
    return(ac);
}
