/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi_copies.c,v 1.5 1999/11/08 06:20:22 bbarrett Exp $
 * 
 *	Function:	- widgets for setting number of application copies
 */

#define _NO_PROTO

#include <Xm/ArrowBG.h>
#include <Xm/Form.h>
#include <Xm/TextF.h>

#include <ctype.h>
#include <stdio.h>
#include "lam.h"

/*
 * local definitions
 */
#define XMPI_UPARROW	((XtPointer) 1)
#define XMPI_DOWNARROW	((XtPointer) 2)

/*
 * external functions
 */
extern int4		stoi();

/*
 * local functions
 */
static void		do_arrow();
static void		verify();
static void		change();

/*
 * local variables
 */
static int		copies = 0;		/* counter as value */
static Widget		text_w;			/* counter as text */
static Widget		sc_w = 0;		/* container */

/*
 *	xmpi_copies_get
 *
 *	Function:	- copy counter accessor
 *	Returns:	- copy counter text
 */
char *
xmpi_copies_get()

{
	char		*s;
	
	XtVaGetValues(text_w, XmNvalue, &s, NULL);
	return(s);
}

/*
 *	xmpi_copies_create
 *
 *	Function:	- create the widget for setting the copy counter
 *	Accepts:	- parent widget
 *	Returns:	- copy counter setting widget
 */
Widget
xmpi_copies_create(parent_w)

Widget			parent_w;

{
	Widget		up_w;		/* up arrow */
	Widget		down_w;		/* down arrow */
	Dimension	height;

	if (sc_w != 0) return(sc_w);
	
	sc_w = XtVaCreateWidget("setcopies",
			xmFormWidgetClass, parent_w, NULL);
/*
 * Create the text field.
 */
	text_w = XtVaCreateManagedWidget("text",
		xmTextFieldWidgetClass, sc_w,
		XmNvalue, "",
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);
	XtVaGetValues(text_w, XmNheight, &height, NULL);
	XtAddCallback(text_w, XmNmodifyVerifyCallback, verify, NULL);
	XtAddCallback(text_w, XmNvalueChangedCallback, change, NULL);
/*
 * Create the up arrow.
 */
	up_w = XtVaCreateManagedWidget("uparrow",
		xmArrowButtonGadgetClass, sc_w,
		XmNarrowDirection, XmARROW_UP,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNborderWidth, 0,
		NULL);

	XtAddCallback(up_w, XmNactivateCallback, do_arrow, XMPI_UPARROW);
/*
 * Create the down arrow.
 */
	down_w = XtVaCreateManagedWidget("downarrow",
		xmArrowButtonGadgetClass, sc_w,
		XmNarrowDirection, XmARROW_DOWN,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, up_w,
		NULL);

	XtAddCallback(down_w, XmNactivateCallback, do_arrow, XMPI_DOWNARROW);
	
	XtVaSetValues(text_w,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, down_w,
		NULL);

	return(sc_w);
}

/*
 *	do_arrow
 *
 *	Function:	- manage arrows of copy counter
 *			- increment/decrement copy counter
 *	Accepts:	- callback parameters
 */
static void
do_arrow(parent_w, data, cbs)

Widget			parent_w;
XtPointer		data;
XmArrowButtonCallbackStruct
			*cbs;

{
	char		fbuf[16];	/* small formatting buffer */
	int		inc;

	inc = (cbs->event->xbutton.state & ShiftMask) ? 10 : 1;

	if (data == XMPI_UPARROW) {
		copies += inc;
	} else {
		copies -= inc;
	}
	if (copies < 0) copies = 0;

	if (copies > 0) {
		sprintf(fbuf, "%d", copies);
	} else {
		fbuf[0] = 0;
	}
	XtVaSetValues(text_w, XmNvalue, fbuf, NULL);
}

/*
 *	verify
 *
 *	Function:	- verify numeric input for copy counter
 *	Accepts:	- callback parameters
 */
static void
verify(parent_w, unused, cbs)

Widget			parent_w;
XtPointer		unused;
XmTextVerifyCallbackStruct
			*cbs;

{
	int		i;
	
	if (cbs->event == NULL || cbs->text->ptr == NULL) return;

	for (i = 0; i < cbs->text->length; i++) {
		if (! isdigit((int)cbs->text->ptr[i])) {
			cbs->doit = False;
			return;
		}
	}
}

/*
 *	change
 *
 *	Function:	- update counter to reflect text change
 *	Accepts:	- callback parameters
 */
static void
change(parent_w, unused, cbs)

Widget			parent_w;
XtPointer		unused;
XmTextVerifyCallbackStruct
			*cbs;

{
	char		*s;
	
	if (cbs->event == NULL) return;

	XtVaGetValues(text_w, XmNvalue, &s, NULL);

	if (s == 0 || *s == 0) {
		copies = 0;
	} else {
		copies = (int) stoi((unsigned char *)s);
	}
}
