/*	$Id: mkdoc.c,v 1.3 1997/09/08 10:22:32 sandro Exp $	*/

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <err.h>

struct fentry {
	char	*name;
	char	*key1;
	char	*key2;
	char	*key3;
	char	*key4;
	char	*doc;
} fentry_table[] = {
#define X0(zile_name, c_name) \
	{ zile_name },
#define X1(zile_name, c_name, key1) \
	{ zile_name, key1},
#define X2(zile_name, c_name, key1, key2) \
	{ zile_name, key1, key2},
#define X3(zile_name, c_name, key1, key2, key3) \
	{ zile_name, key1, key2, key3},
#define X4(zile_name, c_name, key1, key2, key3, key4) \
	{ zile_name, key1, key2, key3, key4},
#include "tbl_funcs.h"
#undef X0
#undef X1
#undef X2
#undef X3
#undef X4
};

#define fentry_table_size (sizeof(fentry_table) / sizeof fentry_table[0])

FILE *input_file = stdin;
FILE *output_file = stdout;

static void
fdecl(char *name)
{
	char *doc, buf[1024];
	int size, maxsize;
	int i, s = 0;

	size = 0;
	maxsize = 30;
	doc = (char *)xmalloc(maxsize);
	doc[0] = '\0';

	while (fgets(buf, 1024, input_file) != NULL) {
		if (s == 1) {
			if (!strncmp(buf, "+*/", 3))
				break;
			i = strlen(buf);
			if (size + i >= maxsize) {
				maxsize += i + 10;
				doc = (char *)xrealloc(doc, maxsize);
			}
			strcat(doc, buf);
			size += i;
		}
		if (!strncmp(buf, "/*+", 3))
			s = 1;
		else if (buf[0] == '{')
			break;
	}

	for (i = 0; i < fentry_table_size; ++i)
		if (!strcmp(name, fentry_table[i].name))
			fentry_table[i].doc = doc;
}

static void
parse(void)
{
	char buf[1024];

	while (fgets(buf, 1024, input_file) != NULL) {
		if (!strncmp(buf, "DEFUN(", 6)) {
			*strchr(strchr(buf, '"') + 1, '"') = '\0';
			fdecl(strchr(buf, '"') + 1);
		}
	}
}

static void
dump_document(void)
{
	int i;

	fprintf(output_file, "@c -------- By function\n");
	fprintf(output_file, "@table\n");
	for (i = 0; i < fentry_table_size; ++i) {
		fprintf(output_file, "@item %s\n%s",
			fentry_table[i].name, fentry_table[i].doc);
	}
	fprintf(output_file, "@end table\n");

	fprintf(output_file, "@c -------- By key\n");
	fprintf(output_file, "@table\n");
	for (i = 0; i < fentry_table_size; ++i) {
		if (fentry_table[i].key1 != NULL)
			fprintf(output_file, "@item %s\n", fentry_table[i].key1);
		else
			continue;
		if (fentry_table[i].key2 != NULL)
			fprintf(output_file, "@item %s\n", fentry_table[i].key2);
		if (fentry_table[i].key3 != NULL)
			fprintf(output_file, "@item %s\n", fentry_table[i].key3);
		if (fentry_table[i].key4 != NULL)
			fprintf(output_file, "@item %s\n", fentry_table[i].key4);
		fprintf(output_file, "%s", fentry_table[i].doc);
	}
	fprintf(output_file, "@end table\n");
}

static void
dump_help(void)
{
	int i;
	for (i = 0; i < fentry_table_size; ++i) {
		fprintf(output_file, "\fF_%s\n%s",
			fentry_table[i].name, fentry_table[i].doc);
	}
}

static void
process_file(char *filename)
{
	if (filename != NULL && strcmp(filename, "-") != 0) {
		if ((input_file = fopen(filename, "r")) == NULL)
			err(1, "%s", filename);
	} else
		input_file = stdin;

	parse();

	if (input_file != stdin)
		fclose(input_file);
}

/*
 * Output the program syntax then exit.
 */
static void
usage(void)
{
	fprintf(stderr, "usage: mkdoc [-d] [-o file] [file ...]\n");
	exit(1);
}

int
main(int argc, char **argv)
{
	int c, opt_d = 0;

	while ((c = getopt(argc, argv, "do:")) != -1)
		switch (c) {
		case 'd':
			opt_d = 1;
			break;
		case 'o':
			if (output_file != stdout)
				fclose(output_file);
			if ((output_file = fopen(optarg, "w")) == NULL)
				err(1, "%s", optarg);
			break;
		case '?':
		default:
			usage();
			/* NOTREACHED */
		}
	argc -= optind;
	argv += optind;

	if (argc < 1)
		process_file(NULL);
	else
		while (*argv)
			process_file(*argv++);

	if (opt_d)
		dump_document();
	else
		dump_help();

	return 0;
}
