/*	$Id: glue.c,v 1.8 1997/10/31 20:35:49 sandro Exp $	*/

/*
 * Copyright (c) 1997
 *	Sandro Sigala, Brescia, Italy.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#include <assert.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "zile.h"
#include "extern.h"

/*
 * Emit an error sound only when the appropriate variable
 * is set.
 */
void
ding(void)
{
	if (thisflag & FLAG_DEFINING_MACRO)
		cancel_kbd_macro();

	if (lookup_bool_variable("beep"))
		cur_tp->beep();

	thisflag |= FLAG_GOT_ERROR;
}

/*
 * Wait for `msecs' milliseconds or until a key is pressed.
 * The key is then available with cur_tp->getkey().
 */
void
waitkey(int msecs)
{
	int c;

	if ((c = cur_tp->xgetkey(GETKEY_DELAYED, msecs)) != KBD_NOKEY)
		cur_tp->ungetkey(c);
}

/*
 * Wait for `msecs' milliseconds or until a key is pressed.
 * The key is returned.
 */
int
waitkey_discard(int msecs)
{
	return cur_tp->xgetkey(GETKEY_DELAYED, msecs);
}

/*
 * Copy a region of text into an allocated buffer.
 */
char *
copy_text_block(int startn, int starto, size_t size)
{
	char *buf, *sp, *dp;
	int max_size, n;
	linep lp;

	max_size = 10;
	dp = buf = (char *)xmalloc(max_size);

	lp = cur_wp->pointp;
	n = cur_wp->pointn;
	if (n > startn)
		do
			lp = lp->prev;
		while (--n > startn);
	else if (n < startn)
		do
			lp = lp->next;
		while (++n < startn);

	sp = lp->text + starto;

	while (dp - buf < size) {
		if (dp - buf + 1 > max_size) {
			int save_off = dp - buf;
			max_size += 10;
			buf = (char *)xrealloc(buf, max_size);
			dp = buf + save_off;
		}
		if (sp < lp->text + lp->size)
			*dp++ = *sp++;
		else {
			*dp++ = '\n';
			lp = lp->next;
			sp = lp->text;
		}
	}

	return buf;
}

/*
 * Return a string of maximum length `maxlen' beginning with a `...'
 * sequence if a cut is need.
 */
char *
short_string(char *dest, char *s, int maxlen)
{
	int len;

	if ((len = strlen(s)) <= maxlen)
		strcpy(dest, s);
	else {
		strcpy(dest, "...");
		strcpy(dest + 3, s + len - maxlen + 3);
	}

	return dest;
}
