// dxifile.cpp
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "dxifile.h"
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

static char *months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
                          "Aug", "Sep", "Oct", "Nov", "Dec", NULL};

static struct segstruct {
    long freq;
    unsigned char band;
    unsigned char mode;
} segments[] = {
    {1830, BAND_160M, CW_MODE},
    {1900, BAND_160M, SSB_MODE},
    {3750, BAND_80M, CW_MODE},
    {4000, BAND_80M, SSB_MODE},
    {7150, BAND_40M, CW_MODE},
    {7300, BAND_40M, SSB_MODE},
    {10150, BAND_30M, CW_MODE},
    {14150, BAND_20M, CW_MODE},
    {14350, BAND_20M, SSB_MODE},
    {18100, BAND_18M, CW_MODE},
    {18168, BAND_12M, SSB_MODE},
    {21200, BAND_15M, CW_MODE},
    {21450, BAND_15M, SSB_MODE},
    {24900, BAND_12M, CW_MODE},
    {24990, BAND_12M, SSB_MODE},
    {28300, BAND_10M, CW_MODE},
    {29700, BAND_10M, SSB_MODE},
    {50100, BAND_50MHZ, CW_MODE},
    {51000, BAND_50MHZ, SSB_MODE},
    {54000, BAND_50MHZ, FM_MODE},
    {144100, BAND_144MHZ, CW_MODE},
    {144700, BAND_144MHZ, SSB_MODE},
    {148000, BAND_144MHZ, FM_MODE},
    {222100, BAND_222MHZ, CW_MODE},
    {222400, BAND_222MHZ, SSB_MODE},
    {225000, BAND_222MHZ, FM_MODE},
    {440000, BAND_432MHZ, SSB_MODE},
    {450000, BAND_432MHZ, FM_MODE},
    {928000, BAND_902MHZ, SSB_MODE},
    {1300000, BAND_1GHZ, SSB_MODE},
    {2450000, BAND_2GHZ, SSB_MODE},
    {3500000, BAND_3GHZ, SSB_MODE},
    {5900000, BAND_5GHZ, SSB_MODE},
    {10500000, BAND_10GHZ, SSB_MODE},
    {24250000, BAND_24GHZ, SSB_MODE},
    {0, 0, 0}
};

RDxiFile::RDxiFile(char *filename)
{
    location = 0;
    RDxiFile::open(filename);
}

boolean RDxiFile::open(char *filename, int mode)
{
    if (!RFile::open(filename, mode))
        return FALSE;

    header.contest = CQ_WW_CONTEST;             // Only one supported right now.

    if (header.contest == CQ_WW_CONTEST)
        ctyFile = new RCtyFile("cqww.cty");
    
    location = 0;

    return TRUE;
}

boolean RDxiFile::nextQso(qso_data *qso)
{
    char buffer[MAX_DXI_LINE_SIZE];
    struct tm dosTime;
    unsigned char count;
    char *tempPtr;
    long freq;
    struct segstruct *bandsegs = &segments[0];

    char country[80], prefix[80];
    int zone;

    qso->init();
    memset(&dosTime, '\0', sizeof(struct tm));

    RFile::read((void *)buffer, MAX_DXI_LINE_SIZE);
    if (RFile::eof())
        return FALSE;

    //Is this a valid record?
    tempPtr = strtok(buffer, " ");
    if (*tempPtr != 'O')
        return FALSE;

    // Get frequency and mode.
    freq = atol(strtok(NULL, " "));
    while (bandsegs->freq != 0)
    {
        if (freq <= bandsegs->freq)
        {
            qso->setBand(bandsegs->band);
            qso->setMode(bandsegs->mode);
            break;
        }
        bandsegs++;
    }
    
    // Get callsign of station worked.
    qso->setCallsign(strtok(NULL, " "));

    // Get the date
    dosTime.tm_mday = atoi(strtok(NULL, " -"));
    tempPtr = strtok(NULL, " -");
    for (count = 0; months[count] != NULL
                    && strcmp(months[count],&buffer[10]) != 0; count++);
    if (months[count] != NULL)                    
        dosTime.tm_mon = count;
    dosTime.tm_year = atoi(strtok(NULL, " -"));
    // Get the time
    tempPtr = strtok(NULL, " ");
    tempPtr[strlen(tempPtr)] = (char)NULL;      // Get rid of trailing 'Z'
    dosTime.tm_min = atoi(&tempPtr[2]);
    tempPtr[2] = (char)NULL;
    dosTime.tm_hour = atoi(tempPtr);
    dosTime.tm_sec = 0;
    dosTime.tm_isdst = 0;
    qso->setTime(mktime(&dosTime) - timezone);

    if ((qso->getMode() == CW_MODE) || (qso->getMode() == RTTY_MODE))
        qso->setReceivedRST(599);
    else
        qso->setReceivedRST(59);

    switch (header.contest) {
        case ARRL_DX_CONTEST:
        case CQ_WPX_CONTEST:
            qso->setInfo("100");
            break;
        case CQ_WW_CONTEST:
            ctyFile->GetInfo(qso->getCallsign(), country, prefix, &zone);
            qso->setCqZone(zone);
            break;
        case ALL_ASIAN_CONTEST:
            qso->setInfo("35");
            break;
        case SAC_CONTEST:
            qso->setInfo("1");
            break;
        default:
            return FALSE;
    }
    
    location++;
    return TRUE;
}


boolean RDxiFile::writeHeader(header_data newheader)
{
    // This capability not yet implemented.
    newheader = newheader;
    return FALSE;
}

boolean RDxiFile::writeQso(qso_data *qso)
{
    // This capability not yet implemented.
    qso = qso;
    return FALSE;
}
