/*
 * Copyright (C) 1999  Rob Crittenden (rcrit@greyoak.com)
 * Copyright (C) 1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_LADDER_TYPES
#define INCLUDED_LADDER_TYPES

typedef struct
{
    double       prob;
    unsigned int k;
    int          adj;
    unsigned int oldrating;
    unsigned int oldrank;
} t_ladder_info;

typedef enum
{
    ladder_sort_highestrated,
    ladder_sort_mostwins,
    ladder_sort_mostgames
} t_ladder_sort;

typedef enum
{
    ladder_time_active,
    ladder_time_current
} t_ladder_time;

#endif

#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_LADDER_PROTOS
#define INCLUDED_LADDER_PROTOS

#define JUST_NEED_TYPES
#include "account.h"
#include "game.h"
#undef JUST_NEED_TYPES

extern int ladder_init(void);
extern int ladder_init_account(t_account * account, char const * clienttag);
extern int ladder_update(char const * clienttag, unsigned int count, t_account * * players, t_game_result * results, t_ladder_info * info);
extern int ladder_make_all_active(void);

extern int ladder_check_map(char const * mapname, char const * clienttag);

extern t_account * ladder_get_account_by_rank(unsigned int rank, t_ladder_sort lsort, t_ladder_time ltime, char const * clienttag);
extern unsigned int ladder_get_rank_by_account(t_account * account, t_ladder_sort lsort, t_ladder_time ltime, char const * clienttag);

#endif
#endif
