/*
 * Copyright (C) 1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_LIST_TYPES
#define INCLUDED_LIST_TYPES

typedef struct list
#ifdef LIST_INTERNAL_ACCESS
{
    struct list * next;
    void *        data;
}
#endif
t_list;

#endif


#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_LIST_PROTOS
#define INCLUDED_LIST_PROTOS

extern unsigned int list_get_length(t_list const * list);
extern int list_prepend_item(t_list * * list, void * data);
extern int list_append_item(t_list * * list, void * data);
extern t_list * * list_find_item(t_list * * list, void const * data);
extern int list_remove(t_list * * list); /* delete head */
extern int list_remove_item(t_list * * list, void const * data); /* delete item */
extern int list_set_item(t_list * list, void * data);
extern void * list_get_item(t_list const * list);
extern void * list_get_item_by_pos(t_list const * list, unsigned int pos);
extern t_list const * const * list_get_next_const(t_list const * list);
extern t_list * * list_get_next(t_list * list);

#endif
#endif
