/*
 * GSDV_RST.C - PGS raster device routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
  
#include "pgs.h"
#include "gsrast.h"

#define _PG_RST_N_FONTS 1

static int
 **_PG_rst_marker_fonts = NULL,
  *_PG_rst_current_font = NULL;

static char
 _PG_rst_char_list[] = "!\"#$%&\'()*+,-./0123456789:;<=>\?@ABCDEFG\
HIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

static void
 SC_DECLARE(_PG_rst_query_pointer,
	    (PG_device *dev, int *px, int *py, int *pb, int *pq)),
 SC_DECLARE(_PG_rst_clear_page, (PG_device *dev, int i)),
 SC_DECLARE(_PG_rst_clear_window, (PG_device *dev)),
 SC_DECLARE(_PG_rst_clear_viewport, (PG_device *dev)),
 SC_DECLARE(_PG_rst_clear_region_NDC,
	    (PG_device *dev, double xmn, double xmx,
	     double ymn, double ymx, int pad)),
 SC_DECLARE(_PG_rst_expose_device, (PG_device *dev)),
 SC_DECLARE(_PG_rst_make_device_current, (PG_device *dev)),
 SC_DECLARE(_PG_rst_map_to_color_table, (PG_device *dev, PG_palette *pal)),
 SC_DECLARE(_PG_rst_next_line, (PG_device *dev)),
 SC_DECLARE(_PG_rst_query, (PG_device *dev, int *pdx, int *pdy, int *pnc)),
 SC_DECLARE(_PG_rst_release_current_device, (PG_device *dev)),
 SC_DECLARE(_PG_rst_update_vs, (PG_device *dev)),
 SC_DECLARE(_PG_rst_make_def_font, (int *marker_indices)),
 SC_DECLARE(_PG_rst_write_text, (PG_device *dev, FILE *fp, char *s));

static int
 SC_DECLARE(_PG_rst_init_fonts, (PG_device *dev));

/* from the corresponding PR file */

int
 SC_DECLARE(_PG_rst_set_font,
	    (PG_device *dev, char *face, char *style, int size));

void
 SC_DECLARE(_PG_rst_draw_disjoint_polyline_2,
	    (PG_device *dev, REAL *x, REAL *y,
	     long n, int flag, int coord)),
 SC_DECLARE(_PG_rst_draw_curve, (PG_device *dev, PG_curve *crv, int clip)),
 SC_DECLARE(_PG_rst_draw_to_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_rst_draw_to_rel, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_rst_get_text_ext_NDC,
	    (PG_device *dev, char *s, REAL *px, REAL *py)),
 SC_DECLARE(_PG_rst_get_image, (PG_device *dev, unsigned char *bf,
				int ix, int iy, int nx, int ny)),
 SC_DECLARE(_PG_rst_set_clipping, (PG_device *dev, int flag)),
 SC_DECLARE(_PG_rst_set_char_line, (PG_device *dev, int n)),
 SC_DECLARE(_PG_rst_set_char_path, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_rst_set_char_precision, (PG_device *dev, int p)),
 SC_DECLARE(_PG_rst_set_char_space, (PG_device *dev, double s)),
 SC_DECLARE(_PG_rst_set_char_size_NDC, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_rst_set_char_up, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_rst_set_fill_color, (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_rst_set_line_color, (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_rst_set_line_style, (PG_device *dev, int style)),
 SC_DECLARE(_PG_rst_set_line_width, (PG_device *dev, double width)),
 SC_DECLARE(_PG_rst_set_text_color, (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_rst_shade_poly, (PG_device *dev, REAL *x, REAL *y, int n)),
 SC_DECLARE(_PG_rst_fill_curve, (PG_device *dev, PG_curve *crv)),
 SC_DECLARE(_PG_rst_move_gr_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_rst_move_tx_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_rst_move_tx_rel, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_rst_put_image,
	    (PG_device *dev, unsigned char *bf, int ix, int iy,
	     int nx, int ny));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* PG_SETUP_RASTER_DEVICE - do the device dependent device initialization
 *                        - for PG_make_device
 */

void PG_setup_raster_device(d)
   PG_device *d;
   {

    d->type_index              = RASTER_DEVICE;

    d->query_pointer           = _PG_rst_query_pointer;
    d->clear_page              = _PG_rst_clear_page;
    d->clear_window            = _PG_rst_clear_window;
    d->clear_viewport          = _PG_rst_clear_viewport;
    d->clear_region_NDC        = _PG_rst_clear_region_NDC;
    d->close_device            = NULL;  /* device specific */
    d->draw_dj_polyln_2        = _PG_rst_draw_disjoint_polyline_2;
    d->draw_curve              = _PG_rst_draw_curve;
    d->draw_to_abs             = _PG_rst_draw_to_abs;
    d->draw_to_rel             = _PG_rst_draw_to_rel;
    d->expose_device           = _PG_rst_expose_device;
    d->finish_plot             = NULL;  /* device specific */
    d->get_char                = NULL;
    d->get_image               = _PG_rst_get_image;
    d->get_text_ext_NDC        = _PG_rst_get_text_ext_NDC;
    d->ggets                   = (PFfgets) io_gets_hook;
    d->gputs                   = NULL;
    d->make_device_current     = _PG_rst_make_device_current;
    d->map_to_color_table      = _PG_rst_map_to_color_table;
    d->match_rgb_colors        = _PG_match_rgb_colors;
    d->move_gr_abs             = _PG_rst_move_gr_abs;
    d->move_tx_abs             = _PG_rst_move_tx_abs;
    d->move_tx_rel             = _PG_rst_move_tx_rel;
    d->next_line               = _PG_rst_next_line;
    d->open_screen             = NULL;   /* device specific */
    d->put_image               = _PG_rst_put_image;
    d->query_screen            = _PG_rst_query;
    d->release_current_device  = _PG_rst_release_current_device;
    d->resolution_scale_factor = 1;
    d->set_bound               = _PG_set_bound;
    d->set_clipping            = _PG_rst_set_clipping;
    d->set_char_line           = _PG_rst_set_char_line;
    d->set_char_path           = _PG_rst_set_char_path;
    d->set_char_precision      = _PG_rst_set_char_precision;
    d->set_char_size_NDC       = _PG_rst_set_char_size_NDC;
    d->set_char_space          = _PG_rst_set_char_space;
    d->set_char_up             = _PG_rst_set_char_up;
    d->set_fill_color          = _PG_rst_set_fill_color;
    d->set_font                = _PG_rst_set_font;
    d->set_line_color          = _PG_rst_set_line_color;
    d->set_line_style          = _PG_rst_set_line_style;
    d->set_line_width          = _PG_rst_set_line_width;
    d->set_text_color          = _PG_rst_set_text_color;
    d->shade_poly              = _PG_rst_shade_poly;
    d->fill_curve              = _PG_rst_fill_curve;
    d->update_vs               = _PG_rst_update_vs;
    d->write_text              = _PG_rst_write_text;

    _PG_rst_init_fonts(d);

    return;}

/*--------------------------------------------------------------------------*/

/*                         GENERAL RASTER FUNCTIONS                         */

/*--------------------------------------------------------------------------*/

/* PG_MAKE_RASTER_DEVICE - make a raster device struct */

PG_RAST_device *PG_make_raster_device(w, h, name, infr, rgb, fp)
   int w, h;
   char *name;
   frame *infr;
   int rgb;
   FILE *fp;
   {int i;
    PG_RAST_device *rdev;

    rdev = FMAKE(PG_RAST_device, "PG_MAKE_RASTER_DEVICE:rdev");

    rdev->quant     = 0;
    rdev->dctnum    = 0;
    rdev->width     = w;
    rdev->height    = h;
    rdev->rgb_mode  = rgb;
    rdev->out_fname = SC_strsavef(name, "char*:PG_MAKE_RASTER_DEVICE:fname");
    rdev->mb_bits   = 0;
    rdev->mb_type   = 0;
    rdev->fp        = fp;
    rdev->off       = 0;
    rdev->bits_left = 0;

    for (i = 0; i < WRITE_LENGTH; i++)
        rdev->data[i] = 0;

    rdev->first_recon_frame = NULL;
    rdev->last_recon_frame  = NULL;
    rdev->inner_frame       = infr;
    rdev->last_frame        = NULL;

    return(rdev);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PG_FREE_RASTER_DEVICE - release a raster device struct */

void PG_free_raster_device(rdev)
   PG_RAST_device *rdev;
   {

    SFREE(rdev->out_fname);
    SFREE(rdev);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_MAKE_FRAME - make a raster frame */

frame *_PG_make_frame(w, h)
   int w, h;
   {frame *nfr;

    nfr = FMAKE(frame, "_PG_MAKE_FRAME:nfr");
    if (nfr == NULL)
       return(NULL);

/* NOTE: we need w*h/4 for Cb, Cr but the frame will be computed as
 *       RGB and converted to YCbCr at the end so have all the
 *       spaces be w*h
 */
    nfr->Y  = FMAKE_N(unsigned char, w*h, "_PG_MAKE_FRAME:Y");
    nfr->Cb = FMAKE_N(unsigned char, w*h, "_PG_MAKE_FRAME:Cb");
    nfr->Cr = FMAKE_N(unsigned char, w*h, "_PG_MAKE_FRAME:Cr");

    nfr->width  = w;
    nfr->height = h;

    return(nfr);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_FREE_FRAME - release a raster frame */

void _PG_free_frame(fr)
   frame *fr;
   {

    if (fr == NULL)
       return;

    if (fr->Y != NULL)
       SFREE(fr->Y);

    if (fr->Cb != NULL)
       SFREE(fr->Cb);

    if (fr->Cr != NULL)
       SFREE(fr->Cr);

    SFREE(fr);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_COPY_FRAME - make a copy of the frame data */

void _PG_copy_frame(fr1, fr2)
   frame *fr1, *fr2;
   {

    memcpy(fr1->Y, fr2->Y, fr1->width*fr1->height);
    memcpy(fr1->Cb, fr2->Cb, fr1->width*fr1->height/4);
    memcpy(fr1->Cr, fr2->Cr, fr1->width*fr1->height/4);

    return;}

/*--------------------------------------------------------------------------*/

/*                        FONT MANAGEMENT ROUTINES                          */

/*--------------------------------------------------------------------------*/

/* _PG_RST_INIT_FONTS - set up the fonts */

static int _PG_rst_init_fonts(dev)
   PG_device *dev;
   {int i;

    if (_PG_rst_marker_fonts != NULL)
       return(TRUE);
    
    _PG_rst_marker_fonts = FMAKE_N(int *, _PG_RST_N_FONTS,
                                   "_PG_RST_INIT_FONTS:_PG_rst_marker_fonts");
    if (_PG_rst_marker_fonts == NULL)
        return(FALSE);

    for (i = 0; i < _PG_RST_N_FONTS; i++)
        {_PG_rst_marker_fonts[i] = FMAKE_N(int, strlen(_PG_rst_char_list),
                                           "_PG_RST_INIT_FONTS:_PG_rst_marker_fonts[]");
         if (_PG_rst_marker_fonts[i] == NULL)
             return(FALSE);}

/* set up the default (and for now, only) raster font */
    _PG_rst_make_def_font(_PG_rst_marker_fonts[0]);

    _PG_rst_current_font = _PG_rst_marker_fonts[0];

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_RL_RST_FONTS - release the raster fonts */

void _PG_rl_rst_fonts()
   {int i;

    if (_PG_rst_marker_fonts != NULL)
       {for (i = 0; i < _PG_RST_N_FONTS; i++)
	    {SFREE(_PG_rst_marker_fonts[i]);};

	SFREE(_PG_rst_marker_fonts);

	_PG_rst_current_font = NULL;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_RST_MAKE_DEF_FONT - set up the default font */

static void _PG_rst_make_def_font(marker_indices)
   int *marker_indices;
   {REAL x1[50], y1[50], x2[50], y2[50];
    int index = 0;

/* define '!'  */
    x1[0] = 0.0000;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = -0.1667;

    x1[1] = 0.0000;
    y1[1] = -0.5833;

    x2[1] = -0.0833;
    y2[1] = -0.6667;

    x1[2] = -0.0833;
    y1[2] = -0.6667;

    x2[2] = 0.0000;
    y2[2] = -0.7500;

    x1[3] = 0.0000;
    y1[3] = -0.7500;

    x2[3] = 0.0833;
    y2[3] = -0.6667;

    x1[4] = 0.0833;
    y1[4] = -0.6667;

    x2[4] = 0.0000;
    y2[4] = -0.5833;

    marker_indices[index++] = PG_def_marker(5, x1, y1, x2, y2);

/* define '"'  */
    x1[0] = -0.3333;
    y1[0] = 1.0000;

    x2[0] = -0.3333;
    y2[0] = 0.4167;

    x1[1] = 0.3333;
    y1[1] = 1.0000;

    x2[1] = 0.3333;
    y2[1] = 0.4167;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define '#'  */
    x1[0] = 0.0833;
    y1[0] = 1.3333;

    x2[0] = -0.5000;
    y2[0] = -1.3333;

    x1[1] = 0.5833;
    y1[1] = 1.3333;

    x2[1] = 0.0000;
    y2[1] = -1.3333;

    x1[2] = -0.5000;
    y1[2] = 0.2500;

    x2[2] = 0.6667;
    y2[2] = 0.2500;

    x1[3] = -0.5833;
    y1[3] = -0.2500;

    x2[3] = 0.5833;
    y2[3] = -0.2500;

    marker_indices[index++] = PG_def_marker(4, x1, y1, x2, y2);

/* define '$'  */
    x1[0] = -0.1667;
    y1[0] = 1.3333;

    x2[0] = -0.1667;
    y2[0] = -1.0833;

    x1[1] = 0.1667;
    y1[1] = 1.3333;

    x2[1] = 0.1667;
    y2[1] = -1.0833;

    x1[2] = 0.5833;
    y1[2] = 0.7500;

    x2[2] = 0.4167;
    y2[2] = 0.9167;

    x1[3] = 0.4167;
    y1[3] = 0.9167;

    x2[3] = 0.1667;
    y2[3] = 1.0000;

    x1[4] = 0.1667;
    y1[4] = 1.0000;

    x2[4] = -0.1667;
    y2[4] = 1.0000;

    x1[5] = -0.1667;
    y1[5] = 1.0000;

    x2[5] = -0.4167;
    y2[5] = 0.9167;

    x1[6] = -0.4167;
    y1[6] = 0.9167;

    x2[6] = -0.5833;
    y2[6] = 0.7500;

    x1[7] = -0.5833;
    y1[7] = 0.7500;

    x2[7] = -0.5833;
    y2[7] = 0.5833;

    x1[8] = -0.5833;
    y1[8] = 0.5833;

    x2[8] = -0.5000;
    y2[8] = 0.4167;

    x1[9] = -0.5000;
    y1[9] = 0.4167;

    x2[9] = -0.4167;
    y2[9] = 0.3333;

    x1[10] = -0.4167;
    y1[10] = 0.3333;

    x2[10] = -0.2500;
    y2[10] = 0.2500;

    x1[11] = -0.2500;
    y1[11] = 0.2500;

    x2[11] = 0.2500;
    y2[11] = 0.0833;

    x1[12] = 0.2500;
    y1[12] = 0.0833;

    x2[12] = 0.4167;
    y2[12] = 0.0000;

    x1[13] = 0.4167;
    y1[13] = 0.0000;

    x2[13] = 0.5000;
    y2[13] = -0.0833;

    x1[14] = 0.5000;
    y1[14] = -0.0833;

    x2[14] = 0.5833;
    y2[14] = -0.2500;

    x1[15] = 0.5833;
    y1[15] = -0.2500;

    x2[15] = 0.5833;
    y2[15] = -0.5000;

    x1[16] = 0.5833;
    y1[16] = -0.5000;

    x2[16] = 0.4167;
    y2[16] = -0.6667;

    x1[17] = 0.4167;
    y1[17] = -0.6667;

    x2[17] = 0.1667;
    y2[17] = -0.7500;

    x1[18] = 0.1667;
    y1[18] = -0.7500;

    x2[18] = -0.1667;
    y2[18] = -0.7500;

    x1[19] = -0.1667;
    y1[19] = -0.7500;

    x2[19] = -0.4167;
    y2[19] = -0.6667;

    x1[20] = -0.4167;
    y1[20] = -0.6667;

    x2[20] = -0.5833;
    y2[20] = -0.5000;

    marker_indices[index++] = PG_def_marker(21, x1, y1, x2, y2);

/* define '%'  */
    x1[0] = 0.7500;
    y1[0] = 1.0000;

    x2[0] = -0.7500;
    y2[0] = -0.7500;

    x1[1] = -0.3333;
    y1[1] = 1.0000;

    x2[1] = -0.1667;
    y2[1] = 0.8333;

    x1[2] = -0.1667;
    y1[2] = 0.8333;

    x2[2] = -0.1667;
    y2[2] = 0.6667;

    x1[3] = -0.1667;
    y1[3] = 0.6667;

    x2[3] = -0.2500;
    y2[3] = 0.5000;

    x1[4] = -0.2500;
    y1[4] = 0.5000;

    x2[4] = -0.4167;
    y2[4] = 0.4167;

    x1[5] = -0.4167;
    y1[5] = 0.4167;

    x2[5] = -0.5833;
    y2[5] = 0.4167;

    x1[6] = -0.5833;
    y1[6] = 0.4167;

    x2[6] = -0.7500;
    y2[6] = 0.5833;

    x1[7] = -0.7500;
    y1[7] = 0.5833;

    x2[7] = -0.7500;
    y2[7] = 0.7500;

    x1[8] = -0.7500;
    y1[8] = 0.7500;

    x2[8] = -0.6667;
    y2[8] = 0.9167;

    x1[9] = -0.6667;
    y1[9] = 0.9167;

    x2[9] = -0.5000;
    y2[9] = 1.0000;

    x1[10] = -0.5000;
    y1[10] = 1.0000;

    x2[10] = -0.3333;
    y2[10] = 1.0000;

    x1[11] = -0.3333;
    y1[11] = 1.0000;

    x2[11] = -0.1667;
    y2[11] = 0.9167;

    x1[12] = -0.1667;
    y1[12] = 0.9167;

    x2[12] = 0.0833;
    y2[12] = 0.8333;

    x1[13] = 0.0833;
    y1[13] = 0.8333;

    x2[13] = 0.3333;
    y2[13] = 0.8333;

    x1[14] = 0.3333;
    y1[14] = 0.8333;

    x2[14] = 0.5833;
    y2[14] = 0.9167;

    x1[15] = 0.5833;
    y1[15] = 0.9167;

    x2[15] = 0.7500;
    y2[15] = 1.0000;

    x1[16] = 0.4167;
    y1[16] = -0.1667;

    x2[16] = 0.2500;
    y2[16] = -0.2500;

    x1[17] = 0.2500;
    y1[17] = -0.2500;

    x2[17] = 0.1667;
    y2[17] = -0.4167;

    x1[18] = 0.1667;
    y1[18] = -0.4167;

    x2[18] = 0.1667;
    y2[18] = -0.5833;

    x1[19] = 0.1667;
    y1[19] = -0.5833;

    x2[19] = 0.3333;
    y2[19] = -0.7500;

    x1[20] = 0.3333;
    y1[20] = -0.7500;

    x2[20] = 0.5000;
    y2[20] = -0.7500;

    x1[21] = 0.5000;
    y1[21] = -0.7500;

    x2[21] = 0.6667;
    y2[21] = -0.6667;

    x1[22] = 0.6667;
    y1[22] = -0.6667;

    x2[22] = 0.7500;
    y2[22] = -0.5000;

    x1[23] = 0.7500;
    y1[23] = -0.5000;

    x2[23] = 0.7500;
    y2[23] = -0.3333;

    x1[24] = 0.7500;
    y1[24] = -0.3333;

    x2[24] = 0.5833;
    y2[24] = -0.1667;

    x1[25] = 0.5833;
    y1[25] = -0.1667;

    x2[25] = 0.4167;
    y2[25] = -0.1667;

    marker_indices[index++] = PG_def_marker(26, x1, y1, x2, y2);

/* define '&'  */
    x1[0] = 0.8333;
    y1[0] = 0.2500;

    x2[0] = 0.8333;
    y2[0] = 0.3333;

    x1[1] = 0.8333;
    y1[1] = 0.3333;

    x2[1] = 0.7500;
    y2[1] = 0.4167;

    x1[2] = 0.7500;
    y1[2] = 0.4167;

    x2[2] = 0.6667;
    y2[2] = 0.4167;

    x1[3] = 0.6667;
    y1[3] = 0.4167;

    x2[3] = 0.5833;
    y2[3] = 0.3333;

    x1[4] = 0.5833;
    y1[4] = 0.3333;

    x2[4] = 0.5000;
    y2[4] = 0.1667;

    x1[5] = 0.5000;
    y1[5] = 0.1667;

    x2[5] = 0.3333;
    y2[5] = -0.2500;

    x1[6] = 0.3333;
    y1[6] = -0.2500;

    x2[6] = 0.1667;
    y2[6] = -0.5000;

    x1[7] = 0.1667;
    y1[7] = -0.5000;

    x2[7] = 0.0000;
    y2[7] = -0.6667;

    x1[8] = 0.0000;
    y1[8] = -0.6667;

    x2[8] = -0.1667;
    y2[8] = -0.7500;

    x1[9] = -0.1667;
    y1[9] = -0.7500;

    x2[9] = -0.5000;
    y2[9] = -0.7500;

    x1[10] = -0.5000;
    y1[10] = -0.7500;

    x2[10] = -0.6667;
    y2[10] = -0.6667;

    x1[11] = -0.6667;
    y1[11] = -0.6667;

    x2[11] = -0.7500;
    y2[11] = -0.5833;

    x1[12] = -0.7500;
    y1[12] = -0.5833;

    x2[12] = -0.8333;
    y2[12] = -0.4167;

    x1[13] = -0.8333;
    y1[13] = -0.4167;

    x2[13] = -0.8333;
    y2[13] = -0.2500;

    x1[14] = -0.8333;
    y1[14] = -0.2500;

    x2[14] = -0.7500;
    y2[14] = -0.0833;

    x1[15] = -0.7500;
    y1[15] = -0.0833;

    x2[15] = -0.6667;
    y2[15] = 0.0000;

    x1[16] = -0.6667;
    y1[16] = 0.0000;

    x2[16] = -0.0833;
    y2[16] = 0.3333;

    x1[17] = -0.0833;
    y1[17] = 0.3333;

    x2[17] = 0.0000;
    y2[17] = 0.4167;

    x1[18] = 0.0000;
    y1[18] = 0.4167;

    x2[18] = 0.0833;
    y2[18] = 0.5833;

    x1[19] = 0.0833;
    y1[19] = 0.5833;

    x2[19] = 0.0833;
    y2[19] = 0.7500;

    x1[20] = 0.0833;
    y1[20] = 0.7500;

    x2[20] = 0.0000;
    y2[20] = 0.9167;

    x1[21] = 0.0000;
    y1[21] = 0.9167;

    x2[21] = -0.1667;
    y2[21] = 1.0000;

    x1[22] = -0.1667;
    y1[22] = 1.0000;

    x2[22] = -0.3333;
    y2[22] = 0.9167;

    x1[23] = -0.3333;
    y1[23] = 0.9167;

    x2[23] = -0.4167;
    y2[23] = 0.7500;

    x1[24] = -0.4167;
    y1[24] = 0.7500;

    x2[24] = -0.4167;
    y2[24] = 0.5833;

    x1[25] = -0.4167;
    y1[25] = 0.5833;

    x2[25] = -0.3333;
    y2[25] = 0.3333;

    x1[26] = -0.3333;
    y1[26] = 0.3333;

    x2[26] = -0.1667;
    y2[26] = 0.0833;

    x1[27] = -0.1667;
    y1[27] = 0.0833;

    x2[27] = 0.2500;
    y2[27] = -0.5000;

    x1[28] = 0.2500;
    y1[28] = -0.5000;

    x2[28] = 0.4167;
    y2[28] = -0.6667;

    x1[29] = 0.4167;
    y1[29] = -0.6667;

    x2[29] = 0.5833;
    y2[29] = -0.7500;

    x1[30] = 0.5833;
    y1[30] = -0.7500;

    x2[30] = 0.7500;
    y2[30] = -0.7500;

    x1[31] = 0.7500;
    y1[31] = -0.7500;

    x2[31] = 0.8333;
    y2[31] = -0.6667;

    x1[32] = 0.8333;
    y1[32] = -0.6667;

    x2[32] = 0.8333;
    y2[32] = -0.5833;

    marker_indices[index++] = PG_def_marker(33, x1, y1, x2, y2);

/* define '''  */
    x1[0] = 0.0000;
    y1[0] = 0.8333;

    x2[0] = -0.0833;
    y2[0] = 0.9167;

    x1[1] = -0.0833;
    y1[1] = 0.9167;

    x2[1] = 0.0000;
    y2[1] = 1.0000;

    x1[2] = 0.0000;
    y1[2] = 1.0000;

    x2[2] = 0.0833;
    y2[2] = 0.9167;

    x1[3] = 0.0833;
    y1[3] = 0.9167;

    x2[3] = 0.0833;
    y2[3] = 0.7500;

    x1[4] = 0.0833;
    y1[4] = 0.7500;

    x2[4] = 0.0000;
    y2[4] = 0.5833;

    x1[5] = 0.0000;
    y1[5] = 0.5833;

    x2[5] = -0.0833;
    y2[5] = 0.5000;

    marker_indices[index++] = PG_def_marker(6, x1, y1, x2, y2);

/* define '('  */
    x1[0] = 0.3333;
    y1[0] = 1.3333;

    x2[0] = 0.1667;
    y2[0] = 1.1667;

    x1[1] = 0.1667;
    y1[1] = 1.1667;

    x2[1] = 0.0000;
    y2[1] = 0.9167;

    x1[2] = 0.0000;
    y1[2] = 0.9167;

    x2[2] = -0.1667;
    y2[2] = 0.5833;

    x1[3] = -0.1667;
    y1[3] = 0.5833;

    x2[3] = -0.2500;
    y2[3] = 0.1667;

    x1[4] = -0.2500;
    y1[4] = 0.1667;

    x2[4] = -0.2500;
    y2[4] = -0.1667;

    x1[5] = -0.2500;
    y1[5] = -0.1667;

    x2[5] = -0.1667;
    y2[5] = -0.5833;

    x1[6] = -0.1667;
    y1[6] = -0.5833;

    x2[6] = 0.0000;
    y2[6] = -0.9167;

    x1[7] = 0.0000;
    y1[7] = -0.9167;

    x2[7] = 0.1667;
    y2[7] = -1.1667;

    x1[8] = 0.1667;
    y1[8] = -1.1667;

    x2[8] = 0.3333;
    y2[8] = -1.3333;

    marker_indices[index++] = PG_def_marker(9, x1, y1, x2, y2);

/* define ')'  */
    x1[0] = -0.3333;
    y1[0] = 1.3333;

    x2[0] = -0.1667;
    y2[0] = 1.1667;

    x1[1] = -0.1667;
    y1[1] = 1.1667;

    x2[1] = 0.0000;
    y2[1] = 0.9167;

    x1[2] = 0.0000;
    y1[2] = 0.9167;

    x2[2] = 0.1667;
    y2[2] = 0.5833;

    x1[3] = 0.1667;
    y1[3] = 0.5833;

    x2[3] = 0.2500;
    y2[3] = 0.1667;

    x1[4] = 0.2500;
    y1[4] = 0.1667;

    x2[4] = 0.2500;
    y2[4] = -0.1667;

    x1[5] = 0.2500;
    y1[5] = -0.1667;

    x2[5] = 0.1667;
    y2[5] = -0.5833;

    x1[6] = 0.1667;
    y1[6] = -0.5833;

    x2[6] = 0.0000;
    y2[6] = -0.9167;

    x1[7] = 0.0000;
    y1[7] = -0.9167;

    x2[7] = -0.1667;
    y2[7] = -1.1667;

    x1[8] = -0.1667;
    y1[8] = -1.1667;

    x2[8] = -0.3333;
    y2[8] = -1.3333;

    marker_indices[index++] = PG_def_marker(9, x1, y1, x2, y2);

/* define '*'  */
    x1[0] = 0.0000;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = 0.0000;

    x1[1] = -0.4167;
    y1[1] = 0.7500;

    x2[1] = 0.4167;
    y2[1] = 0.2500;

    x1[2] = 0.4167;
    y1[2] = 0.7500;

    x2[2] = -0.4167;
    y2[2] = 0.2500;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define '+'  */
    x1[0] = 0.0000;
    y1[0] = 0.7500;

    x2[0] = 0.0000;
    y2[0] = -0.7500;

    x1[1] = -0.7500;
    y1[1] = 0.0000;

    x2[1] = 0.7500;
    y2[1] = 0.0000;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define ','  */
    x1[0] = 0.0833;
    y1[0] = -0.6667;

    x2[0] = 0.0000;
    y2[0] = -0.7500;

    x1[1] = 0.0000;
    y1[1] = -0.7500;

    x2[1] = -0.0833;
    y2[1] = -0.6667;

    x1[2] = -0.0833;
    y1[2] = -0.6667;

    x2[2] = 0.0000;
    y2[2] = -0.5833;

    x1[3] = 0.0000;
    y1[3] = -0.5833;

    x2[3] = 0.0833;
    y2[3] = -0.6667;

    x1[4] = 0.0833;
    y1[4] = -0.6667;

    x2[4] = 0.0833;
    y2[4] = -0.8333;

    x1[5] = 0.0833;
    y1[5] = -0.8333;

    x2[5] = 0.0000;
    y2[5] = -1.0000;

    x1[6] = 0.0000;
    y1[6] = -1.0000;

    x2[6] = -0.0833;
    y2[6] = -1.0833;

    marker_indices[index++] = PG_def_marker(7, x1, y1, x2, y2);

/* define '-'  */
    x1[0] = -0.7500;
    y1[0] = 0.0000;

    x2[0] = 0.7500;
    y2[0] = 0.0000;

    marker_indices[index++] = PG_def_marker(1, x1, y1, x2, y2);

/* define '.'  */
    x1[0] = 0.0000;
    y1[0] = -0.5833;

    x2[0] = -0.0833;
    y2[0] = -0.6667;

    x1[1] = -0.0833;
    y1[1] = -0.6667;

    x2[1] = 0.0000;
    y2[1] = -0.7500;

    x1[2] = 0.0000;
    y1[2] = -0.7500;

    x2[2] = 0.0833;
    y2[2] = -0.6667;

    x1[3] = 0.0833;
    y1[3] = -0.6667;

    x2[3] = 0.0000;
    y2[3] = -0.5833;

    marker_indices[index++] = PG_def_marker(4, x1, y1, x2, y2);

/* define '/'  */
    x1[0] = 0.7500;
    y1[0] = 1.3333;

    x2[0] = -0.7500;
    y2[0] = -1.3333;

    marker_indices[index++] = PG_def_marker(1, x1, y1, x2, y2);

/* define '0'  */
    x1[0] = -0.0833;
    y1[0] = 1.0000;

    x2[0] = -0.3333;
    y2[0] = 0.9167;

    x1[1] = -0.3333;
    y1[1] = 0.9167;

    x2[1] = -0.5000;
    y2[1] = 0.6667;

    x1[2] = -0.5000;
    y1[2] = 0.6667;

    x2[2] = -0.5833;
    y2[2] = 0.2500;

    x1[3] = -0.5833;
    y1[3] = 0.2500;

    x2[3] = -0.5833;
    y2[3] = 0.0000;

    x1[4] = -0.5833;
    y1[4] = 0.0000;

    x2[4] = -0.5000;
    y2[4] = -0.4167;

    x1[5] = -0.5000;
    y1[5] = -0.4167;

    x2[5] = -0.3333;
    y2[5] = -0.6667;

    x1[6] = -0.3333;
    y1[6] = -0.6667;

    x2[6] = -0.0833;
    y2[6] = -0.7500;

    x1[7] = -0.0833;
    y1[7] = -0.7500;

    x2[7] = 0.0833;
    y2[7] = -0.7500;

    x1[8] = 0.0833;
    y1[8] = -0.7500;

    x2[8] = 0.3333;
    y2[8] = -0.6667;

    x1[9] = 0.3333;
    y1[9] = -0.6667;

    x2[9] = 0.5000;
    y2[9] = -0.4167;

    x1[10] = 0.5000;
    y1[10] = -0.4167;

    x2[10] = 0.5833;
    y2[10] = 0.0000;

    x1[11] = 0.5833;
    y1[11] = 0.0000;

    x2[11] = 0.5833;
    y2[11] = 0.2500;

    x1[12] = 0.5833;
    y1[12] = 0.2500;

    x2[12] = 0.5000;
    y2[12] = 0.6667;

    x1[13] = 0.5000;
    y1[13] = 0.6667;

    x2[13] = 0.3333;
    y2[13] = 0.9167;

    x1[14] = 0.3333;
    y1[14] = 0.9167;

    x2[14] = 0.0833;
    y2[14] = 1.0000;

    x1[15] = 0.0833;
    y1[15] = 1.0000;

    x2[15] = -0.0833;
    y2[15] = 1.0000;

    marker_indices[index++] = PG_def_marker(16, x1, y1, x2, y2);

/* define '1'  */
    x1[0] = -0.3333;
    y1[0] = 0.6667;

    x2[0] = -0.1667;
    y2[0] = 0.7500;

    x1[1] = -0.1667;
    y1[1] = 0.7500;

    x2[1] = 0.0833;
    y2[1] = 1.0000;

    x1[2] = 0.0833;
    y1[2] = 1.0000;

    x2[2] = 0.0833;
    y2[2] = -0.7500;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define '2'  */
    x1[0] = -0.5000;
    y1[0] = 0.5833;

    x2[0] = -0.5000;
    y2[0] = 0.6667;

    x1[1] = -0.5000;
    y1[1] = 0.6667;

    x2[1] = -0.4167;
    y2[1] = 0.8333;

    x1[2] = -0.4167;
    y1[2] = 0.8333;

    x2[2] = -0.3333;
    y2[2] = 0.9167;

    x1[3] = -0.3333;
    y1[3] = 0.9167;

    x2[3] = -0.1667;
    y2[3] = 1.0000;

    x1[4] = -0.1667;
    y1[4] = 1.0000;

    x2[4] = 0.1667;
    y2[4] = 1.0000;

    x1[5] = 0.1667;
    y1[5] = 1.0000;

    x2[5] = 0.3333;
    y2[5] = 0.9167;

    x1[6] = 0.3333;
    y1[6] = 0.9167;

    x2[6] = 0.4167;
    y2[6] = 0.8333;

    x1[7] = 0.4167;
    y1[7] = 0.8333;

    x2[7] = 0.5000;
    y2[7] = 0.6667;

    x1[8] = 0.5000;
    y1[8] = 0.6667;

    x2[8] = 0.5000;
    y2[8] = 0.5000;

    x1[9] = 0.5000;
    y1[9] = 0.5000;

    x2[9] = 0.4167;
    y2[9] = 0.3333;

    x1[10] = 0.4167;
    y1[10] = 0.3333;

    x2[10] = 0.2500;
    y2[10] = 0.0833;

    x1[11] = 0.2500;
    y1[11] = 0.0833;

    x2[11] = -0.5833;
    y2[11] = -0.7500;

    x1[12] = -0.5833;
    y1[12] = -0.7500;

    x2[12] = 0.5833;
    y2[12] = -0.7500;

    marker_indices[index++] = PG_def_marker(13, x1, y1, x2, y2);

/* define '3'  */
    x1[0] = -0.4167;
    y1[0] = 1.0000;

    x2[0] = 0.5000;
    y2[0] = 1.0000;

    x1[1] = 0.5000;
    y1[1] = 1.0000;

    x2[1] = 0.0000;
    y2[1] = 0.3333;

    x1[2] = 0.0000;
    y1[2] = 0.3333;

    x2[2] = 0.2500;
    y2[2] = 0.3333;

    x1[3] = 0.2500;
    y1[3] = 0.3333;

    x2[3] = 0.4167;
    y2[3] = 0.2500;

    x1[4] = 0.4167;
    y1[4] = 0.2500;

    x2[4] = 0.5000;
    y2[4] = 0.1667;

    x1[5] = 0.5000;
    y1[5] = 0.1667;

    x2[5] = 0.5833;
    y2[5] = -0.0833;

    x1[6] = 0.5833;
    y1[6] = -0.0833;

    x2[6] = 0.5833;
    y2[6] = -0.2500;

    x1[7] = 0.5833;
    y1[7] = -0.2500;

    x2[7] = 0.5000;
    y2[7] = -0.5000;

    x1[8] = 0.5000;
    y1[8] = -0.5000;

    x2[8] = 0.3333;
    y2[8] = -0.6667;

    x1[9] = 0.3333;
    y1[9] = -0.6667;

    x2[9] = 0.0833;
    y2[9] = -0.7500;

    x1[10] = 0.0833;
    y1[10] = -0.7500;

    x2[10] = -0.1667;
    y2[10] = -0.7500;

    x1[11] = -0.1667;
    y1[11] = -0.7500;

    x2[11] = -0.4167;
    y2[11] = -0.6667;

    x1[12] = -0.4167;
    y1[12] = -0.6667;

    x2[12] = -0.5000;
    y2[12] = -0.5833;

    x1[13] = -0.5000;
    y1[13] = -0.5833;

    x2[13] = -0.5833;
    y2[13] = -0.4167;

    marker_indices[index++] = PG_def_marker(14, x1, y1, x2, y2);

/* define '4'  */
    x1[0] = 0.2500;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.1667;

    x1[1] = -0.5833;
    y1[1] = -0.1667;

    x2[1] = 0.6667;
    y2[1] = -0.1667;

    x1[2] = 0.2500;
    y1[2] = 1.0000;

    x2[2] = 0.2500;
    y2[2] = -0.7500;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define '5'  */
    x1[0] = 0.4167;
    y1[0] = 1.0000;

    x2[0] = -0.4167;
    y2[0] = 1.0000;

    x1[1] = -0.4167;
    y1[1] = 1.0000;

    x2[1] = -0.5000;
    y2[1] = 0.2500;

    x1[2] = -0.5000;
    y1[2] = 0.2500;

    x2[2] = -0.4167;
    y2[2] = 0.3333;

    x1[3] = -0.4167;
    y1[3] = 0.3333;

    x2[3] = -0.1667;
    y2[3] = 0.4167;

    x1[4] = -0.1667;
    y1[4] = 0.4167;

    x2[4] = 0.0833;
    y2[4] = 0.4167;

    x1[5] = 0.0833;
    y1[5] = 0.4167;

    x2[5] = 0.3333;
    y2[5] = 0.3333;

    x1[6] = 0.3333;
    y1[6] = 0.3333;

    x2[6] = 0.5000;
    y2[6] = 0.1667;

    x1[7] = 0.5000;
    y1[7] = 0.1667;

    x2[7] = 0.5833;
    y2[7] = -0.0833;

    x1[8] = 0.5833;
    y1[8] = -0.0833;

    x2[8] = 0.5833;
    y2[8] = -0.2500;

    x1[9] = 0.5833;
    y1[9] = -0.2500;

    x2[9] = 0.5000;
    y2[9] = -0.5000;

    x1[10] = 0.5000;
    y1[10] = -0.5000;

    x2[10] = 0.3333;
    y2[10] = -0.6667;

    x1[11] = 0.3333;
    y1[11] = -0.6667;

    x2[11] = 0.0833;
    y2[11] = -0.7500;

    x1[12] = 0.0833;
    y1[12] = -0.7500;

    x2[12] = -0.1667;
    y2[12] = -0.7500;

    x1[13] = -0.1667;
    y1[13] = -0.7500;

    x2[13] = -0.4167;
    y2[13] = -0.6667;

    x1[14] = -0.4167;
    y1[14] = -0.6667;

    x2[14] = -0.5000;
    y2[14] = -0.5833;

    x1[15] = -0.5000;
    y1[15] = -0.5833;

    x2[15] = -0.5833;
    y2[15] = -0.4167;

    marker_indices[index++] = PG_def_marker(16, x1, y1, x2, y2);

/* define '6'  */
    x1[0] = 0.5000;
    y1[0] = 0.7500;

    x2[0] = 0.4167;
    y2[0] = 0.9167;

    x1[1] = 0.4167;
    y1[1] = 0.9167;

    x2[1] = 0.1667;
    y2[1] = 1.0000;

    x1[2] = 0.1667;
    y1[2] = 1.0000;

    x2[2] = 0.0000;
    y2[2] = 1.0000;

    x1[3] = 0.0000;
    y1[3] = 1.0000;

    x2[3] = -0.2500;
    y2[3] = 0.9167;

    x1[4] = -0.2500;
    y1[4] = 0.9167;

    x2[4] = -0.4167;
    y2[4] = 0.6667;

    x1[5] = -0.4167;
    y1[5] = 0.6667;

    x2[5] = -0.5000;
    y2[5] = 0.2500;

    x1[6] = -0.5000;
    y1[6] = 0.2500;

    x2[6] = -0.5000;
    y2[6] = -0.1667;

    x1[7] = -0.5000;
    y1[7] = -0.1667;

    x2[7] = -0.4167;
    y2[7] = -0.5000;

    x1[8] = -0.4167;
    y1[8] = -0.5000;

    x2[8] = -0.2500;
    y2[8] = -0.6667;

    x1[9] = -0.2500;
    y1[9] = -0.6667;

    x2[9] = 0.0000;
    y2[9] = -0.7500;

    x1[10] = 0.0000;
    y1[10] = -0.7500;

    x2[10] = 0.0833;
    y2[10] = -0.7500;

    x1[11] = 0.0833;
    y1[11] = -0.7500;

    x2[11] = 0.3333;
    y2[11] = -0.6667;

    x1[12] = 0.3333;
    y1[12] = -0.6667;

    x2[12] = 0.5000;
    y2[12] = -0.5000;

    x1[13] = 0.5000;
    y1[13] = -0.5000;

    x2[13] = 0.5833;
    y2[13] = -0.2500;

    x1[14] = 0.5833;
    y1[14] = -0.2500;

    x2[14] = 0.5833;
    y2[14] = -0.1667;

    x1[15] = 0.5833;
    y1[15] = -0.1667;

    x2[15] = 0.5000;
    y2[15] = 0.0833;

    x1[16] = 0.5000;
    y1[16] = 0.0833;

    x2[16] = 0.3333;
    y2[16] = 0.2500;

    x1[17] = 0.3333;
    y1[17] = 0.2500;

    x2[17] = 0.0833;
    y2[17] = 0.3333;

    x1[18] = 0.0833;
    y1[18] = 0.3333;

    x2[18] = 0.0000;
    y2[18] = 0.3333;

    x1[19] = 0.0000;
    y1[19] = 0.3333;

    x2[19] = -0.2500;
    y2[19] = 0.2500;

    x1[20] = -0.2500;
    y1[20] = 0.2500;

    x2[20] = -0.4167;
    y2[20] = 0.0833;

    x1[21] = -0.4167;
    y1[21] = 0.0833;

    x2[21] = -0.5000;
    y2[21] = -0.1667;

    marker_indices[index++] = PG_def_marker(22, x1, y1, x2, y2);

/* define '7'  */
    x1[0] = 0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.2500;
    y2[0] = -0.7500;

    x1[1] = -0.5833;
    y1[1] = 1.0000;

    x2[1] = 0.5833;
    y2[1] = 1.0000;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define '8'  */
    x1[0] = -0.1667;
    y1[0] = 1.0000;

    x2[0] = -0.4167;
    y2[0] = 0.9167;

    x1[1] = -0.4167;
    y1[1] = 0.9167;

    x2[1] = -0.5000;
    y2[1] = 0.7500;

    x1[2] = -0.5000;
    y1[2] = 0.7500;

    x2[2] = -0.5000;
    y2[2] = 0.5833;

    x1[3] = -0.5000;
    y1[3] = 0.5833;

    x2[3] = -0.4167;
    y2[3] = 0.4167;

    x1[4] = -0.4167;
    y1[4] = 0.4167;

    x2[4] = -0.2500;
    y2[4] = 0.3333;

    x1[5] = -0.2500;
    y1[5] = 0.3333;

    x2[5] = 0.0833;
    y2[5] = 0.2500;

    x1[6] = 0.0833;
    y1[6] = 0.2500;

    x2[6] = 0.3333;
    y2[6] = 0.1667;

    x1[7] = 0.3333;
    y1[7] = 0.1667;

    x2[7] = 0.5000;
    y2[7] = 0.0000;

    x1[8] = 0.5000;
    y1[8] = 0.0000;

    x2[8] = 0.5833;
    y2[8] = -0.1667;

    x1[9] = 0.5833;
    y1[9] = -0.1667;

    x2[9] = 0.5833;
    y2[9] = -0.4167;

    x1[10] = 0.5833;
    y1[10] = -0.4167;

    x2[10] = 0.5000;
    y2[10] = -0.5833;

    x1[11] = 0.5000;
    y1[11] = -0.5833;

    x2[11] = 0.4167;
    y2[11] = -0.6667;

    x1[12] = 0.4167;
    y1[12] = -0.6667;

    x2[12] = 0.1667;
    y2[12] = -0.7500;

    x1[13] = 0.1667;
    y1[13] = -0.7500;

    x2[13] = -0.1667;
    y2[13] = -0.7500;

    x1[14] = -0.1667;
    y1[14] = -0.7500;

    x2[14] = -0.4167;
    y2[14] = -0.6667;

    x1[15] = -0.4167;
    y1[15] = -0.6667;

    x2[15] = -0.5000;
    y2[15] = -0.5833;

    x1[16] = -0.5000;
    y1[16] = -0.5833;

    x2[16] = -0.5833;
    y2[16] = -0.4167;

    x1[17] = -0.5833;
    y1[17] = -0.4167;

    x2[17] = -0.5833;
    y2[17] = -0.1667;

    x1[18] = -0.5833;
    y1[18] = -0.1667;

    x2[18] = -0.5000;
    y2[18] = 0.0000;

    x1[19] = -0.5000;
    y1[19] = 0.0000;

    x2[19] = -0.3333;
    y2[19] = 0.1667;

    x1[20] = -0.3333;
    y1[20] = 0.1667;

    x2[20] = -0.0833;
    y2[20] = 0.2500;

    x1[21] = -0.0833;
    y1[21] = 0.2500;

    x2[21] = 0.2500;
    y2[21] = 0.3333;

    x1[22] = 0.2500;
    y1[22] = 0.3333;

    x2[22] = 0.4167;
    y2[22] = 0.4167;

    x1[23] = 0.4167;
    y1[23] = 0.4167;

    x2[23] = 0.5000;
    y2[23] = 0.5833;

    x1[24] = 0.5000;
    y1[24] = 0.5833;

    x2[24] = 0.5000;
    y2[24] = 0.7500;

    x1[25] = 0.5000;
    y1[25] = 0.7500;

    x2[25] = 0.4167;
    y2[25] = 0.9167;

    x1[26] = 0.4167;
    y1[26] = 0.9167;

    x2[26] = 0.1667;
    y2[26] = 1.0000;

    x1[27] = 0.1667;
    y1[27] = 1.0000;

    x2[27] = -0.1667;
    y2[27] = 1.0000;

    marker_indices[index++] = PG_def_marker(28, x1, y1, x2, y2);

/* define '9'  */
    x1[0] = 0.5000;
    y1[0] = 0.4167;

    x2[0] = 0.4167;
    y2[0] = 0.1667;

    x1[1] = 0.4167;
    y1[1] = 0.1667;

    x2[1] = 0.2500;
    y2[1] = 0.0000;

    x1[2] = 0.2500;
    y1[2] = 0.0000;

    x2[2] = 0.0000;
    y2[2] = -0.0833;

    x1[3] = 0.0000;
    y1[3] = -0.0833;

    x2[3] = -0.0833;
    y2[3] = -0.0833;

    x1[4] = -0.0833;
    y1[4] = -0.0833;

    x2[4] = -0.3333;
    y2[4] = 0.0000;

    x1[5] = -0.3333;
    y1[5] = 0.0000;

    x2[5] = -0.5000;
    y2[5] = 0.1667;

    x1[6] = -0.5000;
    y1[6] = 0.1667;

    x2[6] = -0.5833;
    y2[6] = 0.4167;

    x1[7] = -0.5833;
    y1[7] = 0.4167;

    x2[7] = -0.5833;
    y2[7] = 0.5000;

    x1[8] = -0.5833;
    y1[8] = 0.5000;

    x2[8] = -0.5000;
    y2[8] = 0.7500;

    x1[9] = -0.5000;
    y1[9] = 0.7500;

    x2[9] = -0.3333;
    y2[9] = 0.9167;

    x1[10] = -0.3333;
    y1[10] = 0.9167;

    x2[10] = -0.0833;
    y2[10] = 1.0000;

    x1[11] = -0.0833;
    y1[11] = 1.0000;

    x2[11] = 0.0000;
    y2[11] = 1.0000;

    x1[12] = 0.0000;
    y1[12] = 1.0000;

    x2[12] = 0.2500;
    y2[12] = 0.9167;

    x1[13] = 0.2500;
    y1[13] = 0.9167;

    x2[13] = 0.4167;
    y2[13] = 0.7500;

    x1[14] = 0.4167;
    y1[14] = 0.7500;

    x2[14] = 0.5000;
    y2[14] = 0.4167;

    x1[15] = 0.5000;
    y1[15] = 0.4167;

    x2[15] = 0.5000;
    y2[15] = 0.0000;

    x1[16] = 0.5000;
    y1[16] = 0.0000;

    x2[16] = 0.4167;
    y2[16] = -0.4167;

    x1[17] = 0.4167;
    y1[17] = -0.4167;

    x2[17] = 0.2500;
    y2[17] = -0.6667;

    x1[18] = 0.2500;
    y1[18] = -0.6667;

    x2[18] = 0.0000;
    y2[18] = -0.7500;

    x1[19] = 0.0000;
    y1[19] = -0.7500;

    x2[19] = -0.1667;
    y2[19] = -0.7500;

    x1[20] = -0.1667;
    y1[20] = -0.7500;

    x2[20] = -0.4167;
    y2[20] = -0.6667;

    x1[21] = -0.4167;
    y1[21] = -0.6667;

    x2[21] = -0.5000;
    y2[21] = -0.5000;

    marker_indices[index++] = PG_def_marker(22, x1, y1, x2, y2);

/* define ':'  */
    x1[0] = 0.0000;
    y1[0] = 0.4167;

    x2[0] = -0.0833;
    y2[0] = 0.3333;

    x1[1] = -0.0833;
    y1[1] = 0.3333;

    x2[1] = 0.0000;
    y2[1] = 0.2500;

    x1[2] = 0.0000;
    y1[2] = 0.2500;

    x2[2] = 0.0833;
    y2[2] = 0.3333;

    x1[3] = 0.0833;
    y1[3] = 0.3333;

    x2[3] = 0.0000;
    y2[3] = 0.4167;

    x1[4] = 0.0000;
    y1[4] = -0.5833;

    x2[4] = -0.0833;
    y2[4] = -0.6667;

    x1[5] = -0.0833;
    y1[5] = -0.6667;

    x2[5] = 0.0000;
    y2[5] = -0.7500;

    x1[6] = 0.0000;
    y1[6] = -0.7500;

    x2[6] = 0.0833;
    y2[6] = -0.6667;

    x1[7] = 0.0833;
    y1[7] = -0.6667;

    x2[7] = 0.0000;
    y2[7] = -0.5833;

    marker_indices[index++] = PG_def_marker(8, x1, y1, x2, y2);

/* define ';'  */
    x1[0] = 0.0000;
    y1[0] = 0.4167;

    x2[0] = -0.0833;
    y2[0] = 0.3333;

    x1[1] = -0.0833;
    y1[1] = 0.3333;

    x2[1] = 0.0000;
    y2[1] = 0.2500;

    x1[2] = 0.0000;
    y1[2] = 0.2500;

    x2[2] = 0.0833;
    y2[2] = 0.3333;

    x1[3] = 0.0833;
    y1[3] = 0.3333;

    x2[3] = 0.0000;
    y2[3] = 0.4167;

    x1[4] = 0.0833;
    y1[4] = -0.6667;

    x2[4] = 0.0000;
    y2[4] = -0.7500;

    x1[5] = 0.0000;
    y1[5] = -0.7500;

    x2[5] = -0.0833;
    y2[5] = -0.6667;

    x1[6] = -0.0833;
    y1[6] = -0.6667;

    x2[6] = 0.0000;
    y2[6] = -0.5833;

    x1[7] = 0.0000;
    y1[7] = -0.5833;

    x2[7] = 0.0833;
    y2[7] = -0.6667;

    x1[8] = 0.0833;
    y1[8] = -0.6667;

    x2[8] = 0.0833;
    y2[8] = -0.8333;

    x1[9] = 0.0833;
    y1[9] = -0.8333;

    x2[9] = 0.0000;
    y2[9] = -1.0000;

    x1[10] = 0.0000;
    y1[10] = -1.0000;

    x2[10] = -0.0833;
    y2[10] = -1.0833;

    marker_indices[index++] = PG_def_marker(11, x1, y1, x2, y2);

/* define '<'  */
    x1[0] = 0.6667;
    y1[0] = 0.7500;

    x2[0] = -0.6667;
    y2[0] = 0.0000;

    x1[1] = -0.6667;
    y1[1] = 0.0000;

    x2[1] = 0.6667;
    y2[1] = -0.7500;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define '='  */
    x1[0] = -0.7500;
    y1[0] = 0.2500;

    x2[0] = 0.7500;
    y2[0] = 0.2500;

    x1[1] = -0.7500;
    y1[1] = -0.2500;

    x2[1] = 0.7500;
    y2[1] = -0.2500;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define '>'  */
    x1[0] = -0.6667;
    y1[0] = 0.7500;

    x2[0] = 0.6667;
    y2[0] = 0.0000;

    x1[1] = 0.6667;
    y1[1] = 0.0000;

    x2[1] = -0.6667;
    y2[1] = -0.7500;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define '?'  */
    x1[0] = -0.5000;
    y1[0] = 0.5833;

    x2[0] = -0.5000;
    y2[0] = 0.6667;

    x1[1] = -0.5000;
    y1[1] = 0.6667;

    x2[1] = -0.4167;
    y2[1] = 0.8333;

    x1[2] = -0.4167;
    y1[2] = 0.8333;

    x2[2] = -0.3333;
    y2[2] = 0.9167;

    x1[3] = -0.3333;
    y1[3] = 0.9167;

    x2[3] = -0.1667;
    y2[3] = 1.0000;

    x1[4] = -0.1667;
    y1[4] = 1.0000;

    x2[4] = 0.1667;
    y2[4] = 1.0000;

    x1[5] = 0.1667;
    y1[5] = 1.0000;

    x2[5] = 0.3333;
    y2[5] = 0.9167;

    x1[6] = 0.3333;
    y1[6] = 0.9167;

    x2[6] = 0.4167;
    y2[6] = 0.8333;

    x1[7] = 0.4167;
    y1[7] = 0.8333;

    x2[7] = 0.5000;
    y2[7] = 0.6667;

    x1[8] = 0.5000;
    y1[8] = 0.6667;

    x2[8] = 0.5000;
    y2[8] = 0.5000;

    x1[9] = 0.5000;
    y1[9] = 0.5000;

    x2[9] = 0.4167;
    y2[9] = 0.3333;

    x1[10] = 0.4167;
    y1[10] = 0.3333;

    x2[10] = 0.3333;
    y2[10] = 0.2500;

    x1[11] = 0.3333;
    y1[11] = 0.2500;

    x2[11] = 0.0000;
    y2[11] = 0.0833;

    x1[12] = 0.0000;
    y1[12] = 0.0833;

    x2[12] = 0.0000;
    y2[12] = -0.1667;

    x1[13] = 0.0000;
    y1[13] = -0.5833;

    x2[13] = -0.0833;
    y2[13] = -0.6667;

    x1[14] = -0.0833;
    y1[14] = -0.6667;

    x2[14] = 0.0000;
    y2[14] = -0.7500;

    x1[15] = 0.0000;
    y1[15] = -0.7500;

    x2[15] = 0.0833;
    y2[15] = -0.6667;

    x1[16] = 0.0833;
    y1[16] = -0.6667;

    x2[16] = 0.0000;
    y2[16] = -0.5833;

    marker_indices[index++] = PG_def_marker(17, x1, y1, x2, y2);

/* define '@'  */
    x1[0] = 0.4167;
    y1[0] = 0.3333;

    x2[0] = 0.3333;
    y2[0] = 0.5000;

    x1[1] = 0.3333;
    y1[1] = 0.5000;

    x2[1] = 0.1667;
    y2[1] = 0.5833;

    x1[2] = 0.1667;
    y1[2] = 0.5833;

    x2[2] = -0.0833;
    y2[2] = 0.5833;

    x1[3] = -0.0833;
    y1[3] = 0.5833;

    x2[3] = -0.2500;
    y2[3] = 0.5000;

    x1[4] = -0.2500;
    y1[4] = 0.5000;

    x2[4] = -0.3333;
    y2[4] = 0.4167;

    x1[5] = -0.3333;
    y1[5] = 0.4167;

    x2[5] = -0.4167;
    y2[5] = 0.1667;

    x1[6] = -0.4167;
    y1[6] = 0.1667;

    x2[6] = -0.4167;
    y2[6] = -0.0833;

    x1[7] = -0.4167;
    y1[7] = -0.0833;

    x2[7] = -0.3333;
    y2[7] = -0.2500;

    x1[8] = -0.3333;
    y1[8] = -0.2500;

    x2[8] = -0.1667;
    y2[8] = -0.3333;

    x1[9] = -0.1667;
    y1[9] = -0.3333;

    x2[9] = 0.0833;
    y2[9] = -0.3333;

    x1[10] = 0.0833;
    y1[10] = -0.3333;

    x2[10] = 0.2500;
    y2[10] = -0.2500;

    x1[11] = 0.2500;
    y1[11] = -0.2500;

    x2[11] = 0.3333;
    y2[11] = -0.0833;

    x1[12] = -0.0833;
    y1[12] = 0.5833;

    x2[12] = -0.2500;
    y2[12] = 0.4167;

    x1[13] = -0.2500;
    y1[13] = 0.4167;

    x2[13] = -0.3333;
    y2[13] = 0.1667;

    x1[14] = -0.3333;
    y1[14] = 0.1667;

    x2[14] = -0.3333;
    y2[14] = -0.0833;

    x1[15] = -0.3333;
    y1[15] = -0.0833;

    x2[15] = -0.2500;
    y2[15] = -0.2500;

    x1[16] = -0.2500;
    y1[16] = -0.2500;

    x2[16] = -0.1667;
    y2[16] = -0.3333;

    x1[17] = 0.4167;
    y1[17] = 0.5833;

    x2[17] = 0.3333;
    y2[17] = -0.0833;

    x1[18] = 0.3333;
    y1[18] = -0.0833;

    x2[18] = 0.3333;
    y2[18] = -0.2500;

    x1[19] = 0.3333;
    y1[19] = -0.2500;

    x2[19] = 0.5000;
    y2[19] = -0.3333;

    x1[20] = 0.5000;
    y1[20] = -0.3333;

    x2[20] = 0.6667;
    y2[20] = -0.3333;

    x1[21] = 0.6667;
    y1[21] = -0.3333;

    x2[21] = 0.8333;
    y2[21] = -0.1667;

    x1[22] = 0.8333;
    y1[22] = -0.1667;

    x2[22] = 0.9167;
    y2[22] = 0.0833;

    x1[23] = 0.9167;
    y1[23] = 0.0833;

    x2[23] = 0.9167;
    y2[23] = 0.2500;

    x1[24] = 0.9167;
    y1[24] = 0.2500;

    x2[24] = 0.8333;
    y2[24] = 0.5000;

    x1[25] = 0.8333;
    y1[25] = 0.5000;

    x2[25] = 0.7500;
    y2[25] = 0.6667;

    x1[26] = 0.7500;
    y1[26] = 0.6667;

    x2[26] = 0.5833;
    y2[26] = 0.8333;

    x1[27] = 0.5833;
    y1[27] = 0.8333;

    x2[27] = 0.4167;
    y2[27] = 0.9167;

    x1[28] = 0.4167;
    y1[28] = 0.9167;

    x2[28] = 0.1667;
    y2[28] = 1.0000;

    x1[29] = 0.1667;
    y1[29] = 1.0000;

    x2[29] = -0.0833;
    y2[29] = 1.0000;

    x1[30] = -0.0833;
    y1[30] = 1.0000;

    x2[30] = -0.3333;
    y2[30] = 0.9167;

    x1[31] = -0.3333;
    y1[31] = 0.9167;

    x2[31] = -0.5000;
    y2[31] = 0.8333;

    x1[32] = -0.5000;
    y1[32] = 0.8333;

    x2[32] = -0.6667;
    y2[32] = 0.6667;

    x1[33] = -0.6667;
    y1[33] = 0.6667;

    x2[33] = -0.7500;
    y2[33] = 0.5000;

    x1[34] = -0.7500;
    y1[34] = 0.5000;

    x2[34] = -0.8333;
    y2[34] = 0.2500;

    x1[35] = -0.8333;
    y1[35] = 0.2500;

    x2[35] = -0.8333;
    y2[35] = 0.0000;

    x1[36] = -0.8333;
    y1[36] = 0.0000;

    x2[36] = -0.7500;
    y2[36] = -0.2500;

    x1[37] = -0.7500;
    y1[37] = -0.2500;

    x2[37] = -0.6667;
    y2[37] = -0.4167;

    x1[38] = -0.6667;
    y1[38] = -0.4167;

    x2[38] = -0.5000;
    y2[38] = -0.5833;

    x1[39] = -0.5000;
    y1[39] = -0.5833;

    x2[39] = -0.3333;
    y2[39] = -0.6667;

    x1[40] = -0.3333;
    y1[40] = -0.6667;

    x2[40] = -0.0833;
    y2[40] = -0.7500;

    x1[41] = -0.0833;
    y1[41] = -0.7500;

    x2[41] = 0.1667;
    y2[41] = -0.7500;

    x1[42] = 0.1667;
    y1[42] = -0.7500;

    x2[42] = 0.4167;
    y2[42] = -0.6667;

    x1[43] = 0.4167;
    y1[43] = -0.6667;

    x2[43] = 0.5833;
    y2[43] = -0.5833;

    x1[44] = 0.5833;
    y1[44] = -0.5833;

    x2[44] = 0.6667;
    y2[44] = -0.5000;

    x1[45] = 0.5000;
    y1[45] = 0.5833;

    x2[45] = 0.4167;
    y2[45] = -0.0833;

    x1[46] = 0.4167;
    y1[46] = -0.0833;

    x2[46] = 0.4167;
    y2[46] = -0.2500;

    x1[47] = 0.4167;
    y1[47] = -0.2500;

    x2[47] = 0.5000;
    y2[47] = -0.3333;

    marker_indices[index++] = PG_def_marker(48, x1, y1, x2, y2);

/* define 'A'  */
    x1[0] = 0.0000;
    y1[0] = 1.0000;

    x2[0] = -0.6667;
    y2[0] = -0.7500;

    x1[1] = 0.0000;
    y1[1] = 1.0000;

    x2[1] = 0.6667;
    y2[1] = -0.7500;

    x1[2] = -0.4167;
    y1[2] = -0.1667;

    x2[2] = 0.4167;
    y2[2] = -0.1667;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define 'B'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.7500;

    x1[1] = -0.5833;
    y1[1] = 1.0000;

    x2[1] = 0.1667;
    y2[1] = 1.0000;

    x1[2] = 0.1667;
    y1[2] = 1.0000;

    x2[2] = 0.4167;
    y2[2] = 0.9167;

    x1[3] = 0.4167;
    y1[3] = 0.9167;

    x2[3] = 0.5000;
    y2[3] = 0.8333;

    x1[4] = 0.5000;
    y1[4] = 0.8333;

    x2[4] = 0.5833;
    y2[4] = 0.6667;

    x1[5] = 0.5833;
    y1[5] = 0.6667;

    x2[5] = 0.5833;
    y2[5] = 0.5000;

    x1[6] = 0.5833;
    y1[6] = 0.5000;

    x2[6] = 0.5000;
    y2[6] = 0.3333;

    x1[7] = 0.5000;
    y1[7] = 0.3333;

    x2[7] = 0.4167;
    y2[7] = 0.2500;

    x1[8] = 0.4167;
    y1[8] = 0.2500;

    x2[8] = 0.1667;
    y2[8] = 0.1667;

    x1[9] = -0.5833;
    y1[9] = 0.1667;

    x2[9] = 0.1667;
    y2[9] = 0.1667;

    x1[10] = 0.1667;
    y1[10] = 0.1667;

    x2[10] = 0.4167;
    y2[10] = 0.0833;

    x1[11] = 0.4167;
    y1[11] = 0.0833;

    x2[11] = 0.5000;
    y2[11] = 0.0000;

    x1[12] = 0.5000;
    y1[12] = 0.0000;

    x2[12] = 0.5833;
    y2[12] = -0.1667;

    x1[13] = 0.5833;
    y1[13] = -0.1667;

    x2[13] = 0.5833;
    y2[13] = -0.4167;

    x1[14] = 0.5833;
    y1[14] = -0.4167;

    x2[14] = 0.5000;
    y2[14] = -0.5833;

    x1[15] = 0.5000;
    y1[15] = -0.5833;

    x2[15] = 0.4167;
    y2[15] = -0.6667;

    x1[16] = 0.4167;
    y1[16] = -0.6667;

    x2[16] = 0.1667;
    y2[16] = -0.7500;

    x1[17] = 0.1667;
    y1[17] = -0.7500;

    x2[17] = -0.5833;
    y2[17] = -0.7500;

    marker_indices[index++] = PG_def_marker(18, x1, y1, x2, y2);

/* define 'C'  */
    x1[0] = 0.6667;
    y1[0] = 0.5833;

    x2[0] = 0.5833;
    y2[0] = 0.7500;

    x1[1] = 0.5833;
    y1[1] = 0.7500;

    x2[1] = 0.4167;
    y2[1] = 0.9167;

    x1[2] = 0.4167;
    y1[2] = 0.9167;

    x2[2] = 0.2500;
    y2[2] = 1.0000;

    x1[3] = 0.2500;
    y1[3] = 1.0000;

    x2[3] = -0.0833;
    y2[3] = 1.0000;

    x1[4] = -0.0833;
    y1[4] = 1.0000;

    x2[4] = -0.2500;
    y2[4] = 0.9167;

    x1[5] = -0.2500;
    y1[5] = 0.9167;

    x2[5] = -0.4167;
    y2[5] = 0.7500;

    x1[6] = -0.4167;
    y1[6] = 0.7500;

    x2[6] = -0.5000;
    y2[6] = 0.5833;

    x1[7] = -0.5000;
    y1[7] = 0.5833;

    x2[7] = -0.5833;
    y2[7] = 0.3333;

    x1[8] = -0.5833;
    y1[8] = 0.3333;

    x2[8] = -0.5833;
    y2[8] = -0.0833;

    x1[9] = -0.5833;
    y1[9] = -0.0833;

    x2[9] = -0.5000;
    y2[9] = -0.3333;

    x1[10] = -0.5000;
    y1[10] = -0.3333;

    x2[10] = -0.4167;
    y2[10] = -0.5000;

    x1[11] = -0.4167;
    y1[11] = -0.5000;

    x2[11] = -0.2500;
    y2[11] = -0.6667;

    x1[12] = -0.2500;
    y1[12] = -0.6667;

    x2[12] = -0.0833;
    y2[12] = -0.7500;

    x1[13] = -0.0833;
    y1[13] = -0.7500;

    x2[13] = 0.2500;
    y2[13] = -0.7500;

    x1[14] = 0.2500;
    y1[14] = -0.7500;

    x2[14] = 0.4167;
    y2[14] = -0.6667;

    x1[15] = 0.4167;
    y1[15] = -0.6667;

    x2[15] = 0.5833;
    y2[15] = -0.5000;

    x1[16] = 0.5833;
    y1[16] = -0.5000;

    x2[16] = 0.6667;
    y2[16] = -0.3333;

    marker_indices[index++] = PG_def_marker(17, x1, y1, x2, y2);

/* define 'D'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.7500;

    x1[1] = -0.5833;
    y1[1] = 1.0000;

    x2[1] = 0.0000;
    y2[1] = 1.0000;

    x1[2] = 0.0000;
    y1[2] = 1.0000;

    x2[2] = 0.2500;
    y2[2] = 0.9167;

    x1[3] = 0.2500;
    y1[3] = 0.9167;

    x2[3] = 0.4167;
    y2[3] = 0.7500;

    x1[4] = 0.4167;
    y1[4] = 0.7500;

    x2[4] = 0.5000;
    y2[4] = 0.5833;

    x1[5] = 0.5000;
    y1[5] = 0.5833;

    x2[5] = 0.5833;
    y2[5] = 0.3333;

    x1[6] = 0.5833;
    y1[6] = 0.3333;

    x2[6] = 0.5833;
    y2[6] = -0.0833;

    x1[7] = 0.5833;
    y1[7] = -0.0833;

    x2[7] = 0.5000;
    y2[7] = -0.3333;

    x1[8] = 0.5000;
    y1[8] = -0.3333;

    x2[8] = 0.4167;
    y2[8] = -0.5000;

    x1[9] = 0.4167;
    y1[9] = -0.5000;

    x2[9] = 0.2500;
    y2[9] = -0.6667;

    x1[10] = 0.2500;
    y1[10] = -0.6667;

    x2[10] = 0.0000;
    y2[10] = -0.7500;

    x1[11] = 0.0000;
    y1[11] = -0.7500;

    x2[11] = -0.5833;
    y2[11] = -0.7500;

    marker_indices[index++] = PG_def_marker(12, x1, y1, x2, y2);

/* define 'E'  */
    x1[0] = -0.5000;
    y1[0] = 1.0000;

    x2[0] = -0.5000;
    y2[0] = -0.7500;

    x1[1] = -0.5000;
    y1[1] = 1.0000;

    x2[1] = 0.5833;
    y2[1] = 1.0000;

    x1[2] = -0.5000;
    y1[2] = 0.1667;

    x2[2] = 0.1667;
    y2[2] = 0.1667;

    x1[3] = -0.5000;
    y1[3] = -0.7500;

    x2[3] = 0.5833;
    y2[3] = -0.7500;

    marker_indices[index++] = PG_def_marker(4, x1, y1, x2, y2);

/* define 'F'  */
    x1[0] = -0.5000;
    y1[0] = 1.0000;

    x2[0] = -0.5000;
    y2[0] = -0.7500;

    x1[1] = -0.5000;
    y1[1] = 1.0000;

    x2[1] = 0.5833;
    y2[1] = 1.0000;

    x1[2] = -0.5000;
    y1[2] = 0.1667;

    x2[2] = 0.1667;
    y2[2] = 0.1667;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define 'G'  */
    x1[0] = 0.6667;
    y1[0] = 0.5833;

    x2[0] = 0.5833;
    y2[0] = 0.7500;

    x1[1] = 0.5833;
    y1[1] = 0.7500;

    x2[1] = 0.4167;
    y2[1] = 0.9167;

    x1[2] = 0.4167;
    y1[2] = 0.9167;

    x2[2] = 0.2500;
    y2[2] = 1.0000;

    x1[3] = 0.2500;
    y1[3] = 1.0000;

    x2[3] = -0.0833;
    y2[3] = 1.0000;

    x1[4] = -0.0833;
    y1[4] = 1.0000;

    x2[4] = -0.2500;
    y2[4] = 0.9167;

    x1[5] = -0.2500;
    y1[5] = 0.9167;

    x2[5] = -0.4167;
    y2[5] = 0.7500;

    x1[6] = -0.4167;
    y1[6] = 0.7500;

    x2[6] = -0.5000;
    y2[6] = 0.5833;

    x1[7] = -0.5000;
    y1[7] = 0.5833;

    x2[7] = -0.5833;
    y2[7] = 0.3333;

    x1[8] = -0.5833;
    y1[8] = 0.3333;

    x2[8] = -0.5833;
    y2[8] = -0.0833;

    x1[9] = -0.5833;
    y1[9] = -0.0833;

    x2[9] = -0.5000;
    y2[9] = -0.3333;

    x1[10] = -0.5000;
    y1[10] = -0.3333;

    x2[10] = -0.4167;
    y2[10] = -0.5000;

    x1[11] = -0.4167;
    y1[11] = -0.5000;

    x2[11] = -0.2500;
    y2[11] = -0.6667;

    x1[12] = -0.2500;
    y1[12] = -0.6667;

    x2[12] = -0.0833;
    y2[12] = -0.7500;

    x1[13] = -0.0833;
    y1[13] = -0.7500;

    x2[13] = 0.2500;
    y2[13] = -0.7500;

    x1[14] = 0.2500;
    y1[14] = -0.7500;

    x2[14] = 0.4167;
    y2[14] = -0.6667;

    x1[15] = 0.4167;
    y1[15] = -0.6667;

    x2[15] = 0.5833;
    y2[15] = -0.5000;

    x1[16] = 0.5833;
    y1[16] = -0.5000;

    x2[16] = 0.6667;
    y2[16] = -0.3333;

    x1[17] = 0.6667;
    y1[17] = -0.3333;

    x2[17] = 0.6667;
    y2[17] = -0.0833;

    x1[18] = 0.2500;
    y1[18] = -0.0833;

    x2[18] = 0.6667;
    y2[18] = -0.0833;

    marker_indices[index++] = PG_def_marker(19, x1, y1, x2, y2);

/* define 'H'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.7500;

    x1[1] = 0.5833;
    y1[1] = 1.0000;

    x2[1] = 0.5833;
    y2[1] = -0.7500;

    x1[2] = -0.5833;
    y1[2] = 0.1667;

    x2[2] = 0.5833;
    y2[2] = 0.1667;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define 'I'  */
    x1[0] = 0.0000;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = -0.7500;

    marker_indices[index++] = PG_def_marker(1, x1, y1, x2, y2);

/* define 'J'  */
    x1[0] = 0.3333;
    y1[0] = 1.0000;

    x2[0] = 0.3333;
    y2[0] = -0.3333;

    x1[1] = 0.3333;
    y1[1] = -0.3333;

    x2[1] = 0.2500;
    y2[1] = -0.5833;

    x1[2] = 0.2500;
    y1[2] = -0.5833;

    x2[2] = 0.1667;
    y2[2] = -0.6667;

    x1[3] = 0.1667;
    y1[3] = -0.6667;

    x2[3] = 0.0000;
    y2[3] = -0.7500;

    x1[4] = 0.0000;
    y1[4] = -0.7500;

    x2[4] = -0.1667;
    y2[4] = -0.7500;

    x1[5] = -0.1667;
    y1[5] = -0.7500;

    x2[5] = -0.3333;
    y2[5] = -0.6667;

    x1[6] = -0.3333;
    y1[6] = -0.6667;

    x2[6] = -0.4167;
    y2[6] = -0.5833;

    x1[7] = -0.4167;
    y1[7] = -0.5833;

    x2[7] = -0.5000;
    y2[7] = -0.3333;

    x1[8] = -0.5000;
    y1[8] = -0.3333;

    x2[8] = -0.5000;
    y2[8] = -0.1667;

    marker_indices[index++] = PG_def_marker(9, x1, y1, x2, y2);

/* define 'K'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.7500;

    x1[1] = 0.5833;
    y1[1] = 1.0000;

    x2[1] = -0.5833;
    y2[1] = -0.1667;

    x1[2] = -0.1667;
    y1[2] = 0.2500;

    x2[2] = 0.5833;
    y2[2] = -0.7500;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define 'L'  */
    x1[0] = -0.5000;
    y1[0] = 1.0000;

    x2[0] = -0.5000;
    y2[0] = -0.7500;

    x1[1] = -0.5000;
    y1[1] = -0.7500;

    x2[1] = 0.5000;
    y2[1] = -0.7500;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define 'M'  */
    x1[0] = -0.6667;
    y1[0] = 1.0000;

    x2[0] = -0.6667;
    y2[0] = -0.7500;

    x1[1] = -0.6667;
    y1[1] = 1.0000;

    x2[1] = 0.0000;
    y2[1] = -0.7500;

    x1[2] = 0.6667;
    y1[2] = 1.0000;

    x2[2] = 0.0000;
    y2[2] = -0.7500;

    x1[3] = 0.6667;
    y1[3] = 1.0000;

    x2[3] = 0.6667;
    y2[3] = -0.7500;

    marker_indices[index++] = PG_def_marker(4, x1, y1, x2, y2);

/* define 'N'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.7500;

    x1[1] = -0.5833;
    y1[1] = 1.0000;

    x2[1] = 0.5833;
    y2[1] = -0.7500;

    x1[2] = 0.5833;
    y1[2] = 1.0000;

    x2[2] = 0.5833;
    y2[2] = -0.7500;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define 'O'  */
    x1[0] = -0.1667;
    y1[0] = 1.0000;

    x2[0] = -0.3333;
    y2[0] = 0.9167;

    x1[1] = -0.3333;
    y1[1] = 0.9167;

    x2[1] = -0.5000;
    y2[1] = 0.7500;

    x1[2] = -0.5000;
    y1[2] = 0.7500;

    x2[2] = -0.5833;
    y2[2] = 0.5833;

    x1[3] = -0.5833;
    y1[3] = 0.5833;

    x2[3] = -0.6667;
    y2[3] = 0.3333;

    x1[4] = -0.6667;
    y1[4] = 0.3333;

    x2[4] = -0.6667;
    y2[4] = -0.0833;

    x1[5] = -0.6667;
    y1[5] = -0.0833;

    x2[5] = -0.5833;
    y2[5] = -0.3333;

    x1[6] = -0.5833;
    y1[6] = -0.3333;

    x2[6] = -0.5000;
    y2[6] = -0.5000;

    x1[7] = -0.5000;
    y1[7] = -0.5000;

    x2[7] = -0.3333;
    y2[7] = -0.6667;

    x1[8] = -0.3333;
    y1[8] = -0.6667;

    x2[8] = -0.1667;
    y2[8] = -0.7500;

    x1[9] = -0.1667;
    y1[9] = -0.7500;

    x2[9] = 0.1667;
    y2[9] = -0.7500;

    x1[10] = 0.1667;
    y1[10] = -0.7500;

    x2[10] = 0.3333;
    y2[10] = -0.6667;

    x1[11] = 0.3333;
    y1[11] = -0.6667;

    x2[11] = 0.5000;
    y2[11] = -0.5000;

    x1[12] = 0.5000;
    y1[12] = -0.5000;

    x2[12] = 0.5833;
    y2[12] = -0.3333;

    x1[13] = 0.5833;
    y1[13] = -0.3333;

    x2[13] = 0.6667;
    y2[13] = -0.0833;

    x1[14] = 0.6667;
    y1[14] = -0.0833;

    x2[14] = 0.6667;
    y2[14] = 0.3333;

    x1[15] = 0.6667;
    y1[15] = 0.3333;

    x2[15] = 0.5833;
    y2[15] = 0.5833;

    x1[16] = 0.5833;
    y1[16] = 0.5833;

    x2[16] = 0.5000;
    y2[16] = 0.7500;

    x1[17] = 0.5000;
    y1[17] = 0.7500;

    x2[17] = 0.3333;
    y2[17] = 0.9167;

    x1[18] = 0.3333;
    y1[18] = 0.9167;

    x2[18] = 0.1667;
    y2[18] = 1.0000;

    x1[19] = 0.1667;
    y1[19] = 1.0000;

    x2[19] = -0.1667;
    y2[19] = 1.0000;

    marker_indices[index++] = PG_def_marker(20, x1, y1, x2, y2);

/* define 'P'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.7500;

    x1[1] = -0.5833;
    y1[1] = 1.0000;

    x2[1] = 0.1667;
    y2[1] = 1.0000;

    x1[2] = 0.1667;
    y1[2] = 1.0000;

    x2[2] = 0.4167;
    y2[2] = 0.9167;

    x1[3] = 0.4167;
    y1[3] = 0.9167;

    x2[3] = 0.5000;
    y2[3] = 0.8333;

    x1[4] = 0.5000;
    y1[4] = 0.8333;

    x2[4] = 0.5833;
    y2[4] = 0.6667;

    x1[5] = 0.5833;
    y1[5] = 0.6667;

    x2[5] = 0.5833;
    y2[5] = 0.4167;

    x1[6] = 0.5833;
    y1[6] = 0.4167;

    x2[6] = 0.5000;
    y2[6] = 0.2500;

    x1[7] = 0.5000;
    y1[7] = 0.2500;

    x2[7] = 0.4167;
    y2[7] = 0.1667;

    x1[8] = 0.4167;
    y1[8] = 0.1667;

    x2[8] = 0.1667;
    y2[8] = 0.0833;

    x1[9] = 0.1667;
    y1[9] = 0.0833;

    x2[9] = -0.5833;
    y2[9] = 0.0833;

    marker_indices[index++] = PG_def_marker(10, x1, y1, x2, y2);

/* define 'Q'  */
    x1[0] = -0.1667;
    y1[0] = 1.0000;

    x2[0] = -0.3333;
    y2[0] = 0.9167;

    x1[1] = -0.3333;
    y1[1] = 0.9167;

    x2[1] = -0.5000;
    y2[1] = 0.7500;

    x1[2] = -0.5000;
    y1[2] = 0.7500;

    x2[2] = -0.5833;
    y2[2] = 0.5833;

    x1[3] = -0.5833;
    y1[3] = 0.5833;

    x2[3] = -0.6667;
    y2[3] = 0.3333;

    x1[4] = -0.6667;
    y1[4] = 0.3333;

    x2[4] = -0.6667;
    y2[4] = -0.0833;

    x1[5] = -0.6667;
    y1[5] = -0.0833;

    x2[5] = -0.5833;
    y2[5] = -0.3333;

    x1[6] = -0.5833;
    y1[6] = -0.3333;

    x2[6] = -0.5000;
    y2[6] = -0.5000;

    x1[7] = -0.5000;
    y1[7] = -0.5000;

    x2[7] = -0.3333;
    y2[7] = -0.6667;

    x1[8] = -0.3333;
    y1[8] = -0.6667;

    x2[8] = -0.1667;
    y2[8] = -0.7500;

    x1[9] = -0.1667;
    y1[9] = -0.7500;

    x2[9] = 0.1667;
    y2[9] = -0.7500;

    x1[10] = 0.1667;
    y1[10] = -0.7500;

    x2[10] = 0.3333;
    y2[10] = -0.6667;

    x1[11] = 0.3333;
    y1[11] = -0.6667;

    x2[11] = 0.5000;
    y2[11] = -0.5000;

    x1[12] = 0.5000;
    y1[12] = -0.5000;

    x2[12] = 0.5833;
    y2[12] = -0.3333;

    x1[13] = 0.5833;
    y1[13] = -0.3333;

    x2[13] = 0.6667;
    y2[13] = -0.0833;

    x1[14] = 0.6667;
    y1[14] = -0.0833;

    x2[14] = 0.6667;
    y2[14] = 0.3333;

    x1[15] = 0.6667;
    y1[15] = 0.3333;

    x2[15] = 0.5833;
    y2[15] = 0.5833;

    x1[16] = 0.5833;
    y1[16] = 0.5833;

    x2[16] = 0.5000;
    y2[16] = 0.7500;

    x1[17] = 0.5000;
    y1[17] = 0.7500;

    x2[17] = 0.3333;
    y2[17] = 0.9167;

    x1[18] = 0.3333;
    y1[18] = 0.9167;

    x2[18] = 0.1667;
    y2[18] = 1.0000;

    x1[19] = 0.1667;
    y1[19] = 1.0000;

    x2[19] = -0.1667;
    y2[19] = 1.0000;

    x1[20] = 0.0833;
    y1[20] = -0.4167;

    x2[20] = 0.5833;
    y2[20] = -0.9167;

    marker_indices[index++] = PG_def_marker(21, x1, y1, x2, y2);

/* define 'R'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.7500;

    x1[1] = -0.5833;
    y1[1] = 1.0000;

    x2[1] = 0.1667;
    y2[1] = 1.0000;

    x1[2] = 0.1667;
    y1[2] = 1.0000;

    x2[2] = 0.4167;
    y2[2] = 0.9167;

    x1[3] = 0.4167;
    y1[3] = 0.9167;

    x2[3] = 0.5000;
    y2[3] = 0.8333;

    x1[4] = 0.5000;
    y1[4] = 0.8333;

    x2[4] = 0.5833;
    y2[4] = 0.6667;

    x1[5] = 0.5833;
    y1[5] = 0.6667;

    x2[5] = 0.5833;
    y2[5] = 0.5000;

    x1[6] = 0.5833;
    y1[6] = 0.5000;

    x2[6] = 0.5000;
    y2[6] = 0.3333;

    x1[7] = 0.5000;
    y1[7] = 0.3333;

    x2[7] = 0.4167;
    y2[7] = 0.2500;

    x1[8] = 0.4167;
    y1[8] = 0.2500;

    x2[8] = 0.1667;
    y2[8] = 0.1667;

    x1[9] = 0.1667;
    y1[9] = 0.1667;

    x2[9] = -0.5833;
    y2[9] = 0.1667;

    x1[10] = 0.0000;
    y1[10] = 0.1667;

    x2[10] = 0.5833;
    y2[10] = -0.7500;

    marker_indices[index++] = PG_def_marker(11, x1, y1, x2, y2);

/* define 'S'  */
    x1[0] = 0.5833;
    y1[0] = 0.7500;

    x2[0] = 0.4167;
    y2[0] = 0.9167;

    x1[1] = 0.4167;
    y1[1] = 0.9167;

    x2[1] = 0.1667;
    y2[1] = 1.0000;

    x1[2] = 0.1667;
    y1[2] = 1.0000;

    x2[2] = -0.1667;
    y2[2] = 1.0000;

    x1[3] = -0.1667;
    y1[3] = 1.0000;

    x2[3] = -0.4167;
    y2[3] = 0.9167;

    x1[4] = -0.4167;
    y1[4] = 0.9167;

    x2[4] = -0.5833;
    y2[4] = 0.7500;

    x1[5] = -0.5833;
    y1[5] = 0.7500;

    x2[5] = -0.5833;
    y2[5] = 0.5833;

    x1[6] = -0.5833;
    y1[6] = 0.5833;

    x2[6] = -0.5000;
    y2[6] = 0.4167;

    x1[7] = -0.5000;
    y1[7] = 0.4167;

    x2[7] = -0.4167;
    y2[7] = 0.3333;

    x1[8] = -0.4167;
    y1[8] = 0.3333;

    x2[8] = -0.2500;
    y2[8] = 0.2500;

    x1[9] = -0.2500;
    y1[9] = 0.2500;

    x2[9] = 0.2500;
    y2[9] = 0.0833;

    x1[10] = 0.2500;
    y1[10] = 0.0833;

    x2[10] = 0.4167;
    y2[10] = 0.0000;

    x1[11] = 0.4167;
    y1[11] = 0.0000;

    x2[11] = 0.5000;
    y2[11] = -0.0833;

    x1[12] = 0.5000;
    y1[12] = -0.0833;

    x2[12] = 0.5833;
    y2[12] = -0.2500;

    x1[13] = 0.5833;
    y1[13] = -0.2500;

    x2[13] = 0.5833;
    y2[13] = -0.5000;

    x1[14] = 0.5833;
    y1[14] = -0.5000;

    x2[14] = 0.4167;
    y2[14] = -0.6667;

    x1[15] = 0.4167;
    y1[15] = -0.6667;

    x2[15] = 0.1667;
    y2[15] = -0.7500;

    x1[16] = 0.1667;
    y1[16] = -0.7500;

    x2[16] = -0.1667;
    y2[16] = -0.7500;

    x1[17] = -0.1667;
    y1[17] = -0.7500;

    x2[17] = -0.4167;
    y2[17] = -0.6667;

    x1[18] = -0.4167;
    y1[18] = -0.6667;

    x2[18] = -0.5833;
    y2[18] = -0.5000;

    marker_indices[index++] = PG_def_marker(19, x1, y1, x2, y2);

/* define 'T'  */
    x1[0] = 0.0000;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = -0.7500;

    x1[1] = -0.5833;
    y1[1] = 1.0000;

    x2[1] = 0.5833;
    y2[1] = 1.0000;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define 'U'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.2500;

    x1[1] = -0.5833;
    y1[1] = -0.2500;

    x2[1] = -0.5000;
    y2[1] = -0.5000;

    x1[2] = -0.5000;
    y1[2] = -0.5000;

    x2[2] = -0.3333;
    y2[2] = -0.6667;

    x1[3] = -0.3333;
    y1[3] = -0.6667;

    x2[3] = -0.0833;
    y2[3] = -0.7500;

    x1[4] = -0.0833;
    y1[4] = -0.7500;

    x2[4] = 0.0833;
    y2[4] = -0.7500;

    x1[5] = 0.0833;
    y1[5] = -0.7500;

    x2[5] = 0.3333;
    y2[5] = -0.6667;

    x1[6] = 0.3333;
    y1[6] = -0.6667;

    x2[6] = 0.5000;
    y2[6] = -0.5000;

    x1[7] = 0.5000;
    y1[7] = -0.5000;

    x2[7] = 0.5833;
    y2[7] = -0.2500;

    x1[8] = 0.5833;
    y1[8] = -0.2500;

    x2[8] = 0.5833;
    y2[8] = 1.0000;

    marker_indices[index++] = PG_def_marker(9, x1, y1, x2, y2);

/* define 'V'  */
    x1[0] = -0.6667;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = -0.7500;

    x1[1] = 0.6667;
    y1[1] = 1.0000;

    x2[1] = 0.0000;
    y2[1] = -0.7500;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define 'W'  */
    x1[0] = -0.8333;
    y1[0] = 1.0000;

    x2[0] = -0.4167;
    y2[0] = -0.7500;

    x1[1] = 0.0000;
    y1[1] = 1.0000;

    x2[1] = -0.4167;
    y2[1] = -0.7500;

    x1[2] = 0.0000;
    y1[2] = 1.0000;

    x2[2] = 0.4167;
    y2[2] = -0.7500;

    x1[3] = 0.8333;
    y1[3] = 1.0000;

    x2[3] = 0.4167;
    y2[3] = -0.7500;

    marker_indices[index++] = PG_def_marker(4, x1, y1, x2, y2);

/* define 'X'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = 0.5833;
    y2[0] = -0.7500;

    x1[1] = 0.5833;
    y1[1] = 1.0000;

    x2[1] = -0.5833;
    y2[1] = -0.7500;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define 'Y'  */
    x1[0] = -0.6667;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = 0.1667;

    x1[1] = 0.0000;
    y1[1] = 0.1667;

    x2[1] = 0.0000;
    y2[1] = -0.7500;

    x1[2] = 0.6667;
    y1[2] = 1.0000;

    x2[2] = 0.0000;
    y2[2] = 0.1667;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define 'Z'  */
    x1[0] = 0.5833;
    y1[0] = 1.0000;

    x2[0] = -0.5833;
    y2[0] = -0.7500;

    x1[1] = -0.5833;
    y1[1] = 1.0000;

    x2[1] = 0.5833;
    y2[1] = 1.0000;

    x1[2] = -0.5833;
    y1[2] = -0.7500;

    x2[2] = 0.5833;
    y2[2] = -0.7500;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define '['  */
    x1[0] = -0.2500;
    y1[0] = 1.3333;

    x2[0] = -0.2500;
    y2[0] = -1.3333;

    x1[1] = -0.1667;
    y1[1] = 1.3333;

    x2[1] = -0.1667;
    y2[1] = -1.3333;

    x1[2] = -0.2500;
    y1[2] = 1.3333;

    x2[2] = 0.3333;
    y2[2] = 1.3333;

    x1[3] = -0.2500;
    y1[3] = -1.3333;

    x2[3] = 0.3333;
    y2[3] = -1.3333;

    marker_indices[index++] = PG_def_marker(4, x1, y1, x2, y2);

/* define '\'  */
    x1[0] = -0.5833;
    y1[0] = 1.0000;

    x2[0] = 0.5833;
    y2[0] = -1.0000;

    marker_indices[index++] = PG_def_marker(1, x1, y1, x2, y2);

/* define ']'  */
    x1[0] = 0.1667;
    y1[0] = 1.3333;

    x2[0] = 0.1667;
    y2[0] = -1.3333;

    x1[1] = 0.2500;
    y1[1] = 1.3333;

    x2[1] = 0.2500;
    y2[1] = -1.3333;

    x1[2] = -0.3333;
    y1[2] = 1.3333;

    x2[2] = 0.2500;
    y2[2] = 1.3333;

    x1[3] = -0.3333;
    y1[3] = -1.3333;

    x2[3] = 0.2500;
    y2[3] = -1.3333;

    marker_indices[index++] = PG_def_marker(4, x1, y1, x2, y2);

/* define '^'  */
    x1[0] = -0.1667;
    y1[0] = 0.5000;

    x2[0] = 0.0000;
    y2[0] = 0.7500;

    x1[1] = 0.0000;
    y1[1] = 0.7500;

    x2[1] = 0.1667;
    y2[1] = 0.5000;

    x1[2] = -0.4167;
    y1[2] = 0.2500;

    x2[2] = 0.0000;
    y2[2] = 0.6667;

    x1[3] = 0.0000;
    y1[3] = 0.6667;

    x2[3] = 0.4167;
    y2[3] = 0.2500;

    x1[4] = 0.0000;
    y1[4] = 0.6667;

    x2[4] = 0.0000;
    y2[4] = -0.7500;

    marker_indices[index++] = PG_def_marker(5, x1, y1, x2, y2);

/* define '_'  */
    x1[0] = -0.6667;
    y1[0] = -0.9167;

    x2[0] = 0.6667;
    y2[0] = -0.9167;

    marker_indices[index++] = PG_def_marker(1, x1, y1, x2, y2);

/* define '`'  */
    x1[0] = 0.0833;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = 0.9167;

    x1[1] = 0.0000;
    y1[1] = 0.9167;

    x2[1] = -0.0833;
    y2[1] = 0.7500;

    x1[2] = -0.0833;
    y1[2] = 0.7500;

    x2[2] = -0.0833;
    y2[2] = 0.5833;

    x1[3] = -0.0833;
    y1[3] = 0.5833;

    x2[3] = 0.0000;
    y2[3] = 0.5000;

    x1[4] = 0.0000;
    y1[4] = 0.5000;

    x2[4] = 0.0833;
    y2[4] = 0.5833;

    x1[5] = 0.0833;
    y1[5] = 0.5833;

    x2[5] = 0.0000;
    y2[5] = 0.6667;

    marker_indices[index++] = PG_def_marker(6, x1, y1, x2, y2);

/* define 'a'  */
    x1[0] = 0.5000;
    y1[0] = 0.4167;

    x2[0] = 0.5000;
    y2[0] = -0.7500;

    x1[1] = 0.5000;
    y1[1] = 0.1667;

    x2[1] = 0.3333;
    y2[1] = 0.3333;

    x1[2] = 0.3333;
    y1[2] = 0.3333;

    x2[2] = 0.1667;
    y2[2] = 0.4167;

    x1[3] = 0.1667;
    y1[3] = 0.4167;

    x2[3] = -0.0833;
    y2[3] = 0.4167;

    x1[4] = -0.0833;
    y1[4] = 0.4167;

    x2[4] = -0.2500;
    y2[4] = 0.3333;

    x1[5] = -0.2500;
    y1[5] = 0.3333;

    x2[5] = -0.4167;
    y2[5] = 0.1667;

    x1[6] = -0.4167;
    y1[6] = 0.1667;

    x2[6] = -0.5000;
    y2[6] = -0.0833;

    x1[7] = -0.5000;
    y1[7] = -0.0833;

    x2[7] = -0.5000;
    y2[7] = -0.2500;

    x1[8] = -0.5000;
    y1[8] = -0.2500;

    x2[8] = -0.4167;
    y2[8] = -0.5000;

    x1[9] = -0.4167;
    y1[9] = -0.5000;

    x2[9] = -0.2500;
    y2[9] = -0.6667;

    x1[10] = -0.2500;
    y1[10] = -0.6667;

    x2[10] = -0.0833;
    y2[10] = -0.7500;

    x1[11] = -0.0833;
    y1[11] = -0.7500;

    x2[11] = 0.1667;
    y2[11] = -0.7500;

    x1[12] = 0.1667;
    y1[12] = -0.7500;

    x2[12] = 0.3333;
    y2[12] = -0.6667;

    x1[13] = 0.3333;
    y1[13] = -0.6667;

    x2[13] = 0.5000;
    y2[13] = -0.5000;

    marker_indices[index++] = PG_def_marker(14, x1, y1, x2, y2);

/* define 'b'  */
    x1[0] = -0.5000;
    y1[0] = 1.0000;

    x2[0] = -0.5000;
    y2[0] = -0.7500;

    x1[1] = -0.5000;
    y1[1] = 0.1667;

    x2[1] = -0.3333;
    y2[1] = 0.3333;

    x1[2] = -0.3333;
    y1[2] = 0.3333;

    x2[2] = -0.1667;
    y2[2] = 0.4167;

    x1[3] = -0.1667;
    y1[3] = 0.4167;

    x2[3] = 0.0833;
    y2[3] = 0.4167;

    x1[4] = 0.0833;
    y1[4] = 0.4167;

    x2[4] = 0.2500;
    y2[4] = 0.3333;

    x1[5] = 0.2500;
    y1[5] = 0.3333;

    x2[5] = 0.4167;
    y2[5] = 0.1667;

    x1[6] = 0.4167;
    y1[6] = 0.1667;

    x2[6] = 0.5000;
    y2[6] = -0.0833;

    x1[7] = 0.5000;
    y1[7] = -0.0833;

    x2[7] = 0.5000;
    y2[7] = -0.2500;

    x1[8] = 0.5000;
    y1[8] = -0.2500;

    x2[8] = 0.4167;
    y2[8] = -0.5000;

    x1[9] = 0.4167;
    y1[9] = -0.5000;

    x2[9] = 0.2500;
    y2[9] = -0.6667;

    x1[10] = 0.2500;
    y1[10] = -0.6667;

    x2[10] = 0.0833;
    y2[10] = -0.7500;

    x1[11] = 0.0833;
    y1[11] = -0.7500;

    x2[11] = -0.1667;
    y2[11] = -0.7500;

    x1[12] = -0.1667;
    y1[12] = -0.7500;

    x2[12] = -0.3333;
    y2[12] = -0.6667;

    x1[13] = -0.3333;
    y1[13] = -0.6667;

    x2[13] = -0.5000;
    y2[13] = -0.5000;

    marker_indices[index++] = PG_def_marker(14, x1, y1, x2, y2);

/* define 'c'  */
    x1[0] = 0.5000;
    y1[0] = 0.1667;

    x2[0] = 0.3333;
    y2[0] = 0.3333;

    x1[1] = 0.3333;
    y1[1] = 0.3333;

    x2[1] = 0.1667;
    y2[1] = 0.4167;

    x1[2] = 0.1667;
    y1[2] = 0.4167;

    x2[2] = -0.0833;
    y2[2] = 0.4167;

    x1[3] = -0.0833;
    y1[3] = 0.4167;

    x2[3] = -0.2500;
    y2[3] = 0.3333;

    x1[4] = -0.2500;
    y1[4] = 0.3333;

    x2[4] = -0.4167;
    y2[4] = 0.1667;

    x1[5] = -0.4167;
    y1[5] = 0.1667;

    x2[5] = -0.5000;
    y2[5] = -0.0833;

    x1[6] = -0.5000;
    y1[6] = -0.0833;

    x2[6] = -0.5000;
    y2[6] = -0.2500;

    x1[7] = -0.5000;
    y1[7] = -0.2500;

    x2[7] = -0.4167;
    y2[7] = -0.5000;

    x1[8] = -0.4167;
    y1[8] = -0.5000;

    x2[8] = -0.2500;
    y2[8] = -0.6667;

    x1[9] = -0.2500;
    y1[9] = -0.6667;

    x2[9] = -0.0833;
    y2[9] = -0.7500;

    x1[10] = -0.0833;
    y1[10] = -0.7500;

    x2[10] = 0.1667;
    y2[10] = -0.7500;

    x1[11] = 0.1667;
    y1[11] = -0.7500;

    x2[11] = 0.3333;
    y2[11] = -0.6667;

    x1[12] = 0.3333;
    y1[12] = -0.6667;

    x2[12] = 0.5000;
    y2[12] = -0.5000;

    marker_indices[index++] = PG_def_marker(13, x1, y1, x2, y2);

/* define 'd'  */
    x1[0] = 0.5000;
    y1[0] = 1.0000;

    x2[0] = 0.5000;
    y2[0] = -0.7500;

    x1[1] = 0.5000;
    y1[1] = 0.1667;

    x2[1] = 0.3333;
    y2[1] = 0.3333;

    x1[2] = 0.3333;
    y1[2] = 0.3333;

    x2[2] = 0.1667;
    y2[2] = 0.4167;

    x1[3] = 0.1667;
    y1[3] = 0.4167;

    x2[3] = -0.0833;
    y2[3] = 0.4167;

    x1[4] = -0.0833;
    y1[4] = 0.4167;

    x2[4] = -0.2500;
    y2[4] = 0.3333;

    x1[5] = -0.2500;
    y1[5] = 0.3333;

    x2[5] = -0.4167;
    y2[5] = 0.1667;

    x1[6] = -0.4167;
    y1[6] = 0.1667;

    x2[6] = -0.5000;
    y2[6] = -0.0833;

    x1[7] = -0.5000;
    y1[7] = -0.0833;

    x2[7] = -0.5000;
    y2[7] = -0.2500;

    x1[8] = -0.5000;
    y1[8] = -0.2500;

    x2[8] = -0.4167;
    y2[8] = -0.5000;

    x1[9] = -0.4167;
    y1[9] = -0.5000;

    x2[9] = -0.2500;
    y2[9] = -0.6667;

    x1[10] = -0.2500;
    y1[10] = -0.6667;

    x2[10] = -0.0833;
    y2[10] = -0.7500;

    x1[11] = -0.0833;
    y1[11] = -0.7500;

    x2[11] = 0.1667;
    y2[11] = -0.7500;

    x1[12] = 0.1667;
    y1[12] = -0.7500;

    x2[12] = 0.3333;
    y2[12] = -0.6667;

    x1[13] = 0.3333;
    y1[13] = -0.6667;

    x2[13] = 0.5000;
    y2[13] = -0.5000;

    marker_indices[index++] = PG_def_marker(14, x1, y1, x2, y2);

/* define 'e'  */
    x1[0] = -0.5000;
    y1[0] = -0.0833;

    x2[0] = 0.5000;
    y2[0] = -0.0833;

    x1[1] = 0.5000;
    y1[1] = -0.0833;

    x2[1] = 0.5000;
    y2[1] = 0.0833;

    x1[2] = 0.5000;
    y1[2] = 0.0833;

    x2[2] = 0.4167;
    y2[2] = 0.2500;

    x1[3] = 0.4167;
    y1[3] = 0.2500;

    x2[3] = 0.3333;
    y2[3] = 0.3333;

    x1[4] = 0.3333;
    y1[4] = 0.3333;

    x2[4] = 0.1667;
    y2[4] = 0.4167;

    x1[5] = 0.1667;
    y1[5] = 0.4167;

    x2[5] = -0.0833;
    y2[5] = 0.4167;

    x1[6] = -0.0833;
    y1[6] = 0.4167;

    x2[6] = -0.2500;
    y2[6] = 0.3333;

    x1[7] = -0.2500;
    y1[7] = 0.3333;

    x2[7] = -0.4167;
    y2[7] = 0.1667;

    x1[8] = -0.4167;
    y1[8] = 0.1667;

    x2[8] = -0.5000;
    y2[8] = -0.0833;

    x1[9] = -0.5000;
    y1[9] = -0.0833;

    x2[9] = -0.5000;
    y2[9] = -0.2500;

    x1[10] = -0.5000;
    y1[10] = -0.2500;

    x2[10] = -0.4167;
    y2[10] = -0.5000;

    x1[11] = -0.4167;
    y1[11] = -0.5000;

    x2[11] = -0.2500;
    y2[11] = -0.6667;

    x1[12] = -0.2500;
    y1[12] = -0.6667;

    x2[12] = -0.0833;
    y2[12] = -0.7500;

    x1[13] = -0.0833;
    y1[13] = -0.7500;

    x2[13] = 0.1667;
    y2[13] = -0.7500;

    x1[14] = 0.1667;
    y1[14] = -0.7500;

    x2[14] = 0.3333;
    y2[14] = -0.6667;

    x1[15] = 0.3333;
    y1[15] = -0.6667;

    x2[15] = 0.5000;
    y2[15] = -0.5000;

    marker_indices[index++] = PG_def_marker(16, x1, y1, x2, y2);

/* define 'f'  */
    x1[0] = 0.4167;
    y1[0] = 1.0000;

    x2[0] = 0.2500;
    y2[0] = 1.0000;

    x1[1] = 0.2500;
    y1[1] = 1.0000;

    x2[1] = 0.0833;
    y2[1] = 0.9167;

    x1[2] = 0.0833;
    y1[2] = 0.9167;

    x2[2] = 0.0000;
    y2[2] = 0.6667;

    x1[3] = 0.0000;
    y1[3] = 0.6667;

    x2[3] = 0.0000;
    y2[3] = -0.7500;

    x1[4] = -0.2500;
    y1[4] = 0.4167;

    x2[4] = 0.3333;
    y2[4] = 0.4167;

    marker_indices[index++] = PG_def_marker(5, x1, y1, x2, y2);

/* define 'g'  */
    x1[0] = 0.5000;
    y1[0] = 0.4167;

    x2[0] = 0.5000;
    y2[0] = -0.9167;

    x1[1] = 0.5000;
    y1[1] = -0.9167;

    x2[1] = 0.4167;
    y2[1] = -1.1667;

    x1[2] = 0.4167;
    y1[2] = -1.1667;

    x2[2] = 0.3333;
    y2[2] = -1.2500;

    x1[3] = 0.3333;
    y1[3] = -1.2500;

    x2[3] = 0.1667;
    y2[3] = -1.3333;

    x1[4] = 0.1667;
    y1[4] = -1.3333;

    x2[4] = -0.0833;
    y2[4] = -1.3333;

    x1[5] = -0.0833;
    y1[5] = -1.3333;

    x2[5] = -0.2500;
    y2[5] = -1.2500;

    x1[6] = 0.5000;
    y1[6] = 0.1667;

    x2[6] = 0.3333;
    y2[6] = 0.3333;

    x1[7] = 0.3333;
    y1[7] = 0.3333;

    x2[7] = 0.1667;
    y2[7] = 0.4167;

    x1[8] = 0.1667;
    y1[8] = 0.4167;

    x2[8] = -0.0833;
    y2[8] = 0.4167;

    x1[9] = -0.0833;
    y1[9] = 0.4167;

    x2[9] = -0.2500;
    y2[9] = 0.3333;

    x1[10] = -0.2500;
    y1[10] = 0.3333;

    x2[10] = -0.4167;
    y2[10] = 0.1667;

    x1[11] = -0.4167;
    y1[11] = 0.1667;

    x2[11] = -0.5000;
    y2[11] = -0.0833;

    x1[12] = -0.5000;
    y1[12] = -0.0833;

    x2[12] = -0.5000;
    y2[12] = -0.2500;

    x1[13] = -0.5000;
    y1[13] = -0.2500;

    x2[13] = -0.4167;
    y2[13] = -0.5000;

    x1[14] = -0.4167;
    y1[14] = -0.5000;

    x2[14] = -0.2500;
    y2[14] = -0.6667;

    x1[15] = -0.2500;
    y1[15] = -0.6667;

    x2[15] = -0.0833;
    y2[15] = -0.7500;

    x1[16] = -0.0833;
    y1[16] = -0.7500;

    x2[16] = 0.1667;
    y2[16] = -0.7500;

    x1[17] = 0.1667;
    y1[17] = -0.7500;

    x2[17] = 0.3333;
    y2[17] = -0.6667;

    x1[18] = 0.3333;
    y1[18] = -0.6667;

    x2[18] = 0.5000;
    y2[18] = -0.5000;

    marker_indices[index++] = PG_def_marker(19, x1, y1, x2, y2);

/* define 'h'  */
    x1[0] = -0.4167;
    y1[0] = 1.0000;

    x2[0] = -0.4167;
    y2[0] = -0.7500;

    x1[1] = -0.4167;
    y1[1] = 0.0833;

    x2[1] = -0.1667;
    y2[1] = 0.3333;

    x1[2] = -0.1667;
    y1[2] = 0.3333;

    x2[2] = 0.0000;
    y2[2] = 0.4167;

    x1[3] = 0.0000;
    y1[3] = 0.4167;

    x2[3] = 0.2500;
    y2[3] = 0.4167;

    x1[4] = 0.2500;
    y1[4] = 0.4167;

    x2[4] = 0.4167;
    y2[4] = 0.3333;

    x1[5] = 0.4167;
    y1[5] = 0.3333;

    x2[5] = 0.5000;
    y2[5] = 0.0833;

    x1[6] = 0.5000;
    y1[6] = 0.0833;

    x2[6] = 0.5000;
    y2[6] = -0.7500;

    marker_indices[index++] = PG_def_marker(7, x1, y1, x2, y2);

/* define 'i'  */
    x1[0] = -0.0833;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = 0.9167;

    x1[1] = 0.0000;
    y1[1] = 0.9167;

    x2[1] = 0.0833;
    y2[1] = 1.0000;

    x1[2] = 0.0833;
    y1[2] = 1.0000;

    x2[2] = 0.0000;
    y2[2] = 1.0833;

    x1[3] = 0.0000;
    y1[3] = 1.0833;

    x2[3] = -0.0833;
    y2[3] = 1.0000;

    x1[4] = 0.0000;
    y1[4] = 0.4167;

    x2[4] = 0.0000;
    y2[4] = -0.7500;

    marker_indices[index++] = PG_def_marker(5, x1, y1, x2, y2);

/* define 'j'  */
    x1[0] = 0.0000;
    y1[0] = 1.0000;

    x2[0] = 0.0833;
    y2[0] = 0.9167;

    x1[1] = 0.0833;
    y1[1] = 0.9167;

    x2[1] = 0.1667;
    y2[1] = 1.0000;

    x1[2] = 0.1667;
    y1[2] = 1.0000;

    x2[2] = 0.0833;
    y2[2] = 1.0833;

    x1[3] = 0.0833;
    y1[3] = 1.0833;

    x2[3] = 0.0000;
    y2[3] = 1.0000;

    x1[4] = 0.0833;
    y1[4] = 0.4167;

    x2[4] = 0.0833;
    y2[4] = -1.0000;

    x1[5] = 0.0833;
    y1[5] = -1.0000;

    x2[5] = 0.0000;
    y2[5] = -1.2500;

    x1[6] = 0.0000;
    y1[6] = -1.2500;

    x2[6] = -0.1667;
    y2[6] = -1.3333;

    x1[7] = -0.1667;
    y1[7] = -1.3333;

    x2[7] = -0.3333;
    y2[7] = -1.3333;

    marker_indices[index++] = PG_def_marker(8, x1, y1, x2, y2);

/* define 'k'  */
    x1[0] = -0.4167;
    y1[0] = 1.0000;

    x2[0] = -0.4167;
    y2[0] = -0.7500;

    x1[1] = 0.4167;
    y1[1] = 0.4167;

    x2[1] = -0.4167;
    y2[1] = -0.4167;

    x1[2] = -0.0833;
    y1[2] = -0.0833;

    x2[2] = 0.5000;
    y2[2] = -0.7500;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define 'l'  */
    x1[0] = 0.0000;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = -0.7500;

    marker_indices[index++] = PG_def_marker(1, x1, y1, x2, y2);

/* define 'm'  */
    x1[0] = -0.9167;
    y1[0] = 0.4167;

    x2[0] = -0.9167;
    y2[0] = -0.7500;

    x1[1] = -0.9167;
    y1[1] = 0.0833;

    x2[1] = -0.6667;
    y2[1] = 0.3333;

    x1[2] = -0.6667;
    y1[2] = 0.3333;

    x2[2] = -0.5000;
    y2[2] = 0.4167;

    x1[3] = -0.5000;
    y1[3] = 0.4167;

    x2[3] = -0.2500;
    y2[3] = 0.4167;

    x1[4] = -0.2500;
    y1[4] = 0.4167;

    x2[4] = -0.0833;
    y2[4] = 0.3333;

    x1[5] = -0.0833;
    y1[5] = 0.3333;

    x2[5] = 0.0000;
    y2[5] = 0.0833;

    x1[6] = 0.0000;
    y1[6] = 0.0833;

    x2[6] = 0.0000;
    y2[6] = -0.7500;

    x1[7] = 0.0000;
    y1[7] = 0.0833;

    x2[7] = 0.2500;
    y2[7] = 0.3333;

    x1[8] = 0.2500;
    y1[8] = 0.3333;

    x2[8] = 0.4167;
    y2[8] = 0.4167;

    x1[9] = 0.4167;
    y1[9] = 0.4167;

    x2[9] = 0.6667;
    y2[9] = 0.4167;

    x1[10] = 0.6667;
    y1[10] = 0.4167;

    x2[10] = 0.8333;
    y2[10] = 0.3333;

    x1[11] = 0.8333;
    y1[11] = 0.3333;

    x2[11] = 0.9167;
    y2[11] = 0.0833;

    x1[12] = 0.9167;
    y1[12] = 0.0833;

    x2[12] = 0.9167;
    y2[12] = -0.7500;

    marker_indices[index++] = PG_def_marker(13, x1, y1, x2, y2);

/* define 'n'  */
    x1[0] = -0.4167;
    y1[0] = 0.4167;

    x2[0] = -0.4167;
    y2[0] = -0.7500;

    x1[1] = -0.4167;
    y1[1] = 0.0833;

    x2[1] = -0.1667;
    y2[1] = 0.3333;

    x1[2] = -0.1667;
    y1[2] = 0.3333;

    x2[2] = 0.0000;
    y2[2] = 0.4167;

    x1[3] = 0.0000;
    y1[3] = 0.4167;

    x2[3] = 0.2500;
    y2[3] = 0.4167;

    x1[4] = 0.2500;
    y1[4] = 0.4167;

    x2[4] = 0.4167;
    y2[4] = 0.3333;

    x1[5] = 0.4167;
    y1[5] = 0.3333;

    x2[5] = 0.5000;
    y2[5] = 0.0833;

    x1[6] = 0.5000;
    y1[6] = 0.0833;

    x2[6] = 0.5000;
    y2[6] = -0.7500;

    marker_indices[index++] = PG_def_marker(7, x1, y1, x2, y2);

/* define 'o'  */
    x1[0] = -0.0833;
    y1[0] = 0.4167;

    x2[0] = -0.2500;
    y2[0] = 0.3333;

    x1[1] = -0.2500;
    y1[1] = 0.3333;

    x2[1] = -0.4167;
    y2[1] = 0.1667;

    x1[2] = -0.4167;
    y1[2] = 0.1667;

    x2[2] = -0.5000;
    y2[2] = -0.0833;

    x1[3] = -0.5000;
    y1[3] = -0.0833;

    x2[3] = -0.5000;
    y2[3] = -0.2500;

    x1[4] = -0.5000;
    y1[4] = -0.2500;

    x2[4] = -0.4167;
    y2[4] = -0.5000;

    x1[5] = -0.4167;
    y1[5] = -0.5000;

    x2[5] = -0.2500;
    y2[5] = -0.6667;

    x1[6] = -0.2500;
    y1[6] = -0.6667;

    x2[6] = -0.0833;
    y2[6] = -0.7500;

    x1[7] = -0.0833;
    y1[7] = -0.7500;

    x2[7] = 0.1667;
    y2[7] = -0.7500;

    x1[8] = 0.1667;
    y1[8] = -0.7500;

    x2[8] = 0.3333;
    y2[8] = -0.6667;

    x1[9] = 0.3333;
    y1[9] = -0.6667;

    x2[9] = 0.5000;
    y2[9] = -0.5000;

    x1[10] = 0.5000;
    y1[10] = -0.5000;

    x2[10] = 0.5833;
    y2[10] = -0.2500;

    x1[11] = 0.5833;
    y1[11] = -0.2500;

    x2[11] = 0.5833;
    y2[11] = -0.0833;

    x1[12] = 0.5833;
    y1[12] = -0.0833;

    x2[12] = 0.5000;
    y2[12] = 0.1667;

    x1[13] = 0.5000;
    y1[13] = 0.1667;

    x2[13] = 0.3333;
    y2[13] = 0.3333;

    x1[14] = 0.3333;
    y1[14] = 0.3333;

    x2[14] = 0.1667;
    y2[14] = 0.4167;

    x1[15] = 0.1667;
    y1[15] = 0.4167;

    x2[15] = -0.0833;
    y2[15] = 0.4167;

    marker_indices[index++] = PG_def_marker(16, x1, y1, x2, y2);

/* define 'p'  */
    x1[0] = -0.5000;
    y1[0] = 0.4167;

    x2[0] = -0.5000;
    y2[0] = -1.3333;

    x1[1] = -0.5000;
    y1[1] = 0.1667;

    x2[1] = -0.3333;
    y2[1] = 0.3333;

    x1[2] = -0.3333;
    y1[2] = 0.3333;

    x2[2] = -0.1667;
    y2[2] = 0.4167;

    x1[3] = -0.1667;
    y1[3] = 0.4167;

    x2[3] = 0.0833;
    y2[3] = 0.4167;

    x1[4] = 0.0833;
    y1[4] = 0.4167;

    x2[4] = 0.2500;
    y2[4] = 0.3333;

    x1[5] = 0.2500;
    y1[5] = 0.3333;

    x2[5] = 0.4167;
    y2[5] = 0.1667;

    x1[6] = 0.4167;
    y1[6] = 0.1667;

    x2[6] = 0.5000;
    y2[6] = -0.0833;

    x1[7] = 0.5000;
    y1[7] = -0.0833;

    x2[7] = 0.5000;
    y2[7] = -0.2500;

    x1[8] = 0.5000;
    y1[8] = -0.2500;

    x2[8] = 0.4167;
    y2[8] = -0.5000;

    x1[9] = 0.4167;
    y1[9] = -0.5000;

    x2[9] = 0.2500;
    y2[9] = -0.6667;

    x1[10] = 0.2500;
    y1[10] = -0.6667;

    x2[10] = 0.0833;
    y2[10] = -0.7500;

    x1[11] = 0.0833;
    y1[11] = -0.7500;

    x2[11] = -0.1667;
    y2[11] = -0.7500;

    x1[12] = -0.1667;
    y1[12] = -0.7500;

    x2[12] = -0.3333;
    y2[12] = -0.6667;

    x1[13] = -0.3333;
    y1[13] = -0.6667;

    x2[13] = -0.5000;
    y2[13] = -0.5000;

    marker_indices[index++] = PG_def_marker(14, x1, y1, x2, y2);

/* define 'q'  */
    x1[0] = 0.5000;
    y1[0] = 0.4167;

    x2[0] = 0.5000;
    y2[0] = -1.3333;

    x1[1] = 0.5000;
    y1[1] = 0.1667;

    x2[1] = 0.3333;
    y2[1] = 0.3333;

    x1[2] = 0.3333;
    y1[2] = 0.3333;

    x2[2] = 0.1667;
    y2[2] = 0.4167;

    x1[3] = 0.1667;
    y1[3] = 0.4167;

    x2[3] = -0.0833;
    y2[3] = 0.4167;

    x1[4] = -0.0833;
    y1[4] = 0.4167;

    x2[4] = -0.2500;
    y2[4] = 0.3333;

    x1[5] = -0.2500;
    y1[5] = 0.3333;

    x2[5] = -0.4167;
    y2[5] = 0.1667;

    x1[6] = -0.4167;
    y1[6] = 0.1667;

    x2[6] = -0.5000;
    y2[6] = -0.0833;

    x1[7] = -0.5000;
    y1[7] = -0.0833;

    x2[7] = -0.5000;
    y2[7] = -0.2500;

    x1[8] = -0.5000;
    y1[8] = -0.2500;

    x2[8] = -0.4167;
    y2[8] = -0.5000;

    x1[9] = -0.4167;
    y1[9] = -0.5000;

    x2[9] = -0.2500;
    y2[9] = -0.6667;

    x1[10] = -0.2500;
    y1[10] = -0.6667;

    x2[10] = -0.0833;
    y2[10] = -0.7500;

    x1[11] = -0.0833;
    y1[11] = -0.7500;

    x2[11] = 0.1667;
    y2[11] = -0.7500;

    x1[12] = 0.1667;
    y1[12] = -0.7500;

    x2[12] = 0.3333;
    y2[12] = -0.6667;

    x1[13] = 0.3333;
    y1[13] = -0.6667;

    x2[13] = 0.5000;
    y2[13] = -0.5000;

    marker_indices[index++] = PG_def_marker(14, x1, y1, x2, y2);

/* define 'r'  */
    x1[0] = -0.2500;
    y1[0] = 0.4167;

    x2[0] = -0.2500;
    y2[0] = -0.7500;

    x1[1] = -0.2500;
    y1[1] = -0.0833;

    x2[1] = -0.1667;
    y2[1] = 0.1667;

    x1[2] = -0.1667;
    y1[2] = 0.1667;

    x2[2] = 0.0000;
    y2[2] = 0.3333;

    x1[3] = 0.0000;
    y1[3] = 0.3333;

    x2[3] = 0.1667;
    y2[3] = 0.4167;

    x1[4] = 0.1667;
    y1[4] = 0.4167;

    x2[4] = 0.4167;
    y2[4] = 0.4167;

    marker_indices[index++] = PG_def_marker(5, x1, y1, x2, y2);

/* define 's'  */
    x1[0] = 0.5000;
    y1[0] = 0.1667;

    x2[0] = 0.4167;
    y2[0] = 0.3333;

    x1[1] = 0.4167;
    y1[1] = 0.3333;

    x2[1] = 0.1667;
    y2[1] = 0.4167;

    x1[2] = 0.1667;
    y1[2] = 0.4167;

    x2[2] = -0.0833;
    y2[2] = 0.4167;

    x1[3] = -0.0833;
    y1[3] = 0.4167;

    x2[3] = -0.3333;
    y2[3] = 0.3333;

    x1[4] = -0.3333;
    y1[4] = 0.3333;

    x2[4] = -0.4167;
    y2[4] = 0.1667;

    x1[5] = -0.4167;
    y1[5] = 0.1667;

    x2[5] = -0.3333;
    y2[5] = 0.0000;

    x1[6] = -0.3333;
    y1[6] = 0.0000;

    x2[6] = -0.1667;
    y2[6] = -0.0833;

    x1[7] = -0.1667;
    y1[7] = -0.0833;

    x2[7] = 0.2500;
    y2[7] = -0.1667;

    x1[8] = 0.2500;
    y1[8] = -0.1667;

    x2[8] = 0.4167;
    y2[8] = -0.2500;

    x1[9] = 0.4167;
    y1[9] = -0.2500;

    x2[9] = 0.5000;
    y2[9] = -0.4167;

    x1[10] = 0.5000;
    y1[10] = -0.4167;

    x2[10] = 0.5000;
    y2[10] = -0.5000;

    x1[11] = 0.5000;
    y1[11] = -0.5000;

    x2[11] = 0.4167;
    y2[11] = -0.6667;

    x1[12] = 0.4167;
    y1[12] = -0.6667;

    x2[12] = 0.1667;
    y2[12] = -0.7500;

    x1[13] = 0.1667;
    y1[13] = -0.7500;

    x2[13] = -0.0833;
    y2[13] = -0.7500;

    x1[14] = -0.0833;
    y1[14] = -0.7500;

    x2[14] = -0.3333;
    y2[14] = -0.6667;

    x1[15] = -0.3333;
    y1[15] = -0.6667;

    x2[15] = -0.4167;
    y2[15] = -0.5000;

    marker_indices[index++] = PG_def_marker(16, x1, y1, x2, y2);

/* define 't'  */
    x1[0] = 0.0000;
    y1[0] = 1.0000;

    x2[0] = 0.0000;
    y2[0] = -0.4167;

    x1[1] = 0.0000;
    y1[1] = -0.4167;

    x2[1] = 0.0833;
    y2[1] = -0.6667;

    x1[2] = 0.0833;
    y1[2] = -0.6667;

    x2[2] = 0.2500;
    y2[2] = -0.7500;

    x1[3] = 0.2500;
    y1[3] = -0.7500;

    x2[3] = 0.4167;
    y2[3] = -0.7500;

    x1[4] = -0.2500;
    y1[4] = 0.4167;

    x2[4] = 0.3333;
    y2[4] = 0.4167;

    marker_indices[index++] = PG_def_marker(5, x1, y1, x2, y2);

/* define 'u'  */
    x1[0] = -0.4167;
    y1[0] = 0.4167;

    x2[0] = -0.4167;
    y2[0] = -0.4167;

    x1[1] = -0.4167;
    y1[1] = -0.4167;

    x2[1] = -0.3333;
    y2[1] = -0.6667;

    x1[2] = -0.3333;
    y1[2] = -0.6667;

    x2[2] = -0.1667;
    y2[2] = -0.7500;

    x1[3] = -0.1667;
    y1[3] = -0.7500;

    x2[3] = 0.0833;
    y2[3] = -0.7500;

    x1[4] = 0.0833;
    y1[4] = -0.7500;

    x2[4] = 0.2500;
    y2[4] = -0.6667;

    x1[5] = 0.2500;
    y1[5] = -0.6667;

    x2[5] = 0.5000;
    y2[5] = -0.4167;

    x1[6] = 0.5000;
    y1[6] = 0.4167;

    x2[6] = 0.5000;
    y2[6] = -0.7500;

    marker_indices[index++] = PG_def_marker(7, x1, y1, x2, y2);

/* define 'v'  */
    x1[0] = -0.5000;
    y1[0] = 0.4167;

    x2[0] = 0.0000;
    y2[0] = -0.7500;

    x1[1] = 0.5000;
    y1[1] = 0.4167;

    x2[1] = 0.0000;
    y2[1] = -0.7500;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define 'w'  */
    x1[0] = -0.6667;
    y1[0] = 0.4167;

    x2[0] = -0.3333;
    y2[0] = -0.7500;

    x1[1] = 0.0000;
    y1[1] = 0.4167;

    x2[1] = -0.3333;
    y2[1] = -0.7500;

    x1[2] = 0.0000;
    y1[2] = 0.4167;

    x2[2] = 0.3333;
    y2[2] = -0.7500;

    x1[3] = 0.6667;
    y1[3] = 0.4167;

    x2[3] = 0.3333;
    y2[3] = -0.7500;

    marker_indices[index++] = PG_def_marker(4, x1, y1, x2, y2);

/* define 'x'  */
    x1[0] = -0.4167;
    y1[0] = 0.4167;

    x2[0] = 0.5000;
    y2[0] = -0.7500;

    x1[1] = 0.5000;
    y1[1] = 0.4167;

    x2[1] = -0.4167;
    y2[1] = -0.7500;

    marker_indices[index++] = PG_def_marker(2, x1, y1, x2, y2);

/* define 'y'  */
    x1[0] = -0.5000;
    y1[0] = 0.4167;

    x2[0] = 0.0000;
    y2[0] = -0.7500;

    x1[1] = 0.5000;
    y1[1] = 0.4167;

    x2[1] = 0.0000;
    y2[1] = -0.7500;

    x1[2] = 0.0000;
    y1[2] = -0.7500;

    x2[2] = -0.1667;
    y2[2] = -1.0833;

    x1[3] = -0.1667;
    y1[3] = -1.0833;

    x2[3] = -0.3333;
    y2[3] = -1.2500;

    x1[4] = -0.3333;
    y1[4] = -1.2500;

    x2[4] = -0.5000;
    y2[4] = -1.3333;

    x1[5] = -0.5000;
    y1[5] = -1.3333;

    x2[5] = -0.5833;
    y2[5] = -1.3333;

    marker_indices[index++] = PG_def_marker(6, x1, y1, x2, y2);

/* define 'z'  */
    x1[0] = 0.5000;
    y1[0] = 0.4167;

    x2[0] = -0.4167;
    y2[0] = -0.7500;

    x1[1] = -0.4167;
    y1[1] = 0.4167;

    x2[1] = 0.5000;
    y2[1] = 0.4167;

    x1[2] = -0.4167;
    y1[2] = -0.7500;

    x2[2] = 0.5000;
    y2[2] = -0.7500;

    marker_indices[index++] = PG_def_marker(3, x1, y1, x2, y2);

/* define '{'  */
    x1[0] = 0.1667;
    y1[0] = 1.3333;

    x2[0] = 0.0000;
    y2[0] = 1.2500;

    x1[1] = 0.0000;
    y1[1] = 1.2500;

    x2[1] = -0.0833;
    y2[1] = 1.1667;

    x1[2] = -0.0833;
    y1[2] = 1.1667;

    x2[2] = -0.1667;
    y2[2] = 1.0000;

    x1[3] = -0.1667;
    y1[3] = 1.0000;

    x2[3] = -0.1667;
    y2[3] = 0.8333;

    x1[4] = -0.1667;
    y1[4] = 0.8333;

    x2[4] = -0.0833;
    y2[4] = 0.6667;

    x1[5] = -0.0833;
    y1[5] = 0.6667;

    x2[5] = 0.0000;
    y2[5] = 0.5833;

    x1[6] = 0.0000;
    y1[6] = 0.5833;

    x2[6] = 0.0833;
    y2[6] = 0.4167;

    x1[7] = 0.0833;
    y1[7] = 0.4167;

    x2[7] = 0.0833;
    y2[7] = 0.2500;

    x1[8] = 0.0833;
    y1[8] = 0.2500;

    x2[8] = -0.0833;
    y2[8] = 0.0833;

    x1[9] = 0.0000;
    y1[9] = 1.2500;

    x2[9] = -0.0833;
    y2[9] = 1.0833;

    x1[10] = -0.0833;
    y1[10] = 1.0833;

    x2[10] = -0.0833;
    y2[10] = 0.9167;

    x1[11] = -0.0833;
    y1[11] = 0.9167;

    x2[11] = 0.0000;
    y2[11] = 0.7500;

    x1[12] = 0.0000;
    y1[12] = 0.7500;

    x2[12] = 0.0833;
    y2[12] = 0.6667;

    x1[13] = 0.0833;
    y1[13] = 0.6667;

    x2[13] = 0.1667;
    y2[13] = 0.5000;

    x1[14] = 0.1667;
    y1[14] = 0.5000;

    x2[14] = 0.1667;
    y2[14] = 0.3333;

    x1[15] = 0.1667;
    y1[15] = 0.3333;

    x2[15] = 0.0833;
    y2[15] = 0.1667;

    x1[16] = 0.0833;
    y1[16] = 0.1667;

    x2[16] = -0.2500;
    y2[16] = 0.0000;

    x1[17] = -0.2500;
    y1[17] = 0.0000;

    x2[17] = 0.0833;
    y2[17] = -0.1667;

    x1[18] = 0.0833;
    y1[18] = -0.1667;

    x2[18] = 0.1667;
    y2[18] = -0.3333;

    x1[19] = 0.1667;
    y1[19] = -0.3333;

    x2[19] = 0.1667;
    y2[19] = -0.5000;

    x1[20] = 0.1667;
    y1[20] = -0.5000;

    x2[20] = 0.0833;
    y2[20] = -0.6667;

    x1[21] = 0.0833;
    y1[21] = -0.6667;

    x2[21] = 0.0000;
    y2[21] = -0.7500;

    x1[22] = 0.0000;
    y1[22] = -0.7500;

    x2[22] = -0.0833;
    y2[22] = -0.9167;

    x1[23] = -0.0833;
    y1[23] = -0.9167;

    x2[23] = -0.0833;
    y2[23] = -1.0833;

    x1[24] = -0.0833;
    y1[24] = -1.0833;

    x2[24] = 0.0000;
    y2[24] = -1.2500;

    x1[25] = -0.0833;
    y1[25] = -0.0833;

    x2[25] = 0.0833;
    y2[25] = -0.2500;

    x1[26] = 0.0833;
    y1[26] = -0.2500;

    x2[26] = 0.0833;
    y2[26] = -0.4167;

    x1[27] = 0.0833;
    y1[27] = -0.4167;

    x2[27] = 0.0000;
    y2[27] = -0.5833;

    x1[28] = 0.0000;
    y1[28] = -0.5833;

    x2[28] = -0.0833;
    y2[28] = -0.6667;

    x1[29] = -0.0833;
    y1[29] = -0.6667;

    x2[29] = -0.1667;
    y2[29] = -0.8333;

    x1[30] = -0.1667;
    y1[30] = -0.8333;

    x2[30] = -0.1667;
    y2[30] = -1.0000;

    x1[31] = -0.1667;
    y1[31] = -1.0000;

    x2[31] = -0.0833;
    y2[31] = -1.1667;

    x1[32] = -0.0833;
    y1[32] = -1.1667;

    x2[32] = 0.0000;
    y2[32] = -1.2500;

    x1[33] = 0.0000;
    y1[33] = -1.2500;

    x2[33] = 0.1667;
    y2[33] = -1.3333;

    marker_indices[index++] = PG_def_marker(34, x1, y1, x2, y2);

/* define '|'  */
    x1[0] = 0.0000;
    y1[0] = 1.3333;

    x2[0] = 0.0000;
    y2[0] = -1.3333;

    marker_indices[index++] = PG_def_marker(1, x1, y1, x2, y2);

/* define '}'  */
    x1[0] = -0.1667;
    y1[0] = 1.3333;

    x2[0] = 0.0000;
    y2[0] = 1.2500;

    x1[1] = 0.0000;
    y1[1] = 1.2500;

    x2[1] = 0.0833;
    y2[1] = 1.1667;

    x1[2] = 0.0833;
    y1[2] = 1.1667;

    x2[2] = 0.1667;
    y2[2] = 1.0000;

    x1[3] = 0.1667;
    y1[3] = 1.0000;

    x2[3] = 0.1667;
    y2[3] = 0.8333;

    x1[4] = 0.1667;
    y1[4] = 0.8333;

    x2[4] = 0.0833;
    y2[4] = 0.6667;

    x1[5] = 0.0833;
    y1[5] = 0.6667;

    x2[5] = 0.0000;
    y2[5] = 0.5833;

    x1[6] = 0.0000;
    y1[6] = 0.5833;

    x2[6] = -0.0833;
    y2[6] = 0.4167;

    x1[7] = -0.0833;
    y1[7] = 0.4167;

    x2[7] = -0.0833;
    y2[7] = 0.2500;

    x1[8] = -0.0833;
    y1[8] = 0.2500;

    x2[8] = 0.0833;
    y2[8] = 0.0833;

    x1[9] = 0.0000;
    y1[9] = 1.2500;

    x2[9] = 0.0833;
    y2[9] = 1.0833;

    x1[10] = 0.0833;
    y1[10] = 1.0833;

    x2[10] = 0.0833;
    y2[10] = 0.9167;

    x1[11] = 0.0833;
    y1[11] = 0.9167;

    x2[11] = 0.0000;
    y2[11] = 0.7500;

    x1[12] = 0.0000;
    y1[12] = 0.7500;

    x2[12] = -0.0833;
    y2[12] = 0.6667;

    x1[13] = -0.0833;
    y1[13] = 0.6667;

    x2[13] = -0.1667;
    y2[13] = 0.5000;

    x1[14] = -0.1667;
    y1[14] = 0.5000;

    x2[14] = -0.1667;
    y2[14] = 0.3333;

    x1[15] = -0.1667;
    y1[15] = 0.3333;

    x2[15] = -0.0833;
    y2[15] = 0.1667;

    x1[16] = -0.0833;
    y1[16] = 0.1667;

    x2[16] = 0.2500;
    y2[16] = 0.0000;

    x1[17] = 0.2500;
    y1[17] = 0.0000;

    x2[17] = -0.0833;
    y2[17] = -0.1667;

    x1[18] = -0.0833;
    y1[18] = -0.1667;

    x2[18] = -0.1667;
    y2[18] = -0.3333;

    x1[19] = -0.1667;
    y1[19] = -0.3333;

    x2[19] = -0.1667;
    y2[19] = -0.5000;

    x1[20] = -0.1667;
    y1[20] = -0.5000;

    x2[20] = -0.0833;
    y2[20] = -0.6667;

    x1[21] = -0.0833;
    y1[21] = -0.6667;

    x2[21] = 0.0000;
    y2[21] = -0.7500;

    x1[22] = 0.0000;
    y1[22] = -0.7500;

    x2[22] = 0.0833;
    y2[22] = -0.9167;

    x1[23] = 0.0833;
    y1[23] = -0.9167;

    x2[23] = 0.0833;
    y2[23] = -1.0833;

    x1[24] = 0.0833;
    y1[24] = -1.0833;

    x2[24] = 0.0000;
    y2[24] = -1.2500;

    x1[25] = 0.0833;
    y1[25] = -0.0833;

    x2[25] = -0.0833;
    y2[25] = -0.2500;

    x1[26] = -0.0833;
    y1[26] = -0.2500;

    x2[26] = -0.0833;
    y2[26] = -0.4167;

    x1[27] = -0.0833;
    y1[27] = -0.4167;

    x2[27] = 0.0000;
    y2[27] = -0.5833;

    x1[28] = 0.0000;
    y1[28] = -0.5833;

    x2[28] = 0.0833;
    y2[28] = -0.6667;

    x1[29] = 0.0833;
    y1[29] = -0.6667;

    x2[29] = 0.1667;
    y2[29] = -0.8333;

    x1[30] = 0.1667;
    y1[30] = -0.8333;

    x2[30] = 0.1667;
    y2[30] = -1.0000;

    x1[31] = 0.1667;
    y1[31] = -1.0000;

    x2[31] = 0.0833;
    y2[31] = -1.1667;

    x1[32] = 0.0833;
    y1[32] = -1.1667;

    x2[32] = 0.0000;
    y2[32] = -1.2500;

    x1[33] = 0.0000;
    y1[33] = -1.2500;

    x2[33] = -0.1667;
    y2[33] = -1.3333;

    marker_indices[index++] = PG_def_marker(34, x1, y1, x2, y2);

/* define '~'  */
    x1[0] = -0.7500;
    y1[0] = -0.2500;

    x2[0] = -0.7500;
    y2[0] = -0.0833;

    x1[1] = -0.7500;
    y1[1] = -0.0833;

    x2[1] = -0.6667;
    y2[1] = 0.1667;

    x1[2] = -0.6667;
    y1[2] = 0.1667;

    x2[2] = -0.5000;
    y2[2] = 0.2500;

    x1[3] = -0.5000;
    y1[3] = 0.2500;

    x2[3] = -0.3333;
    y2[3] = 0.2500;

    x1[4] = -0.3333;
    y1[4] = 0.2500;

    x2[4] = -0.1667;
    y2[4] = 0.1667;

    x1[5] = -0.1667;
    y1[5] = 0.1667;

    x2[5] = 0.1667;
    y2[5] = -0.0833;

    x1[6] = 0.1667;
    y1[6] = -0.0833;

    x2[6] = 0.3333;
    y2[6] = -0.1667;

    x1[7] = 0.3333;
    y1[7] = -0.1667;

    x2[7] = 0.5000;
    y2[7] = -0.1667;

    x1[8] = 0.5000;
    y1[8] = -0.1667;

    x2[8] = 0.6667;
    y2[8] = -0.0833;

    x1[9] = 0.6667;
    y1[9] = -0.0833;

    x2[9] = 0.7500;
    y2[9] = 0.0833;

    x1[10] = -0.7500;
    y1[10] = -0.0833;

    x2[10] = -0.6667;
    y2[10] = 0.0833;

    x1[11] = -0.6667;
    y1[11] = 0.0833;

    x2[11] = -0.5000;
    y2[11] = 0.1667;

    x1[12] = -0.5000;
    y1[12] = 0.1667;

    x2[12] = -0.3333;
    y2[12] = 0.1667;

    x1[13] = -0.3333;
    y1[13] = 0.1667;

    x2[13] = -0.1667;
    y2[13] = 0.0833;

    x1[14] = -0.1667;
    y1[14] = 0.0833;

    x2[14] = 0.1667;
    y2[14] = -0.1667;

    x1[15] = 0.1667;
    y1[15] = -0.1667;

    x2[15] = 0.3333;
    y2[15] = -0.2500;

    x1[16] = 0.3333;
    y1[16] = -0.2500;

    x2[16] = 0.5000;
    y2[16] = -0.2500;

    x1[17] = 0.5000;
    y1[17] = -0.2500;

    x2[17] = 0.6667;
    y2[17] = -0.1667;

    x1[18] = 0.6667;
    y1[18] = -0.1667;

    x2[18] = 0.7500;
    y2[18] = 0.0833;

    x1[19] = 0.7500;
    y1[19] = 0.0833;

    x2[19] = 0.7500;
    y2[19] = 0.2500;

    marker_indices[index++] = PG_def_marker(20, x1, y1, x2, y2);

    return;}

/*--------------------------------------------------------------------------*/

/*                            PAGE STATE ROUTINES                           */

/*--------------------------------------------------------------------------*/
 
/* _PG_RST_CLEAR_WINDOW - clear the screen */
 
static void _PG_rst_clear_window(dev)
   PG_device *dev;
   {int w, h, sz, v, rgb;
    frame *cfr;
    PG_RAST_device *mdv;

    w  = dev->window_width;
    h  = dev->window_height;
    sz = w*h;

    GET_RAST_DEVICE(dev, mdv);
    rgb = mdv->rgb_mode;
    if (mdv->inner_frame == NULL)
       mdv->inner_frame = _PG_make_frame(w, h);

    cfr = mdv->inner_frame;

    if (rgb)
       {v = (dev->background_color_white) ? 255 : 0;
	memset(cfr->Y, v, sz);
	memset(cfr->Cr, v, sz);
	memset(cfr->Cb, v, sz);}
    else
       {v = dev->BLACK;
	memset(cfr->Y, v, sz);
	memset(cfr->Cr, 0, sz);
	memset(cfr->Cb, 0, sz);};

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_RST_CLEAR_VIEWPORT - clear the viewport */
 
static void _PG_rst_clear_viewport(dev)
   PG_device *dev;
   {PG_clear_region_NDC(dev, dev->sxmin, dev->sxmax,
                        dev->symin, dev->symax, 1);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_RST_CLEAR_REGION_NDC - clear the rectangular region specified in NDC */
 
static void _PG_rst_clear_region_NDC(dev, xmn, xmx, ymn, ymx, pad)
   PG_device *dev;
   double xmn, xmx, ymn, ymx;
   int pad;
   {int clr;
    REAL p;
    PG_curve *crv;

    p = ((REAL) pad)/dev->window_width;

    clr = dev->fill_color;
    crv = PG_make_box_curve(dev, NORMC, 0.0, 0.0,
			    xmn-p, xmx+p, ymn-p, ymx+p);

    dev->fill_color = dev->BLACK;
    PG_fill_curve(dev, crv);
    dev->fill_color = clr;

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_RST_UPDATE_VS - update the view surface for the given device */
 
static void _PG_rst_update_vs(dev)
   PG_device *dev;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_RST_CLEAR_PAGE - clear the current page
 *                    - and go to the line i on the screen
 */
 
static void _PG_rst_clear_page(dev, i)
   PG_device *dev;
   int i;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_RST_EXPOSE_DEVICE - make this device the topmost one */
 
static void _PG_rst_expose_device(dev)
   PG_device *dev;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_RST_MAKE_DEVICE_CURRENT - make this device the current one for drawing
 *                             - purposes
 */
 
static void _PG_rst_make_device_current(dev)
   PG_device *dev;
   {return;}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_RST_RELEASE_CURRENT_DEVICE - make no device current
 *                                - (SUN in its brilliance needs this)
 */
 
static void _PG_rst_release_current_device(dev)
   PG_device *dev;
   {return;}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_RST_WRITE_TEXT - write out text to the appropriate device */
 
static void _PG_rst_write_text(dev, fp, s)
   PG_device *dev;
   FILE *fp;
   char *s;
   {int i, index, savlinclr, ncharfont, ncharin;
    REAL x, y, dx;
    char *target;

    ncharfont = strlen(_PG_rst_char_list);
    ncharin   = strlen(s);
    dx        = (dev->char_width_s + dev->char_space_s) * 
                dev->bxs_w;
    savlinclr = dev->line_color;
    PG_set_line_color(dev, dev->text_color);

    for (i = 0; i < ncharin; i++)
        {target = strchr(_PG_rst_char_list, (int)s[i]);
         if (target != NULL)
            {index = target - _PG_rst_char_list;
             x = dev->tcurx;
             y = dev->tcury;
             PG_draw_markers(dev, 1, &x, &y, 
                             _PG_rst_current_font[index]);} 
/* need to calculate new x and y positions based upon character size */
/* and path.  For now, just for testing, wing it.                    */
             dev->tcurx += dx;}

    PG_set_line_color(dev, savlinclr);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_RST_NEXT_LINE - do a controlled newline */
 
static void _PG_rst_next_line(dev)
   PG_device *dev;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_RST_QUERY_POINTER - query the pointer for location and button status */

static void _PG_rst_query_pointer(dev, px, py, pb, pq)
   PG_device *dev;
   int *px, *py, *pb, *pq;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_RST_SET_DEV_PROP - set some RASTER device characteristics */

void _PG_rst_set_dev_prop(dev, dx, dy, nc)
   PG_device *dev;
   int dx, dy, nc;
   {

    dev->window_width     = dx;
    dev->window_height    = dy;
    dev->absolute_n_color = nc;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_RST_QUERY - query some MPEG device characteristics */

static void _PG_rst_query(dev, pdx, pdy, pnc)
   PG_device *dev;
   int *pdx, *pdy, *pnc;
   {

    *pdx = dev->window_width;
    *pdy = dev->window_height;
    *pnc = dev->absolute_n_color;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_RST_MAP_TO_COLOR_TABLE - map the PGS palette to host
 *                            - color table values
 */

static void _PG_rst_map_to_color_table(dev, pal)
   PG_device *dev;
   PG_palette *pal;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
  
