/*
 * GSLAXT.C - test of log axis scales
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

extern PG_axis_def
 SC_DECLARE(*PG_mk_axis_def,
         (int atype, int ttype, int ltype,
          double xl, double yl, double xr, double yr,
          double t1, double t2, double v1, double v2,
          double as, int xlog, int ylog));

static void
 SC_DECLARE(test_axis,
         (PG_device *dev,
          double xmin, double ymin,
          double xmax, double ymax,
          double vmin, double vmax)),
 SC_DECLARE(print_axis_description,
         (PG_axis_def *ad,
          double xmin, double ymin,
          double xmax, double ymax,
          double vmin, double vmax));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

int main(argc, argv)
   int argc;
   char **argv;
   {int i, hc_flag, debug_mode, ret;
    long bytaa, bytfa, bytab, bytfb;
    char s[MAXLINE], *token, *t;
    double xmin, xmax, ymin, ymax, vmin, vmax;
    PG_device *tdev;
    FILE *fp;

    SC_zero_space(0);
    debug_mode = FALSE;

    SC_mem_stats(&bytab, &bytfb, NULL, NULL);

    PG_open_console("GSLAXT", "MONOCHROME", 1,
                    0.55, 0.1, 0.4, 0.8);

    SC_setbuf(STDOUT, NULL);

    PRINT(STDOUT, "\n");

/* process the command line arguments */
    hc_flag = FALSE;
    fp   = stdin;
    for (i = 1; i < argc; i++)
        {if (argv[i][0] == '-')
            {switch (argv[i][1])
	        {case 'd' : debug_mode  = TRUE;
		            SC_mm_debug = TRUE;
		            break;
                 case 's' : hc_flag = TRUE;
		            break;
		 default :
		            break;};}
         else
            {fp = fopen(argv[i], "r");
             break;};};

    if (hc_flag)
       tdev = PG_make_device("PS", "MONOCHROME", "gslaxt");
    else
       tdev = PG_make_device("WINDOW", "MONOCHROME", "PGS Axis Test");

    PG_white_background(tdev, TRUE);
    
    PG_open_device(tdev, 0.05, 0.2, 0.45, 0.45);
    PG_set_viewport(tdev, 0.2, 0.8, 0.2, 0.8);

    while (TRUE)
       {PRINT(STDOUT, "End Points -> ");
        if (GETLN(s, MAXLINE, fp) == NULL)
           {ret = 1;
            break;};

        if (strcmp(s, "end\n") == 0)
           {ret = 0;
            break;};

        token = SC_strtok(s, " ,", t);
        xmin  = SC_stof(token);
        token = SC_strtok(NULL, " ,", t);
        ymin  = SC_stof(token);

        token = SC_strtok(NULL, " ,", t);
        xmax  = SC_stof(token);
        token = SC_strtok(NULL, " ,", t);
        ymax  = SC_stof(token);

        if (xmin == xmax)
           {vmin = ymin;
            vmax = ymax;
            xmin = vmin;
            xmax = vmin;}

        else if (ymin == ymax)
           {vmin = xmin;
            vmax = xmax;
            ymin = vmin;
            ymax = vmin;}

        else
           {vmin = min(xmin, ymin);
            vmax = max(xmax, ymax);};

        test_axis(tdev, xmin, ymin, xmax, ymax, vmin, vmax);};

    PRINT(STDOUT, "\n");

    PG_close_device(tdev);
    PG_close_console();

    if (fp != stdin)
       fclose(fp);

    PG_rl_all();

    _PC_rl_io_callback_lists();

    SC_mem_stats(&bytaa, &bytfa, NULL, NULL);

    bytaa -= bytab;
    bytfa -= bytfb;

    if (debug_mode)
       SC_mem_map(STDOUT, FALSE);

    if ((bytaa - bytfa) != 0)
       {PRINT(STDOUT, "\n\n\t\t   Allocated      Freed       Diff\n");
	PRINT(STDOUT, "\t\t   %9d  %9d  %9d\n\n",
	      bytaa, bytfa, bytaa - bytfa);

        ret = 1;};

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* TEST_AXIS - test the computation of the axis description parameters */

static void test_axis(dev, xmin, ymin, xmax, ymax, vmin, vmax)
   PG_device *dev;
   double xmin, ymin, xmax, ymax, vmin, vmax;
   {PG_axis_def *ad;

    dev->ifxlog = TRUE;
    dev->ifylog = TRUE;

    PG_clear_window(dev);
    PG_set_window(dev, vmin, vmax, vmin, vmax);

    ad = PG_draw_axis(dev, xmin, ymin, xmax, ymax,
                      0.0, 1.0, vmin, vmax,
                      1.0, "%10.3e", STRADDLE_AXIS, RIGHT_OF_AXIS, TRUE,
/*                    LABEL, 0); */
                      MAJOR, MINOR, LABEL, 0);

    PG_finish_plot(dev);

/*    dx = _PG_tick_distribution(ad, logsp, pn)

    ad = PG_mk_axis_def(CARTESIAN, STRADDLE_AXIS, RIGHT_OF_AXIS,
                        xmin, ymin, xmax, ymax, 0.0, 1.0, vmin, vmax, 1.0,
                        TRUE, TRUE);

    _PG_tick(ad, MAJOR);
    _PG_tick(ad, MINOR);
    _PG_tick(ad, LABEL);
 */
    print_axis_description(ad, xmin, ymin, xmax, ymax, vmin, vmax);

    SFREE(ad->major_dx);
    SFREE(ad->minor_dx);
    SFREE(ad);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PRINT_AXIS_DESCRIPTION - print the axis description */

static void print_axis_description(ad, xmin, ymin, xmax, ymax, vmin, vmax)
   PG_axis_def *ad;
   double xmin, ymin, xmax, ymax, vmin, vmax;
   {int i, n;
    REAL *dx;

    PRINT(STDOUT,
          "Axis description for (%f, %f) to (%f, %f):\n",
          xmin, ymin, xmax, ymax);

    PRINT(STDOUT,
          "Label range %f to %f:\n",
          vmin, vmax);

    PRINT(STDOUT,
          "Origin: (%f, %f)\n", ad->x0, ad->y0);
    PRINT(STDOUT,
          "Axis length: %f\n", ad->dr);
    PRINT(STDOUT,
          "Orientation: (%f, %f)\n", ad->cosa, ad->sina);
    PRINT(STDOUT,
          "Scales: %f and (%f, %f)\n", ad->scale, ad->x_scale, ad->y_scale);

    PRINT(STDOUT, "\n");

    PRINT(STDOUT,
          "Major tick info: %d (%f : %f : %f)\n",
          ad->n_major, ad->major_start, ad->major_end, ad->major_space);
    PRINT(STDOUT,
          "Major end tick locations: (%f, %f)\n", ad->va_major, ad->vb_major);

    PRINT(STDOUT,
          "Major tick fractions: ");
    n  = ad->n_major;
    dx = ad->major_dx;
    for (i = 0; i < n; i++)
        PRINT(STDOUT, "%f ", dx[i]);
    PRINT(STDOUT, "\n\n");

    ad->minor_start = max(SMALL, ad->minor_start);

    PRINT(STDOUT,
          "Minor tick info: %d (%f : %f : %f)\n",
          ad->n_minor, ad->minor_start, ad->minor_end, ad->minor_space);
    PRINT(STDOUT,
          "Minor end tick locations: (%f, %f)\n", ad->va_minor, ad->vb_minor);

    PRINT(STDOUT,
          "Minor tick fractions: ");
    n  = ad->n_minor;
    dx = ad->minor_dx;
    for (i = 0; i < n; i++)
        PRINT(STDOUT, "%f ", dx[i]);
    PRINT(STDOUT, "\n\n");

    PRINT(STDOUT,
          "Label tick info: %d (%f : %f : %f)\n",
          ad->n_label, ad->label_start, ad->label_end, ad->label_space);
    PRINT(STDOUT,
          "End tick values: (%f, %f)\n", ad->v1, ad->v2);

    PRINT(STDOUT, "\n");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
