/*
 * SX.H - header file for SX
 *      - Scheme with PACT Extensions
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#ifndef PCK_SX

#define PCK_SX

/* Think C compiler defines THINK_C; CodeWarrior defines __MWERKS__ */
#ifdef THINK_C

# include "panace.h"
# include "scheme.h"

#else

# ifdef __MWERKS__

#  include "panace.h"
#  include "scheme.h"

# else

#  include <panace.h>
#  include <scheme.h>

# endif

#endif

/*--------------------------------------------------------------------------*/

/*                              DEFINED CONSTANTS                           */

/*--------------------------------------------------------------------------*/

#define NPREFIX 26

/* SCHEME object type designations */

#define G_FILE              40
#define G_DEFSTR            41
#define G_SYMENT            42
#define G_DIMDES            43
#define G_MEMDES            44
#define G_PDBDATA           45
#define G_PANVAR            46
#define G_PACKAGE           47
#define G_SOURCE_VARIABLE   48
#define G_IV_SPECIFICATION  49
#define G_PLOT_REQUEST      50
#define G_PLOT_MAP          51
#define G_PLT_CRV           52
#define G_GRAPH             53
#define G_DEVICE            54
#define G_DEV_ATTRIBUTES    55
#define G_NUM_ARRAY         56
#define G_MAPPING           57
#define G_SET               58
#define G_FUNCTION          59
#define G_IMAGE             60
#define G_INTERFACE_OBJECT  61

/*--------------------------------------------------------------------------*/

/*                            PROCEDURAL MACROS                             */

/*--------------------------------------------------------------------------*/

/* SX_PREP_ARG - prepare the arg list by merging lists and
 *             - delistifying one element lists
 *             - NOTE: _SX_prep_arg is doing the ref count right
 *             -       so that a simple assignment must be done here!!!
 */

#define SX_prep_arg(argl)                                                    \
    {argl = _SX_prep_arg(argl);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_PREP_RET - prepare the return value by delistifying one element lists */

#define SX_prep_ret(ret)                                                     \
    {if (_SS_length(ret) == 1)                                               \
        {SS_Assign(ret, SS_car(ret));}                                       \
     else                                                                    \
        {SS_Assign(ret, SS_reverse(ret));};                                  \
     SC_mark(ret, -1);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_LAST_ARG - strip off the last element of the arg list
 *             - potential GC problem here
 */

#define SX_last_arg(tok, argl)                                               \
   {object *t;                                                               \
    for (t = argl, tok = SS_null; SS_consp(t); t = SS_cdr(t))                \
        {SS_Assign(tok, SS_cadr(t));                                         \
         if (SS_nullobjp(SS_cddr(t)))                                        \
            {_SS_setcdr(t, SS_null);                                         \
	     break;};};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_FLOAT_FROM_LIST - extract a double from the list and cdr the list */

#define SX_GET_FLOAT_FROM_LIST(x, argl, s)                                   \
   {obj  = SS_car(argl);                                                     \
    argl = SS_cdr(argl);                                                     \
    if (SS_integerp(obj))                                                    \
       x = (double) SS_INTEGER_VALUE(obj);                                   \
    else if (SS_floatp(obj))                                                 \
       x = SS_FLOAT_VALUE(obj);                                              \
    else                                                                     \
       SS_error(s, obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_INTEGER_FROM_LIST - extract an int from the list and cdr the list */

#define SX_GET_INTEGER_FROM_LIST(x, argl, s)                                 \
   {obj  = SS_car(argl);                                                     \
    argl = SS_cdr(argl);                                                     \
    if (SS_integerp(obj))                                                    \
       x = SS_INTEGER_VALUE(obj);                                            \
    else                                                                     \
       SS_error(s, obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_STRING_FROM_LIST - extract a string from the list
 *                         - and cdr the list
 */

#define SX_GET_STRING_FROM_LIST(x, argl, s)                                  \
   {obj  = SS_car(argl);                                                     \
    argl = SS_cdr(argl);                                                     \
    x    = SC_strsavef(SS_get_string(obj),				     \
           "char*:SX_GET_STRING_FROM_LIST:x");}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_OBJECT_FROM_LIST - extract any object from the list
 *                         - and cdr the list
 */

#define SX_GET_OBJECT_FROM_LIST(predicate, x, value, argl, s)                \
   {obj  = SS_car(argl);                                                     \
    argl = SS_cdr(argl);                                                     \
    if (predicate)                                                           \
       x = (value);                                                          \
    else                                                                     \
       SS_error(s, obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_ARRAY_FROM_LIST - extract a numeric array from the list
 *                        - and cdr the list
 */

#define SX_GET_ARRAY_FROM_LIST(x, argl, s)                                   \
   {obj  = SS_car(argl);                                                     \
    argl = SS_cdr(argl);                                                     \
    if (SX_NUMERIC_ARRAYP(obj))                                              \
       x = NUMERIC_ARRAY_DATA(obj);                                          \
    else                                                                     \
       SS_error(s, obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_GRAPH_FROM_LIST - extract a PG_graph from the list
 *                        - and cdr the list
 */

#define SX_GET_GRAPH_FROM_LIST(x, argl, s)                                   \
   {obj  = SS_car(argl);                                                     \
    argl = SS_cdr(argl);                                                     \
    if (SX_GRAPHP(obj))                                                      \
       x = SS_GET(PG_graph, obj);                                            \
    else                                                                     \
       SS_error(s, obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_SET_FROM_LIST - extract a PM_set from the list
 *                      - and cdr the list
 */

#define SX_GET_SET_FROM_LIST(x, argl, s)                                     \
   {obj  = SS_car(argl);                                                     \
    argl = SS_cdr(argl);                                                     \
    if (SX_SETP(obj))                                                        \
       x = SS_GET(PM_set, obj);                                              \
    else                                                                     \
       SS_error(s, obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GET_MAPPING_FROM_LIST - extract a PM_mapping from the list
 *                          - and cdr the list
 *                          - if item is a graph extract the mapping from it
 */

#define SX_GET_MAPPING_FROM_LIST(pn, argl)                                   \
    {PG_graph *g;                                                            \
     object *obj;                                                            \
     obj  = SS_car(argl);                                                    \
     argl = SS_cdr(argl);                                                    \
     if (SX_GRAPHP(obj))                                                     \
        {g  = SS_GET(PG_graph, obj);                                         \
         pn = g->f;}                                                         \
     else if (SX_MAPPINGP(obj))                                              \
        pn = SS_GET(PM_mapping, obj);                                        \
     else                                                                    \
        SS_error("BAD MAPPING OR GRAPH - SX_GET_MAPPING_FROM_LIST",          \
                 obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_OK_TO_DRAW - TRUE iff in graphics mode or is a hardcopy device */

#define SX_OK_TO_DRAW(dev) (SX_gr_mode || HARDCOPY_DEVICE(dev))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#define FUNCTION_NAME(x)                                                     \
    (SS_GET(SX_object, x)->name)
#define FUNCTION_PROC(x)                                                     \
    ((PFPObject) (SS_GET(SX_object, x)->p1.fp))
#define FUNCTION_HANDLER(x)                                                  \
    ((PFPObject) (SS_GET(SX_object, x)->p2.fp))
#define FUNCTION_DOCUMENTATION(x)                                            \
    ((char *) (SS_GET(SX_object, x)->p3.dp))

#define SX_SET_FUNCTION(x, v)       (SS_GET(SX_object, x)->p1.dp = (byte *) v)
#define SX_SET_HANDLER(x, v)        (SS_GET(SX_object, x)->p2.fp = (PFVoid) v)
#define SX_SET_DOCUMENTATION(x, v)  (SS_GET(SX_object, x)->p3.dp = (byte *) v)

/* PDBLib Types */

#define FILE_FILE(type, x)    (type *) ((x)->file)

#define FILE_TYPE(x)                   (SS_GET(g_file, x)->type)
#define FILE_EXT_TYPE(x)               (SS_GET(g_file, x)->external_type)
#define FILE_STREAM(type, x)  (type *) (SS_GET(g_file, x)->file)
#define FILE_NAME(x)                   (SS_GET(g_file, x)->name)
#define FILE_MENU(x)                   (SS_GET(g_file, x)->menu)
#define FILE_N_MENU_ITEMS(x)           (SS_GET(g_file, x)->n_menu_items)
#define FILE_MAX_MENU_ITEMS(x)         (SS_GET(g_file, x)->max_menu_items)

#define PDBDATA_NAME(x)     (SS_GET(g_pdbdata, x)->name)
#define PDBDATA_DATA(x)     (SS_GET(g_pdbdata, x)->data)
#define PDBDATA_EP(x)       (SS_GET(g_pdbdata, x)->ep)
#define PDBDATA_FILE(x)     (SS_GET(g_pdbdata, x)->file)

#define SYMENT_TYPE(x)      PD_entry_type(SS_GET(syment, x))
#define SYMENT_DIMS(x)      PD_entry_dimensions(SS_GET(syment, x))
#define SYMENT_NUM(x)       PD_entry_number(SS_GET(syment, x))
#define SYMENT_ADDR(x)      PD_entry_address(SS_GET(syment, x))

#define DEFSTR_TYPE(x)      (SS_GET(defstr, x)->type)
#define DEFSTR_SIZE(x)      (SS_GET(defstr, x)->size)
#define DEFSTR_ALIGN(x)     (SS_GET(defstr, x)->alignment)
#define DEFSTR_MEMBERS(x)   (SS_GET(defstr, x)->members)

/* PANACEA Types */

#define PANVAR_NAME(x)      (SS_GET(PA_variable, x)->name)
#define PANVAR_DATA(x)      (SS_GET(PA_variable, x)->data)
#define PANVAR_SIZE(x)      (SS_GET(PA_variable, x)->size)
#define PANVAR_RESTART(x)   (SS_GET(PA_variable, x)->restart)
#define PANVAR_CLASS(x)     (SS_GET(PA_variable, x)->option)
#define PANVAR_CONV(x)      (SS_GET(PA_variable, x)->conv)
#define PANVAR_UNIT(x)      (SS_GET(PA_variable, x)->unit)
#define PANVAR_DESC(x)      (SS_GET(PA_variable, x)->desc)

#define PACKAGE_NAME(x)     (SS_GET(PA_package, x)->name)
#define PACKAGE_TIME(x)     (SS_GET(PA_package, x)->time)
#define PACKAGE_SPACE(x)    (SS_GET(PA_package, x)->space)
#define PACKAGE_DT(x)       (SS_GET(PA_package, x)->dt)
#define PACKAGE_GENCMD(x)   (SS_GET(PA_package, x)->gencmd)
#define PACKAGE_DFSTRC(x)   (SS_GET(PA_package, x)->dfstrc)
#define PACKAGE_INTRN(x)    (SS_GET(PA_package, x)->intrn)
#define PACKAGE_DEFVAR(x)   (SS_GET(PA_package, x)->defvar)
#define PACKAGE_DEFCNT(x)   (SS_GET(PA_package, x)->defcnt)
#define PACKAGE_INIZER(x)   (SS_GET(PA_package, x)->inizer)
#define PACKAGE_MAIN(x)     (SS_GET(PA_package, x)->main)
#define PACKAGE_PPSOR(x)    (SS_GET(PA_package, x)->ppsor)
#define PACKAGE_FINZER(x)   (SS_GET(PA_package, x)->finzer)
#define PACKAGE_PPCMD(x)    (SS_GET(PA_package, x)->ppcmd)
#define PACKAGE_N_SWTCH(x)  (SS_GET(PA_package, x)->n_swtch)
#define PACKAGE_SWTCH(x)    (SS_GET(PA_package, x)->iswtch)
#define PACKAGE_N_PARAM(x)  (SS_GET(PA_package, x)->n_param)
#define PACKAGE_PARAM(x)    (SS_GET(PA_package, x)->rparam)
#define PACKAGE_N_ASCII(x)  (SS_GET(PA_package, x)->n_ascii)
#define PACKAGE_ASCII(x)    (SS_GET(PA_package, x)->ascii)
#define PACKAGE_S(x)        (SS_GET(PA_package, x)->s)

#define SOURCE_VARIABLE_NAME(x)        (SS_GET(PA_src_variable, x)->name)
#define SOURCE_VARIABLE_VAR_INDEX(x)   (SS_GET(PA_src_variable, x)->var_index)
#define SOURCE_VARIABLE_N_TIMEs(x)     (SS_GET(PA_src_variable, x)->n_times)
#define SOURCE_VARIABLE_CONV(x)        (SS_GET(PA_src_variable, x)->conv)
#define SOURCE_VARIABLE_TIMES(x)       (SS_GET(PA_src_variable, x)->times)
#define SOURCE_VARIABLE_QUEUE(x)       (SS_GET(PA_src_variable, x)->queue)
#define SOURCE_VARIABLE_QUEUE_TIMES(x) (SS_GET(PA_src_variable, x)->queue_times)
#define SOURCE_VARIABLE_INDEX(x)       (SS_GET(PA_src_variable, x)->index)
#define SOURCE_VARIABLE_SIZE(x)        (SS_GET(PA_src_variable, x)->size)
#define SOURCE_VARIABLE_FILE(x)        (SS_GET(PA_src_variable, x)->file)

/* IV_SPECIFICATION is PD_DEFSTR'd in DEF_STR in PANACEA.C
 * so any changes here must be reflected there
 */

#define IV_SPECIFICATION_TYPE(x)      (SS_GET(PA_iv_specification, x)->type)
#define IV_SPECIFICATION_NAME(x)      (SS_GET(PA_iv_specification, x)->name)
#define IV_SPECIFICATION_FILE(x)      (SS_GET(PA_iv_specification, x)->file)
#define IV_SPECIFICATION_NUM(x)       (SS_GET(PA_iv_specification, x)->num)
#define IV_SPECIFICATION_INDEX(x)     (SS_GET(PA_iv_specification, x)->index)
#define IV_SPECIFICATION_SPEC(x)      (SS_GET(PA_iv_specification, x)->spec)
#define IV_SPECIFICATION_DATA(x)      (SS_GET(PA_iv_specification, x)->data)
#define IV_SPECIFICATION_NEXT(x)      (SS_GET(PA_iv_specification, x)->next)

/* PLOT_REQUEST is PD_DEFSTR'd in DEF_STR in PANACEA.C
 * so any changes here must be reflected there
 */

#define PLOT_REQUEST_Y_AXIS(x)      (SS_GET(plot_request, x)->y_axis)
#define PLOT_REQUEST_Y_ZONE(x)      (SS_GET(plot_request, x)->y_zone)
#define PLOT_REQUEST_Y_AXIS_INT(x)  (SS_GET(plot_request, x)->y_axis_int)
#define PLOT_REQUEST_X_AXIS(x)      (SS_GET(plot_request, x)->x_axis)
#define PLOT_REQUEST_X_ZONE(x)      (SS_GET(plot_request, x)->x_zone)
#define PLOT_REQUEST_X_AXIS_INT(x)  (SS_GET(plot_request, x)->x_axis_int)
#define PLOT_REQUEST_SNAP(x)        (SS_GET(plot_request, x)->snap)
#define PLOT_REQUEST_SNAP_TIMES(x)  (SS_GET(plot_request, x)->snap_times)
#define PLOT_REQUEST_NEXT(x)        (SS_GET(plot_request, x)->next)

#define PLOT_MAP_NAME(x)       (SS_GET(plot_map, x)->name)
#define PLOT_MAP_FALSE(x)      (SS_GET(plot_map, x)->false)
#define PLOT_MAP_INDEX(x)      (SS_GET(plot_map, x)->index)
#define PLOT_MAP_CONV(x)       (SS_GET(plot_map, x)->conv)

#define PLT_CRV_LABEL(x)      (SS_GET(plt_crv, x)->label)
#define PLT_CRV_Y_INDEX(x)    (SS_GET(plt_crv, x)->y_index)
#define PLT_CRV_Y_CONV(x)     (SS_GET(plt_crv, x)->y_conv)
#define PLT_CRV_X_INDEX(x)    (SS_GET(plt_crv, x)->x_index)
#define PLT_CRV_X_CONV(x)     (SS_GET(plt_crv, x)->x_conv)
#define PLT_CRV_PLT_R(x)      (SS_GET(plt_crv, x)->plt_r)
#define PLT_CRV_NPTS(x)       (SS_GET(plt_crv, x)->npts)

/* PGS extensions */

/* GRAPH - contains the information necessary to display a list of functions
 *       - in some fashion
 */

#define GRAPH_F(x)             (SS_GET(PG_graph, x)->f)
#define GRAPH_IDENTIFIER(x)    (SS_GET(PG_graph, x)->identifier)
#define GRAPH_INFO(x)          (SS_GET(PG_graph, x)->info)
#define GRAPH_NEXT(x)          (SS_GET(PG_graph, x)->next)

/* INTERFACE_OBJECT - access PG_interface_object structure members */

#define INTERFACE_OBJECT(x)           (SS_GET(PG_interface_object, x))
#define INTERFACE_OBJECT_NAME(x)      (SS_GET(PG_interface_object, x)->name)
#define INTERFACE_OBJECT_TYPE(x)      (SS_GET(PG_interface_object, x)->type)
#define INTERFACE_OBJECT_DEVICE(x)    (SS_GET(PG_interface_object, x)->device)

/* IMAGE - access image structure members */

#define IMAGE_NAME(x)          (SS_GET(PG_image, x)->label)
#define IMAGE_DATA(x)          (SS_GET(PG_image, x)->bf)
#define IMAGE_TYPE(x)          (SS_GET(PG_image, x)->element_type)
#define IMAGE_KMAX(x)          (SS_GET(PG_image, x)->kmax)
#define IMAGE_LMAX(x)          (SS_GET(PG_image, x)->lmax)
#define IMAGE_XMAX(x)          (SS_GET(PG_image, x)->xmax)
#define IMAGE_XMIN(x)          (SS_GET(PG_image, x)->xmin)
#define IMAGE_YMAX(x)          (SS_GET(PG_image, x)->ymax)
#define IMAGE_YMIN(x)          (SS_GET(PG_image, x)->ymin)
#define IMAGE_ZMAX(x)          (SS_GET(PG_image, x)->zmax)
#define IMAGE_ZMIN(x)          (SS_GET(PG_image, x)->ymin)

#define DEV_ATTRIBUTES_CLIPPING(x)        (SS_GET(PG_dev_attributes, x)->clipping)
#define DEV_ATTRIBUTES_CHAR_FONT(x)       (SS_GET(PG_dev_attributes, x)->char_font)
#define DEV_ATTRIBUTES_CHAR_FRAC(x)       (SS_GET(PG_dev_attributes, x)->char_frac)
#define DEV_ATTRIBUTES_CHAR_HEIGHT(x)     (SS_GET(PG_dev_attributes, x)->char_height)
#define DEV_ATTRIBUTES_CHAR_PRECISION(x)  (SS_GET(PG_dev_attributes, x)->char_precision)
#define DEV_ATTRIBUTES_CHAR_SPACE(x)      (SS_GET(PG_dev_attributes, x)->char_space)
#define DEV_ATTRIBUTES_CHAR_UP_X(x)       (SS_GET(PG_dev_attributes, x)->char_up_x)
#define DEV_ATTRIBUTES_CHAR_UP_Y(x)       (SS_GET(PG_dev_attributes, x)->char_up_y)
#define DEV_ATTRIBUTES_CHAR_WIDTH(x)      (SS_GET(PG_dev_attributes, x)->char_width)
#define DEV_ATTRIBUTES_FILL_COLOR(x)      (SS_GET(PG_dev_attributes, x)->fill_color)
#define DEV_ATTRIBUTES_LINE_COLOR(x)      (SS_GET(PG_dev_attributes, x)->line_color)
#define DEV_ATTRIBUTES_LINE_STYLE(x)      (SS_GET(PG_dev_attributes, x)->line_style)
#define DEV_ATTRIBUTES_LINE_WIDTH(x)      (SS_GET(PG_dev_attributes, x)->line_width)
#define DEV_ATTRIBUTES_LOGICAL_OP(x)      (SS_GET(PG_dev_attributes, x)->logical_op)
#define DEV_ATTRIBUTES_TEXT_COLOR(x)      (SS_GET(PG_dev_attributes, x)->text_color)

#define DEVICE_AUTODOMAIN(x)             (SS_GET(PG_device, x)->autodomain)
#define DEVICE_AUTOPLOT(x)               (SS_GET(PG_device, x)->autoplot)
#define DEVICE_AUTORANGE(x)              (SS_GET(PG_device, x)->autorange)
#define DEVICE_AXS_W(x)                  (SS_GET(PG_device, x)->axs_w)
#define DEVICE_AXW_S(x)                  (SS_GET(PG_device, x)->axw_s)
#define DEVICE_AYW_S(x)                  (SS_GET(PG_device, x)->ayw_s)
#define DEVICE_AYS_W(x)                  (SS_GET(PG_device, x)->ays_w)
#define DEVICE_BXS_W(x)                  (SS_GET(PG_device, x)->bxs_w)
#define DEVICE_BXW_S(x)                  (SS_GET(PG_device, x)->bxw_s)
#define DEVICE_BYS_W(x)                  (SS_GET(PG_device, x)->bys_w)
#define DEVICE_BYW_S(x)                  (SS_GET(PG_device, x)->byw_s)
#define DEVICE_BACKGROUND_COLOR_WHITE(x) (SS_GET(PG_device, x)->background_color_white)
#define DEVICE_BORDER_WIDTH(x)           (SS_GET(PG_device, x)->border_width)
#define DEVICE_BOTSPACE(x)               (SS_GET(PG_device, x)->botspace)
#define DEVICE_CHAR_FONT(x)              (SS_GET(PG_device, x)->char_font)
#define DEVICE_CHAR_FRAC(x)              (SS_GET(PG_device, x)->char_frac)
#define DEVICE_CHAR_HEIGHT(x)            (SS_GET(PG_device, x)->char_height)
#define DEVICE_CHAR_HEIGHT_S(x)          (SS_GET(PG_device, x)->char_height_s)
#define DEVICE_CHAR_PRECISION(x)         (SS_GET(PG_device, x)->char_precision)
#define DEVICE_CHAR_SPACE(x)             (SS_GET(PG_device, x)->char_space)
#define DEVICE_CHAR_SPACE_S(x)           (SS_GET(PG_device, x)->char_space_s)
#define DEVICE_CHAR_UP_X(x)              (SS_GET(PG_device, x)->char_up_x)
#define DEVICE_CHAR_UP_Y(x)              (SS_GET(PG_device, x)->char_up_y)
#define DEVICE_CHAR_WIDTH(x)             (SS_GET(PG_device, x)->char_width)
#define DEVICE_CHAR_WIDTH_S(x)           (SS_GET(PG_device, x)->char_width_s)
#define DEVICE_CLIPPING(x)               (SS_GET(PG_device, x)->clipping)
#define DEVICE_FILE(x)                   (SS_GET(PG_device, x)->file)
#define DEVICE_FILL_COLOR(x)             (SS_GET(PG_device, x)->fill_color)
#define DEVICE_GCURX(x)                  (SS_GET(PG_device, x)->SS_gcurx)
#define DEVICE_GCURY(x)                  (SS_GET(PG_device, x)->SS_gcury)
#define DEVICE_GPRINT_FLAG(x)            (SS_GET(PG_device, x)->gprint_flag)
#define DEVICE_GRID(x)                   (SS_GET(PG_device, x)->grid)
#define DEVICE_HARD_COPY_DEVICE(x)       (SS_GET(PG_device, x)->hard_copy_device)
#define DEVICE_GXMAX(x)                  (SS_GET(PG_device, x)->gxmax)
#define DEVICE_GXMIN(x)                  (SS_GET(PG_device, x)->gxmin)
#define DEVICE_GYMAX(x)                  (SS_GET(PG_device, x)->gymax)
#define DEVICE_GYMIN(x)                  (SS_GET(PG_device, x)->gymin)
#define DEVICE_IFXLOG(x)                 (SS_GET(PG_device, x)->ifxlog)
#define DEVICE_IFYLOG(x)                 (SS_GET(PG_device, x)->ifylog)
#define DEVICE_LEFTSPACE(x)              (SS_GET(PG_device, x)->leftspace)
#define DEVICE_LINE_STYLE(x)             (SS_GET(PG_device, x)->line_style)
#define DEVICE_LINE_COLOR(x)             (SS_GET(PG_device, x)->line_color)
#define DEVICE_TEXT_COLOR(x)             (SS_GET(PG_device, x)->text_color)
#define DEVICE_LINE_WIDTH(x)             (SS_GET(PG_device, x)->line_width)
#define DEVICE_LOGICAL_OP(x)             (SS_GET(PG_device, x)->logical_op)
#define DEVICE_MARK(x)                   (SS_GET(PG_device, x)->mark)
#define DEVICE_MARKER(x)                 (SS_GET(PG_device, x)->marker)
#define DEVICE_MODE(x)                   (SS_GET(PG_device, x)->mode)
#define DEVICE_NAME(x)                   (SS_GET(PG_device, x)->name)
#define DEVICE_N_CHAR_LINE(x)            (SS_GET(PG_device, x)->n_char_line)
#define DEVICE_NCOLOR(x)                 (SS_GET(PG_device, x)->ncolor)
#define DEVICE_N_LINES_PAGE(x)           (SS_GET(PG_device, x)->n_lines_page)
#define DEVICE_NLINES(x)                 (SS_GET(PG_device, x)->nlines)
#define DEVICE_PS_COLOR(x)               (SS_GET(PG_device, x)->ps_color)
#define DEVICE_QUADRANT(x)               (SS_GET(PG_device, x)->quadrant)
#define DEVICE_RIGHTSPACE(x)             (SS_GET(PG_device, x)->rightspace)
#define DEVICE_SCATTER(x)                (SS_GET(PG_device, x)->scatter)
#define DEVICE_SXMAX(x)                  (SS_GET(PG_device, x)->sxmax)
#define DEVICE_SXMIN(x)                  (SS_GET(PG_device, x)->sxmin)
#define DEVICE_SYMAX(x)                  (SS_GET(PG_device, x)->symax)
#define DEVICE_SYMIN(x)                  (SS_GET(PG_device, x)->symin)
#define DEVICE_TCURX(x)                  (SS_GET(PG_device, x)->tcurx)
#define DEVICE_TCURY(x)                  (SS_GET(PG_device, x)->tcury)
#define DEVICE_TITLE(x)                  (SS_GET(PG_device, x)->title)
#define DEVICE_TOPSPACE(x)               (SS_GET(PG_device, x)->topspace)
#define DEVICE_TXMAX(x)                  (SS_GET(PG_device, x)->txmax)
#define DEVICE_TXMIN(x)                  (SS_GET(PG_device, x)->txmin)
#define DEVICE_TYMAX(x)                  (SS_GET(PG_device, x)->tymax)
#define DEVICE_TYMIN(x)                  (SS_GET(PG_device, x)->tymin)
#define DEVICE_TYPE_INDEX(x)             (SS_GET(PG_device, x)->type_index)
#define DEVICE_TXT_RATIO(x)              (SS_GET(PG_device, x)->txt_ratio)
#define DEVICE_TYPE(x)                   (SS_GET(PG_device, x)->type)
#define DEVICE_VIEW_ASPECT(x)            (SS_GET(PG_device, x)->view_aspect)
#define DEVICE_VIEW_HEIGHT(x)            (SS_GET(PG_device, x)->view_height)
#define DEVICE_VIEW_WIDTH(x)             (SS_GET(PG_device, x)->view_width)
#define DEVICE_VIEW_X(x)                 (SS_GET(PG_device, x)->view_x)
#define DEVICE_VIEW_Y(x)                 (SS_GET(PG_device, x)->view_y)
#define DEVICE_WINDOW_HEIGHT(x)          (SS_GET(PG_device, x)->window_height)
#define DEVICE_WINDOW_WIDTH(x)           (SS_GET(PG_device, x)->window_width)
#define DEVICE_WINDOW_X(x)               (SS_GET(PG_device, x)->window_x)
#define DEVICE_WINDOW_Y(x)               (SS_GET(PG_device, x)->window_y)
#define DEVICE_XMAX(x)                   (SS_GET(PG_device, x)->xmax)
#define DEVICE_XMIN(x)                   (SS_GET(PG_device, x)->xmin)
#define DEVICE_YMAX(x)                   (SS_GET(PG_device, x)->ymax)
#define DEVICE_YMIN(x)                   (SS_GET(PG_device, x)->ymin)
#define DEVICE_BLACK(x)                  (SS_GET(PG_device, x)->BLACK)
#define DEVICE_WHITE(x)                  (SS_GET(PG_device, x)->WHITE)
#define DEVICE_GRAY(x)                   (SS_GET(PG_device, x)->GRAY)
#define DEVICE_DARK_GRAY(x)              (SS_GET(PG_device, x)->DARK_GRAY)
#define DEVICE_BLUE(x)                   (SS_GET(PG_device, x)->BLUE)
#define DEVICE_GREEN(x)                  (SS_GET(PG_device, x)->GREEN)
#define DEVICE_CYAN(x)                   (SS_GET(PG_device, x)->CYAN)
#define DEVICE_RED(x)                    (SS_GET(PG_device, x)->RED)
#define DEVICE_MAGENTA(x)                (SS_GET(PG_device, x)->MAGENTA)
#define DEVICE_BROWN(x)                  (SS_GET(PG_device, x)->BROWN)
#define DEVICE_DARK_BLUE(x)              (SS_GET(PG_device, x)->DARK_BLUE)
#define DEVICE_DARK_GREEN(x)             (SS_GET(PG_device, x)->DARK_GREEN)
#define DEVICE_DARK_CYAN(x)              (SS_GET(PG_device, x)->DARK_CYAN)
#define DEVICE_DARK_RED(x)               (SS_GET(PG_device, x)->DARK_RED)
#define DEVICE_YELLOW(x)                 (SS_GET(PG_device, x)->YELLOW)
#define DEVICE_DARK_MAGENTA(x)           (SS_GET(PG_device, x)->DARK_MAGENTA)

/* PML Extensions */

#define NUMERIC_ARRAY_TYPE(x)       (SS_GET(C_array, x)->type)
#define NUMERIC_ARRAY_LENGTH(x)     (SS_GET(C_array, x)->length)
#define NUMERIC_ARRAY_DATA(x)       (SS_GET(C_array, x)->data)

#define SET_NAME(x)                 (SS_GET(PM_set, x)->name)
#define SET_ELEMENT_TYPE(x)         (SS_GET(PM_set, x)->element_type)
#define SET_N_ELEMENTS(x)           (SS_GET(PM_set, x)->n_elements)
#define SET_DIMENSION(x)            (SS_GET(PM_set, x)->dimension)
#define SET_MAX_INDEX(x)            (SS_GET(PM_set, x)->max_index)
#define SET_ELEMENTS(x)             (SS_GET(PM_set, x)->elements)
#define SET_ES_TYPE(x)              (SS_GET(PM_set, x)->es_type)
#define SET_EXTREMA(x)              (SS_GET(PM_set, x)->extrema)
#define SET_SCALES(x)               (SS_GET(PM_set, x)->scales)
#define SET_OPERS(x)                (SS_GET(PM_set, x)->opers)
#define SET_METRIC(x)               (SS_GET(PM_set, x)->metric)
#define SET_SYMMETRY_TYPE(x)        (SS_GET(PM_set, x)->symmetry_type)
#define SET_SYMMETRY(x)             (SS_GET(PM_set, x)->symmetry)
#define SET_TOPOLOGY_TYPE(x)        (SS_GET(PM_set, x)->topology_type)
#define SET_TOPOLOGY(x)             (SS_GET(PM_set, x)->topology)
#define SET_INFO_TYPE(x)            (SS_GET(PM_set, x)->info_type)
#define SET_INFO(x)                 (SS_GET(PM_set, x)->info)

#define MAPPING_NAME(x)             (SS_GET(PM_mapping, x)->name)
#define MAPPING_DOMAIN(x)           (SS_GET(PM_mapping, x)->domain)
#define MAPPING_RANGE(x)            (SS_GET(PM_mapping, x)->range)
#define MAPPING_MAP_TYPE(x)         (SS_GET(PM_mapping, x)->map_type)
#define MAPPING_MAP(x)              (SS_GET(PM_mapping, x)->map)
#define MAPPING_FILE_TYPE(x)        (SS_GET(PM_mapping, x)->file_type)
#define MAPPING_FILE_INFO(x)        (SS_GET(PM_mapping, x)->file_info)
#define MAPPING_FILE(x)             (SS_GET(PM_mapping, x)->file)
#define MAPPING_NEXT(x)             (SS_GET(PM_mapping, x)->next)

/*--------------------------------------------------------------------------*/

/*                           PREDICATE MACROS                               */

/*--------------------------------------------------------------------------*/
 
/* SX Types */

#define SX_FUNCTIONP(obj)         (SS_OBJECT_TYPE(obj) == G_FUNCTION)
#define SX_FILEP(obj)             (SS_OBJECT_TYPE(obj) == G_FILE)

/* PDBLib Types */

#define SX_DEFSTRP(obj)           (SS_OBJECT_TYPE(obj) == G_DEFSTR)
#define SX_SYMENTP(obj)           (SS_OBJECT_TYPE(obj) == G_SYMENT)
#define SX_PDBDATAP(obj)          (SS_OBJECT_TYPE(obj) == G_PDBDATA)

/* PANACEA Types */

#define SX_PANVARP(obj)           (SS_OBJECT_TYPE(obj) == G_PANVAR)
#define SX_PACKAGEP(obj)          (SS_OBJECT_TYPE(obj) == G_PACKAGE)
#define SX_SOURCE_VARIABLEP(obj)  (SS_OBJECT_TYPE(obj) == G_SOURCE_VARIABLE)
#define SX_IV_SPECIFICATIONP(obj) (SS_OBJECT_TYPE(obj) == G_IV_SPECIFICATION)
#define SX_PLOT_REQUESTP(obj)     (SS_OBJECT_TYPE(obj) == G_PLOT_REQUEST)
#define SX_PLOT_MAPP(obj)         (SS_OBJECT_TYPE(obj) == G_PLOT_MAP)
#define SX_PLT_CRVP(obj)          (SS_OBJECT_TYPE(obj) == G_PLT_CRV)

/* PGS Types */

#define SX_GRAPHP(obj)            (SS_OBJECT_TYPE(obj) == G_GRAPH)
#define SX_IMAGEP(obj)            (SS_OBJECT_TYPE(obj) == G_IMAGE)
#define SX_INTERFACE_OBJECTP(obj) (SS_OBJECT_TYPE(obj) == G_INTERFACE_OBJECT)
#define SX_DEVICEP(obj)           (SS_OBJECT_TYPE(obj) == G_DEVICE)
#define SX_DEV_ATTRIBUTESP(obj)   (SS_OBJECT_TYPE(obj) == G_DEV_ATTRIBUTES)

/* PML Types */

#define SX_NUMERIC_ARRAYP(obj)    (SS_OBJECT_TYPE(obj) == G_NUM_ARRAY)
#define SX_MAPPINGP(obj)          (SS_OBJECT_TYPE(obj) == G_MAPPING)
#define SX_SETP(obj)              (SS_OBJECT_TYPE(obj) == G_SET)

/*--------------------------------------------------------------------------*/

/*                           STRUCT DEFINITIONS                             */

/*--------------------------------------------------------------------------*/

struct s_g_pdbdata
   {char *name;                                     /* name of the variable */
    byte *data;                                      /* pointer to the data */
    syment *ep;                                       /* symbol table entry */
    PDBfile *file;};  /* the file this data is from (needs structure chart) */

typedef struct s_g_pdbdata g_pdbdata;

union u_SX_pointer
   {PFVoid fp;
    byte *dp;};

typedef union u_SX_pointer SX_pointer;

struct s_SX_object
   {char *name;
    char *type;
    SX_pointer p1;
    SX_pointer p2;
    SX_pointer p3;};

typedef struct s_SX_object SX_object;

struct s_SX_menu_item
   {char *vname;
    char *label;
    char *type;};

typedef struct s_SX_menu_item SX_menu_item;

struct s_g_file
   {char *type;                                       /* file type SX knows */
    char *external_type;                       /* file type the world knows */
    char *file;
    object *file_object;
    char *name;
    PFInt type_hook;
    SX_menu_item *menu;
    int n_menu_items;
    int max_menu_items;
    struct s_g_file *next;};
    
typedef struct s_g_file g_file;

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------*/

/*                        VARIABLE DECLARATIONS                             */

/*--------------------------------------------------------------------------*/

extern data_standard
 *PDB_STANDARD;

extern HASHTAB
 *PDB_Chrt;

extern FILE
 *SX_command_log;

extern PDBfile
 *SX_vif;

extern g_file
 *SX_file_list,
 *SX_gvif;

extern object
 *_SX_var_tab,
 *SX_ovif;

extern PFByte
 SX_plot_hook;

extern PFInt
 SX_pan_data_hook,
 SX_file_type_hook;

extern int
 SX_disp_individ_diff,
 SX_prefix_list[],
 SX_autorange,
 SX_autodomain,
 SX_autoplot,
 SX_background_color_white,
 SX_border_width,
 SX_cgm_background_color,
 SX_cgm_flag,
 SX_data_id,
 SX_default_color,
 SX_file_exist_action,
 SX_GRI_type_size,
 SX_gr_mode,
 SX_grid,
 SX_label_color_flag,
 SX_label_length,
 SX_label_type_size,
 SX_plot_flag,
 SX_plot_type_size,
 SX_ps_flag,
 SX_qflag,
 SX_render_def,
 SX_render_1d_1d,
 SX_render_2d_1d,
 SX_render_2d_2d,
 SX_show_mouse_location,
 SX_squeeze_labels,
 SX_x_log_scale,
 SX_y_log_scale;

extern REAL
 SX_botspace,
 SX_chi,
 SX_console_x,
 SX_console_y,
 SX_console_width,
 SX_console_height,
 SX_window_x,
 SX_window_x_P,
 SX_window_y,
 SX_window_y_P,
 SX_window_width,
 SX_window_width_P,
 SX_window_height,
 SX_window_height_P,
 SX_GRI_x,
 SX_GRI_y,
 SX_GRI_dx,
 SX_GRI_dy,
 SX_label_space,
 SX_leftspace,
 SX_marker_scale,
 SX_marker_orientation,
 SX_phi,
 SX_rightspace,
 SX_show_mouse_location_x,
 SX_show_mouse_location_y,
 SX_theta,
 SX_topspace;

extern char
 *SX_cgm_name,
 *SX_cgm_type,
 *SX_command_log_name,
 *SX_console_type,
 SX_err[],                      /* global buffer for certain error messages */
 *SX_GRI_title,
 *SX_GRI_type_face,
 *SX_GRI_type_style,
 *SX_PDBFILE_S,
 *SX_plot_type_style,
 *SX_promotion_type,
 *SX_ps_name,
 *SX_ps_type,
 *SX_pui_file,
 *SX_smooth_method;

#ifdef HAVE_JPEGLIB
extern int
 SX_jpeg_flag;

extern char
 *SX_jpeg_name,
 *SX_jpeg_type;
#endif

extern char
 *SX_jpeglib_flag;

/*--------------------------------------------------------------------------*/

/*                        FUNCTION DECLARATIONS                             */

/*--------------------------------------------------------------------------*/


/* SXCONT.C declarations */

extern int
 SC_DECLARE(_SX_expand_expr, (char *s)),
 SC_DECLARE(_SX_split_command, (char *cmd, char *lst));

extern char
 *SC_DECLARE(_SX_wrap_paren, 
             (char *open, char *form, char *close));

extern object
 *SC_DECLARE(_SX_call_args, (int type, byte *v)),
 *SC_DECLARE(SX_menu, (object *argl));

extern void
 SC_DECLARE(_SX_args, (object *obj, byte *v, int type)),
 SC_DECLARE(_SX_get_menu, (g_file *po)),
 SC_DECLARE(_SX_push_menu_item, 
            (g_file *po, char *name, char *type)),
 SC_DECLARE(SX_parse, (DECLFPTR(byte, replot, (void)),
		    DECLFPTR(char *, reproc, (char *s)),
		    object *strm)),
 SC_DECLARE(SX_install_global_vars, (byte));


/* SXSET.C declarations */

extern object
 *SC_DECLARE(SX_pp_names, (object *argl)),
 *SC_DECLARE(_SX_prep_arg, (object *argl));

extern void
 SC_DECLARE(SX_init, (char *code, char *vers)),
 SC_DECLARE(SX_install_funcs, (byte));

extern int
 SC_DECLARE(_SX_get_object_length, (object *obj)),
 SC_DECLARE(SX_next_prefix, (byte)),
 SC_DECLARE(SX_get_ch, (object *str, int ign_ws));


/* SXFUNC.C declarations */

extern void
 SC_DECLARE(_SX_quit, (int i)),
 SC_DECLARE(SX_install_global_funcs, (byte));

extern object
 *SC_DECLARE(SX_synonym, (object *argl)),
 *SC_DECLARE(SX_toggle_log, (object *argl)),
 *SC_DECLARE(SX_get_dimension, (object *arg)),
 *SC_DECLARE(SX_get_domain, (object *arg)),
 *SC_DECLARE(SX_get_range, (object *arg)),
 *SC_DECLARE(SX_get_mapping_name, (object *arg)),
 *SC_DECLARE(SX_set_volume, (object *arg)),
 *SC_DECLARE(SX_shift_domain, (object *argl)),
 *SC_DECLARE(SX_shift_range, (object *argl)),
 *SC_DECLARE(SX_scale_domain, (object *argl)),
 *SC_DECLARE(SX_scale_range, (object *argl)),
 *SC_DECLARE(SX_plane, (object *argl));

extern PM_mapping
 *SC_DECLARE(SX_norm_mapping, (PM_mapping *h)),
 *SC_DECLARE(SX_integrate_mapping, (PM_mapping *h));

extern PM_set
 *SC_DECLARE(SX_copy_set, (PM_set *in));

extern int
 SC_DECLARE(SX_map_count, (byte));


/* SXGRI.C declarations */

extern object
 *SC_DECLARE(SX_mk_iob, (PG_interface_object *iob));

extern void
 SC_DECLARE(SX_rem_iob, 
            (PG_interface_object *iob, int flag));


/* SXGROT.C declarations */

extern int
 SC_DECLARE(_SX_grotrian_mappingp, (PM_mapping *f)),
 SC_DECLARE(_SX_grotrian_graphp, (PG_graph *g)),
 SC_DECLARE(_SX_any_grotrianp, (object *argl));

extern object
 *SC_DECLARE(SX_draw_grotrian, (object *argl)),
 *SC_DECLARE(SX_grotrian_mappingp, (object *obj)),
 *SC_DECLARE(SX_grotrian_graphp, (object *obj));


/* SXHAND.C declarations */

extern object
 *SC_DECLARE(_SX_mh_u_s, (PFPObject f, object *argl)),
 *SC_DECLARE(_SX_mh_u_s_nm, 
             (PFPObject oper, object *argl)),
 *SC_DECLARE(_SX_m11_x, (PFPObject oper, object *argl)),
 *SC_DECLARE(_SX_m11_b_mds, 
             (PFPObject oper, object *argl)),
 *SC_DECLARE(_SX_m11_b_mrs, 
             (PFPObject oper, object *argl)),
 *SC_DECLARE(_SX_mh_u_m, (PFPObject oper, object *argl)),
 *SC_DECLARE(_SX_mh_u_o, (PFPObject oper, object *argl)),
 *SC_DECLARE(_SX_mh_u_v, (PFPObject oper, object *argl)),
 *SC_DECLARE(_SX_ah_m, (PFPObject oper, object *argl));

extern void
 SC_DECLARE(SX_mf_install, (byte));


/* SXHBO.C declarations */

extern object
 *SC_DECLARE(_SX_mh_b_s, (PFPObject fn, object *argl));

PM_set
 *SC_DECLARE(SX_build_common_domain, (PM_mapping *h));

PM_mapping
 *SC_DECLARE(SX_build_accumulator_mapping,
         (PM_set *domain, PM_mapping *h));


/* SXPAN.C declarations */

extern void
 SC_DECLARE(SX_install_panacea_funcs, (byte));

extern object
 *SC_DECLARE(SX_mk_package, (PA_package *pck)),
 *SC_DECLARE(SX_mk_variable, (PA_variable *pp));


/* SXPANW.C declarations */

extern object
 *SC_DECLARE(SX_display_pan_object, (object *obj)),
 *SC_DECLARE(SX_desc_pan, (object *obj));


/* SXPDB.C declarations */

extern void
 SC_DECLARE(SX_install_pdb_funcs, (byte)),
 SC_DECLARE(SX_container, (char *dtype, char *stype));

extern int
 SC_DECLARE(SX_pdbfilep, (object *arg)),
 SC_DECLARE(SX_ipdbfilep, (object *arg)),
 SC_DECLARE(_SX_file_varp, 
            (PDBfile *file, char *name, int flag)),
 SC_DECLARE(SX_convert,
	    (char *dtype, byte **pd, char *stype, byte *s, int n, int flag));

extern object
 *SC_DECLARE(SX_create_pdbfile, (object *arg)),
 *SC_DECLARE(SX_open_pdbfile, (object *arg)),
 *SC_DECLARE(SX_open_file,
          (object *arg, PFPByte fun, char *type, char *ext_type,
           char *mode, PFInt type_hook)),
 *SC_DECLARE(SX_close_pdbfile, (object *arg)),
 *SC_DECLARE(SX_close_file, (object *arg, PFInt fun)),
 *SC_DECLARE(SX_list_file, (byte)),
 *SC_DECLARE(SX_flush_pdbfile, (object *arg)),
 *SC_DECLARE(SX_pdbfp, (object *obj)),
 *SC_DECLARE(SX_defp, (object *obj)),
 *SC_DECLARE(SX_pdbdatap, (object *obj)),
 *SC_DECLARE(SX_symp, (object *obj)),
 *SC_DECLARE(SX_list_symtab, (object *argl)),
 *SC_DECLARE(SX_list_variables, (object *argl)),
 *SC_DECLARE(SX_change_directory, (object *argl)),
 *SC_DECLARE(SX_make_directory, (object *argl)),
 *SC_DECLARE(SX_current_directory, (object *arg)),
 *SC_DECLARE(SX_create_link, (object *argl)),
 *SC_DECLARE(SX_list_defstrs, (object *arg)),
 *SC_DECLARE(SX_file_varp, (object *argl)),
 *SC_DECLARE(SX_wrt_ultra_curve, (object *argl)),
 *SC_DECLARE(SX_get_pdbfile, 
             (object *argl, PDBfile **pfile)),
 *SC_DECLARE(SX_get_file, (object *argl, g_file **pfile)),
 *SC_DECLARE(SX_show_pdb, (object *arg)),
 *SC_DECLARE(SX_wr_to_textfile, (object *arg)),
 *SC_DECLARE(SX_pdb_to_list, (object *arg)),
 *SC_DECLARE(_SX_pdbfile_to_list, (PDBfile *file)),
 *SC_DECLARE(_SX_syment_to_list, (syment *ep)),
 *SC_DECLARE(_SX_defstr_to_list, (defstr *dp)),
 *SC_DECLARE(_SX_pdbdata_to_list,
          (char *name, byte *vr, syment *ep, PDBfile *file)),
 *SC_DECLARE(SX_desc_variable, (object *obj)),
 *SC_DECLARE(_SX_make_dims_obj, (dimdes *dims)),
 *SC_DECLARE(SX_pdbdata_to_hash, (object *arg)),
 *SC_DECLARE(SX_hash_to_pdbdata, (object *argl)),
 *SC_DECLARE(SX_pdbdata_handler,
          (PDBfile *file, char *name,
           char *type, byte *vr, int flag)),
 *SC_DECLARE(SX_set_switch, (object *argl)),
 *SC_DECLARE(SX_set_format, (object *argl)),
 *SC_DECLARE(SX_pdb_type, (object *argl));

extern dimdes
 *SC_DECLARE(_SX_make_dims_dimdes, 
             (PDBfile *file, object *argl));


/* SXPDBA.C declarations */

extern void
 SC_DECLARE(SX_install_pdb_attr_funcs, (byte));


/* SXPDBC.C declarations */

extern void
 SC_DECLARE(_SX_copy_tree,
         (PDBfile *file, char *vrin, char *vrout,
          long nitems, char *type));


/* SXPDBD.C declarations */

extern object
 *SC_DECLARE(SX_diff_var, (object *argl)),
 *SC_DECLARE(SX_display_diff, (object *arg));

extern int
 SC_DECLARE(_SX_type_equal,
         (PDBfile *file_a, PDBfile *file_b, char *typea, char *typeb));


/* SXPDBF.C declarations */

extern object
 *SC_DECLARE(SX_find_types, (object *arg));


/* SXPDBL.C declarations */

extern object
 *SC_DECLARE(_SX_make_list_syment,
          (PDBfile *file, byte *vr, long nitems, char *type));


/* SXPDBR.C declarations */

extern void
 SC_DECLARE(_SX_rd_tree_list,
         (object *obj, PDBfile *file, char *vr,
          long nitems, char *type, dimdes *dims));

extern object
 *SC_DECLARE(SX_read_numeric_data, (object *argl));


/* SXPGS.C declarations */

extern object
 *SC_DECLARE(SX_mk_graph, (PG_graph *g)),
 *SC_DECLARE(SX_mk_image, (PG_image *im)),
 *SC_DECLARE(SX_mk_graphics_device, (PG_device *dev)),
 *SC_DECLARE(SX_mk_dev_attributes, 
             (PG_dev_attributes *da));

extern void
 SC_DECLARE(SX_install_pgs_funcs, (byte)),
 SC_DECLARE(SX_expose_event_handler, 
            (PG_device *dev, PG_event *ev)),
 SC_DECLARE(SX_update_event_handler, 
            (PG_device *dev, PG_event *ev)),
 SC_DECLARE(SX_motion_event_handler, 
            (PG_device *dev, PG_event *ev)),
 SC_DECLARE(SX_default_event_handler, 
            (PG_device *dev, PG_event *ev));

extern int
 SC_DECLARE(_SX_next_color, (PG_device *dev));


/* SXPML.C declarations */

extern void
 SC_DECLARE(SX_install_pml_funcs, (byte));

extern object
 *SC_DECLARE(SX_numeric_arrayp, (object *obj)),
 *SC_DECLARE(SX_mappingp, (object *obj)),
 *SC_DECLARE(SX_setp, (object *obj)),
 *SC_DECLARE(SX_list_array, (object *argl)),
 *SC_DECLARE(SX_array_list, (object *argl)),
 *SC_DECLARE(SX_num_arr_len, (object *obj)),
 *SC_DECLARE(SX_num_arr_extr, (object *obj)),
 *SC_DECLARE(SX_make_pml_set, (object *argl)),
 *SC_DECLARE(SX_set_map_type, (object *argl)),
 *SC_DECLARE(SX_pdbdata_mapping, (object *argl)),
 *SC_DECLARE(SX_mapping_pdbdata, (object *argl)),
 *SC_DECLARE(SX_mk_set, (PM_set *set)),
 *SC_DECLARE(SX_mk_mapping, (PM_mapping *f)),
 *SC_DECLARE(SX_mk_C_array, (C_array *arr));


/* SXMM.C declarations */

extern object
 *SC_DECLARE(SX_mk_gfile, (g_file *po)),
 *SC_DECLARE(_SX_mk_gpdbdata,
          (char *name, byte *data, syment *ep, PDBfile *file)),
 *SC_DECLARE(_SX_mk_gsyment, (syment *ep)),
 *SC_DECLARE(_SX_mk_gdefstr, (defstr *dp));

extern g_file
 *SC_DECLARE(_SX_mk_file,
          (char *name, char *type, char *ext_type, byte *file)),
 *SC_DECLARE(_SX_mk_open_file,
          (PFPByte fun, char *name, char *type, char *ext_type,
           char *mode, PFInt type_hook));

extern g_pdbdata
 *SC_DECLARE(_SX_mk_pdbdata,
          (char *name, byte *data, syment *ep, PDBfile *file));

extern void
 SC_DECLARE(_SX_rel_open_file, (PFInt fun, g_file *po));


/* SXHOOK.C declarations */

extern memdes
 *SC_DECLARE(_SX_hash_hook, 
             (PDBfile *file, char *vr, defstr *dp));

extern int
 SC_DECLARE(SX_fprintf, (FILE *fp, char *fmt, ...));

extern void
 SC_DECLARE(_SX_ins_mem,
         (defstr *dp, char *member, int imem, PDBfile *File)),
 SC_DECLARE(_SX_init_hash_objects, (PDBfile *file));


/* SXIO.C declarations */

extern object
SC_DECLARE(*SS_print,(object *argl));


/* SXGC.C declarations */

extern void
 SC_DECLARE(_SX_gc_data, 
            (PDBfile *file, byte *vr, long nitems, char *type)),
 SC_DECLARE(_SX_gc_indirection,
         (PDBfile *file, char **vr, long nitems, char *type)),
 SC_DECLARE(_SX_gc_leaf, 
            (PDBfile *file, char *vr, long nitems, char *type));

#ifdef __cplusplus
}
#endif

#endif

