/*
 * SXHAND.C - handlers for SX
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MH_U_S - SX Math Handler for Unary Scalar operators
 *            - first cut will be to apply operator to scalar elements
 *            - of the range set of the given list of mappings
 *            - or elements of set
 *            - or elements of C_array
 */

object *_SX_mh_u_s(f, argl)
   PFPObject f;
   object *argl;
   {object *ret, *first, *obj;
    int ie, id, ne, nde;
    char dtype[MAXLINE], *type, *s;
    REAL **elem, *pd, *d;
    PFDouble fn;
    PM_set *set;

    ret   = SS_null;
    first = SS_car(argl);
    if (_SS_numberp(first))
       return(SS_unary_flt(f, argl));

    fn = (PFDouble) f;
    SS_Assign(ret, argl);

    while (SS_consp(argl))
       {obj  = SS_car(argl);
	argl = SS_cdr(argl);
	if (SX_NUMERIC_ARRAYP(obj))
	   {pd = (REAL *) NUMERIC_ARRAY_DATA(obj);
	    ne = NUMERIC_ARRAY_LENGTH(obj);
	    for (ie = 0; ie < ne; ie++, pd++)
	        *pd = (*fn)(*pd);

	    continue;}

	else if (SX_GRAPHP(obj))
	   set = SS_GET(PG_graph, obj)->f->range;
	else if (SX_MAPPINGP(obj))
	   set = SS_GET(PM_mapping, obj)->range;
	else if (SX_SETP(obj))
	   set = SS_GET(PM_set, obj);
	else
	   SS_error("BAD TYPE OBJECT - _SX_MH_U_S", obj);

        type = set->element_type;
	strcpy(dtype, type);
	SC_strtok(dtype, " *", s);

        ne   = set->n_elements;
        nde  = set->dimension_elem;
        elem = (REAL **) set->elements;
        d    = FMAKE_N(REAL, ne, "_SX_MH_U_S:d");
        for (id = 0; id < nde; id++)
            {pd = elem[id];

	     PM_array_real(type, elem[id], ne, d);

             for (ie = 0, pd = d; ie < ne; ie++, pd++)
                 *pd = (*fn)(*pd);

	     CONVERT(dtype, elem+id, SC_REAL_S, d, ne, FALSE);};

	SFREE(d);
        PM_find_extrema(set);};

    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MH_U_S_NM - SX Math Handler for Unary Scalar operators
 *               - first cut will be to apply operator to scalar elements
 *               - of the range set of the given list of mappings
 *               - these operators return new mappings (hence _NM)
 */

object *_SX_mh_u_s_nm(oper, argl)
   PFPObject oper;
   object *argl;
   {int iret;
    object *mo, *ret, *first;
    PFPPM_mapping fn;
    PM_mapping *f, *h;

    first = SS_car(argl);
    if (_SS_numberp(first))
       return(SS_unary_flt(oper, argl));

    fn  = (PFPPM_mapping) oper;
    ret = SS_null;

    while (SS_consp(argl))
       {SX_GET_MAPPING_FROM_LIST(h, argl);

        f     = (*fn)(h);
        iret  = PM_set_opers(f->domain);
        iret &= PM_set_opers(f->range);
        if (iret == FALSE)
           SS_error("NO FIELD FOR TYPE - _SX_MH_US_NM", SS_null);

        mo = SX_mk_mapping(f);
        SS_Assign(ret, SS_mk_cons(mo, ret));};

    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_M11_X - math handler applies the given unary function to the x values
 *           - specific to mappings with 1d ranges and domains
 *           - this was UL_uopxc in ULTRA II
 */

object *_SX_m11_x(oper, argl)
   PFPObject oper;
   object *argl;
   {int i, n;
    REAL *xp;
    object *obj, *ret;
    PM_set *set;
    PM_mapping *f;

    ret = SS_null;
    while (SS_consp(argl))
       {obj = SS_car(argl);
        SX_GET_MAPPING_FROM_LIST(f, argl);
        if (f != NULL)
           {set = f->domain;
            xp = *(REAL **) set->elements;
            n  = set->n_elements;
            for (i = 0; i < n; xp++, i++)
                *xp = (REAL) (*(PFDouble) oper)(*xp);

/* for later
            UL_dataset[j].modified = TRUE;
 */

            SS_Assign(ret, SS_mk_cons(obj, ret));
            PM_find_extrema(set);};};
         
    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_M11_B_MRS - performs binary operations on range values of mappings
 *               - using a single scalar
 */

object *_SX_m11_b_mrs(oper, argl)
   PFPObject oper;
   object *argl;
   {object *obj, *tok, *ret;
    PM_set *set;
    PM_mapping *f;
    int i, n;
    REAL *yp;
    REAL a;
        
    SX_last_arg(tok, argl);

    a = HUGE;
    SS_args(tok,
	    SC_REAL_I, &a,
	    0);
    if (a == HUGE)
       SS_error("BAD NUMBER - SX_M11_B_MRS ", tok);

    ret = SS_null;
    while (SS_consp(argl))
       {obj = SS_car(argl);
        SX_GET_MAPPING_FROM_LIST(f, argl);
        if (f != NULL)
           {set = f->range;
            yp = *(REAL **) set->elements;
            n  = set->n_elements;
            for (i = 0; i < n; yp++, i++)
                *yp = (REAL) (*(PFDouble) oper)(*yp, a);

/* for later
            UL_dataset[j].modified = TRUE;
 */

            SS_Assign(ret, SS_mk_cons(obj, ret));
            PM_find_extrema(set);};};
         
    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_M11_B_MDS - performs binary operations on domains values of mappings
 *               - using a single scalar
 */

object *_SX_m11_b_mds(oper, argl)
   PFPObject oper;
   object *argl;
   {object *obj, *tok, *ret;
    PM_set *set;
    PM_mapping *f;
    int i, n;
    REAL *xp;
    REAL a;
        
    SX_last_arg(tok, argl);

    a = HUGE;
    SS_args(tok,
	    SC_REAL_I, &a,
	    0);
    if (a == HUGE)
       SS_error("BAD NUMBER - SX_M11_B_MDS ", tok);

    ret = SS_null;
    while (SS_consp(argl))
       {obj = SS_car(argl);
        SX_GET_MAPPING_FROM_LIST(f, argl);
        if (f != NULL)
           {set = f->domain;
            xp = *(REAL **) set->elements;
            n  = set->n_elements;
            for (i = 0; i < n; xp++, i++)
                *xp = (REAL) (*(PFDouble) oper)(*xp, a);

/* for later
            UL_dataset[j].modified = TRUE;
 */

            SS_Assign(ret, SS_mk_cons(obj, ret));
            PM_find_extrema(set);};};
         
    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MH_U_M - handler for unary operation acting on a set of mappings */

object *_SX_mh_u_m(oper, argl)
   PFPObject oper;
   object *argl;
   {object *ret;
    PM_mapping *f;

    ret = SS_null;
    while (SS_consp(argl))
       {SX_GET_MAPPING_FROM_LIST(f, argl);
        if (f != NULL)
            {SS_Assign(ret, SS_mk_cons((*oper)(f), ret));};};
         
    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MH_U_O - handler for unary operation acting on a set of objects */

object *_SX_mh_u_o(oper, argl)
   PFPObject oper;
   object *argl;
   {object *ret, *val;

    ret = SS_null;
    for (; !SS_nullobjp(argl); argl = SS_cdr(argl))
        {val = (*oper)(SS_car(argl));
         SS_Assign(ret, SS_mk_cons(val, ret));};
         
    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MH_U_V - unary operation on mappings using first arg which
 *            - may be a list of values to mapping
 */

object *_SX_mh_u_v(oper, argl)
   PFPObject oper;
   object *argl;
   {object *lst, *s, *ret;

    lst  = SS_car(argl);
    argl = SS_cdr(argl);
    ret  = SS_null;
    for ( ; SS_consp(argl); argl = SS_cdr(argl))
        {s = SS_car(argl);
         if (SX_MAPPINGP(s))
            {SS_Assign(ret,
		       SS_mk_cons((*oper)(s, lst), ret));};};

    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_AH_M - unary operation applied to each mapping using the
 *          - last argument as a parameter
 */

object *_SX_ah_m(oper, argl)
   PFPObject oper;
   object *argl;
   {object *s, *ret, *tok;

    SX_last_arg(tok, argl);
    if (!_SS_numberp(tok))
       SS_error("BAD LAST ARGUMENT - _SX_AH_M", tok);

    ret = SS_null;
    for ( ; SS_consp(argl); argl = SS_cdr(argl))
        {s = SS_car(argl);
         if (SX_MAPPINGP(s))
            SS_Assign(ret, SS_mk_cons((*oper)(s, tok), ret));};

    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_MF_INSTALL - install SX math functions in the SX function table
 *               - a separate function table is necessary to tell SCHEME
 *               - which version of "sin" to use, for example
 */

void SX_mf_install()
   {

    SS_install("hyper-plane",
               "Generate a hyper-plane sum(i=0,n; ci*xi)\nFORM hyper-plane c0 (c1 x1min x1max np1) ...)",
               SS_nargs,
	       (PFPObject) SX_plane, SS_PR_PROC);

/* Functions under the _SX_MH_U_S handler */

    SS_install("log10",
               "Math base 10 log of range values\nFORM log10 <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_log, SS_PR_PROC);
    SS_install("exp",
               "Math exponential of range values y=e^y\nFORM exp <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) exp, SS_PR_PROC);
    SS_install("random",
               "Generates random range values between -1 and 1 for the curve\nFORM random <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_random, SS_PR_PROC);
    SS_install("cos",
               "Math cosine of y \nFORM cos <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) cos, SS_PR_PROC);
    SS_install("acos",
               "Math ArcCos of y\nFORM acos <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) acos, SS_PR_PROC);
    SS_install("cosh",
               "Math hyperbolic cosine of y\nFORM cosh <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) cosh, SS_PR_PROC);
    SS_install("sin",
               "Math sine of y\nFORM sin <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) sin, SS_PR_PROC);
    SS_install("asin",
               "Math ArcSin of y\nFORM asin <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) asin, SS_PR_PROC);
    SS_install("sinh",
               "Math hyperbolic sine of y\nFORM sinh <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) sinh, SS_PR_PROC);
    SS_install("tan",
               "Math tangent of range values\nFORM tan <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) tan, SS_PR_PROC);
    SS_install("atan",
               "Math ArcTan of range values\nFORM atan <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) atan, SS_PR_PROC);
    SS_install("tanh",
               "Math hyperbolic tangent on range values\nFORM tanh <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) tanh, SS_PR_PROC);
    SS_install("j0",
               "Math zero-th order Bessel function of the first kind on range values\nFORM j0 <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_j0, SS_PR_PROC);
    SS_install("j1",
               "Math first order Bessel function of the first kind on range values\nFORM j1 <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_j1, SS_PR_PROC);
    SS_install("y0",
               "Math zero-th order Bessel function of the second kind on range values\nFORM y0 <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_y0, SS_PR_PROC);
    SS_install("y1",
               "Math first order Bessel function of the second kind on range values\nFORM y1 <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_y1, SS_PR_PROC);
    SS_install("jn",
               "Math nth order Bessel function of the first kind on range values\nFORM jn <graph-list> <n>",
               _SX_mh_u_s,
	       (PFPObject) PM_jn, SS_PR_PROC);
    SS_install("yn",
               "Math nth order Bessel function of the second kind on range values\nFORM yn <graph-list> <n>",
               _SX_mh_u_s,
	       (PFPObject) PM_yn, SS_PR_PROC);
    SS_install("tchn",
               "Math nth order Tchebyshev function on range values\nFORM tchn <graph-list> <n>",
               _SX_mh_u_s,
	       (PFPObject) PM_tchn, SS_PR_PROC);
    SS_install("sqr",
               "Math square of range values\nFORM sqr <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_sqr, SS_PR_PROC);
    SS_install("ln",
               "Math natural log of range values\nFORM ln <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_ln, SS_PR_PROC);
    SS_install("sqrt",
               "Math square root of range values\nFORM sqrt <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_sqrt, SS_PR_PROC);
    SS_install("recip",
               "Math reciprocal of y\nFORM recip <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) PM_recip, SS_PR_PROC);

    SS_install("abs",
               "Math absolute value of range values\nFORM abs <graph-list>",
               _SX_mh_u_s,
	       (PFPObject) ABS, SS_PR_PROC);

/* Functions under the _SX_MH_U_S_NM handler */
    SS_install("integrate",
               "Integrate mappings\nFORM integrate <graph-list>",
               _SX_mh_u_s_nm,
	       (PFPObject) SX_integrate_mapping, SS_PR_PROC);
    SS_install("norm",
               "Euclidean norm of range elements\nFORM norm <graph-list>",
               _SX_mh_u_s_nm,
	       (PFPObject) SX_norm_mapping, SS_PR_PROC);

/* Functions under the _SX_MH_B_S handler */

    SS_install("+",
               "Math sum of mappings\nFORM + <graph-list>",
               _SX_mh_b_s,
	       (PFPObject) PM_fplus, SS_PR_PROC);
    SS_install("-",
               "Math difference of mappings a-b\nFORM - <a> <b>",
               _SX_mh_b_s,
	       (PFPObject) PM_fminus, SS_PR_PROC);
    SS_install("*",
               "Math product of mappings\nFORM * <graph-list>",
               _SX_mh_b_s,
	       (PFPObject) PM_ftimes, SS_PR_PROC);
    SS_install("/",
               "Math divides one curve by another a/b\nFORM / <a> <b>",
               _SX_mh_b_s,
	       (PFPObject) PM_fdivide, SS_PR_PROC);
    SS_install("hypot",
               "Math calculates sqrt(a^2+b^2)\nFORM hypot <a> <b>",
               _SX_mh_b_s,
	       (PFPObject) HYPOT, SS_PR_PROC);

/* Functions under the _SX_M11_X handler */

    SS_install("lnx",
               "Math natural log of domain values\nFORM lnx <graph-list>",
               _SX_m11_x,
	       (PFPObject) PM_ln, SS_PR_PROC);
    SS_install("log10x",
               "Math base 10 log of domain values\nFORM log10x <graph-list>",
               _SX_m11_x,
	       (PFPObject) PM_log, SS_PR_PROC);
    SS_install("expx",
               "Math exponential of domain values x=e^x\nFORM expx <graph-list>",
               _SX_m11_x,
	       (PFPObject) exp, SS_PR_PROC);
    SS_install("sqrtx",
               "Math square root of domain values\nFORM sqrtx <graph-list>",
               _SX_m11_x,
	       (PFPObject) PM_sqrt, SS_PR_PROC);
    SS_install("sqrx",
               "Math square of domain values\nFORM sqrx <graph-list>",
               _SX_m11_x,
	       (PFPObject) PM_sqr, SS_PR_PROC);
    SS_install("absx",
               "Math absolute value of x\nFORM absx <graph-list>",
               _SX_m11_x,
	       (PFPObject) ABS, SS_PR_PROC);
    SS_install("recipx",
               "Math reciprocal of x\nFORM recipx <graph-list>",
               _SX_m11_x,
	       (PFPObject) PM_recip, SS_PR_PROC);
    SS_install("cosx",
               "Math cosine of x\nFORM cosx <graph-list>",
               _SX_m11_x,
	       (PFPObject) cos, SS_PR_PROC);
    SS_install("acosx",
               "Math ArcCos of x\nFORM acosx <graph-list>",
               _SX_m11_x,
	       (PFPObject) acos, SS_PR_PROC);
    SS_install("coshx",
               "Math hyperbolic cosine of x\nFORM coshx <graph-list>",
               _SX_m11_x,
	       (PFPObject) cosh, SS_PR_PROC);
    SS_install("sinx",
               "Math sine of x\nFORM sinx <graph-list>",
               _SX_m11_x,
	       (PFPObject) sin, SS_PR_PROC);
    SS_install("asinx",
               "Math ArcSin of x\nFORM asinx <graph-list>",
               _SX_m11_x,
	       (PFPObject) asin, SS_PR_PROC);
    SS_install("sinhx",
               "Math hyperbolic sine of x\nFORM sinhx <graph-list>",
               _SX_m11_x,
	       (PFPObject) sinh, SS_PR_PROC);
    SS_install("tanx",
               "Math tangent of domain values\nFORM tanx <graph-list>",
               _SX_m11_x,
	       (PFPObject) tan, SS_PR_PROC);
    SS_install("atanx",
               "Math ArcTan of domain values\nFORM atanx <graph-list>",
               _SX_m11_x,
	       (PFPObject) atan, SS_PR_PROC);
    SS_install("tanhx",
               "Math hyperbolic tangent on domain values\nFORM tanhx <graph-list>",
               _SX_m11_x,
	       (PFPObject) tanh, SS_PR_PROC);
    SS_install("j0x",
               "Math zero-th order Bessel function of the first kind on domain values\nFORM j0x <graph-list>",
               _SX_m11_x,
	       (PFPObject) PM_j0, SS_PR_PROC);
    SS_install("j1x",
               "Math first order Bessel function of the first kind on domain values\nFORM j1x <graph-list>",
               _SX_m11_x,
	       (PFPObject) PM_j1, SS_PR_PROC);
    SS_install("jnx",
               "Math nth order Bessel function of the first kind on domain values\nFORM jnx <graph-list> <n>",
               _SX_m11_b_mds,
	       (PFPObject) PM_jn, SS_PR_PROC);
    SS_install("ynx",
               "Math nth order Bessel function of the second kind on domain values\nFORM yn <graph-list> <n>",
               _SX_m11_b_mds,
	       (PFPObject) PM_yn, SS_PR_PROC);
    SS_install("y0x",
               "Math zero-th order Bessel function of the second kind on domain values\nFORM y0x <graph-list>",
               _SX_m11_x,
	       (PFPObject) PM_y0, SS_PR_PROC);
    SS_install("y1x",
               "Math first order Bessel function of the second kind on domain values\nFORM y1x <graph-list>",
               _SX_m11_x,
	       (PFPObject) PM_y1, SS_PR_PROC);


/* _SX_M11_B_MDS and _SX_M11_B_MRS functions */

    SS_install("powrx",
               "Math raise domain values to a power x=x^a\nFORM powrx <graph-list> <a>",
               _SX_m11_b_mds,
	       (PFPObject) POW, SS_PR_PROC);
    SS_install("powx",
               "Math raise domain values to a power x=x^a\nFORM powx <graph-list> <a>",
               _SX_m11_b_mds,
	       (PFPObject) POW, SS_PR_PROC);
    SS_install("powax",
                "Math raise a to the power of the x value\nx=a^x\nFORM powax <graph-list> <a>",
               _SX_m11_b_mds,
	       (PFPObject) PM_pow, SS_PR_PROC);
    SS_install("powr",
               "Math raise range values to a power y=y^a\nFORM powr <graph-list> <a>",
               _SX_m11_b_mrs,
	       (PFPObject) POW, SS_PR_PROC);
    SS_install("pow",
               "Math raise range values to a power y=y^a\nFORM pow <graph-list> <a>",
               _SX_m11_b_mrs,
	       (PFPObject) POW, SS_PR_PROC);
    SS_install("powa",
               "Math raise a to the power of the y value\ny=a^y\nFORM powa <graph-list> <a>",
               _SX_m11_b_mrs,
	       (PFPObject) PM_pow, SS_PR_PROC);
    SS_install("jn",
               "Math nth order Bessel function of the first kind on range values\nFORM jn <graph-list> <n>",
               _SX_m11_b_mrs,
	       (PFPObject) PM_jn, SS_PR_PROC);
    SS_install("yn",
               "Math nth order Bessel function of the second kind on range values\nFORM yn <graph-list> <n>",
               _SX_m11_b_mrs,
	       (PFPObject) PM_yn, SS_PR_PROC);
    SS_install("dx",
               "Shift domain values of curve by a constant\nFORM dx <graph-list> <value>",
               _SX_m11_b_mds,
	       (PFPObject) PM_fplus, SS_PR_PROC);
    SS_install("dy",
               "Shift range values of curve by a constant\nFORM dy <graph-list> <value>",
               _SX_m11_b_mrs,
	       (PFPObject) PM_fplus, SS_PR_PROC);
    SS_install("mx",
               "Scale domain values of curve by a constant\nFORM mx <graph-list> <value>",
               _SX_m11_b_mds,
	       (PFPObject) PM_ftimes, SS_PR_PROC);
    SS_install("my",
               "Scale range values of curve by a constant\nFORM my <graph-list> <value>",
               _SX_m11_b_mrs,
	       (PFPObject) PM_ftimes, SS_PR_PROC);
    SS_install("divx",
               "Divide domain values by a constant\nFORM divx <graph-list> <value>",
               _SX_m11_b_mds,
	       (PFPObject) PM_fdivide, SS_PR_PROC);
    SS_install("divy",
               "Divide range values by a constant\nFORM divy <graph-list> <value>",
               _SX_m11_b_mrs,
	       (PFPObject) PM_fdivide, SS_PR_PROC);

#if 0

/* _SX_MH_U_M functions */

    SS_install("derivative",
               "Take derivative of curves\nFORM derivative <graph-list>",
               _SX_mh_u_m,
	       (PFPObject) derivative, SS_PR_PROC);
    SS_install("rev",
               "Swaps x and range values for a curve\nYou may want to sort after this\nFORM rev <graph-list>",
               _SX_mh_u_m,
	       (PFPObject) reverse, SS_PR_PROC);
    SS_install("copy",
               "Copies a curve\nFORM copy <graph-list>",
               _SX_mh_u_m,
	       (PFPObject) copy_curve, SS_PR_PROC);
    SS_install("sort",
               "Sorts a curve into ascending order based on domain values\nFORM sort <graph-list>",
               _SX_mh_u_m,
	       (PFPObject) sort, SS_PR_PROC);
    SS_install("hide",
               "Hide the list of curves from view\nFORM hide <graph-list>",
               _SX_mh_u_m,
	       (PFPObject) hide, SS_PR_PROC);
    SS_install("unhide",
               "Reverses the action of hide.  Reveals curves that were hidden\nFORM unhide <graph-list>",
               _SX_mh_u_m,
	       (PFPObject) unhide, SS_PR_PROC);

/* _SX_MH_U_O functions */

    SS_install("select",
               "Select curve(s) from the menu\nFORM select <list-of-menu-numbers>",
               _SX_mh_u_o,
	       (PFPObject) SX_select, SS_PR_PROC);
    SS_install("del",
               "Deletes curve from list\nFORM del <graph-list>",
               _SX_mh_u_o,
	       (PFPObject) SX_delete, SS_PR_PROC);


/* _SX_AH_M functions */
    SS_install("color",
               "Sets the color of a curve\nFORM color <curve-id> <color-number>",
               _SX_ah_m,
	       (PFPObject) ccolor, SS_PR_PROC);
    SS_install("lnwidth",
               "Sets the line width of a curve\nFORM lnwidth <curve-id> <width-number>",
               _SX_ah_m,
	       (PFPObject) clnwidth, SS_PR_PROC);
    SS_install("lnstyle",
               "Set line style\n 1-solid\n2-dashed\n3-dotted\nFORM lnstyle <curve-id> <style-number>",
               _SX_ah_m,
	       (PFPObject) clnstyle, SS_PR_PROC);
    SS_install("marker",
               "Set the marker of a curve\n 1-plus\n 2-star\n 3-triangle\nFORM marker <curve-id> <marker-number>",
               _SX_ah_m,
	       (PFPObject) cmarker, SS_PR_PROC);
    SS_install("smo",
               "Smooths curve using n point integral to average\nFORM smo <graph-list> <n>",
               _SX_ah_m,
	       (PFPObject) smooth, SS_PR_PROC);


/* _SX_MH_U_V functions */
    SS_install("xmm",
               "Excerpts a part of a curve\nFORM xmm <graph-list> <low-lim> <<high-lim>",
               _SX_mh_u_v,
	       (PFPObject) xmm, SS_PR_PROC);


/* -------------- ULTRA II  templates --------------- */


/* BCXL functions */

    SS_install("compose",
               "Functional composition f(g(x))\nFORM compose <f> <g>",
               bcxl,
	       (PFPObject) compose, SS_PR_PROC);

#endif

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

