/*
 * SXMAIN.C - the main routine for SX
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

#ifdef HAVE_JPEGLIB
#include "gsrast.h"
#endif

#ifdef MAC
#include "trconfig.h"
#else
#include "spokes/trconfig.h"
#endif

#define SCODE "SX 3.0"
#define PCODE "PDBView 2.0"

#define NDISPLAY 26

extern void
 SC_DECLARE(_SX_end_prog, (void *d, PG_event *ev));

jmp_buf
 SX_jump_buffer;

HASHTAB
 *SX_data_tab = NULL;

int
 SX_data_index[NDISPLAY],
 SX_default_npts,
 *SX_number;

REAL
 SX_gxmin,
 SX_gxmax,
 SX_gymin,
 SX_gymax,
 SX_view_x,
 SX_view_y,
 SX_view_width,
 SX_view_height,
 SX_view_aspect;

C_procedure
 *Mapping_Proc;

object
 *SX_curfile,
#if 0
 *SX_iofopts,
 *SX_ioflist,
#endif
 *proc[NDISPLAY],
 *curobj[NDISPLAY],
 *varbl[NDISPLAY];

PG_device
 *SX_CGM_device,
 *SX_graphics_device,
 *SX_PS_device;

char
 *SX_ascii_output_format,
 *SX_display_name,
 *SX_display_type,
 *SX_display_title,
 *SX_OBJECT_S,
 SX_data_directory[MAXLINE] = "";

static char
 _SX_bf[MAXLINE];

void
 SC_DECLARE(SX_plot, (byte)),
 SC_DECLARE(SX_end, (int val));

static char
 *SC_DECLARE(_SX_reproc_in, (char *line));

static void
 SC_DECLARE(SX_init_env, (byte)),
 SC_DECLARE(SX_init_view, (byte)),
 SC_DECLARE(SX_set_graphics_state, (PG_device *d)),
 SC_DECLARE(SX_init_mappings, (byte)),
 SC_DECLARE(_SX_parse, (object *strm)),
 SC_DECLARE(_SX_expand_prefix, (char *s)),
 SC_DECLARE(_SX_read, (object *strm));

static int
 SC_DECLARE(SX_rd_scm, (char *name)),
 SC_DECLARE(_SX_rd_scm, (byte)),
 SC_DECLARE(_SX_print, (byte));

static object
 *SC_DECLARE(SX_mode_text, (byte)),
 *SC_DECLARE(SX_mode_graphics, (byte)),
 *SC_DECLARE(SX_thru, (object *argl)),
 *SC_DECLARE(SX_mapping_ref, (object *argl)),
 *SC_DECLARE(_SX_mapping_ref, 
             (char *fname, char *dtype, int indx));

extern object
 *SC_DECLARE(_SX_get_ref_map, 
             (g_file *po, int indx, char *dtype));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAIN - start up a fun filled session of SX right here */

int main(argc, argv)
   int argc;
   char **argv;
   {int i, n, commnd_flag, tflag, pvflag, load_rc;
    int load_init, n_files, ret;
    char commnd[MAXLINE], *s, t[MAXLINE];
    SIGNED char order[MAXLINE];
    double evalt;

    PG_IO_INTERRUPTS(FALSE);

    SC_init("ABORT: Gross Initialization Error", (PFByte) SX_end,
            TRUE, SS_interrupt_handler,
            TRUE, NULL, 0);

    commnd_flag = FALSE;
    pvflag      = FALSE;
    tflag       = FALSE;
    load_init   = TRUE;
    SX_gr_mode  = TRUE;
    load_rc     = TRUE;

/* be able to access remote files */
    PC_io_connect(PC_REMOTE);

/* initialize the file order */
    n_files = 0;

#ifndef MAC

/* connect the I/O functions */
    putln = (PFfprintf) SS_printf;
    getln = io_gets_hook;

#ifndef AIX
    PG_IO_INTERRUPTS(TRUE);
#endif

/* process the command line arguments */
    for (i = 1; i < argc; i++)
        if (argv[i][0] == '-')
	   {switch (argv[i][1])
               {case 'i' :                       /* IO not interrupt driven */
		     PG_IO_INTERRUPTS(FALSE);
                     break;
                case 'l' :                              /* load Scheme file */
                     order[n_files++] = ++i;
                     break;
                case 'n' :                          /* don't load init file */
                     load_init = FALSE;
                     break;
                case 'p' :                       /* do everything (PDBView) */
#ifdef AIX
                     PG_IO_INTERRUPTS(TRUE);
#endif
                     pvflag = TRUE;
                     break;
                case 'q' :                    /* quite mode suppress version and */
                                              /* cannot connect to display       */
                     SX_qflag = TRUE;
                     break;
                case 'r' :                    /* don't load .pdbviewrc file */
                     load_rc   = FALSE;
                     break;
                case 's' :                                       /* SX mode */
                     SX_gr_mode = FALSE;
		     PG_IO_INTERRUPTS(FALSE);
                     break;
                case 't' :                                /* time the loads */
                     tflag = TRUE;
                     break;
                default :
                     printf("ERROR: Bad flag %s\n", argv[i]);
                     break;};}

        else if ((pvflag) && (argv[i][0] != '(') && !commnd_flag)
           order[n_files++] = -i;

        else
           {commnd_flag = TRUE;
            strcpy(commnd, " ");
            for ( ; i < argc; i++)
                {strcat(commnd, argv[i]);
                 strcat(commnd, " ");};};

#else

/* assume we always want PDBVIEW mode on the Mac */
    pvflag = TRUE;

#endif

/* initialize SX */

/* the following variables must be initialized before DEF_SX */
    SX_console_type     = SC_strsavef("MONOCHROME",
                          "char*:SXMAIN:console_type");
    SX_console_x        = 0.0;
    SX_console_y        = 0.0;
    SX_console_width    = 1.0;
    SX_console_height   = 1.0;
    SX_background_color_white = TRUE;

    if (pvflag)
       {DEF_SX(PCODE, VERSION);
        SX_init_view();
        SX_install_global_vars();
        SX_init_mappings();
        SX_init_env();

#ifndef MAC
        if (SX_gr_mode && !SX_qflag)
	   SS_banner(SS_mk_string(PCODE));
#endif

/* load the SCHEME level PDBView functionality */
	if (load_init)
           {if (_SC_query_file("pdbview.scm", "r", "ascii"))
               strcpy(t, "pdbview.scm");
            else
               {s = SC_search_file(SC_path, "pdbview.scm");
                if (s == NULL)
                   {PRINT(stderr, "Can't find pdbview.scm\n");

#ifndef MAC
                    PRINT(stderr, "Check SCHEME environment variable\n\n");
#endif
                    _SX_quit(ABORT);};
                strcpy(t, s);};

            SS_load_scm(t);

/* load the init file */
            if (load_rc == TRUE)
               s = SC_search_file(SC_path, ".pdbviewrc");
            if ((s == NULL) || !_SC_query_file(s, "r", "ascii"))
               {s = SC_search_file(SC_path, "pdbview.rc");
                if (s == NULL)
                   {PRINT(stderr, "Can't find .pdbviewrc or pdbview.rc\n");
#ifndef MAC
                    PRINT(stderr, "Check SCHEME environment variable\n\n");
#endif
                    _SX_quit(ABORT);};

                if (!_SC_query_file(s, "r", "ascii"))
                   {PRINT(stderr, "Can't open .pdbviewrc or pdbview.rc\n");
                    _SX_quit(ABORT);};};

            SS_load_scm(s);};}

    else
         DEF_SX(SCODE, VERSION);

    if (pvflag)
       {if (SX_gr_mode)
	   SX_mode_graphics();
        else
           SX_mode_text();

        PG_expose_device(PG_console_device);};

#ifdef HAVE_JPEGLIB
/* register the JPEG device */
        PG_register_device("JPEG", PG_setup_jpeg_device);
#endif

#ifdef MAC

/* connect the I/O functions */
/*    if (!PG_open_console("PACT SX", SX_console_type,
            SX_background_color_white,
            SX_console_x, SX_console_y,
            SX_console_width, SX_console_height))
       if (SX_gr_mode)
           printf("\nCannot connect to display\n\n");
*/

    if (SX_gr_mode)
        SS_banner(SS_mk_string(PCODE));

/* This is a kludge to make the "Quit" menu option work */
    PG_register_callback("End", _SX_end_prog);

#endif

/* read the optionally specified data/scheme files in order */
    for (i = 0; i < n_files; i++)
        {n = order[i];
	 if (n < 0)
	    SX_rd_scm(argv[-n]);
	 else
            {evalt = SC_cpu_time();
	     SS_load_scm(argv[n]);
	     evalt = SC_cpu_time() - evalt;

	     if (tflag)
                PRINT(STDOUT,
		      "   %s load time: (%10.3e)\n",
		      argv[n], evalt);};};

    SS_nsave    = 0;
    SS_nrestore = 0;
    SS_nsetc    = 0;
    SS_ngoc     = 0;

    SC_mem_stats_set(0L, 0L);

    if (commnd_flag)
       {ret = !SS_run(commnd);
	return(ret);}

    else
       {if (SX_gr_mode && !SX_qflag)
	   SS_banner(SS_mk_string(SCODE));
	SS_repl();};

    return(TRUE);}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_END - gracefully exit from SX */

void SX_end(val)
   int val;
   {/*PRINT(STDOUT, "\n\nExit from SX\n\n");*/

    PC_exit_all();

    if (!SS_nullobjp(SS_histdev))
       SS_trans_off();

    switch (val)
       {case ABORT    : exit(1);
        case ERR_FREE : exit(0);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_RD_SCM - do a SCHEME level rd with error protection */

static int SX_rd_scm(name)
   char *name;
   {strcpy(_SX_bf, name);

    return(SS_err_catch(_SX_rd_scm, NULL));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_RD_SCM - do a SCHEME level open with error protection */

static int _SX_rd_scm()
   {SS_call_scheme("cf",
                   SC_STRING_I, _SX_bf,
                   0);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_INIT_ENV - initialize the SCHEME environment variables for PDBView */

static void SX_init_env()
   {int i;

/* initialize the prefix list */
    for (i = 0; i < NPREFIX; i++)
        SX_prefix_list[i] = 0;

    SX_pui_file  = SC_strsavef("pdbview.pui",
                   "char*:SX_INIT_ENV:fname");

/* initialize the some global objects */

    SX_curfile  = SS_install_cv("current-file", SS_null, SS_OBJECT_I);

    SS_install("thru",
               "Procedure: Return an expanded list of mappings\n     Usage: thru <first-mapping> <last-mapping>",
               SS_nargs,
               SX_thru, SS_PR_PROC);

    SS_install("mapping-ref",
               "Find a mapping object.\nFORM (mapping-ref <file> <type> <index>)",
               SS_nargs,
               SX_mapping_ref, SS_PR_PROC);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_INIT_VIEW - initialize the plot parameters */

static void SX_init_view()
   {int j;

/*    SX_gr_mode           = TRUE; */
    SX_plot_flag         = TRUE;
    _PG_restore_viewport = FALSE;
    SX_default_npts      = 100;

    SX_gxmax            = 1.0;
    SX_gxmin            = 0.0;
    SX_gymax            = 1.0;
    SX_gymin            = 0.0;
    SX_view_x           = 0.18;
    SX_view_y           = 0.2;
    SX_view_width       = 0.75;
    SX_view_height      = 0.75;
    SX_view_aspect      = 1.0;
    SX_window_x         = 0.5;
    SX_window_y         = 0.1;
    SX_window_width     = 0.4;
    SX_window_height    = 0.4;

    SX_ascii_output_format = SC_strsavef("%13.6e",
                             "char*:SX_INIT_VIEW:format");

    SX_display_name  = SC_strsavef("WINDOW",
                       "char*:SX_INIT_VIEW:name");
    SX_display_type  = SC_strsavef("COLOR",
                       "char*:SX_INIT_VIEW:type");
    SX_display_title = SC_strsavef("PDBView",
                       "char*:SX_INIT_VIEW:title");

    SS_interactive = FALSE;
    SS_print_flag  = FALSE;
    SS_stat_flag   = FALSE;

    SX_command_log_name = SC_strsavef("pdbview.log",
                          "char*:SX_INIT_VIEW:log_name");

    for (j = 0; j < NDISPLAY; j++)
        SX_data_index[j] = -1;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_MODE_TEXT - go into text mode and
 *              - return "#t" if text mode was already in effect
 *              - else return "#f"
 */

static object *SX_mode_text()
   {object *ret;

    if (PG_console_device == NULL)
       PG_open_console("PDBView", SX_console_type, SX_background_color_white,
                       SX_console_x, SX_console_y,
                       SX_console_width, SX_console_height);

    if (SX_graphics_device != NULL)
       {PG_clear_window(SX_graphics_device);
        PG_close_device(SX_graphics_device);
        SX_graphics_device = NULL;

/* give default values to the lisp package interface variables */
        SS_post_read_hook  = NULL;
        SS_post_eval_hook  = NULL;
        SS_post_print_hook = NULL;
        SS_pr_ch_in        = SX_get_ch;
        SS_pr_ch_un        = SS_unget_ch;
        SS_pr_ch_out       = SS_put_ch;
        SS_post_read_hook  = (PFVoid) _SX_read;
        SS_post_eval_hook  = (PFVoid) _SX_parse;
        SS_post_print_hook = (PFInt) _SX_print;

#ifdef MAC
        putln = (PFfprintf) SX_fprintf;
        getln = (PFfgets) PG_wind_fgets;
#else
        putln = (PFfprintf) SS_printf;
        getln = io_gets_hook;
#endif

        SX_gr_mode   = FALSE;
        SX_plot_flag = FALSE;

        ret = SS_t;}
    else
        ret = SS_f;

    strcpy(SS_prompt, "SX-> ");

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_MODE_GRAPHICS - go into graphics mode
 *                  - return "#t" if graphics mode was already in effect
 *                  - else return "#f"
 */

static object *SX_mode_graphics()
   {object *ret;

    if (PG_console_device == NULL)
       {if (!PG_open_console("PDBView", SX_console_type,
                             SX_background_color_white,
                             SX_console_x, SX_console_y,
                             SX_console_width, SX_console_height))
           {if (!SX_qflag)
               PRINT(STDOUT, "\nCannot connect to display\n");};}

    if (SX_graphics_device == NULL)
       {strcpy(SS_prompt, "\n-> ");
        strcpy(SS_ans_prompt, "");

        SS_post_read_hook  = (PFVoid) _SX_read;
        SS_post_eval_hook  = (PFVoid) _SX_parse;
        SS_post_print_hook = (PFInt) _SX_print;
        SS_pr_ch_in        = (PFInt) SX_get_ch;
        putln              = (PFfprintf) SX_fprintf;
	if (PG_console_device == NULL)
	   getln = io_gets_hook;
	else
	   getln = (PFfgets) PG_wind_fgets;

        SX_gr_mode         = TRUE;
        SX_graphics_device = PG_make_device(SX_display_name, SX_display_type,
                                            SX_display_title);

/* map the PDBView graphics state onto the device */
	if (SX_graphics_device != NULL)
	   {SX_set_graphics_state(SX_graphics_device);

	    SX_graphics_device->view_y      = (SX_view_y + SX_label_space)/
	                                      (1.0 + SX_label_space);
	    SX_graphics_device->view_height = SX_view_height/
                                              (1.0 + SX_label_space);

	    PG_make_device_current(SX_graphics_device);
	    PG_set_window(SX_graphics_device, 0.0, 1.0, 0.0, 1.0);
	    PG_release_current_device(SX_graphics_device);

	    PG_set_default_event_handler(SX_graphics_device,
					 SX_default_event_handler);

	    PG_set_motion_event_handler(SX_graphics_device,
					SX_motion_event_handler);

	    PG_set_expose_event_handler(SX_graphics_device,
					SX_expose_event_handler);

	    PG_set_update_event_handler(SX_graphics_device,
					SX_update_event_handler);

/* remember the window size and position in pixels */
	    SX_window_height_P = SX_graphics_device->window_height;
	    SX_window_width_P  = SX_graphics_device->window_width;
	    SX_window_x_P      = SX_graphics_device->window_x;
	    SX_window_y_P      = SX_graphics_device->window_y;
	    
	    if (PG_console_device != NULL)
	       PG_expose_device(PG_console_device);};

        ret = SS_t;}
    else
       ret = SS_f;

    PG_make_device_current(PG_console_device);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_SET_GRAPHICS_STATE - map the PDBView graphics state variables onto the
 *                       - given device before initialization or plotting
 */

static void SX_set_graphics_state(d)
   PG_device *d;
   {d->autodomain             = SX_autodomain;
    d->autoplot               = SX_autoplot;
    d->autorange              = SX_autorange;
    d->background_color_white = SX_background_color_white;

    if (CGM_DEVICE(d) && (SX_cgm_background_color != -1))
       d->background_color_white = SX_cgm_background_color;

    d->border_width           = SX_border_width;
    d->data_id                = SX_data_id;
    d->gprint_flag            = TRUE;
    d->grid                   = SX_grid;

    d->marker_scale           = SX_marker_scale;
    d->marker_orientation     = SX_marker_orientation;

    d->botspace               = SX_botspace;
    d->gxmin                  = SX_gxmin;
    d->gxmax                  = SX_gxmax;
    d->gymin                  = SX_gymin;
    d->gymax                  = SX_gymax;
    d->leftspace              = SX_leftspace;
    d->rightspace             = SX_rightspace;
    d->topspace               = SX_topspace;
    d->view_aspect            = SX_view_aspect;
    d->view_height            = SX_view_height;
    d->view_width             = SX_view_width;
    d->view_x                 = SX_view_x;
    d->view_y                 = SX_view_y;
    d->window_height          = SX_window_height_P;
    d->window_width           = SX_window_width_P;

    PG_set_axis_log_scale(d, SX_x_log_scale, SX_y_log_scale);
    PG_set_font(d, _PG_axis_type_face, SX_plot_type_style, SX_plot_type_size);

    if (!POSTSCRIPT_DEVICE(d))
       {d->window_x = SX_window_x_P;
        d->window_y = SX_window_y_P;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_PLOT - replot the requesite frames */

void SX_plot()
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_PARSE - determine whether or not to reprocess the input for PDBView
 *           - this is the real worker for the SS_post_eval_hook
 */

static void _SX_parse(strm)
   object *strm;
   {SX_parse(SX_plot, _SX_reproc_in, strm);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_REPROC_IN - reprocess the contents of the input buffer
 *               - treat the contents of the buffer as an implicit list
 *               - by effectively wrapping parens about the contents of
 *               - the buffer
 */

static char *_SX_reproc_in(line)
   char *line;
   {static char command[MAXLINE];

    if (!_SX_split_command(command, line))
       return(NULL);

    else
       {if (!_SX_expand_expr(command))
           SS_error("SYNTAX ERROR - _SX_REPROC_IN", SS_null);

        _SX_expand_prefix(command);

        _SX_wrap_paren("(", command, ")");

        if (SX_command_log != NULL)
           PRINT(SX_command_log, "%s\n", command);

        return(command);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_EXPAND_PREFIX - expand prefix expressions in referring to menu items
 *                   - Because of possible user defined synonyms, this must
 *                   - be done for every command, not just select. This step
 *                   - could come later and be applied only to number lists,
 *                   - if range expansion were moved to the handlers.
 *
 * GOTCHA - Data references fail if the file name contains '.' (e.g. file.pdb)
 */

static void _SX_expand_prefix(s)
   char *s;
   {char t[MAXLINE], bf[MAXLINE], token[MAXLINE];
    char *sp, *tp, *fp, *ip, *pt;
    int index, more_tokens;

    strcpy(t, s);
    sp  = s;

    more_tokens = TRUE;
    
    while (more_tokens)
       {token[0] = '\0';
        if (*t == '\"')
           {tp = SC_firsttok(t, "\"");
            token[0] = '\"';
            strcpy(token + 1, tp);
            strcat(token, "\"");}
        else
          if ((tp = SC_firsttok(t, " \t\n\r")) != NULL)
             strcpy(token, tp);
          else
             more_tokens = FALSE;

        if (strlen(token) > 0)
           {if (isalpha(*tp))
               {strcpy(bf, tp);
                fp = SC_strtok(bf, ".()[]", pt);
	        if (*(token + strlen(fp)) == '.')
	           {ip = SC_strtok(NULL, "()[]", pt);
	            if (SC_intstrp(ip, 10))
	               {index = ATOL(ip);
		        sprintf(token, "(data-reference %d %s)%s", index, fp,
		   	        tp + strlen(fp) + 1 + strlen(ip));};};}

           sprintf(sp, "%s ", token);
           sp += strlen(token) + 1;};}
 
    *(sp - 1) = '\0';

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_READ - this is the SS_post_read_hook function for PDBView
 *          - trap implicit requests to print or change file variable
 *          - values and make them explicit
 */

static void _SX_read(strm)
   object *strm;
   {char *s;
    g_file *po;
    PDBfile *file;

    if (SS_bind_env(SS_rdobj, SS_Env))
       return;

    SS_args(SS_rdobj,
            SC_STRING_I, &s,
            0);

    SS_var_value("current-file", G_FILE, &po, TRUE);
    if (po == NULL)
       file = SX_vif;
    else
       file = FILE_FILE(PDBfile, po);

    if (_SX_file_varp(file, s, FALSE))
       {char bf[MAXLINE], *ptr, *t;

        t   = SS_BUFFER(strm);
        ptr = SS_PTR(strm);
        if ((*ptr != '\0') && (*ptr != '\n'))
           sprintf(bf, "change %s", t);
        else
           sprintf(bf, "print %s", t);

        strcpy(t, bf);
        SS_PTR(strm) = t;
        SS_Assign(SS_rdobj, _SS_read(strm));};

    return;}
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_PRINT - the SS_post_print_hook function for PDBView */

static int _SX_print()
   {if (PG_console_device != NULL)
       PG_console_device->gprint_flag = TRUE;

    return(TRUE);}

/*--------------------------------------------------------------------------*/

/*                       MAPPING MANAGEMENT ROUTINES                        */

/*--------------------------------------------------------------------------*/

/* SX_MAPPING_REF - give a SCHEME level reference to a mapping */

static object *SX_mapping_ref(argl)
   object *argl;
   {char *fname, *dtype;
    int indx;

    fname = NULL;
    dtype = NULL;
    indx  = -1;
    SS_args(argl,
            SC_STRING_I, &fname,
            SC_STRING_I, &dtype,
            SC_INTEGER_I, &indx,
            0);

    return(_SX_mapping_ref(fname, dtype, indx));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MAPPING_REF - give a SCHEME level reference to a mapping */

static object *_SX_mapping_ref(fname, dtype, indx)
   char *fname, *dtype;
   int indx;
   {g_file *po;
    object *ret;

    if (strcmp(fname, "#t") == 0)
       {for (po = SX_file_list; po != NULL; po = po->next)
            {_SX_get_menu(po);

             ret = _SX_get_ref_map(po, indx, dtype);
             if (!SS_nullobjp(ret))
                return(ret);}

	if (po == NULL)
	   return(SS_null);}

    else if ((strcmp(fname, "nil") == 0) || (strcmp(fname, "#f") == 0))
       {po = SX_gvif;
        _SX_get_menu(po);

        ret = _SX_get_ref_map(po, indx, dtype);
        if (!SS_nullobjp(ret))
          return(ret);}

    else
       {for (po = SX_file_list; po != NULL; po = po->next)
            {if (strcmp(fname, po->name) == 0)
                break;};

        if (po == NULL)
           return(SS_null);

        _SX_get_menu(po);

        ret = _SX_get_ref_map(po, indx, dtype);
        if (!SS_nullobjp(ret))
           return(ret);};

    return(SS_null);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MK_MAPPING - the C level function that creates a new mapping object */

object *_SX_mk_mapping(f, po)
   PM_mapping *f;
   g_file *po;
   {

/* be sure to make a copy of the data */

    return(SS_null);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_RL_MAPPING - release a mapping object */

object *SX_rl_mapping(s)
   char *s;
   {PM_mapping *f;

/* make the mapping object a simple variable for the benefit of objects
 * still pointing to it
 */
#if 0
    obj = curobj[j];

    SS_VARIABLE_VALUE(obj) = varbl[j];
    SS_VARIABLE_NAME(obj)  = SS_VARIABLE_NAME(varbl[j]);
#endif

    f = (PM_mapping *) SC_def_lookup(s, SX_data_tab);
    PM_rel_mapping(f, TRUE, TRUE);

    SC_hash_rem(s, SX_data_tab);

    return(SS_null);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_INIT_MAPPINGS - initialize the mapping data and references */

static void SX_init_mappings()
   {

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_NEXT_MARK - return the index for the next available mapping list slot */

int SX_next_mark()
   {
#if 0
    for (j = 0; j < NDISPLAY; j++)
        if (SX_data_index[j] == -1)
           return(j);

    SX_plot();
    SS_error("ALL 26 MAPPING ID'S IN USE - SX_NEXT_ID", SS_null);
#endif
    return(-1);}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_NEXT_NUMBER - return the index for the next available mapping
 *                - menu slot
 */

int SX_next_number()
   {

    return(SX_next_number());}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_MK_MAPPING_PROC - return a Scheme procedure object made from the
 *                    - specified mapping
 *                    - also bind the variable whose name is the lower
 *                    - case version of the mapping label (mapping.id) to
 *                    - the new object
 */

object *SX_mk_mapping_proc(i)
   int i;
   {object *obj;

    obj = SS_null;

/*
    s[0] = SX_dataset[i].id;
    s[1] = '\0';
    
    j = _SX_mapping_id(s[0]);

    obj = curobj[j];

    SS_PROCEDURE_DOC(proc[j]) = SX_dataset[i].text;
    SS_VARIABLE_VALUE(obj)    = proc[j];
    SS_VARIABLE_NAME(obj)     = SS_PROCEDURE_NAME(proc[j]);

    SX_dataset[i].obj = (byte *) obj;
*/

    return(obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_SET_ID - change the data-id of the given mapping */

object *SX_set_id(argl)
   object *argl;
   {int iold;

    SX_prep_arg(argl);

    iold = -1;

#if 0
    iold    = -1;
    id = '\0';
    SS_args(argl,
            SC_STRING_I, &iold,
            SC_STRING_I, &id,
            0);

    if (iold < 0)
       SS_error("BAD MAPPING ARGUMENT - SX_SET_ID", argl);

    if ((id == '\0') || (id < 'A') || (id > 'Z'))
       SS_error("BAD ID ARGUMENT - SX_SET_ID", argl);

    if (_SX_mappingp(&id))
       SS_error("SPECIFIED ID ALREADY IN USE - SX_SET_ID", argl);

    jnew = id - 'A';
    jold = SX_dataset[iold].id - 'A';

/*  Sever the connection with the old mapping */
    obj = curobj[jold];
    SS_VARIABLE_VALUE(obj) = varbl[jold];
    SS_VARIABLE_NAME(obj)  = SS_VARIABLE_NAME(varbl[jold]);
    SX_data_index[jold] = -1;

/*  Make the connection with the new mapping */
    SX_dataset[iold].id  = id;
    SX_data_index[jnew] = iold;
#endif

    return(SX_mk_mapping_proc(iold));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_THRU - return an expanded list of mappings */

static object *SX_thru(argl)
   object *argl;
   {object *ret = SS_null;
    g_file *po;

    SX_prep_arg(argl);

    if (_SS_numberp(SS_car(argl)))
       {int first = 0, last = 0, id;
        
        SS_args(argl,
                SC_INTEGER_I, &first,
                SC_INTEGER_I, &last,
                0);

        if (first < 1)
           SS_error("FIRST ARGUMENT NOT A VALID MAPPING NUMBER - SX_THRU",
                    argl);

        if (last < 1)
           SS_error("SECOND ARGUMENT NOT A VALID MAPPING NUMBER - SX_THRU",
                    argl);

/* GOTCHA: in general, when processing something like "f1.1:4",
           f1 will not refer to the current input file */

	SS_args(SS_lk_var_val(SX_curfile, SS_Env),
		G_FILE, &po,
		0);

	_SX_get_menu(po);

        if (first <= last)
           {last = min(last, po->n_menu_items);
            for (id = first; id <= last; id++)
                SS_Assign(ret, SS_mk_cons(SS_mk_integer(id), ret));}
        else
           {first = min(first, po->n_menu_items);
            for (id = first; id >= last; id--)
                SS_Assign(ret, SS_mk_cons(SS_mk_integer(id), ret));};}
#if 0
    else
       {char first = '\0', last = '\0', id;

        SS_args(argl,
                SX_DATA_ID_I, &first,
                SX_DATA_ID_I, &last,
                0);

        if ((first < 'A') || (first > 'Z'))
           SS_error("FIRST ARGUMENT NOT A VALID DATA-ID - SX_THRU",
                    argl);

        if ((last < 'A') || (last > 'Z'))
           SS_error("SECOND ARGUMENT NOT A VALID DATA-ID - SX_THRU",
                    argl);

        if (first <= last)
           {for (id = first; id <= last; id++)
                if (_SX_mappingp(&id))
                   SS_Assign(ret, SS_mk_cons(curobj[id - 'A'], ret));}
        else
           {for (id = first; id >= last; id--)
                if (_SX_mappingp(&id))
                   SS_Assign(ret, SS_mk_cons(curobj[id - 'A'], ret));};};
#endif
    SX_prep_ret(ret);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_COPY_MAPPING - make a copy of the mapping indexed by j
 *                 - and return the objectified mapping label
 */

object *SX_copy_mapping(j)
   int j;
   {int i;

    i = 0;

    return(SX_mk_mapping_proc(i));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_EXTRACT_MAPPING - extract a mapping from the given mapping 
 *                    - from xstart to xstop by xstep
 */

object *SX_extract_mapping(argl)
   object *argl;
   {int i;

    i = 0;

    return(SX_mk_mapping_proc(i));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_XINDEX_MAPPING - make a copy of the mapping indexed by j
 *                   - with x values replaced by the index of the x values
 *                   - and return the objectified mapping SX_label
 */

object *SX_xindex_mapping(j)
   int j;
   {int i;

    i = 0;

    return(SX_mk_mapping_proc(i));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MAPPING_ID - given the mapping character return
 *                - the mapping name identifier
 */

char *_SX_mapping_id(c)
   int c;
   {
#if 0
    if (islower(c))
       return(min(toupper(c)-'A', NDISPLAY));

    return(c - 'A');
#endif

    return(NULL);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_MAPPING_ID - given the mapping object return the
 *               - mapping name identifier
 */

char *SX_mapping_id(c)
   object *c;
   {
#if 0
    return(_SX_mapping_id(*SX_get_string(c)));
#endif

    return(NULL);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
