dnl aclocal.m4 generated automatically by aclocal 1.3

dnl Copyright (C) 1994, 1995, 1996, 1997, 1998 Free Software Foundation, Inc.
dnl This Makefile.in is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

AC_DEFUN(PRCS_DEFAULT_ENV_VARS,
[
PRCS_DEFAULT_ENV_VAR(TMPDIR)
PRCS_DEFAULT_ENV_VAR(RCS_PATH)
PRCS_DEFAULT_ENV_VAR(PRCS_REPOSITORY)
PRCS_DEFAULT_ENV_VAR(PRCS_PLAIN_FORMAT)
PRCS_DEFAULT_ENV_VAR(PRCS_MERGE_COMMAND)
PRCS_DEFAULT_ENV_VAR(PRCS_LOGQUERY)
PRCS_DEFAULT_ENV_VAR(PRCS_JOB_NUMBER)
PRCS_DEFAULT_ENV_VAR(PRCS_DIFF_OPTIONS)
PRCS_DEFAULT_ENV_VAR(PRCS_DIFF_COMMAND)
PRCS_DEFAULT_ENV_VAR(PRCS_CONFLICT_EDITOR)
])
AC_DEFUN(PRCS_DEFAULT_ENV_VAR,
[
AC_CACHE_CHECK(for default environment variable $1, ac_cv_prcs_var_$1,
[if test -z "$$1" -o "$ENVVARS" = no; then
  ac_cv_prcs_var_$1=NULL
else
  ac_cv_prcs_var_$1=\""$$1"\"
  AC_SUBST(DEFAULT_ENV_$1)
fi
])
DEFAULT_ENV_$1=$ac_cv_prcs_var_$1
AC_SUBST(DEFAULT_ENV_$1)
])
dnl I don't like the standard mmap test, its broken in
dnl several ways.

AC_DEFUN(JM_FUNC_MMAP,
[AC_CACHE_CHECK(for working mmap read private, ac_cv_func_mmap,
[AC_TRY_RUN([
/* Josh's READ ONLY mmap test.  This is taken from, but heavily
 * modified, the autoconf 2.10 distribution.  This only tests the
 * features of mmap required by PRCS.  It is advisable to run
 * this test on an NFS filesystem if you intend to use PRCS with
 * a repository on NFS. */
#include <sys/types.h>
#include <unistd.h>
#include <sys/mman.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>

int
main()
{
  char *buf1;
  caddr_t     buf2;
  char *buf3;
  int ps = 5000;  /* This is purposely not a pagesize. */
  int ps2 = 2*ps;
  int ps3 = 3*ps;
  int j;
  int fd;

  /* Allocate 3 pages of buffer. */
  if ((buf1 = (char *)malloc(ps3)) == NULL ||
      (buf3 = (char *)malloc(ps3)) == NULL)
    {
      perror ("malloc failed");
      exit(1);
    }

  /* Generate 3 pages of random numbers into buf1. */
  for (j = 0; j < ps3; ++j)
    *(buf1 + j) = rand();

  /* Open for read/write. */
  if ((fd = open("conftestmmap", O_CREAT | O_RDWR, 0666)) < 0)
    {
      perror ("open 1 failed");
      exit(1);
    }

  /* Write 2 pages of the random numbers to the file. */
  if (write(fd, buf1, ps2) != ps2)
    {
      perror ("write 1 failed");
      exit(1);
    }

  /* Now map the file onto buf2. */
  if((buf2=mmap(NULL, ps2, PROT_READ, MAP_PRIVATE, fd, 0)) == NULL)
    {
      perror ("mmap 1 failed");
      exit (1);
    }

  /* Compare buf1 and buf2. */
  for (j = 0; j < ps2; ++j)
    if (*(buf1 + j) != *(buf2 + j))
      {
	fprintf (stderr, "read/mmap comparison failed\n");
	exit(1);
      }

  /* Write the 3rd page to the file. */
  if (write(fd, buf1+ps2, ps) != ps)
    {
      perror ("write 2 failed");
      exit(1);
    }

  /* Unamp the memory. */
  if (munmap (buf2, ps2) < 0)
    {
      perror ("munmap failed");
      exit(1);
    }

  /* Close the file. */
  if (close (fd) < 0)
    {
      perror ("close failed");
      exit(1);
    }

  /* Reopen the file. */
  if ((fd = open("conftestmmap", O_RDWR, 0666)) < 0)
    {
      perror ("open 2 failed");
      exit(1);
    }

  /* Recompare all 3 pages. */
  /* ... map the file onto buf2. */
  if((buf2=mmap(NULL, ps3, PROT_READ, MAP_PRIVATE, fd, 0)) == NULL)
    {
      perror ("mmap 1 failed");
      exit (1);
    }

  /* ... compare buf1 and buf2. */
  for (j = 0; j < ps3; ++j)
    if (*(buf1 + j) != *(buf2 + j))
      {
	fprintf (stderr, "read/mmap/unmap/append/mmap comparison failed");
	exit(1);
      }

  /* Now read it. */
  if (read(fd, buf3, ps3) != ps3)
    {
      perror ("read 1 failed");
      exit(1);
    }

  /* And compare again. */
  for (j = 0; j < ps3; ++j)
    if (*(buf1 + j) != *(buf3 + j))
      {
	fprintf (stderr, "read/mmap/unmap/append/read comparison failed");
	exit(1);
      }

  exit(0);
}
], ac_cv_func_mmap=yes, ac_cv_func_mmap=no, ac_cv_func_mmap=no)])
if test $ac_cv_func_mmap = yes; then
  AC_DEFINE(HAVE_MMAP)
fi
])

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AM_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE")
AC_DEFINE_UNQUOTED(VERSION, "$VERSION"))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])


# serial 1

AC_DEFUN(AM_PROG_INSTALL,
[AC_REQUIRE([AC_PROG_INSTALL])
test -z "$INSTALL_SCRIPT" && INSTALL_SCRIPT='${INSTALL_PROGRAM}'
AC_SUBST(INSTALL_SCRIPT)dnl
])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])


dnl AM_PROG_LEX
dnl Look for flex, lex or missing, then run AC_PROG_LEX and AC_DECL_YYTEXT
AC_DEFUN(AM_PROG_LEX,
[missing_dir=ifelse([$1],,`cd $ac_aux_dir && pwd`,$1)
AC_CHECK_PROGS(LEX, flex lex, "$missing_dir/missing flex")
AC_PROG_LEX
AC_DECL_YYTEXT])


# serial 1

AC_DEFUN(AM_PATH_LISPDIR,
 [# If set to t, that means we are running in a shell under Emacs.
  # If you have an Emacs named "t", then use the full path.
  test "$EMACS" = t && EMACS=
  AC_PATH_PROG(EMACS, emacs xemacs, no)
  if test $EMACS != "no"; then
    AC_MSG_CHECKING([where .elc files should go])
    dnl Set default value
    lispdir="\$(datadir)/emacs/site-lisp"
    if test "x$prefix" = "xNONE"; then
      if test -d $ac_default_prefix/share/emacs/site-lisp; then
	lispdir="\$(prefix)/share/emacs/site-lisp"
      else
	if test -d $ac_default_prefix/lib/emacs/site-lisp; then
	  lispdir="\$(prefix)/lib/emacs/site-lisp"
	fi
      fi
    else
      if test -d $prefix/share/emacs/site-lisp; then
	lispdir="\$(prefix)/share/emacs/site-lisp"
      else
	if test -d $prefix/lib/emacs/site-lisp; then
	  lispdir="\$(prefix)/lib/emacs/site-lisp"
	fi
      fi
    fi
    AC_MSG_RESULT($lispdir)
  fi
  AC_SUBST(lispdir)])

