function cmap = plcolormap(map)

# cmap = plcolormap([map])
# 
# Set colormap1 to map; map is an n row by 3 columns matrix, representing
#   red, green and blue components in the range [0..1]
#
# if map == 'default', returns and sets the default hsl colormap
# if map don't exist, return the current colormap

global __pl __pl_inited

if (!exist("__pl_inited") || plglevel == 0)
	figure(0)
endif

if (nargin == 0)
	if (struct_contains(__pl, "colormap"))
		cmap = __pl.colormap;
	else
# try to obtain the default colormap (plctrl.c, plcmap1_def())
if (0)
		plscmap1n(3); # three colors, blue, red and white
		[r g b]=plgcolbg;
		vertex=(r+g+b)/3/255;
	    if (vertex < 0.5)
	        vertex = 0.01;
	    else
	        vertex = 0.99;
	    endif
		                
		i=[0; 0.45; 0.55; 1];			# intensity
		h=[260; 260; 0; 0];				# hue
		l=[0.5; vertex; vertex; 0.5];	# lightness
		s=[1; 1; 1; 1];					# saturation
		plscmap1l(0,i,h,l,s,0)
		plflush
endif		
	endif

	return
# Ok, it works, but I want the rgb map array to store in __pl.colormap. how?
# see plcmap1_calc() in plctrl.c
endif

if (nargin == 1 && isstr(map) && strcmp(map, 'default'))
	plscmap1n(0);
	plflush
	return
endif

[r c] = size(map);
if( c != 3)
	help plcolormap
	return
endif

__pl.colormap = map;
map = map.*255;

plscmap1(map(:,1), map(:,2), map(:,3));
plflush;

endfunction
