
# Illustration of logarithmic axes, and redefinition of window.

1;

function go

# Parse and process command line arguments */

#    (void) plParseOpts(&argc, argv, PL_PARSE_FULL);

# Initialize plplot */
	global pldevice
	plsdev(pldevice)
    plinit();
    plfont(2);

# Make log plots using two different styles. */

    plot1(0);
    plot1(1);
    plend();
endfunction

# Log-linear plot.

function plot1(type)

    pladv(0);

# Set up data for log plot */

    f0 = 1.0;
    for i=1:100
	freql(i) = -2.0 + i / 20.0;
	freq = 10.0 .^ freql(i);
	ampl(i) = 20.0 * log10(1.0 / sqrt(1.0 + (freq / f0).^ 2.));
	phase(i) = -(180.0 / 3.141592654) * atan(freq / f0);
    endfor

    plvpor(0.15, 0.85, 0.1, 0.9);
    plwind(-2.0, 3.0, -80.0, 0.0);

# Try different axis and labelling styles. */

    plcol0(1);
    switch (type)

    case 0
	plbox("bclnst", 0.0, 0, "bnstv", 0.0, 0);

    case 1
	plbox("bcfghlnst", 0.0, 0, "bcghnstv", 0.0, 0);

	endswitch

# Plot ampl vs freq */

    plcol0(2);
    plline(freql, ampl);
    plcol0(1);
    plptex(5.0, -30.0, 1.0, -20.0, 0.5, "-20 dB/decade");

# Put labels on */

    plcol0(1);
    plmtex("b", 3.2, 0.5, 0.5, "Frequency");
    plmtex("t", 2.0, 0.5, 0.5, "Single Pole Low-Pass Filter");
    plcol0(2);
    plmtex("l", 5.0, 0.5, 0.5, "Amplitude (dB)");

# For the gridless case, put phase vs freq on same plot */

    if (type == 0) 
	plcol0(1);
	plwind(-2.0, 3.0, -100.0, 0.0);
	plbox("", 0.0, 0, "cmstv", 30.0, 3);
	plcol0(3);
	plline(freql, phase);
	plcol0(3);
	plmtex("r", 5.0, 0.5, 0.5, "Phase shift (degrees)");
    endif

endfunction

go
