/* 
 * Use sysconf.h for unix!!!  This file is for NON-unix systems.
 * 
 * This file is used to indicate capabilities of the C compiler and
 * operating system.
 * 
 * See also slrnfeat.h for customization of slrn features.
 */

/* Copyright (c) 1998 John E. Davis (davis@space.mit.edu)
 *
 * This file is part of slrn.
 *
 * Slrn is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * Slrn is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Slrn; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place - Suite 330, 
 * Boston, MA  02111-1307, USA.
 */

#define USE_DOMAIN_NAME 0
#define MY_DOMAIN_NAME "foo.bar"

#ifdef VMS
# ifndef MAIL_PROTOCOL
#   if defined(UCX) || defined(MULTINET)
#     define MAIL_PROTOCOL "SMTP%"
#   else
#     define MAIL_PROTOCOL "IN%"
#   endif
# endif
#endif

#ifdef __GO32__
# ifdef REAL_UNIX_SYSTEM
#  undef REAL_UNIX_SYSTEM
# endif
# ifndef __DJGPP__
#  define __DJGPP__ 1
# endif
#endif

#if defined(__MSDOS__) || defined(__DOS__)
# ifndef __MSDOS__
#  define __MSDOS__
# endif
# ifndef IBMPC_SYSTEM
#  define IBMPC_SYSTEM
# endif
#endif

#if defined(OS2) || defined(__OS2__)
# ifndef IBMPC_SYSTEM
#   define IBMPC_SYSTEM
# endif
# ifndef __os2__
#  define __os2__
# endif
#endif

#if defined(__CYGWIN32__) || defined(__MINGW32__)
# ifndef __WIN32__
#  define __WIN32__
# endif
#endif

#if defined(WIN32) || defined(__WIN32__)
# ifndef IBMPC_SYSTEM
#  define IBMPC_SYSTEM
# endif
# ifndef __WIN32__
#  define __WIN32__ 
# endif
#endif

#if defined(__MSDOS__) && !defined(__GO32__) && !defined(DOS386) && !defined(__WIN32__)
# ifndef __MSDOS_16BIT__
#  define __MSDOS_16BIT__	1
# endif
#endif

#if defined(__NT__)
# ifndef IBMPC_SYSTEM
#  define IBMPC_SYSTEM
# endif
#endif

#if defined(IBMPC_SYSTEM) || defined (__DECC) || defined(VAXC)
# define HAVE_STDLIB_H 1
#else
# define HAVE_MALLOC_H 1
#endif

#if defined (__os2__)
# define HAVE_UNISTD_H 1
# define HAVE_MEMORY_H 1
# define HAVE_SYS_SOCKET_H 1
# define HAVE_NETINET_IN_H 1
# define HAVE_ARPA_INET_H 1
# define HAVE_DIRENT_H 1
#endif

#if defined(__NT__) || defined(__WIN32__)
# define HAVE_UNISTD_H 1
# define HAVE_MEMORY_H 1
# if defined(__CYGWIN32__) || defined(__MINGW32__)
#  define HAVE_DIRENT_H 1
# else
#  define HAVE_DIRECT_H 1
# endif
# define popen _popen
# define pclose _pclose
#endif

#if defined(__WIN32__)
# if !defined(__CYGWIN32__) && !defined(__MINGW32__)
#  define HAVE_WINSPOOL_H
# endif
#endif

#ifdef VMS
# if __VMS_VER >= 60200000
#  define HAVE_UNISTD_H
# endif
#endif

#ifdef VMS
# define USE_NOTEPAD_PRINT_CODE
#endif

#ifdef __WIN32__
/* # define USE_NOTEPAD_PRINT_CODE */
#endif

/* 
 * Basic C library functions.
 */

#if defined(__os2__) || defined(__NT__)
# define HAVE_PUTENV 1
#endif

#define HAVE_GETCWD 1
#define HAVE_MEMSET 1
#define HAVE_MEMCPY 1
#define HAVE_MEMCHR 1

#define SLRN_SERVER_ID_NNTP 1
#define SLRN_SERVER_ID_SPOOL 2

#define SLRN_POST_ID_NNTP 1
#define SLRN_POST_ID_INEWS 2
#define SLRN_POST_ID_PULL 3

#if defined(IBMPC_SYSTEM)
# define SLRN_PATH_SLASH_CHAR	'\\'
#endif

#ifndef SLRN_PATH_SLASH_CHAR
/* I have no idea whether or not this will work on VMS. 
 * Using ']' is probably better. 
 */
# define SLRN_PATH_SLASH_CHAR	'/'
#endif

#if defined(__os2__)
/* Uncomment for no FAT code */
# define SLRN_USE_OS2_FAT
#endif
