
/* Copyright (c) Miguel Angel Sepulveda, 1998. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#ifndef __GD_MONOMER_H 
#define __GD_MONOMER_H 1 
 
/* Standard Libraries */ 
#include <iostream.h> 
#include <math.h> 
 
class GdBead; 
 
typedef GdBead  GdMonomer;  
typedef GdBead*  GdLink; 
 
 
class GdBead {  
/* A bead is an elemental component of a polymer chain. It can also  
*  represent a single monomer   
  */  
public:  
	  
  /* Constructor */  
  GdBead();  
  GdBead(GdBead &); 
	  
  /* Operators */  
  GdBead& operator=(GdBead &);  
	  
  /* Selector Functions */  
  void getPosition(double &x, double &y, double &z) const;  
  void getVelocity(double &x, double &y, double &z) const;  
  void getAcceleration(double &x, double &y, double &z) const;  
  int  getNrBonds() const;  
  double distance(GdBead&) const;  
  double distanceSqr(GdBead&) const;   
  bool isUnsaturated() const; 
	  
  /* Modifiers */  
  void resetAcceleration();  
  void resetVelocity();  
  void setPosition(double x, double y, double z);  
  void setVelocity(double x, double y, double z);  
  void setAcceleration(double x, double y, double z);  
  void addPosition(double dx, double dy, double dz);  
  void addVelocity(double dx, double dy, double dz);  
  void addAcceleration(double dx, double dy, double dz);  
  void multPosition(double sx, double sy, double sz);  
  int  makeBond(GdBead&);  
  int  breakBond(int);  
  GdBead& getBond(int);  
	  
private:  
  /* Functions with access to private members */  
  friend ostream& operator<<(ostream&, GdBead&);  
	  
  unsigned int numberBonds; /* How many monomers are linked to this bead */  
  double  position[3];      /* Position of the bead                      */  
  double  velocity[3];      /* Velocity of the bead                      */  
  double  acceleration[3];  /* Acceleration of the bead                  */  
  GdLink  bond[4];          /* References to linked beads                */  
};  
 
 
#endif 
 
 
 
