(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open OImage

let load name opts = OImage.make (Jpeg.load name opts)

let load_thumbnail name opts geom_spec =
  let w, h, img = Jpeg.load_thumbnail name opts geom_spec in
  w, h, OImage.make img

let save name opts image =
  let rgb24 = OImage.rgb24 image in
  Jpeg.save name opts rgb24#image

let save_as_cmyk name opts trans image =
  let rgb24 = OImage.rgb24 image in
  Jpeg.save_as_cmyk name opts trans rgb24#image


