/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.MemoryComboBox;

public class Browser
extends JFrame
implements HyperlinkListener,
ActionListener {
    private JTextField statusField;
    private MemoryComboBox urlField;
    private JEditorPane htmlPane;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private String[] topics = new String[]{"Home", "About", "User Guide", "File Manager", "Results Manager", "Sequence List", "Alignment Editor"};
    private String[] embossTopics = new String[]{"Home", "Apps"};
    private JSplitPane sp;
    private JMenuItem backMenu;
    private JButton backBt;
    private JMenuItem fwdMenu;
    private JButton fwdBt;

    public Browser(String initialURL, String name, JembossParams mysettings) throws IOException {
        this(initialURL, name, false, "", mysettings);
    }

    public Browser(String initialURL, String name, boolean ltext, String text, JembossParams mysettings) throws IOException {
        super(name);
        if (mysettings.isBrowserProxy()) {
            System.setProperty("http.proxyHost", mysettings.getBrowserProxyHost());
            System.setProperty("http.proxyPort", Integer.toString(mysettings.getBrowserProxyPort()));
            System.setProperty("proxyHost", mysettings.getBrowserProxyHost());
            System.setProperty("proxyPort", Integer.toString(mysettings.getBrowserProxyPort()));
        }
        if (ltext) {
            this.htmlPane = new JEditorPane();
            if (text.indexOf("<html>") > -1 || text.indexOf("<HTML>") > -1) {
                this.htmlPane.setContentType("text/html");
            }
            this.htmlPane.setText(text);
            this.htmlPane.addHyperlinkListener(this);
            this.setBrowserSize();
            Vector<String> urlCache = new Vector<String>();
            urlCache.add(name + ".html");
            this.setUpJMenuBar(urlCache);
            this.addToScrollPane();
            this.setVisible(true);
        } else {
            URL pageURL = new URL(initialURL);
            this.setURL(pageURL, initialURL);
        }
    }

    public Browser(URL urlName, String initialURL) throws IOException {
        super(initialURL);
        this.setURL(urlName, initialURL);
    }

    public void setURL(URL url, String name) {
        try {
            JEditorPane.registerEditorKitForContentType("text/html", "HTMLEditorKit2");
            this.htmlPane = new JEditorPane();
            this.htmlPane.setEditorKitForContentType("text/html", new HTMLEditorKit2());
            this.htmlPane.setPage(url);
            this.htmlPane.addHyperlinkListener(this);
            Vector<URL> urlCache = new Vector<URL>();
            urlCache.add(url);
            this.setBrowserSize();
            this.setUpJMenuBar(urlCache);
            this.setTitle(name);
            this.addToScrollPane();
            this.setVisible(true);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Cannot Load URL\n" + name, "Error", 0);
        }
    }

    private void setUpJMenuBar(Vector urlCache) {
        JMenuBar menuBar = new JMenuBar();
        JToolBar toolBarURL = new JToolBar();
        JToolBar toolBarIcon = new JToolBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        this.backMenu = new JMenuItem("Back");
        this.backMenu.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.backMenu.setActionCommand("BACK");
        this.backMenu.addActionListener(this);
        fileMenu.add(this.backMenu);
        this.backMenu.setEnabled(false);
        this.fwdMenu = new JMenuItem("Forward");
        this.fwdMenu.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fwdMenu.setActionCommand("FWD");
        this.fwdMenu.addActionListener(this);
        fileMenu.add(this.fwdMenu);
        fileMenu.addSeparator();
        JMenuItem closeMenu = new JMenuItem("Close");
        closeMenu.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Browser.this.setVisible(false);
            }
        });
        fileMenu.add(closeMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        menuBar.add(viewMenu);
        JCheckBoxMenuItem sideTopics = new JCheckBoxMenuItem("Display help topics");
        sideTopics.setSelected(true);
        sideTopics.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        sideTopics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Browser.this.sp.getDividerLocation() > 5) {
                    Browser.this.sp.setDividerLocation(0);
                } else {
                    Browser.this.sp.setDividerLocation(100);
                }
            }
        });
        viewMenu.add(sideTopics);
        ClassLoader cl = this.getClass().getClassLoader();
        ImageIcon jem = new ImageIcon(cl.getResource("images/Jemboss_logo_small.gif"));
        JIconButton jembossButton = new JIconButton(jem);
        jembossButton.addActionListener(this);
        jembossButton.setActionCommand("JEMBOSS");
        JLabel urlLabel = new JLabel("URL:");
        this.urlField = new MemoryComboBox(urlCache);
        this.urlField.addActionListener(this);
        int urlFieldHeight = (int)this.urlField.getPreferredSize().getHeight();
        this.backBt = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(new Color(0, 128, 0));
                float[][] loc1 = new float[][]{{4.0f, 12.0f}, {14.0f, 22.0f}, {14.0f, 16.0f}, {18.0f, 16.0f}, {18.0f, 12.0f}};
                g2.fill(Browser.makeShape(loc1));
                g2.setColor(Color.green);
                float[][] loc2 = new float[][]{{4.0f, 12.0f}, {14.0f, 2.0f}, {14.0f, 8.0f}, {18.0f, 8.0f}, {18.0f, 12.0f}};
                g2.fill(Browser.makeShape(loc2));
                if (!this.isEnabled()) {
                    g2.setColor(Color.gray);
                    float[][] loc3 = new float[][]{{5.0f, 12.0f}, {14.0f, 21.0f}, {14.0f, 15.0f}, {18.0f, 15.0f}, {18.0f, 12.0f}};
                    g2.fill(Browser.makeShape(loc3));
                    g2.setColor(Color.lightGray);
                    float[][] loc4 = new float[][]{{5.0f, 12.0f}, {14.0f, 3.0f}, {14.0f, 9.0f}, {18.0f, 9.0f}, {18.0f, 12.0f}};
                    g2.fill(Browser.makeShape(loc4));
                }
                this.setSize(22, 24);
            }
        };
        Dimension dBut = new Dimension(22, 24);
        this.backBt.setPreferredSize(dBut);
        this.backBt.setMaximumSize(dBut);
        this.backBt.setPreferredSize(new Dimension(15, 15));
        this.backBt.setActionCommand("BACK");
        this.backBt.addActionListener(this);
        this.backBt.setEnabled(false);
        this.fwdBt = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(new Color(0, 128, 0));
                float[][] loc1 = new float[][]{{4.0f, 12.0f}, {4.0f, 16.0f}, {8.0f, 16.0f}, {8.0f, 22.0f}, {18.0f, 12.0f}};
                g2.fill(Browser.makeShape(loc1));
                g2.setColor(Color.green);
                float[][] loc2 = new float[][]{{4.0f, 12.0f}, {4.0f, 8.0f}, {8.0f, 8.0f}, {8.0f, 2.0f}, {18.0f, 12.0f}};
                g2.fill(Browser.makeShape(loc2));
                if (!this.isEnabled()) {
                    g2.setColor(Color.gray);
                    float[][] loc3 = new float[][]{{4.0f, 12.0f}, {4.0f, 15.0f}, {8.0f, 15.0f}, {8.0f, 21.0f}, {17.0f, 12.0f}};
                    g2.fill(Browser.makeShape(loc3));
                    g2.setColor(Color.lightGray);
                    float[][] loc4 = new float[][]{{4.0f, 12.0f}, {4.0f, 7.0f}, {8.0f, 7.0f}, {8.0f, 3.0f}, {17.0f, 12.0f}};
                    g2.fill(Browser.makeShape(loc4));
                }
                this.setSize(22, 24);
            }
        };
        this.fwdBt.setPreferredSize(dBut);
        this.fwdBt.setMaximumSize(dBut);
        this.fwdBt.setActionCommand("FWD");
        this.fwdBt.addActionListener(this);
        this.fwdBt.setEnabled(false);
        toolBarIcon.add(this.backBt);
        toolBarIcon.add(this.fwdBt);
        toolBarIcon.add(jembossButton);
        toolBarURL.add(urlLabel);
        toolBarURL.add(this.urlField);
        this.setJMenuBar(menuBar);
        JPanel toolBars = new JPanel(new BorderLayout());
        toolBars.add((Component)toolBarIcon, "North");
        toolBars.add((Component)toolBarURL, "South");
        this.getContentPane().add((Component)toolBars, "North");
        int urlFieldWidth = (int)toolBarURL.getPreferredSize().getWidth();
        Dimension d = new Dimension(urlFieldWidth, urlFieldHeight);
        this.urlField.setMaximumSize(d);
        int iconBarWidth = (int)toolBarIcon.getPreferredSize().getWidth();
        int iconBarHeight = jem.getIconHeight();
        d = new Dimension(iconBarWidth, iconBarHeight);
        toolBarIcon.setPreferredSize(d);
    }

    private void setBrowserSize() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        int width = (int)((double)screenSize.width * 0.6);
        int height = (int)((double)screenSize.height * 0.85);
        this.setBounds((int)((double)width * 0.59), (int)((double)height * 0.02), width, height);
    }

    private void addToScrollPane() {
        this.htmlPane.setEditable(false);
        Box bacross = Box.createHorizontalBox();
        bacross.add(Box.createHorizontalGlue());
        JButton listClose = new JButton(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                BasicStroke stroke = new BasicStroke(2.0f);
                Graphics2D g2 = (Graphics2D)g;
                g2.setStroke(stroke);
                g2.setColor(Color.gray);
                g2.drawLine(4, 5, 9, 10);
                g2.drawLine(9, 5, 4, 10);
                g2.setColor(Color.black);
                g2.drawLine(4, 4, 9, 9);
                g2.drawLine(9, 3, 3, 9);
                this.setSize(15, 15);
            }
        };
        listClose.addActionListener(this);
        listClose.setActionCommand("CLOSE");
        listClose.setPreferredSize(new Dimension(15, 15));
        bacross.add(listClose);
        JPanel leftPane = new JPanel(new BorderLayout());
        JScrollPane leftScroll = new JScrollPane(this.getWebScape());
        leftPane.add((Component)bacross, "North");
        leftPane.add((Component)leftScroll, "Center");
        leftScroll.getViewport().setBackground(Color.white);
        this.sp = new JSplitPane(1, leftPane, this.htmlPane);
        this.sp.setDividerSize(8);
        this.sp.setDividerLocation(100);
        this.sp.setOneTouchExpandable(true);
        JScrollPane scrollPane = new JScrollPane(this.htmlPane);
        this.sp.add(scrollPane);
        this.htmlPane.setPreferredSize(this.getPreferredSize());
        this.getContentPane().add((Component)this.sp, "Center");
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        this.statusField = new JTextField();
        this.statusField.setBorder(compound);
        this.statusField.setEditable(false);
        this.getContentPane().add((Component)this.statusField, "South");
    }

    public void actionPerformed(ActionEvent event) {
        URL url = null;
        this.setCursor(this.cbusy);
        if (event.getSource() == this.urlField) {
            Object select = this.urlField.getSelectedItem();
            if (select instanceof String) {
                try {
                    url = new URL((String)select);
                }
                catch (MalformedURLException me) {}
            } else {
                url = (URL)select;
            }
        } else if (event.getActionCommand().equals("JEMBOSS")) {
            try {
                url = new URL("http://emboss.sourceforge.net/Jemboss/");
            }
            catch (MalformedURLException me) {}
        } else if (event.getActionCommand().equals("BACK")) {
            int index = this.urlField.getIndexOf(this.urlField.getSelectedItem()) - 1;
            if (index > -1 && index < this.urlField.getItemCount()) {
                url = this.urlField.getURLAt(index);
            }
        } else if (event.getActionCommand().equals("FWD")) {
            int index = this.urlField.getIndexOf(this.urlField.getSelectedItem()) + 1;
            if (index > -1 && index < this.urlField.getItemCount()) {
                url = this.urlField.getURLAt(index);
            }
        } else if (event.getActionCommand().equals("CLOSE")) {
            this.setCursor(this.cdone);
            this.sp.setDividerLocation(0);
            return;
        }
        try {
            this.htmlPane.setPage(url);
            if (!this.urlField.isItem(url)) {
                this.urlField.addURL(url);
            } else {
                this.urlField.setSelectedItem(url);
            }
            this.backMenu.setEnabled(this.urlField.isBackPage());
            this.backBt.setEnabled(this.urlField.isBackPage());
            this.fwdMenu.setEnabled(this.urlField.isForwardPage());
            this.fwdBt.setEnabled(this.urlField.isForwardPage());
        }
        catch (IOException ioe) {
            this.setCursor(this.cdone);
            this.warnUser("Can't follow link to " + url);
        }
        this.setCursor(this.cdone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setCursor(this.cbusy);
            try {
                URL url = event.getURL();
                this.htmlPane.setPage(url);
                if (!this.urlField.isItem(url)) {
                    this.urlField.addURL(url);
                }
                this.urlField.setSelectedItem(url);
                this.urlField.setLastIndex(url);
            }
            catch (IOException ioe) {
                this.setCursor(this.cdone);
                this.warnUser("Can't follow link to " + event.getDescription());
            }
            finally {
                this.setCursor(this.cdone);
            }
        } else if (event.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.statusField.setText(event.getDescription());
        } else if (event.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.statusField.setText("");
        }
    }

    private void warnUser(String message) {
        JOptionPane.showMessageDialog(this, message, "Warning", 0);
    }

    public static GeneralPath makeShape(float[][] loc) {
        GeneralPath path = new GeneralPath(1);
        path.moveTo(loc[0][0], loc[0][1]);
        for (int i = 1; i < loc.length; ++i) {
            path.lineTo(loc[i][0], loc[i][1]);
        }
        return path;
    }

    public JTree getWebScape() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Jemboss WebScape");
        this.createNodes(top);
        final JTree webScape = new JTree(top);
        webScape.setShowsRootHandles(true);
        webScape.expandRow(1);
        webScape.getSelectionModel().setSelectionMode(1);
        webScape.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ClassLoader cl = this.getClass().getClassLoader();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)webScape.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object nodeInfo = node.getUserObject();
                if (node.isLeaf()) {
                    String loc = null;
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    String category = (String)parent.getUserObject();
                    String selectedValue = (String)nodeInfo;
                    URL inURL = null;
                    if (selectedValue.equals("File Manager")) {
                        inURL = cl.getResource("resources/filemgr.html");
                    } else if (selectedValue.equals("About")) {
                        inURL = cl.getResource("resources/readme.html");
                    } else if (selectedValue.equals("Alignment Editor")) {
                        inURL = cl.getResource("resources/readmeAlign.html");
                    } else if (selectedValue.equals("Sequence List")) {
                        inURL = cl.getResource("resources/seqList.html");
                    } else if (selectedValue.equals("Results Manager")) {
                        inURL = cl.getResource("resources/results.html");
                    } else if (selectedValue.equals("User Guide")) {
                        loc = "http://emboss.sourceforge.net/Jemboss/guide.html";
                    } else if (selectedValue.equals("Home") && category.equals("Jemboss")) {
                        loc = "http://emboss.sourceforge.net/Jemboss/";
                    } else if (selectedValue.equals("Home") && category.equals("EMBOSS")) {
                        loc = "http://emboss.sourceforge.net/";
                    } else if (selectedValue.equals("Apps") && category.equals("EMBOSS")) {
                        loc = "http://emboss.sourceforge.net/apps/release/6.0/emboss/apps/";
                    }
                    if (loc != null) {
                        try {
                            inURL = new URL(loc);
                        }
                        catch (MalformedURLException me) {
                            Browser.this.warnUser("Can't follow link to " + loc);
                        }
                    }
                    if (inURL != null) {
                        try {
                            Browser.this.htmlPane.setPage(inURL);
                            if (!Browser.this.urlField.isItem(inURL)) {
                                Browser.this.urlField.addURL(inURL);
                            } else {
                                Browser.this.urlField.setSelectedItem(inURL);
                                Browser.this.urlField.setLastIndex(inURL);
                            }
                        }
                        catch (IOException ioe) {
                            Browser.this.setCursor(Browser.this.cdone);
                            Browser.this.warnUser("Can't follow link to " + inURL);
                        }
                        Browser.this.backMenu.setEnabled(Browser.this.urlField.isBackPage());
                        Browser.this.backBt.setEnabled(Browser.this.urlField.isBackPage());
                        Browser.this.fwdMenu.setEnabled(Browser.this.urlField.isForwardPage());
                        Browser.this.fwdBt.setEnabled(Browser.this.urlField.isForwardPage());
                    }
                }
            }
        });
        webScape.setRootVisible(false);
        return webScape;
    }

    private void createNodes(DefaultMutableTreeNode top) {
        int i;
        DefaultMutableTreeNode category = null;
        DefaultMutableTreeNode topic = null;
        category = new DefaultMutableTreeNode("Jemboss");
        top.add(category);
        for (i = 0; i < this.topics.length; ++i) {
            topic = new DefaultMutableTreeNode(this.topics[i]);
            category.add(topic);
        }
        category = new DefaultMutableTreeNode("EMBOSS");
        top.add(category);
        for (i = 0; i < this.embossTopics.length; ++i) {
            topic = new DefaultMutableTreeNode(this.embossTopics[i]);
            category.add(topic);
        }
    }

    public static void main(String[] args) {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        try {
            URL inURL = cl.getResource("resources/seqList.html");
            new Browser(inURL, "resources/seqList.html");
        }
        catch (Exception iex) {
            System.out.println("Didn't find resources/seqList.html");
        }
    }

    public class JIconButton
    extends JButton {
        public JIconButton(ImageIcon ii) {
            super(ii);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }
    }

    public class HTMLEditorKit2
    extends HTMLEditorKit {
        public Document createDefaultDocument() {
            HTMLDocument doc = (HTMLDocument)super.createDefaultDocument();
            doc.setAsynchronousLoadPriority(-1);
            return doc;
        }
    }
}

