/* $Id: UndefinedSymbol.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 * UndefinedSymbol: error meaning that a symbol could not get looked up.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#include "frontend/reporting/UndefinedSymbol.hpp"
#include "frontend/ast/SimpleName.hpp"

namespace ast {

/* FIXME new SimpleName */
UndefinedSymbol::UndefinedSymbol(
	std::string name,
	Location loc
	) : 	CompileError(loc, ""),
		failedName(name)
{
}

void 
UndefinedSymbol::put(std::ostream& stream) const
{
	stream << this->location << ": Symbol"
	       << " '" << this->failedName << "'";

	stream << " undefined.";
}


}; /* namespace ast */
