/* $Id: Jmp.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Jmp: unconditional jump (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __JMP_HPP_INCLUDED
#define __JMP_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/container/Label.hpp"

namespace intermediate {

//! unconditioned jump
/** This opcode will make an unconditional jump to target.
 *  read operands: label
 *  Changes: /PC/
 *
 *  target operand: Label.
 *  Operation: /PC/ = Label
 *   
 */
class Jmp : public OpCode {
public:
	//! c'tor
	/** @param target target of the jump.
	 */
	Jmp(Label *target) : trg(target) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! target to jump to.
	Label *trg;

protected:
	virtual ~Jmp() {
		util::MiscUtil::terminate(this->trg);
	}
};

}; /* namespace intermediate */

#endif /* __JMP_HPP_INCLUDED */
