/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IOINTERFACE_H
#define IOINTERFACE_H

#include <qstring.h>
#include "gui_user.h"

/** Successful return code. */
#define IO_INTF_OK           0
/**< A user callback requested the transfer be cancelled. */
#define IO_INTF_USER_CANCEL 11

/** File 'type'. */
#define IO_INTF_FILE         1
/** Dir 'type'. */
#define IO_INTF_DIR          2
/** Symbolic Link 'type'. */
#define IO_INTF_SYMLINK      3
/** Special 'type'. */
#define IO_INTF_SPECIAL      4
/** Locked Dir 'type'. */
#define IO_INTF_DIR_LOCKED   5


/**
 * Types of I/O Interfaces.  Define one for each type.
 * if you add new types you will also need to add to the
 * case statement in fileviewer.cpp
 */
#define IO_INTF_TYPE_LOCAL   0
#define IO_INTF_TYPE_IFP     1


class IOInterface
   {
   private:
   protected:
      int internal_exec_TransferToiFP(QString& remoteDest, QPtrList<FileInfos> *local_file_list);
      int internal_exec_TransferFromiFP(QString& localDest, QPtrList<FileInfos> *remote_file_list);
      QString internal_get_ProtocolStr(QString& fileName);
      int internal_remove_ProtocolStr(QString& fileName);
      int internal_norm_ProtocolStr(QString& fileName, QString protoStr);
      QString lastErrString;
      int interfaceType;
   public:
      IOInterface() {};
      virtual ~IOInterface() {};

      virtual int exec_TransferUpload(QString& destination, QPtrList<FileInfos> *file_info_list) = 0;
      virtual int exec_TransferDownload(QString& destination, QPtrList<FileInfos> *file_info_list) = 0;
      virtual int exec_Mkdir(QString& baseDir, QString& newDir) = 0;
      virtual int exec_Rename(const QString& oldName, const QString& newName) = 0;
      virtual int exec_Delete(QPtrList<FileInfos> *file_info_list) = 0;
      virtual int exec_ShowProperties(const QString& fileName) = 0;
      virtual int exec_GetDirectoryListing(QString dirName, QPtrList<FileInfos> *file_info_list) = 0;
      virtual bool get_isReadable(QString& dirName) = 0;
      virtual QString get_LastError() = 0;

      QString ProtocolType; // examples (file:  ifp:  ftp:)

   };



class FileInterface : public IOInterface
   {
   private:
   public:
      FileInterface()
         {
         interfaceType = IO_INTF_TYPE_LOCAL;
         ProtocolType  = "file://";
         };
      ~FileInterface() {};

      int exec_TransferUpload(QString& destination, QPtrList<FileInfos> *file_info_list);
      int exec_TransferDownload(QString& destination, QPtrList<FileInfos> *file_info_list);
      int exec_Mkdir(QString& baseDir, QString& newDir);
      int exec_Rename(const QString& oldName, const QString& newName);
      int exec_Delete(QPtrList<FileInfos> *file_info_list);
      int exec_ShowProperties(const QString& fileName);
      int exec_GetDirectoryListing(QString dirName, QPtrList<FileInfos> *file_info_list);
      bool get_isReadable(QString& dirName);
      QString get_LastError();
   };



class iFPInterface : public IOInterface
   {
   private:
      int ifp_connect(bool showError);
   public:
      iFPInterface()
         {
         interfaceType = IO_INTF_TYPE_IFP;
         ProtocolType  = "ifp://";
         };
      virtual ~iFPInterface() {};

      int exec_TransferUpload(QString& destination, QPtrList<FileInfos> *file_info_list);
      int exec_TransferDownload(QString& destination, QPtrList<FileInfos> *file_info_list);
      int exec_Mkdir(QString& baseDir, QString& newDir);
      int exec_Rename(const QString& oldName, const QString& newName);
      int exec_Delete(QPtrList<FileInfos> *file_info_list);
      int exec_ShowProperties(const QString& fileName);
      int exec_GetDirectoryListing(QString dirName, QPtrList<FileInfos> *file_info_list);
      bool get_isReadable(QString& dirName);
      QString get_LastError();
   };

#endif

