/*
 * Interface for accessing iRiver's IFP devices
 * $Id: prim.h,v 1.1.1.1 2005/08/04 19:45:27 jim-campbell Exp $
 *
 * Copyright (C) Geoff Oakham, 2004; <oakhamg@users.sourceforge.net>
 */

#ifndef IFP_PRIM_H
#define IFP_PRIM_H 1

//WARNING: this is a dumping ground for everything that doesn't have a home
//.. it used to be 'ifp.h'

#define IFP_REQ_TYPE            0xc0 //192
//#define TIMEOUT                 1000
//#define TIMEOUT                 5000
#define IFP_TIMEOUT             5000

#define IFP_FAT_PAGE_SIZE       0x0200 //512
#define IFP_FAT_SLOT_WIDTH      0x0020
#define IFP_FAT_SLOTS_PER_PAGE  (IFP_FAT_PAGE_SIZE/IFP_FAT_SLOT_WIDTH)
#define IFP_PATH_XFER_SIZE      0x0100 //256

//request values

#define IFP_ECHO                0x00 //no idea.  PING/ACK, start?
#define IFP_GOLF                0x01 //reset?
#define IFP_02_COMMAND          0x02 //see below
#define IFP_UNKNOWN_1           0x03 
#define IFP_UNKNOWN_2           0x04 
#define IFP_FILE_OPEN           0x05 //file open
#define IFP_FILE_OPEN_NEW       0x06 //'file_info' for uploading
#define IFP_FILE_DOWNLOAD       0x07 //requests next data block
#define IFP_FILE_UPLOAD         0x08 //accepts one data block
#define IFP_UNKNOWN_3           0x09 //? segfaults my test program
#define IFP_UNKNOWN_4           0x0a
#define IFP_FILE_SIZE           0x0b //context 'file_info'
#define IFP_UNKNOWN_5           0x0c
#define IFP_FILE_CLOSE          0x0d //file close for 'info' 'upload' and 'download ' (?)
#define IFP_FILE_DELETE         0x0e
#define IFP_LS_OPEN             0x0f //15
#define IFP_LS_NEXT             0x10 //16
#define IFP_LS_CLOSE            0x11 //17
#define IFP_DIR_CREATE          0x12 //18
#define IFP_DIR_DELETE          0x13 //19
#define IFP_GET_CAPACITY        0x14 //20
#define IFP_GET_FREE            0x15 //21
#define IFP_FORMAT              0x16 //22
#define IFP_FIRMWARE_UPDATE     0x17 //23
#define IFP_SET_BUFFER          0x18 //24 I believe it sets the buffer size
#define IFP_UNKNOWN_6           0x19 //25
#define IFP_GET_FAT_PAGE        0x1a //26 "alpha"
#define IFP_LS_NEXT_DEBUG       0x1b //27 "bravo"
#define IFP_SET_FAT_PAGE        0x1c //28 "charlie"
#define IFP_GET_PRESET          0x1d //29
#define IFP_SET_PRESET          0x1e //30

//when request is '02_COMMAND', index is one of these:
#define IFP_02_STRING           0x00
#define IFP_02_FIRMWARE         0x03
#define IFP_02_DELTA            0x04 //I always get "0108 0616 ffff ffff"
#define IFP_02_UPLOAD_FLUSH     0x06
#define IFP_02_BATTERY          0x08

struct ifp_device;

int ifp_control_send(struct ifp_device * dev, int command, int arg1, int arg2, int * r2);
int ifp_control_send_bool(struct ifp_device * dev, int command, int arg1, int arg2, int * r2);

//Logical primatives
//
//Parameter of type "char *" are either string or filename (named s and f
//respectively) and are utf8 strings.  "void *" buffers will be treated as
//binary data and will not be modified.
//
//The parameter "n" immediately following string and data buffers is the
//buffer size.

int ifp_rmdir_nocheck(struct ifp_device * dev, const char * d);

//returns 0 on success, and 1 on failure because file doesn't exist.
int ifp_file_open(struct ifp_device * dev, const char * f);
int ifp_file_open_new(struct ifp_device * dev, const char * f, int filesize);
int ifp_file_close(struct ifp_device * dev);
int ifp_file_size(struct ifp_device * dev);
int ifp_file_download(struct ifp_device * dev, void * p, int n);
int ifp_file_upload(struct ifp_device * dev, void * p, int n);
int ifp_file_flush(struct ifp_device * dev);

//returns 0 on success, 1 on failure because the dir doesn't exist.
int ifp_dir_open(struct ifp_device * dev, const char * f);
int ifp_dir_next(struct ifp_device * dev, void * s, int n, int mode);
int ifp_dir_close(struct ifp_device * dev);

int ifp_update_firmware_raw(struct ifp_device * dev);
int ifp_ping(struct ifp_device * dev);

//returns a raw bcd value.  For human consumption, I suggest ("%x.%02x", r/0x100, r%0x100).

// 'debug' here refers to the hardware--I believe this wasn't intended for use
// in the production firmware.
int ifp_dir_next_debug(struct ifp_device * dev, char * s, int n, int mode,
	int * dir, int * slot, int * size);
//sizeof(p) == 512 bytes (0x0100)
int ifp_get_fat_page(struct ifp_device * dev, int dir, int page,
	void * p, int n);
int ifp_set_fat_page(struct ifp_device * dev, int dir, int page,
	void * p, int n);


//"compound" or task-oriented functions.

int ifp_count_subdirs(struct ifp_device * dev, const char * dirname);

int ifp_copy_parent_string(char * p, const char * f, int n);

static const int ifp_product_ums_bit = 0x0100;
#define IFP_PRODUCT_IDs 8

extern int ifp_product_ids[IFP_PRODUCT_IDs];
extern char * ifp_product_strings[IFP_PRODUCT_IDs];


//Returns a negative number on error, 0 on success, and the number of
//bytes written (if the whole block wasn't written).
static inline int _ifp_set_buffer_size(struct ifp_device * dev, int n,
        int force)
{
        int i = 0, allowed;
        if (dev->last_buffer_size != n || force) {
                i = ifp_control_send(dev, IFP_SET_BUFFER, n, 0, &allowed);
                if (allowed >= 0) {
                        dev->last_buffer_size = allowed;
                }
                if (i == 1 && allowed == n) {
                        return 0;
                }
	}
	return i ? i : 0;
}

static inline int _ifp_file_download(struct ifp_device * dev,
	int bytes, int * actual)
{
        int i;
        i = ifp_control_send(dev, IFP_FILE_DOWNLOAD, bytes, 0, NULL);
        if (actual) {
                *actual = i;
        }
        if (i < 0) {
                ifp_err_i(i, "error sending code to download block.");
                return i;
        } else if (i == bytes) {
                return 0;
        } else if (i > bytes) {
                ifp_err_i(i, "Something's wierd.  The return value is larger than %d", bytes);
                return -1;
        } else if (i == 0) {
                ifp_wrn("warning: return value is 0 instead of %d, which is often a sign of corruption.", bytes);
                return 1;
        } else {
		//ifp_wrn("[_ifp_file_download] warning: got %d instead of %d.\n", i, bytes);
		return 0;
        }
}

#endif // IFP_PRIM_H

