/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qapplication.h>
#include <qtextcodec.h>
#include "ifp_gui.h"

//extern QString app_path;

int main( int argc, char ** argv )
   {
   int len;
   char path[500];
   QString trans_file, codecLocale;
   bool ret;

   QApplication a( argc, argv );
   QTranslator translator( 0 );
   QTranslator qt_translator(0);
   codecLocale = QTextCodec::locale();
   //fprintf(stderr, "locale = %s\n", codecLocale);

   trans_file = QString( "ifpgui_" ) + codecLocale;
   ret = translator.load(trans_file , "./translations");
                                         //qInstallPathTranslations() );
   if (!ret)
      {
      if (codecLocale.find("en_US") < 0)
         fprintf(stderr, "Loading translation file %s failed\n", trans_file.ascii());
      }

   trans_file = QString( "qt_" ) + QTextCodec::locale();
   ret = qt_translator.load( trans_file, qInstallPathTranslations() );
   if (!ret)
      {
      if (codecLocale.find("en_US") < 0)
         fprintf(stderr, "Loading translation file %s failed\n", trans_file.ascii());
      }

   a.installTranslator( &qt_translator );
   a.installTranslator( &translator );

   // find the path
   strncpy(path, argv[0], 500);
   len = strlen(path) - 1;
   while(len > 0)
      {
      if (path[len] == '/')
         {
         path[len] = '\0';
         break;
         }
      len--;
      }
   app_path = QString(path);

   ifp_gui * mw = new ifp_gui();
   mw->setCaption( "ifpgui" );
   mw->show();
   a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
   return a.exec();

   }
