/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  IFrIT animator script class - maps animator commands to function calls
//

#ifndef IANIMATORSCRIPT_H
#define IANIMATORSCRIPT_H


#include "ibasicscript.h"


class iAnimator;
class iControlScript;
class iDataType;


class iAnimatorScript : public iBasicScript 
{

	friend class iAnimator;
	friend class iExtensionFactory;

public:

	vtkTypeMacro(iAnimatorScript,iBasicScript);
	static iAnimatorScript* New(iAnimator *an = 0);

	inline iAnimator* GetAnimator() const { return mAnimator; }

	void SetInRender(bool s) { mInRender = s; }
	inline bool IsInRender() const { return mInRender; }

protected:

	iAnimatorScript(iAnimator *m);
	virtual ~iAnimatorScript();

	virtual bool IsCommandWordLetter(char c) const;

private:

	//
	//  script functions that need access to private/protected members of iAnimator, iAnimatorScript, or iScript.
	//
	static bool Reset(iScript *self);
	static bool Render(iScript *self, short at, int n);
	static bool RenderAll(iScript *self, short at, int n);
	static bool RenderSet(iScript *self, short at, int num, const int *v, int index);

	static bool ExecuteControlScript(iScript *self, const iString& filename);
	static bool EmbedControlScript(iScript *self, const iString &text);

	static bool Load(iScript *self, short at, int value);

	bool mInRender;
	iAnimator *mAnimator;
	iControlScript *mEmbeddedControlScript;
};

#endif // IANIMATORSCRIPT_H
