/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  This class is a merger of iObject with vtkCamera class. But since we cannot inherit, we must decorate
//
#ifndef ICAMERA_H
#define ICAMERA_H


#include "iobject.h"


#include "iposition.h"

class iEventObserver;
class iRenderTool;

class vtkCamera;


class iCamera : public iObject
{

	friend class iExtensionFactory;

	IPOINTER_AS_PART(ViewModule);

public:

	vtkTypeMacro(iCamera,iObject);
	static const iObjectType& Type();
	static iCamera* New(iRenderTool *rt = 0);

	IOBJECT_DECLARE_GETSET_POSITION(Position,mPosition); 
	//virtual void SetPosition(const iPosition &p);
	//inline const iPosition& GetPosition() const { return mPosition; }

	IOBJECT_DECLARE_GETSET_POSITION(FocalPoint,mFocalPoint); 
	//virtual void SetFocalPoint(const iPosition &p);
	//inline const iPosition& GetFocalPoint() const { return mFocalPoint; }

	//
	//  Camera orientation
	//
	static const iObjectKey& KeyParallelProjection();
	static const iObjectKey& KeyViewUp();
	static const iObjectKey& KeyParallelScale();
	static const iObjectKey& KeyViewAngle();
	static const iObjectKey& KeyViewAngleVertical();
	static const iObjectKey& KeyEyeAngle();
	static const iObjectKey& KeyClippingRange();
	static const iObjectKey& KeyClippingRangeAuto();
	static const iObjectKey& KeySyncProjections();

	//
	//  action keys
	//
	static const iObjectKey& KeyAzimuth();
	static const iObjectKey& KeyElevation();
	static const iObjectKey& KeyYaw();
	static const iObjectKey& KeyPitch();
	static const iObjectKey& KeyRoll();
	static const iObjectKey& KeyZoom();

	static const iObjectKey& KeyReset();

	void Reset();
	void Update();
	void OrthogonalizeView();
	void ShiftTo(const iPosition& pos);

	vtkCamera* GetDevice() const { return mDevice; }

protected:

	virtual ~iCamera();

	virtual void PackStateBody(iString &s) const;
	virtual void UnPackStateBody(const iString &s);

private:

	iCamera(iRenderTool *rt);

	void SyncProjections();

	bool mSyncProjections;
	vtkCamera *mDevice;
	iEventObserver *mObserver;
	iRenderTool *mRenderTool;
	iPosition mPosition, mFocalPoint;
};

#endif

