/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "itext.h"


#include "imath.h"
#include "ioverlayhelper.h"

#include <vtkCamera.h>
#include <vtkRenderer.h>


using namespace iParameter;


iText::iText(iRenderTool *rv) : mOverlayHelper(rv)
{
	mBold = false;
	mHorJust = mVerJust = _TextJustCenter;
	mPos[0] = mPos[1] = 0.0;
	mAngle = 0.0;
	mFontScale = 0;

	mSize[0] = mSize[1] = 0.0;

	this->PickableOff();
}


iText::~iText()
{
}


void iText::ReleaseGraphicsResources(vtkWindow *w)
{
	this->vtkProp::ReleaseGraphicsResources(w);
}


void iText::SetText(const iString &s)
{
	mText = s;
}


void iText::SetActorPosition(vtkViewport *viewport)
{
	this->GetSize(viewport,mSize);
	mActorPos[0] = mPos[0] - 0.5*mHorJust*mSize[0];
	mActorPos[1] = mPos[1] - 0.5*mVerJust*mSize[1];
}

