<?
#    IRM - The Information Resource Manager
#    Copyright (C) 1999,2000 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    $Id: irm.inc,v 1.34.2.5 2000/08/23 01:04:48 atrus Exp $
#
################################################################################
#                                  CHANGELOG                                   #
################################################################################
#  7/22/99 - Keith Schoenefeld:	Cleaned up code, converted all IF(): to if(){. #
#  7/22/99 - Keith Schoenefeld: Changed version number to 0.9a.1.              #
#  7/24/99 - Keith Schoenefeld: Changed version number to 0.9a.2.              #
#  7/25/99 - Yann Ramin: Moved Version to 0.9a.3                               #
#  7/25/99 - Yann Ramin: Re-instated IE bugfixes and moved crypt to md5.       #
#			 Mistake on my part, creating many versions with       #
#			 same number.					       #
#  7/25/99 - Yann Ramin: Added handling of phrasetype searches in multi-page   #
#			 list views.					       #
#  7/28/99 - Yann Ramin: Moved configuration to config.inc                     #
#  7/29/99 - Yann Ramin: Redisplayed followups in a recursive table.           #
#  8/03/99 - Yann Ramin: Added new config options for db name.                 #
#  8/06/99 - Keith Schoenefeld:	Changed my email address.                      #
#  8/06/99 - Keith Schoenefeld:	Added Brandon Neill bneill@learn2.com to the   #
#				copyright list.                                #
#  8/09/99 - Yann Ramin: Made patch for missing contact and contact_num        #
#		         sql lookups					       #
#  8/27/99 - Yann Ramin: Added (or rather changed) config.inc to               #
#			config.inc.php3                                        #
#  9/11/99 - Keith Schoenefeld:	Added checks for is_group so it displays the   #
#			proper name.                                           #
#  9/17/99 - Yann Ramin: Fiddled with the copyright.  Now reads 'Atrus Trivalie#
#			Productions' which encomposes everyone in the          #
#			docs/AUTHORS file.                                     #
#  11/6/99 - Yann Ramin: Fixed my e-mail address, fixed a few old bugs (list   #
#			view), added 'Reports' to the menu.                    #
#  11/18/99- Keith Schoenefeld: Added the nl2br function so that the $contents #
#                               variable is properly html-ized in              #
#				Show_tracking.                                 #
#  11/30/99- Keith Schoenefeld: Set up Show_tracking so it prints a "(U)"      #
#				beside a users name when they have requested   #
#				updates on the tracking.                       #
#  1/1/00 - Yann Ramin: Changed version to 0.9d, Y2ked copyright year,         #
#			added beginning SNMP stuff	                       #
#  2/25/00 - Yann Ramin: Networking beginnings, DB abstraction class.  Made DB #
#			extend DBmysql.					       #
#  3/16/00 - Yann Ramin: Configureable expire headers, eventlog	
################################################################################

# $root_path: The root path of the IRM installation.
# Set this to the actual path of where IRM is installed: this information
# is needed to find the configuration files. 

$root_path = "/usr/home/atrus/irm";

# There is NOTHING else to configure here.  EVERYTHING is in config.inc.php3
# 

include("$root_path/config.inc.php3");
if ($cfg_snmp == 1) {
	include("$root_path/snmp.inc.php3");
}

class DBmysql {

var $dbh;

function DB() {  # Constructor
	global $cfg_dbname, $cfg_dbuser, $cfg_dbpasswd, $cfg_dbdb;
	$this->$dbh = mysql_connect($cfg_dbname, $cfg_dbuser, $cfg_dbpasswd);
	mysql_select_db($cfg_dbdb);
	}

function query($query) {
	return mysql_query($query);
	}

function result($result, $i, $field) {
	return mysql_result($result, $i, $field);
	}

function numrows($result) {
	return mysql_numrows($result);
	}

function fetch_array($result) {
	return mysql_fetch_array($result);
}


}

if ($cfg_dbtype == "mysql") {
	class DB extends DBmysql {
	}
} else {
	PRINT "Database type not supported.";
}

function commonHeader($title) 
{
  if ($cfg_sendexpire == 1) {
	  header("Expires: Fri, Jun 12 1981 08:20:00 GMT\nPragma: no-cache");
  }
  global $PREFIX, $LOGO;

  ?>

  <!-- IRM is (c) 1999,2000 Atrus Trivalie Productions -->
  <!-- Yann Ramin atrus@atrustrivalie.eu.org -->
  <!-- Keith Schoenefeld keith-p@schoenefeld.org -->
  <!-- Some code is (c) 1999 Brandon Neill bneill@learn2.com  -->
  <!-- http://www.redshift.com/~yramin/atp/irm/ -->
  <html>
  <head>
  <title>IRM: <? echo $title;?></title>
  <?
  if ($cfg_sendexpire == 1) {
  ?>
  <META HTTP-EQUIV="Expires" CONTENT="Fri, Jun 12 1981 08:20:00 GMT">
  <META HTTP-EQUIV="Pragma" CONTENT="no-cache">
  <META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
  <?
  }
  ?>
  <style type="text/css">
  //<!-- 
 
  body 
  {  
    font-family: Arial, Helvetica, sans-serif;
    font-size: 10pt;
  }

  th   
  {  
    font-family: Arial, Helvetica, sans-serif;
    font-size: 10pt; 
    font-weight: bold;
    background-color: #D3DCE3;
  }

  td
  {
    font-family: Arial, Helvetica, sans-serif;
    font-size: 10pt;
  }
 
  form
  {
    font-family: Arial, Helvetica, sans-serif;
    font-size: 10pt;
  }

  h1
  {
    font-family: Verdana, Arial, Helvetica, sans-serif;
    font-size: 16pt;
    font-weight: bold;
  }

  A:link
  {
    font-family: Arial, Helvetica, sans-serif;
    font-size: 10pt;
    text-decoration: none;
    color: blue;
  }

  A:visited
  {
    font-family: Arial, Helvetica, sans-serif;
    font-size: 10pt;
    text-decoration: none;
    color: blue;
  }

  A:hover
  {
    font-family: Arial, Helvetica, sans-serif;
    font-size: 10pt;
    text-decoration: underline;
    color: red;
  }

  A:link.nav
  {
    font-family: Verdana, Arial, Helvetica, sans-serif;
    color: #000000;
  }

  A:visited.nav
  {
    font-family: Verdana, Arial, Helvetica, sans-serif;
     color: #000000;
  }

  A:hover.nav
  {
    font-family: Verdana, Arial, Helvetica, sans-serif;
     color: red;
  }

  .nav
  {
    font-family: Verdana, Arial, Helvetica, sans-serif;
    color: #000000;
  }

  //-->
  </style>
  </head>
  <body bgcolor="#FFFFFF" text="#000000" link="#054BBB" vlink="#006342">
  <font face="arial, helvetica">
  <!-- Main Information -->
  <br>
  <table cellspacing=0 border=0 height=20 width=100%>
    <tr height=20 bgcolor=#CCCCCC>
      <td> <a href="computers-index.php3"> 
		<font color=#000000 face="Arial, Helvetica">
		Computers</font></a> | <a href="networking-index.php3">
		<font color=#000000 face="Arial, Helvetica">
		Networking </font></a> | <a href="software-index.php3">
		<font color=#000000 face="Arial, Helvetica">
		Software</font></a> | <a href="tracking-index.php3"> 
		<font color=#000000 face="Arial, Helvetica">
		Tracking</font></a> | <a href="reports-index.php3">
		<font color=#000000 face="Arial, Helvetica">
		Reports</font></a> | <a href="helper.php3">
		<font color=#000000 face="Arial, Helvetica">
		Request Help</font></a> | <a href="setup-index.php3">
		<font color=#000000 face="Arial, Helvetica">
		Setup</font></a> | <a href="prefs-index.php3">
		<font color=#000000 face="Arial, Helvetica">
		Preferences</font></a> | <a href="logout.php3">
		<font color=#000000 face="Arial, Helvetica">
		Logout</font></a></td>
      <td align=right><?  $datetime = date("M d H:i");
		PRINT $datetime; ?> </td>
    </tr>
  </table>
  <a href=index.php3><img src="<? PRINT "$PREFIX/$LOGO"; ?>" border=0></a><br>
  <h3><? echo $title;?></h3>
  <hr noshade>
  <?
}


function commonFooter() 
{
  ?>
  <hr noshade>
  <br>
  </font>	
  <i>IRM Version <b>1.0.3</b>
		<a href="http://irm.schoenefeld.org/">IRM
  Website 1</a> <a href="http://irm.atrustrivalie.eu.org/">2</a> <a href="http://www.redshift.com/~yramin/atp/irm/">3</a>
	<br>IRM is protected by the 
		<a href="../docs/COPYING">GNU GPL License</a>.
		&copy; 1999,2000 <a href="../docs/AUTHORS">Atrus Trivalie Productions</a>
  <a href="mailto:atrus@atrustrivalie.eu.org">atrus@atrustrivalie.eu.org</a>.<br>
  </body>
  </html>

  <?
}
?>
<?
function AuthCheck($authtype) 
{
  global $IRMName, $IRMPass;
  $db = new DB;
  $query = "SELECT * FROM users WHERE (name = '$IRMName')";
  $result = $db->query($query);
  $password = $db->result($result, 0, "password");

  if (IsSet($IRMName) == FALSE) 
  {
    header("Vary: User-Agent");
    commonHeader("Not Logged In");
    ?>You were not logged in. (Check your browsers cookies)  
		<a href="../index.php3">Go Back to the login screen</a>.
    <?
	    commonFooter();

	    exit();
  } else if ($IRMPass != md5($password)) 
  {
	
    commonHeader("Bad Password");
    PRINT "You're supplied password is no longer valid.  This is probaly 
		  because you have just changed it and need to log in again.  
		  <a href=\"../index.php3\">Go back</a>.";
    commonFooter();

    exit();
  } else 
  {
#    SetCookie("IRMName", "$IRMName", 0, "/");
#    SetCookie("IRMPass", md5($password), 0, "/");
    header("Vary: User-Agent");

	if ($authtype == "normal") {
		$query = "SELECT * FROM users WHERE (name = '$IRMName')";
		$result = $db->query($query);
		$type = $db->result($result, 0, "type");
		if ($type != "normal" && $type != "admin")
		{
			commonHeader("Permission Denied");
			PRINT "You are not a normal user!";
			commonFooter();
			exit();
		}
	}
	else if ($authtype == "admin") {
		$query = "SELECT * FROM users WHERE (name = '$IRMName')";
		$result = $db->query($query);
		$typee = $db->result($result, 0, "type");
		if ($typee != "admin")
		{
			  commonHeader("Permission Denied");
			  PRINT "You are not an administrator!";
			  commonFooter();
			  exit();
		}
  	}
	else {
		return 0;
	}

  }
}

function Dropdown($table,$myname) 
{
  $db = new DB;
  $query = "SELECT * FROM $table ORDER BY name";
  $result = $db->query($query);

  PRINT "<SELECT NAME=\"$myname\" SIZE=1>";
  $i = 0;
  $number = $db->numrows($result);
  if ($number > 0)
  {
    while ($i < $number)
    {
	$output = $db->result($result, $i, "name");
	PRINT "<OPTION VALUE=\"$output\">$output</OPTION>";
	$i++;
    }
  }
  ?>
  </SELECT>
  <?
}

function Dropdown_groups($table,$myname) 
{
  $db = new DB;
  $query = "SELECT * FROM $table ORDER BY name";
  $result = $db->query($query);

  PRINT "<SELECT NAME=\"$myname\" SIZE=1>";
  $i = 0;
  $number = $db->numrows($result);
  if ($number > 0)
  {
    while ($i < $number)
    {
	$output = $db->result($result, $i, "name");
	$output2 = $db->result($result, $i, "id");
	PRINT "<OPTION VALUE=\"$output2\">$output</OPTION>";
	$i++;
    }
  }
  ?>
  </SELECT>
  <?
}

function Dropdown_value($table,$myname, $value) 
{
  $db = new DB;
  $query = "SELECT * FROM $table ORDER BY name";
  $result = $db->query($query);

  PRINT "<SELECT NAME=\"$myname\" SIZE=1>";
  $i = 0;
  $number = $db->numrows($result);
  if ($number > 0)
  {
    while ($i < $number)
    {
      $output = $db->result($result, $i, "name");
      if ($output == $value)
      {
        PRINT "<OPTION VALUE=\"$output\" selected>$output</OPTION>";
      } else
      {
        PRINT "<OPTION VALUE=\"$output\">$output</OPTION>";
      }
      $i++;
    }
  }
  ?>
  </SELECT>
  <?
}

function showComputer($ID, $expand) 
{
  global $cfg_snmp, $cfg_snmp_ping;
  $db = new DB;
  $query = "SELECT * FROM computers WHERE (ID = $ID)";
  $result = $db->query($query);

  $name = $db->result($result, 0, "name");
  $type = $db->result($result, 0, "type");
  $os = $db->result($result, 0, "os");
  $osver = $db->result($result, 0, "osver");
  $processor = $db->result($result, 0, "processor");
  $processor_speed = $db->result($result, 0, "processor_speed");
  $location = $db->result($result, 0, "location");
  $serial = $db->result($result, 0, "serial");
  $otherserial = $db->result($result, 0, "otherserial");
  $ramtype = $db->result($result, 0, "ramtype");
  $ram = $db->result($result, 0, "ram");
  $network = $db->result($result, 0, "network");
  $ip = $db->result($result, 0, "ip");
  $mac = $db->result($result, 0, "mac");
  $hdspace = $db->result($result, 0, "hdspace");
  $comments = $db->result($result, 0, "comments");
  $contact = $db->result($result, 0, "contact");
  $contact_num = $db->result($result, 0, "contact_num");
  $date_mod = $db->result($result, 0, "date_mod");
  $flags_server = $db->result($result, 0, "flags_server");

  $new_date = date("Y-m-d H:i:s");
  $comments = stripslashes($comments);
  PRINT "<table width=100% border=1 noshade>
		<form method=post action=computers-update.php3>
		<input type=hidden name=ID value=\"$ID\">
		<tr bgcolor=#CCCCCC><td colspan=2>
		<font face=\"Arial, Helvetica\">";

  if ($cfg_snmp == 1) {
  	
  	if ($cfg_snmp_ping == 1) {
	  	if ($ip != "" OR $ip != "DHCP" OR $ip != "dhcp") {
		  	$out = exec(EscapeShellCmd("ping -c 1 -n -i 1 $ip"),$dummy_array, $ping_return);
		}
	  	if ($ping_return == 2) {
	  		$hstatus = "| Host: <font color=red>DOWN</font>";
  		} else if ($ping_return == 0) {
  			$hstatus = "| Host: <font color=green>UP</font>";
  		} else {
  			$hstatus = "| Host: UNKNOWN ERROR";
  		}
  	}
  	$snmp_link = " | <a href=\"snmp-stat.php3?ID=$ID\">Runtime Information (SNMP)</a> $hstatus";
  }
  if ($expand == 1)
  {
    PRINT "<strong>$name ($ID)</strong> 
		<a href=\"tracking-add-form.php3?ID=$ID\">Add Tracking</a>$snmp_link";
  } else if ($expand == 0)
  {
    PRINT "<strong><a href=\"computers-info.php3?ID=$ID\">$name 
		($ID)</strong></a> 
		<a href=\"tracking-add-form.php3?ID=$ID\">Add Tracking</a>$snmp_link";
  }
  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		Name:<br><input type=text name=name value=\"$name\" 
		size=24></font></td><td><font face=\"Arial, Helvetica\">
		Type:<br>";
  Dropdown_value("dropdown_type", "type", $type);
  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">Location:<br>";
  Dropdown_value("dropdown_locations", "location", $location);
  PRINT "</font></td><td><font face=\"Arial, Helvetica\">OS:<br>";
  Dropdown_value("dropdown_os", "os", $os);
  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		OS Version:<br><input type=text size=5 name=osver 
		value=\"$osver\"></font></td><td><font face=\"Arial, 
		Helvetica\">Processor:<br>";
  Dropdown_value("dropdown_processor", "processor", $processor);

  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		Processor Speed:<br><input type=text name=processor_speed 
		size=4 value=\"$processor_speed\"></font></td><td>
		<font face=\"Arial, Helvetica\">Serial Number:<br>
		<input type=text name=serial size=35 value=\"$serial\">
		</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		Other Serial Number:<br><input type=text size=25 
		name=otherserial value=\"$otherserial\"></font></td>
		<td><font face=\"Arial, Helvetica\">Hard Drive Space 
		(in gigabytes):<br><input type=text name=hdspace size=5 
		value=\"$hdspace\"></font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">RAM Type:<br>";
  Dropdown_value("dropdown_ram", "ramtype", $ramtype);
  PRINT "</font></td><td><font face=\"Arial, Helvetica\">
		RAM Amount (in MB):<br><input type=text name=ram 
		value=\"$ram\" size=5></font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		Network Card Brand/Type:<br>";
  Dropdown_value("dropdown_network", "network", $network);
  PRINT "</font></td><td><font face=\"Arial, Helvetica\">
		IP Address:<br><input type=text name=ip value=\"$ip\" 
		size=16></font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		MAC/Network Address:<br><input type=text name=mac 
		value=\"$mac\"></font></td><td>Comments:<br><textarea 
		cols=20 rows=5 name=comments wrap=soft>$comments</textarea>
		</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		Contact Person:<br><input type=text name=contact size=20 
		value=\"$contact\"></font></td><td><font face=\"Arial, 
		Helvetica\">Contact Number:<br><input type=text 
		name=contact_num value=\"$contact_num\"></font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td colspan=2><font face=\"Arial, Helvetica\">
  		Flags: ";
  if ($flags_server == 1) {
  	PRINT "<input type=checkbox name=flags_server value=yes checked>";
  } else {
  	PRINT "<input type=checkbox name=flags_server value=yes>";
  }

  PRINT " Server (constant running)</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDD0><td colspan=2 align=center><font 
		face=\"Arial, Helvetica\">Last Updated: $date_mod 
		<input type=hidden name=date_mod value=\"$new_date\"></td>
		</tr>";
  PRINT "<tr bgcolor=#CCCCCC><td><input type=submit value=Update></form>
		<form method=post action=computers-del.php3>
		<input type=hidden name=ID value=$ID></td><td>
		<input type=submit value=Delete></form></td></tr></table>";
  PRINT "<br>";
}


function showSoftware($ID) 
{
  $db = new DB;
  $query = "SELECT * FROM software WHERE (ID = $ID)";
  $result = $db->query($query);
  $name = $db->result($result, 0, "name");
  $platform = $db->result($result, 0, "platform");
  $version = $db->result($result, 0, "version");
  $serial = $db->result($result, 0, "serial");
  $otherserial = $db->result($result, 0, "otherserial");
  $location = $db->result($result, 0, "location");
  $license = $db->result($result, 0, "license");
  $comments = $db->result($result, 0, "comments");
  $comments = stripslashes($comments);
  PRINT "<table width=100% border=1 noshade><form method=post 
		action=software-update.php3><input type=hidden 
		name=ID value=\"$ID\"><tr bgcolor=#CCCCCC><td 
		colspan=2><font face=\"Arial, Helvetica\">";

  PRINT "<strong>$name ($ID)</strong>";
  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, 
		Helvetica\">Name:<br><input type=text name=name 
		value=\"$name\" size=24></font></td><td><font face=\"Arial,
		 Helvetica\">Platform:<br>";

  Dropdown_value("dropdown_os", "platform", $platform);

  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		Location:<br>";

  Dropdown_value("dropdown_locations", "location", $location);

  PRINT "</font></td><td>Version: <br><input type=text name=version 
		value=\"$version\" size=5>";
  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		Serial Number:<br><input type=text name=serial size=35 
		value=\"$serial\"></font></td><td><font face=\"Arial, 
		Helvetica\">Other Serial Number:<br><input type=text 
		size=25 name=otherserial value=\"$otherserial\">
		</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td>Licenses:<br><input type=text name=license value=\"$license\" size=4><br>";
  $installed = Count_software($ID);
  $remaining = $license - $installed;
  PRINT "Installed: <b>$installed</b> Remaining: <b>";
  if ($remaining <= 0) {
	PRINT "<font color=red>";
  } 
  PRINT "$remaining</b></td>";

  PRINT "<td colspan><font face=\"Arial, 
		Helvetica\">Comments:<br><textarea cols=40 rows=5 
		name=comments wrap=soft>$comments</textarea></font></td></tr>";
  PRINT "<tr bgcolor=#CCCCCC><td><input type=submit value=Update></form>
		<form method=post action=software-del.php3>
		<input type=hidden name=ID value=$ID></td><td>
		<input type=submit value=Delete></form></td></tr></table>";
  PRINT "<br>";
}
function showNetworking($ID)
{
  $db = new DB;
  $query = "SELECT * FROM networking WHERE (ID = $ID)";
  $result = $db->query($query);
  $name = $db->result($result, 0, "name");
  $type = $db->result($result, 0, "type");
  $ram = $db->result($result, 0, "ram");
  $serial = $db->result($result, 0, "serial");
  $otherserial = $db->result($result, 0, "otherserial");
  $location = $db->result($result, 0, "location");
  $ip = $db->result($result, 0, "ip");
  $mac = $db->result($result, 0, "mac");
  $datemod = $db->result($result, 0, "datemod");
  $contact = $db->result($result, 0, "contact");
  $contact_num = $db->result($result, 0, "contact_num");
  $comments = $db->result($result, 0, "comments");
  $comments = stripslashes($comments);
  PRINT "<table width=100% border=1 noshade><form method=post
		action=networking-update.php3><input type=hidden
		name=ID value=\"$ID\"><tr bgcolor=#CCCCCC><td
		colspan=2><font face=\"Arial, Helvetica\">";

  PRINT "<strong>$name ($ID)</strong>";
  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial,
		Helvetica\">Name:<br><input type=text name=name
		value=\"$name\" size=24></font></td><td><font face=\"Arial,
		 Helvetica\">Type:<br>";

  Dropdown_value("dropdown_type", "type", $type);

  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		Location:<br>";

  Dropdown_value("dropdown_locations", "location", $location);

  PRINT "</font></td><td>RAM amount: <br><input type=text name=ram
		value=\"$ram\" size=5>";
  PRINT "</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td><font face=\"Arial, Helvetica\">
		Serial Number:<br><input type=text name=serial size=35
		value=\"$serial\"></font></td><td><font face=\"Arial,
		Helvetica\">Other Serial Number:<br><input type=text
		size=25 name=otherserial value=\"$otherserial\">
		</font></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td>IP:<br><input type=text name=ip value=\"$ip\" size=20></td><td>MAC:<br><input
  	type=text size=20 name=mac value=\"$mac\"></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td>Contact:<br><input type=text name=contact value=\"$contact\" size=20>";

  PRINT "</td>";
  PRINT "<td>Contact Number:<br><input type=text name=contact_num size=20 value=\"$contact_num\"></td></tr>";
  PRINT "<tr bgcolor=#DDDDDD><td colspan=2><font face=\"Arial,
		Helvetica\">Comments:<br><textarea cols=40 rows=5
		name=comments wrap=soft>$comments</textarea></font></td></tr>";
  PRINT "<tr bgcolor=#CCCCCC><td><input type=submit value=Update></form>
		<form method=post action=networking-del.php3>
		<input type=hidden name=ID value=$ID></td><td>
		<input type=submit value=Delete></form></td></tr></table>";
  PRINT "<br>";
  showPortsOnDevice($ID, 2);
}

function Count_software($sID) {
	$db = new DB;
	$query = "SELECT * FROM inst_software WHERE (sID = $sID)";
	$result = $db->query($query);
	$number = $db->numrows($result);
	return $number;
}

function Show_tracking($ID, $followup) 
{
  $db = new DB;
  global $IRMName, $cfg_userupdates;
  $query = "SELECT * FROM tracking WHERE (ID = $ID)";
  $result = $db->query($query);
  $resultnum = $db->numrows($result);
  $date = $db->result($result,0,"date");
  $status = $db->result($result, 0, "status");
  $author = $db->result($result, 0, "author");
  $computer = $db->result($result, 0, "computer");
  $contents = nl2br($db->result($result, 0, "contents"));
  $priority = $db->result($result, 0, "priority");
  $contents = StripSlashes($contents);
  $closedate = $db->result($result, 0, "closedate");
  $assign = $db->result($result, 0, "assign");
  $is_group = $db->result($result,0, "is_group");
  if($cfg_userupdates = 1)
  {
    $emailupdates = $db->result($result, 0, "emailupdates");
  }
  if($is_group == "yes")
  {
    $query = "SELECT name FROM groups WHERE (ID = $computer)";
  } else
  {
    $query = "SELECT name FROM computers WHERE (ID = $computer)";
  }
  $result = $db->query($query);
  $computername = $db->result($result, 0, "name");
	PRINT "<tr bgcolor=#EEEEEE><td><b>$ID</b></td>";	
  if ($resultnum > 0)
  {
    if ($status == "new")
    {
      PRINT "<td><font color=\"green\"><b>
		NEW</b></font></td>";
    } else
    {
      PRINT "<td><b>OLD</b></td>";
    }

    if ($status == "new") {
	    PRINT "<td><font face=\"Arial, Helvetica\"><b>Opened: $date<br>Not Yet Closed</b></font></td>";
    } 
    else {
	    PRINT "<td><font face=\"Arial, Helvetica\">Opened: $date<br><b>Closed: $closedate</b></font></td>";
    }
    PRINT "<td><font face=\"Arial, Helvetica\"><b>$priority</b></font></td>";
    PRINT "<td><font face=\"Arial, Helvetica\"><b><a href=users-info.php3?ID=$author>$author</a>";
    if(($cfg_userupdates == 1) && ($emailupdates == yes))
    {
      PRINT "(U)";
    }
    PRINT "</b></font></td>";
    if ($assign == "") {
	PRINT "<td>[Nobody]</td>"; 
    }
    else {
	    PRINT "<td><b>$assign</b></td>";
    }    
    PRINT "<td><font face=\"Arial, Helvetica\">
		<a href=\"computers-info.php3?ID=$computer\">
		<b>$computername ($computer)</b></a></font></td>";
    PRINT "<td width=\"70%\"><font face=\"Arial, Helvetica\">
		<b>$contents</b></font></td>";
    $query = "SELECT * FROM followups WHERE (tracking = $ID)";
    $result = $db->query($query);
    $counter = $db->numrows($result);
    PRINT "<td><a href=tracking-followups.php3?ID=$ID>
		More Info</a> ($counter) <br>";
    if ($status == "new") {
		PRINT "<a href=tracking-mark.php3?ID=$ID>
		Mark Old</a><br>";
    }
    PRINT "<a href=tracking-assign-form.php3?ID=$ID>
		Assign</a></td>";
    PRINT "</tr>";
  } else
  {
    PRINT "<tr bgcolor=#EEEEEE><th colspan=6><i>
		No Tracking Available</i></th></tr>";
  }
  if ($followup == 1)
  {
   	
	PRINT "<tr bgcolor=#EEEEEE><td>&nbsp;</td><td colspan=7>";
	Show_followups($ID);
	PRINT "</td></tr>"; 
  }
}

function Checked($field)
{
  if ($field == "yes")
  {
    return("checked");
  } else
  {
    return("");
  }
}

function computerListView($compquery, $sort, $phrasetype) 
{
  global $IRMName, $field, $goto, $contains, $style;
  $db = new DB;
  $query = "SELECT * FROM prefs WHERE (user = '$IRMName')";
  $result = $db->query($query);
  $stype = $db->result($result, 0, "type");
  $stype = Checked($stype);
  $sos = $db->result($result, 0, "os");
  $sos = Checked($sos);
  $sosver = $db->result($result, 0, "osver");
  $sosver = Checked($sosver);
  $sprocessor = $db->result($result, 0, "processor");
  $sprocessor = Checked($sprocessor);
  $sprocessor_speed = $db->result($result, 0, "processor_speed");
  $sprocessor_speed = Checked($sprocessor_speed);
  $slocation = $db->result($result, 0, "location");
  $slocation = Checked($slocation);
  $sserial = $db->result($result, 0, "serial");
  $sserial = Checked($sserial);
  $sotherserial = $db->result($result, 0, "otherserial");
  $sotherserial = Checked($sotherserial);
  $sramtype = $db->result($result, 0, "ramtype");
  $sramtype = Checked($sramtype);
  $sram = $db->result($result, 0, "ram");
  $sram = Checked($sram);
  $snetwork = $db->result($result, 0, "network");
  $snetwork = Checked($snetwork);
  $sip = $db->result($result, 0, "ip");
  $sip = Checked($sip);
  $smac = $db->result($result, 0, "mac");
  $smac = Checked($smac);
  $shdspace = $db->result($result, 0, "hdspace");
  $shdspace = Checked($shdspace);
  $scontact = $db->result($result, 0, "contact");
  $scontact = Checked($scontact);
  $scontact_num = $db->result($result, 0, "contact_num");
  $scontact_num = Checked($scontact_num);
  $scomments = $db->result($result, 0, "comments");
  $scomments = Checked($scomments);
  $sdate_mod = $db->result($result, 0, "date_mod");
  $sdate_mod = Checked($sdate_mod);
	  
	
  $result = "";
  $result = $db->query($compquery);
	
  PRINT "<table border=1 width=100%><tr bgcolor=#CCCCCC>";
	
	
	
	
  PRINT "<th>Name</th>";
	  
  if ($stype == "checked") 
  {
    PRINT "<th>Type</th>";
  }
  if ($sos == "checked") 
  {
    PRINT "<th>OS</th>";
  }
  if ($sosver == "checked") 
  {
    PRINT "<th>OS Version</th>";
  }
  if ($sprocessor == "checked") 
  {
    PRINT "<th>Processor</th>";
  }
  if ($sprocessor_speed == "checked") 
  {
    PRINT "<th>Proc. Speed</th>";
  }
  if ($slocation == "checked") 
  {
    PRINT "<th>Location</th>";
  }
  if ($sserial == "checked") 
  {
    PRINT "<th>SN</th>";
  }
  if ($sotherserial == "checked") 
  {
    PRINT "<th>Other Serial</th>";
  }
  if ($sramtype == "checked") 
  {
    PRINT "<th>RAM Type</th>";
  }
  if ($sram == "checked") 
  {
    PRINT "<th>RAM</th>";
  }
  if ($snetwork == "checked") 
  {
    PRINT "<th>Network</th>";
  }
  if ($sip == "checked")
  {
    PRINT "<th>IP</th>";
  }
  if ($smac == "checked")
  {
    PRINT "<th>Net/MAC Addr.</th>";
  }
  if ($shdspace == "checked") 
  {
    PRINT "<th>HD Space</th>";
  }
  if ($scontact == "checked") 
  {
    PRINT "<th>Contact Person</th>";
  }
  if ($scontact_num == "checked") 
  {
    PRINT "<th>Contact Num.</th>";
  }
  if ($scomments == "checked") 
  {
    PRINT "<th>Comments</th>";
  }
  if ($sdate_mod == "checked") 
  {
    PRINT "<th>Date Modified</th>";
  }
	  
  PRINT "</tr>";
  $i = $goto;
  $number = $db->numrows($result);
  while ($i < $number)
  {
    $ID = $db->result($result, $i, "ID");
    $name = $db->result($result, $i, "name");
    $type = $db->result($result, $i, "type");
    $os = $db->result($result, $i, "os");
    $osver = $db->result($result, $i, "osver");
    $processor = $db->result($result, $i, "processor");
    $processor_speed = $db->result($result, $i, "processor_speed");
    $location = $db->result($result, $i, "location");
    $serial = $db->result($result, $i, "serial");
    $otherserial = $db->result($result, $i, "otherserial");
    $ramtype = $db->result($result, $i, "ramtype");
    $ram = $db->result($result, $i, "ram");
    $network = $db->result($result, $i, "network");
    $ip = $db->result($result, $i, "ip");
    $mac = $db->result($result, $i, "mac");
    $hdspace = $db->result($result, $i, "hdspace");
    $comments = $db->result($result, $i, "comments");
    $date_mod = $db->result($result, $i, "date_mod");
    $contact = $db->result($result, $i, "contact");
    $contact_num = $db->result($result, $i, "contact_num");	
    $comments = stripslashes($comments);
    PRINT "<tr bgcolor=#DDDDDD><td><a href=\"computers-info.php3?ID=$ID\">
		$name ($ID)</a></td>";
		
    if ($stype == "checked")
    {
      PRINT "<td>$type</td>";
    }
    if ($sos == "checked")
    {
      PRINT "<td>$os</td>";
    }
    if ($sosver == "checked")
    {
      PRINT "<td>$osver</td>";
    }
    if ($sprocessor == "checked") 
    {
      PRINT "<td>$processor</td>";
    }
    if ($sprocessor_speed == "checked")
    {
      PRINT "<td>$processor_speed</td>";
    }
    if ($slocation == "checked") 
    {
      PRINT "<td>$location</td>";
    }
    if ($sserial == "checked") 
    {
      PRINT "<td>$serial</td>";
    }
    if ($sotherserial == "checked")
    {
      PRINT "<td>$otherserial</td>";
    }
    if ($sramtype == "checked") 
    {
      PRINT "<td>$ramtype</td>";
    }
    if ($sram == "checked") 
    {
      PRINT "<td>$ram</td>";
    }
    if ($snetwork == "checked") 
    {
      PRINT "<td>$network</td>";
    }
    if ($sip == "checked") 
    {
      PRINT "<td>$ip</td>";
    }
    if ($smac == "checked")
    { 
      PRINT "<td>$mac</td>";
    }
    if ($shdspace == "checked")
    {
      PRINT "<td>$hdspace</td>";
    }
    if ($scontact == "checked") 
    {
      PRINT "<td>$contact</td>";
    }
    if ($scontact_num == "checked") 
    {
      PRINT "<td>$contact_num</td>";
    }
    if ($scomments == "checked") 
    {
      PRINT "<td>$comments</td>";
    }
    if ($sdate_mod == "checked") 
    {
      PRINT "<td>$date_mod</td>";
    }
			
    PRINT "</tr>";
    if (($goto + 24 - $i) < 1)
    {
      break;
    }
    $i++;
  }
  $backgoto = $goto - 25;
  $forgoto = $goto + 25;
  PRINT "</table>";
  PRINT "<table border=0><tr><td>";
  if ($backgoto > -1)
  {
    PRINT "<form><input type=hidden name=sort value=\"$sort\">
		<input type=hidden name=phrasetype value=\"$phrasetype\"> 
		<input type=hidden name=field value=\"$field\">
		<input type=hidden name=contains value=\"$contains\">
		<input type=hidden name=style value=\"$style\">
		<input type=hidden name=goto value=$backgoto>
		<input type=submit value=\"Previous 25\"></form>";
  }
  PRINT "</td><td>";
  if ($forgoto < $number)
  {		
    PRINT "<form><input type=hidden name=sort value=\"$sort\">
		<input type=hidden name=phrasetype value=\"$phrasetype\"> 
		<input type=hidden name=field value=\"$field\">
		<input type=hidden name=contains value=\"$contains\">
		<input type=hidden name=style value=\"$style\">
		<input type=hidden name=goto value=$forgoto>
		<input type=submit value=\"Next 25\"></form>";
  }
  PRINT "</td></tr></table>";
}

function templcompsoftShow($showID) {
        $db = new DB;
	$query = "SELECT * FROM templ_inst_software WHERE (cID = $showID)";
	$result = $db->query($query);
	$number = $db->numrows($result);
	$i = 0;
	PRINT "<table border=1 width=100%><tr bgcolor=#BBBBB><th colspan=2>Installed Software</th></tr>";
	
	while ($i < $number) {
		$sID = $db->result($result, $i, "sID");
		$ID = $db->result($result, $i, "ID");
		$query = "SELECT * FROM software WHERE (ID = $sID)";
		$result2 = $db->query($query);
		$name = $db->result($result2, 0, "name");

		PRINT "<tr bgcolor=#DDDDDD><td><i><a href=\"software-info.php3?ID=$sID\">$name</a></i></td><td width=10%><a href=setup-templates-software-del.php3?ID=$ID>[Delete]</a></td></tr>";
		$i++;		
	}
	PRINT "<tr bgcolor=#CCCCCC><td><form method=post action=setup-templates-software-add.php3><input type=hidden name=cID value=$showID>Add software:";
SoftwareDropdown();
PRINT " to template.</td><td><input type=submit value=Add></form></td></tr>";
	PRINT "</table>";
}


function compsoftShow($showID) {
        $db = new DB;
	$query = "SELECT * FROM inst_software WHERE (cID = $showID)";
	$result = $db->query($query);
	$number = $db->numrows($result);
	$i = 0;
	PRINT "<table border=1 width=100%><tr bgcolor=#BBBBB><th colspan=2>Installed Software</th></tr>";
	
	while ($i < $number) {
		$sID = $db->result($result, $i, "sID");
		$ID = $db->result($result, $i, "ID");
		$query = "SELECT * FROM software WHERE (ID = $sID)";
		$result2 = $db->query($query);
		$name = $db->result($result2, 0, "name");
                $version = $db->result($result2, 0, "version");
		PRINT "<tr bgcolor=#DDDDDD><td><i><a href=\"software-info.php3?ID=$sID\">$name (v. $version)</a></i></td><td width=10%><a href=computers-software-del.php3?ID=$ID>[Delete]</a></td></tr>";
		$i++;		
	}
	PRINT "<tr bgcolor=#CCCCCC><td><form method=post action=computers-software-add.php3><input type=hidden name=cID value=$showID>Add software ";
	SoftwareDropdown();
	PRINT " to computer.</td><td><input type=submit value=Add></form></td></tr>";
	PRINT "</table>";
}

function SoftwareDropdown() {
	$db = new DB;
	$query = "SELECT name,ID,version FROM software ORDER BY name";
	$result = $db->query($query);
	$number = $db->numrows($result);

	$i = 0;
	PRINT "<select name=sID size=1>";
	while ($i < $number) {
		$version = $db->result($result, $i, "version");
		$name = $db->result($result, $i, "name");
		$sID = $db->result($result, $i, "ID");
		PRINT "<option value=$sID>$name (v. $version)</option>";
		$i++;
	}
	PRINT "</select>";
}

function Show_followups($ID) {
    global $IRMName;
    $db = new DB;
    $query = "SELECT * FROM followups WHERE (tracking = $ID) ORDER BY date ASC";
    $result = $db->query($query);
    $number = $db->numrows($result);
    $i=0;
    PRINT "<table border=1 width=100%><tr><th colspan=3>Followups</th></tr><tr bgcolor=#DDCCBB><td><b>Date</b></td><td><b>Author</b></td><td><b>Description</b></td></tr>";
    if ($number == 0)
    {
      PRINT "<tr bgcolor=#CCCCCC><td colspan=3 align=center>
                <font face=\"Arial, Helvetica\"><i>
                No Followups Posted</i></font></td></tr>";
    } else
    {
      while ($i < $number)
      {
        $date = $db->result($result,$i,"date");
        $author = $db->result($result, $i, "author");
        $contents = $db->result($result, $i, "contents");
        $contents = stripslashes($contents);
        PRINT "<tr bgcolor=#CCCCCC>
                <td><font face=\"Arial, Helvetica\">
                $date</font></td><td><font face=\"Arial, 
                Helvetica\">$author</font></td><td><font 
                face=\"Arial, Helvetica\">$contents</font></td>
                </tr>";
        $i++;
      }
        
    }
    $datenow = date("Y-m-d H:i:s");
    PRINT "<form method=post action=tracking-post-followup.php3>
                <input type=hidden name=ID value=$ID>";
    PRINT "<tr bgcolor=#BBBBBB><td><font color=\"yellow\">
                Add Followup</font></td><td><font face=\"Arial, Helvetica\">
                $IRMName</font></td>
                <td><font face=\"Arial, Helvetica\"><textarea cols=20 
                rows=3 name=contents wrap=soft></textarea></font>
                <input type=submit value=Post></form></td></tr>";
  
  PRINT "</table>";
  
}

function text_followups($ID, &$followup) 
{
  global $IRMName;    
  $db = new DB;
  $query = "SELECT * FROM followups WHERE (tracking = $ID) ORDER BY date ASC";
  $result = $db->query($query);
  $number = $db->numrows($result);
  $i=0;
  if ($number == 0)
  {
    $followup = $followup .  "No Followups Posted";
  } else
  {
    $followup = $followup . "Followups:\nDate - Author - Description\n";
    while ($i < $number)
    {
      $date = $db->result($result,$i,"date");
      $author = $db->result($result, $i, "author");
      $contents = $db->result($result, $i, "contents");
      $contents = StripSlashes($contents);
      $followup = $followup . "$date - $author - $contents\n";
      $i++;
    }
  }
}

function Tech_list($value, $myname) 
{
  $db = new DB;
  $query = "SELECT * FROM users WHERE (type = 'admin' || type = 'normal') ORDER BY name";
  $result = $db->query($query);

  PRINT "<SELECT NAME=\"$myname\" SIZE=1>";
  $i = 0;
  $number = $db->numrows($result);
  if ($number > 0)
  {
    PRINT "<OPTION VALUE=\"\">[ Nobody ]</OPTION>\n";
    while ($i < $number)
    {
      $output = $db->result($result, $i, "name");
      if ($output == $value)
      {
        PRINT "<OPTION VALUE=\"$output\" selected>$output</OPTION>";
      } else
      {
        PRINT "<OPTION VALUE=\"$output\">$output</OPTION>";
      }
      $i++;
    }
  }
  ?>
  </SELECT>
  <?
}

function showPortsOnDevice($device, $device_type) {
	$db = new DB;
	$query = "SELECT * FROM networking_ports WHERE (device_on = $device AND device_type = $device_type) ORDER BY logical_number";
	# 1 is computer, 2 networking device
	$result = $db->query($query);
	$number = $db->numrows($result);
	PRINT "<table border=1 width=100%>";
	PRINT "<tr><th>Port #</th><th>Name</th><th>Interface</th><th>Iface Addr</th><th>If MAC</th><th>Connected to...</th></tr>";
	
	if ($number < 1) {
		PRINT "<tr><td colspan=6>Looks like a lonley device to me.  No ports found.</td></tr>";
		
	} else {
	$i = 0;
	while ($i < $number) {
		$ID = $db->result($result, $i, "ID");
		$name = $db->result($result, $i, "name");
		$logical_number = $db->result($result, $i, "logical_number");
		$iface = $db->result($result, $i, "iface");
		$ifaddr = $db->result($result, $i, "ifaddr");
		$ifmac = $db->result($result, $i, "ifmac");
		$wquery = "SELECT * FROM networking_wire WHERE (end1 = $ID OR end2 = $ID)";
		$wresult = $db->query($wquery);
		if ($db->numrows($wresult) > 0) {
			$wID = $db->result($wresult, 0, "ID");
			$wend1 = $db->result($wresult, 0, "end1");
			$wend2 = $db->result($wresult, 0, "end2");
			if ($wend1 == $ID) {
				$pquery = "SELECT * FROM networking_ports WHERE (ID = $wend2)";
			} else {
				$pquery = "SELECT * FROM networking_ports WHERE (ID = $wend1)";
			}
			$presult = $db->query($pquery);
			$pID = $db->result($presult, 0, "ID");
			$pNum = $db->result($presult, 0, "logical_number");
			$pOn = $db->result($presult, 0, "device_on");
			$pType = $db->result($presult, 0, "device_type");
			if ($pType == 1) {
				$nquery = "SELECT ID,name FROM computers WHERE (ID = $pOn)";
			} else if ($pType == 2) {
				$nquery = "SELECT ID,name FROM networking WHERE (ID = $pOn)";
			}
			$nresult = $db->query($nquery);
			$nname = $db->result($nresult, 0, "name");
			$nID = $db->result($nresult, 0, "ID");
			$found = 1;
		} else {
			$found = 0;
			$pType = 0;
		}
		
		PRINT "<tr><td><a href=networking-port.php3?ID=$ID>$logical_number</a></td><td>$name</td><td>$iface</td><td>$ifaddr</td><td>$ifmac</td>";
		PRINT "<td>";
		if ($pType == 1) {
			PRINT "Port <a href=networking-port.php3?ID=$pID>$pNum</a> on computer <a href=computers-info.php3?ID=$nID>$nname ($nID)</a> | <a href=networking-port-discon.php3?ID=$ID>Disconnect</a>.";
		} else if ($pType == 2) {
			PRINT "Port <a href=networking-port.php3?ID=$pID>$pNum</a> on network device <a href=networking-info.php3?ID=$nID>$nname ($nID)</a> | <a href=networking-port-discon.php3?ID=$ID>Disconnect</a>.";
		} else if ($found != 1) {
			PRINT "Nothing Connected. <a href=networking-connecter.php3?ID=$ID>Connect</a>";
		}
		PRINT "</td></tr>";
		$found = 0;
		$pType=0;
			
	
		$i++;
	}
	}
	PRINT "<tr><td colspan=6 align=right><a href=networking-port-add-form.php3?device=$device&device_type=$device_type>Add Port</a></td></tr>";
	PRINT "</table><br>";

}

function logevent($item, $itemtype, $level, $service, $event) {
  global $cfg_minloglevel;
  if ($level <= $cfg_minloglevel) { 
	  $db = new DB;	
	  $query = "INSERT INTO event_log VALUES (NULL, $item, '$itemtype', NOW(), '$service', $level, '$event')";
	  $result = $db->query($query);    
  }
}

function show_events($result) {
	$db = new DB;
	$number = $db->numrows($result);
	if ($number < 1) {
		PRINT "<p>No events<br>";
		return;
	}
	
	$i = 0;
	PRINT "<table width=100% border=1>";
	PRINT "<tr><th>Item</th><th>Date</th><th>Service</th><th width=5%>Level</th><th width=70%>Message</th></tr>";
	while ($i < $number) {
		$ID = $db->result($result, $i, "ID");
		$item = $db->result($result, $i, "item");
		$itemtype = $db->result($result, $i, "itemtype");
		$date = $db->result($result, $i, "date");
		$service = $db->result($result, $i, "service");
		$level = $db->result($result, $i, "level");
		$message = $db->result($result, $i, "message");
		PRINT "<tr><td>$itemtype: $item</td><td>$date</td><td>$service</td><td>$level</td><td>$message</td></tr>";
		$i++; 
	}
	PRINT "</table>";
}


?>
