#ifndef _MY_INTER_H // -*-C++-*-
#define _MY_INTER_H

// Glue functions for talking to libmysqlclient

#include <stdfuns.h>
#include <KayaAPI.h>
#include <mysql/mysql.h>
#include <map>

using namespace std;

typedef enum { DBTEXT, DBINT, DBFLOAT, DBBOOL, DBTIME } DBtype;

/// These class names are rubbish and confusing!!!!1!!!
class MyCon : public gc
{
public:
    MYSQL* con;
    int ok;
    map<int, DBtype> typids;
};

class MyRes : public gc
{
public:
    MyRes();
    KayaArray res_table;
    int rows;
    int cols;
    KayaArray colnames;
    MYSQL_RES* myres;
};

extern "C" {
/// Returns a MyCon
    void* do_mysql_connect(KString rawhost, KString rawuser, KString rawpass, KString rawdb, KInt rawport);
/// Tests if a connection is ok
    bool my_ok(void* conn);
/// Returns an error message
//    wchar_t* pg_getError(void* conn);
/// Returns a PGRes
    void* do_mysql_query(void* vmptr,void* conn,wchar_t* query);
    void* do_mysql_incquery(void* vmptr,void* conn,wchar_t* query);
    Array* my_getrow(void* vmptr, void* resptr);
    void my_discard(void* resptr);
/// Returns a column name
//    wchar_t* pg_columnname(void* vmptr,void* res, int col);
/// Gets the strings from a PGRes
    KayaArray my_getstrs(void* res);
/// Return the number of rows in a result
    int my_numrows(void* res);
/// Return the number of columns in a result
    int my_numcols(void* res);
  /// Get the columnames
  KayaArray my_colnames(void* res);
/// Close the connection
    void do_mysql_close(void* conn);
  void* do_mysqlprepare(wchar_t* query);
  void* do_mysql_execp(void* vmptr, void* conn, void* query, KArray params);
}

#endif
