// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "config.h"
#include "CDDA2Wav.h"
#include "CDParanoia.h"
#include "ReadcdRipper.h"
#include "TOCCdrecord.h"
#include "TOCCdda2wav.h"
#include "AppChooser.h"
#include "ProgressDialog.h"

AudioRipper *AppChooser::getAudioRipper(bool onTheFly) {
  AudioRipper *audio;
#if HAVE_CDPARANOIA
  if (!onTheFly) {
    audio=new CDParanoia();
    if (audio!=0) return (audio);
  }
#endif
#if HAVE_CDDA2WAV
  audio=new CDDA2Wav();
  if (audio!=0) return (audio);
#endif 
  return(0);
}

DataRipper *AppChooser::getDataRipper(void) {
  DataRipper *data;
#if HAVE_READCD
  data=new ReadcdRipper();
  if (data!=0) return(data);
#endif
  return(0);
}

TOCReader *AppChooser::getTOCReader(void) {
  TOCReader *toc;
#if HAVE_CDDA2WAV
  toc=new TOCCdda2wav();
  if (toc!=0) return(toc);
#endif
#if HAVE_CDRECORD
  toc=new TOCCdrecord();
  if (toc!=0) return(toc);
#endif
  return(0);
}

TOCReader *AppChooser::readTOC(bool readBurner) {
  ProgressDialog *prog;
  TOCReader *toc;

  prog=new ProgressDialog();
  toc=getTOCReader();
  if (toc==0) return(0);
  prog->attachProcess(toc);
  if (toc->readTOC(readBurner)!=0) {
    if (prog->exec()!=0) {
      delete(prog);
      return(toc);
    }
  }
  delete toc;

#if HAVE_CDRECORD
  toc=new TOCCdrecord();
  prog->attachProcess(toc);
  if (toc!=0) {
    if (toc->readTOC(readBurner)!=0) {
      if (prog->exec()!=0) {
        delete(prog);
        return(toc);
      }
    }
    delete toc;
  }
#endif
  delete(prog);
  return 0;
}
