// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef AUDIOBUILDIMAGE_INCLUDED
#define AUDIOBUILDIMAGE_INCLUDED

#include "AudioFileConvert.h"

#include <qobject.h>

class AudioFileInfo;

class AudioBuildImage : public AudioFileConvert {
  Q_OBJECT

    public:
  AudioBuildImage(AudioFileInfo *afil,const char *sfn=0);
  int                  buildImage(const char *fn);
  void                 disableAutoQuit(void);

 signals:
  void conversionDone(ProcessInterface *proc,int retval);

 private:
  static int buildImageHFork(ProcessInterface *afi,const char *fn);

  char imageFilename[1024];
  const char *sourceFile;
  bool autoQuit;

 protected:
  virtual int  processCleanup(int rval);  
  virtual int processExited(void);
  virtual bool processStdoutLine(char *buf);
};


#endif
