// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     


#ifndef AUDIOCONVERTER_INCLUDED
#define AUDIOCONVERTER_INCLUDED

class AudioConversion;

class AudioConverter {

 public:
  AudioConverter(void);

  void setAudioConversion(AudioConversion *acon);

  virtual bool doConvert(const char *source,const char *dest);
  virtual bool processStderrLine(char *linebuffer);
  virtual bool processStdoutLine(char *linebuffer);
  virtual int processExited(void);

  AudioConverter &operator<<(const char *str);

  void startTrack(long int size);

  int refCount;

 protected:
  void setPosition(long int pos);
  long int strToLong(const char *src,char **endptr,int base);
  bool strCompare(const char *s1,const char *s2,int len);
        
  int convflag;
  int trackSize;

 private:
  AudioConversion *audioConversion;
};

#endif
