// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "AudioDevice.h"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/stat.h>
#include <sys/ioctl.h>

#if defined(__linux)
#include <linux/soundcard.h>
#define OSS_DEVICE
#elif defined(__FreeBSD__)
#include "machine/soundcard.h"
#define OSS_DEVICE
#elif defined(__NetBSD__)
#include <soundcard.h>
#define OSS_DEVICE
#elif defined(_UNIXWARE)
#include <sys/soundcard.h>
#define OSS_DEVICE
#elif defined(__svr4__)
#include <sys/audioio.h>
#define SOLARIS_DEVICE
#else 
#define NULL_DEVICE
#endif


#ifdef NULL_DEVICE

const char *AudioDevice::getDeviceName(void) {
  return("/dev/null");
}

bool AudioDevice::setupDevice(int audiofd) {
  return(true);
}

void AudioDevice::syncDevice(int audiofd) {
}
#endif

#ifdef OSS_DEVICE

const char *AudioDevice::getDeviceName(void) {
  return("/dev/dsp");
}

bool AudioDevice::setupDevice(int audiofd) {
  int sound_size=16,sound_stereo=1,sound_rate=44100;
  if (ioctl(audiofd, SNDCTL_DSP_SAMPLESIZE, &sound_size)==-1) {
    return(false);
  }
  if (ioctl(audiofd, SNDCTL_DSP_STEREO, &sound_stereo)==-1) {
    return(false);
  }
    if (ioctl(audiofd, SNDCTL_DSP_SPEED, &sound_rate)==-1) {
    return(false);
  }
  return(true);
}

void AudioDevice::syncDevice(int audiofd) {
  ioctl(audiofd,SNDCTL_DSP_SYNC,0);   
}


#endif

#ifdef SOLARIS_DEVICE

const char *AudioDevice::getDeviceName(void) {
  return("/dev/audio");
}

bool AudioDevice::setupDevice(int audiofd) {
  audio_info_t ainf;

  /* Setup our parameters */
  AUDIO_INITINFO(&ainf);

  ainf.play.sample_rate = 44100;
  ainf.play.precision = 16;
  ainf.play.channels = 2;
  ainf.play.buffer_size = 1024;
  ainf.play.encoding = AUDIO_ENCODING_LINEAR;
  //ainf.play.port = AUDIO_SPEAKER;
  //ainf.play.gain = 110;

  if(ioctl(audiofd, AUDIO_SETINFO, &ainf) < 0) {
    return(false);
  }
  return(true);
}

void AudioDevice::syncDevice(int audiofd) {
}


#endif
