// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "FormatPlugin.h"
#include "AudioFileFormat.h"
#include "AudioFileInfo.h"
#include "AudioFileOp.h"
#include "AudioIdentify.h"

#include "AudioFileFormat.moc"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/stat.h>
#include <sys/ioctl.h>

#include <qtimer.h>
#include <qobject.h>
#include <qstringlist.h>

#include <kstddirs.h>
#include <klibloader.h>

QList<FormatPlugin> *AudioFileFormat::plugins; 

AudioFileFormat::AudioFileFormat(AudioFileInfo *afil) {
  audioInfo=afil;
  fileOp=new AudioFileOp(afil);
}

AudioFileFormat::~AudioFileFormat(void) {
  if (fileOp!=0) delete fileOp;
}

void AudioFileFormat::loadPlugins(void) {
  QStringList pluglist;
  QString plugname;
  KLibrary *pluginlibrary;
  FormatPluginHeader *plugin;

  AudioFileFormat::plugins=new QList<FormatPlugin>();
#ifndef USER_PLUGINS
  KGlobal::dirs()->addResourceDir("kreatecd_plugins",PATH_PLUGINS);
#else
  KGlobal::dirs()->addResourceType("kreatecd_plugins","share/apps/kreatecd/plugins");
#endif
  pluglist=KGlobal::dirs()->findAllResources("kreatecd_plugins","*.la",false);

  for ( QStringList::Iterator it = pluglist.begin(); it != pluglist.end(); ++it ) {
     pluginlibrary=KLibLoader::self()->library((*it).latin1());
     if (pluginlibrary!=0) {
       plugname=(*it);
       plugname.remove(0,plugname.findRev('/')+1);
       plugname.remove(plugname.find('.'),99);
       plugin=(FormatPluginHeader *) pluginlibrary->symbol(plugname.latin1());
       if (plugin!=0) {
           if (!registerPlugin(plugin,*it)) {
             KLibLoader::self()->unloadLibrary((*it).latin1());             
           }
       }
    }
  }
}

int AudioFileFormat::registerPlugin(FormatPluginHeader *hd,QString plugpath) {
  FormatPlugin *plug;
  if ( (hd->plugin_magic1==VALUE_MAGIC1) &&
       (hd->plugin_magic2==VALUE_MAGIC2) &&
       (hd->plugin_version==PLUGIN_VERSION) ) {
    plug=new FormatPlugin;
    plug->identifyFactory=hd->identifyFactory;
    plug->identify=plug->identifyFactory();
    if (plug->identify==0) {
      delete plug;
      return(0);
    }
    plug->plugin_path=plugpath;
    AudioFileFormat::plugins->append(plug);
    return(1);
  } else {
    return(0);
  }
}


void AudioFileFormat::unloadPlugins(void) {
  FormatPlugin *plug;
  while ( plug=AudioFileFormat::plugins->first(), plug != 0) {
    delete plug->identify;
    if (!plug->plugin_path.isNull()) {
      KLibLoader::self()->unloadLibrary(plug->plugin_path.latin1());
    }
    AudioFileFormat::plugins->remove (plug);
    delete plug;
  }    
  delete AudioFileFormat::plugins;
}

int AudioFileFormat::setupCDTrack(long int frames) {
  audioInfo->setNeedsRipping(true);

  audioInfo->setChannels(2);
  audioInfo->setSize(AudioFileInfo::Samples_16Bit);
  audioInfo->setFormat(AudioFileInfo::Samples_PCM);
  audioInfo->setEndian(AudioFileInfo::Endian_Big);

  audioInfo->setRate(44100);
  audioInfo->setDataSize(frames*2352);
  audioInfo->setDataPos(0);
  audioInfo->setFormatName("CD");

  return(1);
}

int AudioFileFormat::identifyFile(const char *filename) {
  FormatPlugin *plug;

  if (!fileOp->openRead(filename)) return(0);
  for ( plug=AudioFileFormat::plugins->first(); plug != 0; plug=AudioFileFormat::plugins->next() ) {
    if (plug->identify->identifyFormat(fileOp)) {
      goto posID;
    }
  }

  fileOp->closeRead();
  return(0);
 posID:
  fileOp->closeRead();
  audioInfo->setFilename(filename);
  return(1);
}
