// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "AudioPosWidget.h"
#include "AudioPosWidget.moc"

#include <qlayout.h>
#include <qspinbox.h>
#include <qlabel.h>

#include <kapp.h>
#include <klocale.h>

AudioPosWidget::AudioPosWidget(QWidget *parent,long samplesL,int rateL):QWidget(parent) {
  QHBoxLayout *hlayout;
  QLabel *l1,*l2,*l3;
  long c1;

  samples=samplesL;
  rate=rateL;

  samplerem=(samples%rate)-1;
  c1=samples/rate;
  minutes=c1/60;
  seconds=c1%60;

  hlayout=new QHBoxLayout(this);
  
  minuteSpin=new QSpinBox(this);
  minuteSpin->setRange(0,minutes);
  hlayout->addWidget(minuteSpin);

  l1=new QLabel(this);
  l1->setText(i18n("minutes"));
  hlayout->addWidget(l1);
  

  secondSpin=new QSpinBox(this);
  secondSpin->setRange(0,minutes==0?seconds:60);
  hlayout->addWidget(secondSpin);

  l2=new QLabel(this);
  l2->setText(i18n("seconds"));
  hlayout->addWidget(l2);

  sampleSpin=new QSpinBox(this);
  sampleSpin->setRange(0,((minutes==0) && (seconds==0))?samplerem:rate);
  hlayout->addWidget(sampleSpin);


  l3=new QLabel(this);
  l3->setText(i18n("samples"));
  hlayout->addWidget(l3);


  connect(minuteSpin,SIGNAL(valueChanged(int)),this,SLOT(valuesChanged(int)));
  connect(secondSpin,SIGNAL(valueChanged(int)),this,SLOT(valuesChanged(int)));
  connect(sampleSpin,SIGNAL(valueChanged(int)),this,SLOT(valuesChanged(int)));
  hlayout->activate();
  userChange=false;
}

void AudioPosWidget::valuesChanged(int) {
  if (!userChange) {
    if (sampleSpin->value()>=rate) {
      sampleSpin->setValue(0);
      secondSpin->setValue(secondSpin->value()+1);
    }
    if (secondSpin->value()>=60) {
      secondSpin->setValue(0);
      minuteSpin->setValue(minuteSpin->value()+1);
    }
    if ( (minuteSpin->value()>minutes) ||
          ( (minuteSpin->value()==minutes) && ( (secondSpin->value()>seconds ) ||
            ( (secondSpin->value()==seconds) && ( sampleSpin->value()>samplerem) )
          ) )  ) 
    {
      sampleSpin->setValue(samplerem);
      secondSpin->setValue(seconds);
      minuteSpin->setValue(minutes);
    }
    emit(positionChanged());
  }
}

long AudioPosWidget::position(void) {
  long int pos;
  pos=((minuteSpin->value()*60+secondSpin->value())*rate)+sampleSpin->value();
  return(pos);
}

void AudioPosWidget::setPosition(long pos) {
  long int s1,s2,s3;
  userChange=true;
  if ( (pos<0) || (pos>=samples) ) return;
  s1=pos%rate;
  s2=pos/rate;
  s3=s2/60;
  s2%=60;
  sampleSpin->setValue(s1);
  secondSpin->setValue(s2);
  minuteSpin->setValue(s3);
  userChange=false;
}
