// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "CDDA2Wav.h"
#include "appmacros.h"

#include <qstring.h>
#include <kconfig.h>
#include <kprocess.h>
#include <kapp.h>

#include <stdlib.h>
#include <stdio.h>

#include "CDDA2Wav.moc"

bool CDDA2Wav::doRip(int track,const char *filename) {
  KConfig *config;

  char devline[32],trackline[32];
  QString cddev;
  int host,unit;

  config=kapp->config();
  config->setGroup("SCSI");
  host=config->readNumEntry("SCSICdromHost",0);
  unit=config->readNumEntry("SCSICdromUnit",-1);

  if (unit==-1) return(false);
  sprintf(devline,"-D %d,%d,0",host,unit);

  sprintf(trackline,"-t %d",track);
  config->setGroup("Path");
  if FREE_CDDA2WAV {
    *this<<config->readEntry("PathCdda2Wav",PATH_CDDA2WAV);
  } else {
    *this<<PATH_WRAPPER<<"cdda2wav";
  }
  *this<<"-H"<<"-g"<<"-O"<<"cdr"<<"-E"<<"big"<<devline<<trackline<<filename;
  paranoiafrom=0;
  paranoiato=999999;
  strcpy(Filename,filename);
  strcpy(WFilename,Filename);
  {
    char *xptr;
    xptr=WFilename+strlen(WFilename);
    while ( (*xptr!='.') && ( WFilename!=xptr) ) --xptr;
    if (*xptr=='.') *xptr=0;
  }
  strcat(WFilename,".cdr");
  return(true);
}

int CDDA2Wav::processExited(void) {
  if (strcmp(WFilename,Filename)!=0) {
    rename(WFilename,Filename);
  }
  return(ripflag?1:-2);
}


bool CDDA2Wav::processStderrLine(char *linebuffer) {
  if (strncmp("samplefile size will be ",linebuffer,24)==0) {
    char *xptr;
    long int val;
    xptr=linebuffer+24;
    if (*xptr=='\0') return(true);
    while ( *xptr==' ') ++xptr;
    val=strtol(xptr,0,10);
    paranoiato=val/2352;
    startTrack((long) paranoiato*2352);
    return(true);
  }

  if (*linebuffer==' ') {
    char *xptr;
    long int val;
    xptr=linebuffer;
    while ( *xptr==' ') ++xptr;
    val=strtol(xptr,0,10);
    while ( (*xptr!='%') && (*xptr!='\0')) ++xptr;
    if (*xptr=='\0') return(true);
    {
      long int xpar;
      xpar = paranoiato*val;
      xpar /= 100;
      setPosition( xpar*2352);
      return(true);
    }

  }
  if (strstr(linebuffer,"successfully recorded")!=0) {
    ripflag=1;
  }
  return(true);
}
