// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Niels Reedijk <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ConfigBurnerWidget.h"
#include "ConfigBurnerWidget.moc"

#include <qcombobox.h>
#include <qlayout.h>
#include <qcheckbox.h>

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

int speedtab[7]={1,2,4,6,8,12,16};

ConfigBurnerWidget::ConfigBurnerWidget( QWidget *parent , const char *name ,
                                        bool onthefly )
                  : ConfigBurnerWidget_skel( parent , name )
{
	//Default settings
	KConfig *config = kapp->config();
	config->setGroup( "BurnerSettings" );
	setSpeed(config->readNumEntry( "DefaultSpeed" , 4 ));
	curFixatingSelection = (CDWriter::Fixating) config->readNumEntry( "DefaultFixating" , 2);
	curSimmode = config->readBoolEntry( "DefaultSimmode", false );
	curEject = config->readBoolEntry( "DefaultEject" , false );
	curOnTheFly = config->readBoolEntry( "DefaultOnTheFly" , false );

  if (!onthefly) {
    onthefly_checkbox->setDisabled(true);
    curOnTheFly=false;
  }

  //Simulation checkbox
  simulation_checkbox->setChecked( curSimmode );

  //Eject checkbox
  ejection_checkbox->setChecked( curEject );

  //On the fly checkbox
  onthefly_checkbox->setChecked( curOnTheFly );

  /* Burning speed combo */
  burnspeed_combo->setCurrentItem( curSpeedSelection );
 
  /* Fixating box */
  fixating_combo->setCurrentItem( curFixatingSelection );

  //Notify us of any changes in selected speed
  connect( simulation_checkbox , SIGNAL( toggled(bool) ) , this , SLOT( changeSimulation(bool) ) );
  connect( ejection_checkbox , SIGNAL( toggled(bool) ) , this , SLOT( changeEject(bool) ) );
  connect( onthefly_checkbox , SIGNAL( toggled(bool) ) , this , SLOT( changeOnTheFly(bool) ) );
  connect( burnspeed_combo , SIGNAL( activated(int) ) , this , SLOT( changeSpeed(int) ) );
  connect( fixating_combo , SIGNAL( activated(int) ) , this , SLOT( changeFixating(int) ) );
}

ConfigBurnerWidget::~ConfigBurnerWidget() { }

void ConfigBurnerWidget::applySettings()
{
  KConfig *config = kapp->config();
  config->setGroup( "BurnerSettings" );
  (void) config->writeEntry( "DefaultSimmode" , curSimmode );
  (void) config->writeEntry( "DefaultEject" , curEject );
  (void) config->writeEntry( "DefaultOnTheFly" , curOnTheFly );
  (void) config->writeEntry( "DefaultSpeed" , getSpeed() );
  (void) config->writeEntry( "DefaultFixating" , curFixatingSelection );
}


void ConfigBurnerWidget::setSpeed( int speed )
{
  unsigned int i=0;
  while (i< (sizeof(speedtab) / sizeof(int) ) )
   {
    if (speed<=speedtab[i]) {
      curSpeedSelection=i;
      return;
    }
    ++i;
   }
  curSpeedSelection = 0;
}

void ConfigBurnerWidget::changeSpeed( int speedSelection )
{
  curSpeedSelection = speedSelection;
}

int ConfigBurnerWidget::getSpeed(void)
{
  return(speedtab[curSpeedSelection]);
}

void ConfigBurnerWidget::changeFixating( int fixatingSelection )
{
  curFixatingSelection = (CDWriter::Fixating) fixatingSelection;
}

void ConfigBurnerWidget::changeSimulation(bool sim)
{
  curSimmode = sim;
}

void ConfigBurnerWidget::changeEject(bool eject)
{
  curEject = eject;
}

void ConfigBurnerWidget::changeOnTheFly(bool onthefly)
{
  curOnTheFly = onthefly;
}

CDWriter::Fixating ConfigBurnerWidget::getFixating(void) 
{
  return(curFixatingSelection);
}

bool ConfigBurnerWidget::getEject(void)
{
  return(curEject);
}

bool ConfigBurnerWidget::getSimulation(void)
{
  return(curSimmode);
}

bool ConfigBurnerWidget::getOnTheFly(void)
{
  return(curOnTheFly);
}
