// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Niels Reedijk <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.
#ifndef CONFIGBURNERWIDGET_H
#define CONFIGBURNERWIDGET_H

#include "ConfigBurnerWidget_skel.h"
#include "WriteDialog.h"
#include "CDWriter.h"

class QButtonGroup;
class QRadioButton;
class QCheckBox;


//This class will be used in two circumstances:
// 1) As a configuration widget (so applySettings will be called)
// 2) As the burn dialog (so there are a few buttons)

class ConfigBurnerWidget : public ConfigBurnerWidget_skel
{
  Q_OBJECT
 public:
  ConfigBurnerWidget( QWidget *parent , const char *name,bool onthefly=true );
  ~ConfigBurnerWidget();
  void applySettings();

  int getSpeed();
  bool getSimulation();
  bool getEject();
  bool getOnTheFly();
  CDWriter::Fixating getFixating();

  void setSpeed(int speed);
      
protected slots:
  void changeSimulation(bool sim);
  void changeEject(bool eject);
  void changeOnTheFly(bool onthefly);
  void changeSpeed( int speedSelection );
  void changeFixating( int fixatingSelection );

 private:
  bool curSimmode;
  bool curEject;
  bool curOnTheFly;
  int curSpeedSelection;
  CDWriter::Fixating curFixatingSelection;
};
#endif
