// KreateCD - CD recording software for the K desktop environment
//
// 1998-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "Fork.h"
#include "Fork.moc"

#include <stdlib.h>

Fork::Fork(int (*fx)(int argc,char **argv)):KProcess() {
  function=fx;
  fmode=0;
}

Fork::Fork(int (*fx)(ProcessInterface *afi,const char *fn),ProcessInterface *afil,
	   const char *snx):KProcess() {
  function_af1=fx;
  AFile=afil;
  fmode=1;
  strcpy(strarg,snx);
}

bool Fork::start(RunMode runmode, Communication comm) {
  unsigned int i;
  unsigned int n = arguments.count();
  char **arglist;

  if (runs || ( (n == 0) && (fmode==0)) ) return (false);

  run_mode = runmode;
  status = 0;
  arglist=0;


  switch (fmode) {
  case 0: // setup an arglist {
    arglist=(char **) malloc(sizeof(char **)*n);
    if (arglist==0) return (false);

    for (i=0; i < n; i++) {
      arglist[i]= arguments.at(i);
  }
}



if (!setupCommunication(comm))
  debug("Could not setup Communication!");

runs = true;
pid_ = fork();

if (pid_==0) {
  // child

  if(!commSetupDoneC())
    debug("Could not finish comm setup in child!");
  if (run_mode == DontCare)
    setpgid(0,0);
  switch (fmode) {
  case 0:   // run as virtual shell command
    exit(function(n,arglist));
  case 1:
    exit(function_af1(AFile,strarg));

  }
}
else if (pid_ == -1) {
  // forking failure
  runs = false;
  free(arglist);
  return false;

} else {
  // parent

  if (!commSetupDoneP())
    debug("Could not finish comm setup in parent!");

  input_data = 0;

  if (run_mode == Block) {
    waitpid(pid_, &status, 0);
    processHasExited(status);
  }
}
free(arglist);
return true;
}

bool Fork::writeStdIn(char *buffer,int bufflen) {
if (write(in[1],buffer,bufflen)!=bufflen) return(false);
return(true);
}

