// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef ISOOPTIONS_INCLUDED
#define ISOOPTIONS_INCLUDED

#include <qwidget.h>

class ISOOptions : public QWidget {
  Q_OBJECT;
  
 public:
  ISOOptions( QWidget *parent=0, const char *name=0,class ISOImage *track=0);
  ~ISOOptions(void);
 
 signals:
  void needUpdate(void);

  public slots:
    void updateWindow(void);
  void applySettings(void);

  protected slots:
    void doUnix(void);
  void doUnixWin(void);
  void doWin(void);
  void doMSDos(void);

 private:
  class ISOImage *iso;

  class QCheckBox *tdotButton;
  class QCheckBox *noDeepButton;
  class QCheckBox *longNameButton;
  class QCheckBox *leadDotButton;
  class QCheckBox *omitVerButton;
  class QCheckBox *rockButton;
  class QCheckBox *anoRockButton;
  class QCheckBox *transTabButton;
  class QCheckBox *jolietButton;
  class QCheckBox *allButton;

  class QRadioButton *unixButton;
  class QRadioButton *unixWinButton;
  class QRadioButton *winButton;
  class QRadioButton *msDOSButton;

  class QLabel *appIDLabel;
  class QLabel *sysIDLabel;
  class QLabel *volIDLabel;
  class QLabel *preIDLabel;
  class QLabel *pubIDLabel;

  class QLineEdit *appIDEdit;
  class QLineEdit *sysIDEdit;
  class QLineEdit *volIDEdit;
  class QLineEdit *preIDEdit;
  class QLineEdit *pubIDEdit;

  bool configMode;
};


#endif
