// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "IsoOptionsDialog.h"

#include "IsoOptions.h"

#include <qlayout.h>
#include <qrect.h>

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>

#include "IsoOptionsDialog.moc"


ISOOptionsDialog::ISOOptionsDialog( QWidget *parent, const char *name,ISOImage *isoimage)
                :KDialogBase( parent,name, true ,
                i18n("ISO options window"), Ok, Ok, true) {

  KConfig *config;
  QRect DefaultRect(100,50,500,300); 
 
  config=kapp->config();
  mainWidget=new ISOOptions(this,name,isoimage);
  setMainWidget(mainWidget);
  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("IsoOptWindowGeo",&DefaultRect));
}


ISOOptionsDialog::~ISOOptionsDialog(void) {
  KConfig *config;

  QRect SaveRect(this->pos(),this->size());
  config=kapp->config();
  config->setGroup("Geometry");
  config->writeEntry("IsoOptWindowGeo",SaveRect);
}

void ISOOptionsDialog::needUpdateSlot(void) {
  emit needUpdate();
}
