// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "IsoWindow.h"

#include "IsoImage.h"
#include "IsoFile.h"
#include "IsoWidget.h"
#include "IsoWindow.moc"

#include <qlayout.h>
#include <qpushbutton.h>
#include <qfileinfo.h>
#include <kmessagebox.h>

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>
#include <kstatusbar.h>
#include <qdialog.h>

ISOWindow::ISOWindow( QWidget *parent, const char *name,ISOImage *isoimage,
		      CDTrack *cdt) :KDialogBase( parent,name, true ,
                i18n("ISO tree window"), Ok|Cancel, Ok, true) {
  KConfig *config;
  QRect DefaultRect(100,50,500,300);

  isoImage=isoimage;
  cdTrack=cdt;
  backupTree=new ISOFile (*(isoImage->imageRoot()));

  mainWidget=new IsoWidget(this);
  setMainWidget(mainWidget);
  mainWidget->setTrack(cdt);
  connect(mainWidget,SIGNAL(imageChanged()),this,SIGNAL(imageChanged()));
  connect(mainWidget,SIGNAL(needUpdate()),this,SIGNAL(needUpdate()));

  config=kapp->config();
  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("ISOWindowGeo",&DefaultRect));
}


void ISOWindow::slotOk() {
  mainWidget->doRecalc();  
  emit needUpdate();
  hide();
}

ISOWindow::~ISOWindow(void) {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());
  config=kapp->config();
  config->setGroup("Geometry");
  config->writeEntry("ISOWindowGeo",SaveRect);
  if (backupTree!=0) delete backupTree;
}
  
void ISOWindow::slotCancel(void) {
  if (backupTree!=0) {
    isoImage->setImageRoot(backupTree);
    backupTree=0;
  }
  mainWidget->doRecalc();  
  emit needUpdate();
  hide();
}
