// KreateCD - CD recording seoftware for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef PROCESSINTERFACE_INCLUDED
#define PROCESSINTERFACE_INCLUDED

#include <qobject.h>


/**
    @short ProcessInterface - base class for helper application interaction
    @author Alexander Feigl <Alexander.Feigl@gmx.de>

*/

class KProcess;
class QTimer;

class ProcessInterface : public QObject {
  Q_OBJECT;

 protected:
  ProcessInterface(void);
  ProcessInterface(int (*fx)(int argc,char **argv));
  ProcessInterface(int (*fx)(ProcessInterface *afi,const char *fn),
		   const char *fnx);

  void writeStdin(char *buffer,int len);

 public:
  ProcessInterface& operator<<(const char *arg);
  void waitExit(void);
  ~ProcessInterface(void);

  public slots: 
  void        cancelPressed(void);

  protected slots:
  void        processStdout(KProcess *proc,char *buffer,int bufflen);
  void        processStderr(KProcess *proc,char *buffer,int bufflen);
  void        processLeave (KProcess *proc);
  void        triggerTimer(void);

 protected:

  void         prepareProcess();
  int          startProcess(void);
  void         closeProcess(void);
  void         sendSignal(int signal);
  void         printStatusLine(QString line);
  void         addStatusView(void);
  void         setForkArgument(const char *arg);
  void         setLineTimeout(int timeout);

  virtual bool processStdoutLine(char *linebuffer);
  virtual bool processStderrLine(char *linebuffer);
  virtual int  processExited(void);
  virtual void processCancel(void);
  virtual int  processCleanup(int rval);

  void         reportSecondProgress(long int total,long int offset);
  void         reportProgress(long int current,long int max);
  void         reportAction(QString action);
  void         reportBuffer(int percent);

 signals:
   void        processTerminated (ProcessInterface *proc,int procret);
   void        processProgress(long int current,long int max);
   void        processAction(QString action);
   void        processStatus(QString status);
   void        processDeletion( ProcessInterface *proc);
   void        processBuffer(int percent);
   void        processSecondProgress(long int total,long int offset);
    
 private:

  char stdOutBuffer[512];
  char stdErrBuffer[512];
  KProcess *process;

  bool      forkProcess;
  bool      forkAudio;
  bool      showProgress;
  int (*forkFunc)(int argc,char **argv);
  int (*forkFuncAudio)(ProcessInterface *afi,const char *fn);
  const char *audioForkArg;

  QTimer *outputTimer;
  bool outPending;
  bool errPending;
  bool blockTimer;
  int outTimed;
  int errTimed;

  int lineTimeout;
  int isKilled;
};

#endif
