// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ProjectCDCopyWidget.h"
#include "AppChooser.h"
#include "TOCReader.h"
#include <stdio.h>  /*Forr sprintf --> Should be replaced with QString / Unicode stuff */
#include <kconfig.h>
#include <kapp.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <kiconloader.h>

#include "ProjectCDCopyWidget.moc"

ProjectCDCopyWidget::ProjectCDCopyWidget(QWidget *parent, TrackListManager *TLM):QWidget(parent)
{

  _TLM=TLM;
  QVBoxLayout *l=new QVBoxLayout(this);
  l->setAutoAdd(true);
  QLabel *Header=new QLabel("",this);
  Header->setBackgroundPixmap(QPixmap(UserIcon("kcd_header.png")));
  QFont font=Header->font();
  font.setBold(true);
  font.setPointSize(25);
  font.setFamily("courier");
  Header->setFont(font);
  Header->setText(i18n("CD-Copy"));
  Header->setFixedHeight(Header->sizeHint().height()*2);
  Box1=new QWidget(this);
  bg=new QLabel("",Box1);
  bg->setBackgroundColor(QColor(0,170,255));
  bg->setPixmap(QPixmap(UserIcon("kcd_cd_copy_bg.png")));
  bg->setAlignment(AlignTop | AlignLeft);
  QGridLayout *l1=new QGridLayout(Box1,3,3);
  status= new QLabel("",Box1);
//  status->setAlignment(AlignCenter|WordBreak);
  status->setBackgroundColor(QColor(255,255,255));
  status->setTextFormat(RichText);
  status->setMargin(10);
  l1->addMultiCellWidget(status,1,1,1,1);

  /* Make the Label the biggest part in the window. */
  l1->setColStretch(1,2); l1->setRowStretch(1,2); l1->setColStretch(0,1);   l1->setRowStretch(0,1);   
  l1->setColStretch(2,1); l1->setRowStretch(2,1);


//  QFrame *box2=new QFrame(this);
//  box2->setMargin(10);
/*  QVBoxLayout *l2;
  (l2=new QVBoxLayout(box2))->setAutoAdd(true);
  l2->setMargin(10);
  box2->setBackgroundColor(QColor(0,170,255));*/
  QPushButton *reread;
  connect(reread=new QPushButton(i18n("Reread source CD"),this),SIGNAL(clicked()),_TLM,SLOT(clearTracks()));
  connect(_TLM,SIGNAL(clearList()),this,SLOT(clearTracks()));
  show();
}


void ProjectCDCopyWidget::resizeEvent ( QResizeEvent * )
{
  bg->resize(Box1->width(),Box1->height());
  emit UpdateSizeHint();
}

void ProjectCDCopyWidget::clearTracks()
{
  int i;
  bool ERROR;
  CDTrack *track;
  TOCReader *toc;

  if (_TLM->shutdown) return;
//  MWTrackListManager->newProject(TLMClassic);
  status->setText(i18n("Reading Table of Contents"));
  ERROR=false;
  toc=AppChooser::readTOC();
  if (toc==0) {
    status->setText(i18n("<B>Error while reading TOC:</B><BR>Check if there is a CD in the drive<BR>Check if it is dirty or has many scratches<BR>  Is the drive mounted ?<BR>   Did you select the correct CD-Drive in the Configuration Dialog?"));
    ERROR=true;
  }
  else
    {
        status->setText(i18n("Adding Tracks     "));
        i=0;
        while (1) {
        if (toc->getTOCDuration(i+1)==-1) break;
        track=0;
        track=new CDTrack();
        if (track==0)
        {
          ERROR=true;
          break;
        }
        {
        char trd[20];
        sprintf(trd,"Track %d",i+1);
        track->setDescription(trd);
        }
        track->setTrackType(toc->getTOCType(i+1));
        track->setSourceTrack(i+1,toc->getTOCSum(),toc->getTOCDuration(i+1),
                                toc->getTOCLBA(i+1));

        //    track->validateTrack();
        if (_TLM->addTrack(track)==-1) {
        delete track;
        track=0;
        ERROR=true;
        break;
        }
        qDebug("One Track added");
        status->setText(status->text()+'*');
        ++i;
        }
        delete toc;
    }
  if (ERROR)
    {
      qDebug("ERROR ERROR ERROR");
    }
  else status->setText(i18n("<B><CENTER>You can now press &gt;Write CD!!&lt;<BR> to copy the CD</CENTER></B>"));

#if 0
  CDTrack *tmpTrack;
  tmpTrack=new CDTrack();
  tmpTrack->setTrackType(CDTrack::Track_DataMode1);
  class ISOImage *isoim;
  isoim=tmpTrack->getISOImage();
  tmpTrack->setSourceFileSystem(isoim);
  if (tmpTrack->getISOImage()==0) qDebug("getISOIMAGE == 0");

  //break;

  /*
     if (isoim==0) {
    	connect(ThisTrack->getISOImage(),SIGNAL(imageChanged()),
		this,SLOT(makeImageDirty()));
      }
      ISOTreeWindow=new ISOWindow(0,0,ThisTrack->getISOImage(),ThisTrack);
      connect(ISOTreeWindow,SIGNAL(closed()),this,SLOT(closedISOTree()));
      connect(ISOTreeWindow,SIGNAL(needUpdate()),
	      this,SLOT(updateWindowContents()));
      ISOTreeWindow->show();
      connect(ISOTreeWindow,SIGNAL(imageChanged()),
	      this,SLOT(makeImageDirty()));
  */



  _TLM->addTrack(tmpTrack);
  IW->setTrack(tmpTrack);
#endif
}


ProjectCDCopyWidget::~ProjectCDCopyWidget() {
#if 0
	if (IW) delete IW;
#endif
}










