// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ProjectClassicWidget.h"
#include <kconfig.h>
#include <kapp.h>
#include <qlayout.h>
#include <klocale.h>
#include "ProjectClassicWidget.moc"

ProjectClassicWidget::ProjectClassicWidget(QWidget *parent, 
					   TrackListManager *TLM)
  :QWidget(parent) {
  firstInvoke=true;

  KConfig *config=kapp->config();

  setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
			    QSizePolicy::MinimumExpanding));

  QVBoxLayout *mainlayout=new QVBoxLayout(this);
  mainlayout->setSpacing(6);
  mainlayout->setMargin(11);

  config->setGroup("Geometry");  
  Colwidth[0]=config->readDoubleNumEntry("MainWindowTrackWidth",8);
  Colwidth[1]=config->readDoubleNumEntry("MainWindowDescriptionWidth",60);
  Colwidth[2]=config->readDoubleNumEntry("MainWindowSizeWidth",16);
  Colwidth[3]=config->readDoubleNumEntry("MainWindowModeWidth",16);

  TLV=new TrackListView(this,"Classic Track List",TLM);
  mainlayout->addWidget(TLV);

  SumLabel=new QLabel("-",this);
  SumLabel->setFrameStyle(QFrame::Box|QFrame::Sunken);
  SumLabel->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
				      QSizePolicy::Fixed));
  mainlayout->addWidget(SumLabel);

  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Fixed, 
					 QSizePolicy::Minimum );
  mainlayout->addItem(spacer);
  
  QGridLayout *trackbuttons=new QGridLayout;
  trackbuttons->setSpacing(6);
  trackbuttons->setMargin(0);

  MWAddTrack=new QPushButton(i18n("Add track"),this,"add track");
  MWAddTrack->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
					QSizePolicy::Fixed));
  trackbuttons->addWidget(MWAddTrack,0,0);
  MWEditTrack=new QPushButton(i18n("Edit track"),this,"edit track");
  MWEditTrack->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
					 QSizePolicy::Fixed));
  trackbuttons->addWidget(MWEditTrack,0,1);
  MWDeleteTrack=new QPushButton(i18n("Delete track"),this,"delete track");
  MWDeleteTrack->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
					   QSizePolicy::Fixed));
  trackbuttons->addWidget(MWDeleteTrack,0,2);
  MWTrackUp=new QPushButton(i18n("Track up"),this,"track up");
  MWTrackUp->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
				       QSizePolicy::Fixed));
  trackbuttons->addWidget(MWTrackUp,1,0);
  MWTrackUpdate=new QPushButton(i18n("Track update"),this,"track update");
  MWTrackUpdate->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
					   QSizePolicy::Fixed));
  trackbuttons->addWidget(MWTrackUpdate,1,1);
  MWTrackDown=new QPushButton(i18n("Track down"),this,"track down");
  MWTrackDown->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
					 QSizePolicy::Fixed));
  trackbuttons->addWidget(MWTrackDown,1,2);

  mainlayout->addLayout(trackbuttons);
  QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, 
					   QSizePolicy::Fixed, 
					   QSizePolicy::Minimum );
  mainlayout->addItem( spacer_2 );

  connect(MWAddTrack,SIGNAL(clicked()),TLM,SLOT(addTrack()));
  connect(MWEditTrack,SIGNAL(clicked()),TLV,SLOT(editTrack()));
  connect(MWDeleteTrack,SIGNAL(clicked()),TLV,SLOT(deleteTrack()));

  connect(MWTrackUp,SIGNAL(clicked()),TLV,SLOT(moveUp()));
  connect(MWTrackDown,SIGNAL(clicked()),TLV,SLOT(moveDown()));

  connect(MWTrackUpdate,SIGNAL(clicked()),TLV,SLOT(updateTrack()));
  connect(TLM,SIGNAL(trackSumUpdated(int,QString)),this,
	  SLOT(updateTrackSum(int,QString)));

	show();
}

void ProjectClassicWidget::updateTrackSum(int trackCount, QString duration) {
  SumLabel->setText(i18n("Tracks in project: %1 (duration %2)")
		    .arg(trackCount).arg(duration));
}

void ProjectClassicWidget::readColWidth(int siz) {
  int sum,i;
  sum=siz;
  if (siz==-1) sum=this->width();
  if (sum==0) return;
  for (i=0;i<TRACK_COLUMNS;++i) {
    Colwidth[i]=((float)TLV->columnWidth(i))*100/sum;
  } 
}

void ProjectClassicWidget::writeColWidth() {
  int sum=0,i;
  sum=this->width();
  if (sum==0) return;
  for (i=0;i<TRACK_COLUMNS;++i) {
    TLV->setColumnWidth(i,(int)(Colwidth[i]*sum/100));
  }
}


void ProjectClassicWidget::resizeEvent(QResizeEvent *rs) {
  if (!firstInvoke) readColWidth(rs->oldSize().width());
  firstInvoke=false;
  QWidget::resizeEvent(rs);
  writeColWidth();
}
