// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "MainWindow.h"
#include "CDTrack.h"
#include "TrackWindow.h"

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qlayout.h>

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kurl.h>

#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

void MainWindow::newProject(void) {
  ProjectPath[0]=0;
  if (TrackEdit!=0) {
    delete (TrackEdit);
    TrackEdit=0;
  }
  {
    MWTrackListManager->newProject(TLMNothing);
    CurrentTrack=-1;
  }
}

void MainWindow::openProject() {
  //If there is no Commandline file given, show a dialog
  QString openname;
  KURL url;
  url=KFileDialog::getOpenURL(QString::null,"*.cdp",this,
			      i18n("Open project")).path();
  openname=url.path();
  strcpy(ProjectPath,openname.data());
  if (ProjectPath[0]==0) {
    return;
  }
  KConfig kc(ProjectPath);
  MWTrackListManager->setIsOpening(true);
  loadProjectFromConfig(&kc);
  MWTrackListManager->setIsOpening(false);

}


void MainWindow::openProjectOnCommandline( const QString CmdLineFile ) {
  strcpy(ProjectPath,CmdLineFile.data());
  if (ProjectPath[0]==0) { 
    return;
  }
  KConfig kc(ProjectPath);
  MWTrackListManager->setIsOpening(true);
  loadProjectFromConfig(&kc);
  MWTrackListManager->setIsOpening(false);
}

void MainWindow::saveProject(void) {
  QString savename;
  if (ProjectPath[0]==0) {
    KURL url;
    url=KFileDialog::getSaveURL(QString::null,"*.cdp",
				this,i18n("Save project")).path();
    savename=url.path();
    strcpy(ProjectPath,savename.data());
    if (ProjectPath[0]==0) return;
    {
      char *cptr,i=0;
      cptr=ProjectPath;
      while (*(cptr++)!=0) ++i;
      if ( (i<4) || (strcmp (cptr-5,".cdp")!=0) ) {
        if ( (i>0) && (*(cptr-2)=='/') ) strcat(ProjectPath,"kreatecd");
        strcat(ProjectPath,".cdp");
      }
    }
  }
  remove(ProjectPath);
  {
    KConfig kc(ProjectPath);
    saveProjectToConfig(&kc);
  }
}

void MainWindow::loadProjectFromConfig(KConfig *kc) {
  int tracks=0,i;
  CDTrack *track;
  kc->setGroup("Global");
  tracks=kc->readNumEntry("Tracks",0);
  MWTrackListManager->newProject(kc->readNumEntry("ProjectType",TLMClassic));
  for (i=0;i<tracks;++i) {
    char xgroup[12];
    sprintf(xgroup,"Track%d",i+1);
    kc->setGroup(xgroup);
    track= new CDTrack(kc);
    if (track==0) break;
    if (MWTrackListManager->addTrack(track)==-1) {
      delete track;
      break;
    }
  }

}

void MainWindow::saveProjectToConfig(KConfig *kc) {
  int i,tracks=0;

  kc->setGroup("Global");
  for (i=0;i<MAX_TRACKS_PER_PROJECT;++i) {
    if (ProjectTracks[i]==0) break;
  }
  tracks=i;
  kc->writeEntry("Tracks",tracks);
  kc->writeEntry("ProjectType",MWTrackListManager->getType());
  for (i=0;i<tracks;++i) {
    char xgroup[12];
    sprintf(xgroup,"Track%d",i+1);
    kc->setGroup(xgroup);
    ProjectTracks[i]->saveTrack(kc);
  }
}

void MainWindow::saveProjectAs(void) {
  ProjectPath[0]=0;
  saveProject();
}
